/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.FunctionLibrary;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.NumberUtils;
import tim.prune.data.Track;
import tim.prune.function.Export3dFunction;
import tim.prune.function.srtm.LookupSrtmFunction;
import tim.prune.gui.BaseImageDefinitionPanel;
import tim.prune.gui.DialogCloser;
import tim.prune.gui.TerrainDefinitionPanel;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapSourceLibrary;
import tim.prune.load.GenericFileFilter;
import tim.prune.save.GroutedImage;
import tim.prune.save.MapGrouter;
import tim.prune.save.ModelSegment;
import tim.prune.threedee.ImageDefinition;
import tim.prune.threedee.TerrainCache;
import tim.prune.threedee.TerrainDefinition;
import tim.prune.threedee.TerrainHelper;
import tim.prune.threedee.ThreeDModel;

public class PovExporter
extends Export3dFunction {
    private Track _track = null;
    private JDialog _dialog = null;
    private JFileChooser _fileChooser = null;
    private String _cameraX = null;
    private String _cameraY = null;
    private String _cameraZ = null;
    private JTextField _cameraXField = null;
    private JTextField _cameraYField = null;
    private JTextField _cameraZField = null;
    private JTextField _fontName = null;
    private JTextField _altitudeFactorField = null;
    private JRadioButton _ballsAndSticksButton = null;
    private BaseImageDefinitionPanel _baseImagePanel = null;
    private TerrainDefinitionPanel _terrainPanel = null;
    private static final double DEFAULT_CAMERA_DISTANCE = 30.0;
    private static final double MODEL_SCALE_FACTOR = 20.0;
    private static final String DEFAULT_FONT_FILE = "crystal.ttf";

    public PovExporter(App app) {
        super(app);
        this._track = app.getTrackInfo().getTrack();
        this._cameraX = "17";
        this._cameraY = "13";
        this._cameraZ = "-20";
    }

    @Override
    public String getNameKey() {
        return "function.exportpov";
    }

    @Override
    public void setCameraCoordinates(double d, double d2, double d3) {
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d4 > 0.0) {
            this._cameraX = NumberUtils.formatNumberUk(d / d4 * 30.0, 5);
            this._cameraY = NumberUtils.formatNumberUk(d2 / d4 * 30.0, 5);
            this._cameraZ = NumberUtils.formatNumberUk(-d3 / d4 * 30.0, 5);
        }
    }

    @Override
    public void begin() {
        int n;
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogComponents());
        }
        if ((n = Config.getConfigInt("prune.heightexaggeration")) > 0) {
            this._altFactor = (double)n / 100.0;
        }
        this._cameraXField.setText(this._cameraX);
        this._cameraYField.setText(this._cameraY);
        this._cameraZField.setText(this._cameraZ);
        this._altitudeFactorField.setText("" + this._altFactor);
        if (this._terrainDef != null) {
            this._terrainPanel.initTerrainParameters(this._terrainDef);
        }
        if (this._imageDef != null) {
            this._baseImagePanel.initImageParameters(this._imageDef);
        }
        this._baseImagePanel.updateBaseImageDetails();
        this._dialog.pack();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(4, 4));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.exportpov.text"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 6, 4));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PovExporter.this.doExport();
                        PovExporter.this._baseImagePanel.getGrouter().clearMapImage();
                    }
                }).start();
                PovExporter.this._dialog.dispose();
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PovExporter.this._baseImagePanel.getGrouter().clearMapImage();
                PovExporter.this._dialog.dispose();
            }
        });
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 10, 4));
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.exportpov.font"));
        jLabel2.setHorizontalAlignment(11);
        jPanel3.add(jLabel2);
        String string = Config.getConfigString("prune.povrayfont");
        if (string == null || string.equals("")) {
            string = DEFAULT_FONT_FILE;
        }
        this._fontName = new JTextField(string, 12);
        this._fontName.setAlignmentX(0.0f);
        this._fontName.addKeyListener(new DialogCloser(this._dialog));
        jPanel3.add(this._fontName);
        JLabel jLabel3 = new JLabel(I18nManager.getText("dialog.exportpov.camerax"));
        jLabel3.setHorizontalAlignment(11);
        jPanel3.add(jLabel3);
        this._cameraXField = new JTextField(this._cameraX);
        jPanel3.add(this._cameraXField);
        JLabel jLabel4 = new JLabel(I18nManager.getText("dialog.exportpov.cameray"));
        jLabel4.setHorizontalAlignment(11);
        jPanel3.add(jLabel4);
        this._cameraYField = new JTextField(this._cameraY);
        jPanel3.add(this._cameraYField);
        JLabel jLabel5 = new JLabel(I18nManager.getText("dialog.exportpov.cameraz"));
        jLabel5.setHorizontalAlignment(11);
        jPanel3.add(jLabel5);
        this._cameraZField = new JTextField(this._cameraZ);
        jPanel3.add(this._cameraZField);
        JLabel jLabel6 = new JLabel(I18nManager.getText("dialog.3d.altitudefactor"));
        jLabel6.setHorizontalAlignment(11);
        jPanel3.add(jLabel6);
        this._altitudeFactorField = new JTextField("1.0");
        jPanel3.add(this._altitudeFactorField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 2, 10, 4));
        JLabel jLabel7 = new JLabel(I18nManager.getText("dialog.exportpov.modelstyle"));
        jLabel7.setHorizontalAlignment(11);
        jPanel4.add(jLabel7);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        this._ballsAndSticksButton = new JRadioButton(I18nManager.getText("dialog.exportpov.ballsandsticks"));
        this._ballsAndSticksButton.setSelected(false);
        jPanel5.add(this._ballsAndSticksButton);
        JRadioButton jRadioButton = new JRadioButton(I18nManager.getText("dialog.exportpov.tubesandwalls"));
        jRadioButton.setSelected(true);
        jPanel5.add(jRadioButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._ballsAndSticksButton);
        buttonGroup.add(jRadioButton);
        jPanel4.add(jPanel5);
        this._baseImagePanel = new BaseImageDefinitionPanel(null, this._dialog, this._track);
        this._terrainPanel = new TerrainDefinitionPanel();
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(5, 5));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.add(jPanel3);
        jPanel7.add(Box.createVerticalStrut(4));
        jPanel7.add(jPanel4);
        jPanel7.add(Box.createVerticalStrut(4));
        jPanel7.add(this._terrainPanel);
        jPanel7.add(Box.createVerticalStrut(4));
        jPanel7.add(this._baseImagePanel);
        jPanel6.add((Component)jPanel7, "Center");
        jPanel.add((Component)jPanel6, "Center");
        return jPanel;
    }

    private void doExport() {
        this._cameraX = PovExporter.checkCoordinate(this._cameraXField.getText());
        this._cameraY = PovExporter.checkCoordinate(this._cameraYField.getText());
        this._cameraZ = PovExporter.checkCoordinate(this._cameraZField.getText());
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setDialogType(1);
            this._fileChooser.setFileFilter(new GenericFileFilter("filetype.pov", new String[]{"pov"}));
            this._fileChooser.setAcceptAllFileFilterUsed(false);
            String string = Config.getConfigString("prune.trackdirectory");
            if (string != null) {
                this._fileChooser.setCurrentDirectory(new File(string));
            }
        }
        boolean bl = false;
        do {
            bl = false;
            if (this._fileChooser.showSaveDialog(this._parentFrame) != 0) continue;
            File file = this._fileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".pov")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".pov");
            }
            int n = file.getName().length() - 4;
            File file2 = new File(file.getParentFile(), String.valueOf(file.getName().substring(0, n)) + "_base.png");
            File file3 = new File(file.getParentFile(), String.valueOf(file.getName().substring(0, n)) + "_terrain.png");
            boolean bl2 = this._baseImagePanel.getImageDefinition().getUseImage() && file2.exists();
            boolean bl3 = this._terrainPanel.getUseTerrain() && file3.exists();
            Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file.exists() && !bl2 && !bl3 || JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                if (this.exportFiles(file, file2, file3)) {
                    Config.setConfigString("prune.trackdirectory", file.getParentFile().getAbsolutePath());
                    Config.setConfigInt("prune.heightexaggeration", (int)(this._altFactor * 100.0));
                    if (!this._terrainPanel.getUseTerrain() || this._terrainPanel.getGridSize() <= 20) continue;
                    Config.setConfigInt("prune.terraingridsize", this._terrainPanel.getGridSize());
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        } while (bl);
    }

    /*
     * Loose catch block
     */
    private boolean exportFiles(File file, File file2, File file3) {
        boolean bl;
        Object object;
        Object object2;
        OutputStreamWriter outputStreamWriter = null;
        String string = System.getProperty("line.separator");
        ThreeDModel threeDModel = new ThreeDModel(this._track);
        threeDModel.setModelSize(20.0);
        try {
            double d = Double.parseDouble(this._altitudeFactorField.getText());
            if (d > 0.0) {
                this._altFactor = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this._altitudeFactorField.setText("" + this._altFactor);
        }
        threeDModel.setAltitudeFactor(this._altFactor);
        ImageDefinition imageDefinition = this._baseImagePanel.getImageDefinition();
        boolean bl2 = imageDefinition.getUseImage();
        if (bl2) {
            MapSource mapSource = MapSourceLibrary.getSource(imageDefinition.getSourceIndex());
            object2 = this._baseImagePanel.getGrouter();
            object = ((MapGrouter)object2).getMapImage(this._track, mapSource, imageDefinition.getZoom());
            try {
                bl2 = ImageIO.write((RenderedImage)((GroutedImage)object).getImage(), "png", file2);
            }
            catch (IOException iOException) {
                System.err.println("Can't write image: " + iOException.getClass().getName());
                bl2 = false;
            }
            if (!bl2) {
                this._app.showErrorMessage(this.getNameKey(), "dialog.exportpov.cannotmakebaseimage");
            }
        }
        if (bl = this._terrainPanel.getUseTerrain()) {
            object2 = new TerrainHelper(this._terrainPanel.getGridSize());
            object = new TerrainDefinition(this._terrainPanel.getUseTerrain(), this._terrainPanel.getGridSize());
            Track track = TerrainCache.getTerrainTrack(this._app.getCurrentDataStatus(), (TerrainDefinition)object);
            if (track == null) {
                track = ((TerrainHelper)object2).createGridTrack(this._track);
                LookupSrtmFunction lookupSrtmFunction = (LookupSrtmFunction)FunctionLibrary.FUNCTION_LOOKUP_SRTM;
                lookupSrtmFunction.begin(track);
                while (lookupSrtmFunction.isRunning()) {
                    try {
                        Thread.sleep(750L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ((TerrainHelper)object2).fixVoids(track);
                TerrainCache.storeTerrainTrack(track, this._app.getCurrentDataStatus(), (TerrainDefinition)object);
            }
            threeDModel.setTerrain(track);
            threeDModel.scale();
            ((TerrainHelper)object2).writeHeightMap(threeDModel, file3);
        } else {
            threeDModel.scale();
        }
        outputStreamWriter = new FileWriter(file);
        this.writeStartOfFile((FileWriter)outputStreamWriter, string, bl2 ? file2 : null, bl ? file3 : null);
        if (this._ballsAndSticksButton.isSelected()) {
            PovExporter.writeDataPointsBallsAndSticks((FileWriter)outputStreamWriter, threeDModel, string);
        } else {
            PovExporter.writeDataPointsTubesAndWalls((FileWriter)outputStreamWriter, threeDModel, string);
        }
        UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + this._track.getNumPoints() + " " + I18nManager.getText("confirm.save.ok2") + " " + file.getAbsolutePath());
        try {
            outputStreamWriter.close();
        }
        catch (Exception exception) {}
        return true;
        catch (IOException iOException) {
            try {
                JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage(), I18nManager.getText("error.save.dialogtitle"), 0);
            }
            catch (Throwable throwable) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                outputStreamWriter.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private void writeStartOfFile(FileWriter fileWriter, String string, File file, File file2) throws IOException {
        fileWriter.write("// Pov file produced by GpsPrune - see https://gpsprune.activityworkshop.net/");
        fileWriter.write(string);
        fileWriter.write("#version 3.6;");
        fileWriter.write(string);
        fileWriter.write(string);
        String string2 = this._fontName.getText();
        if (string2 == null || string2.equals("")) {
            string2 = DEFAULT_FONT_FILE;
        } else {
            Config.setConfigString("prune.povrayfont", string2);
        }
        boolean bl = file != null;
        boolean bl2 = bl && file2 == null;
        String string3 = bl2 ? "   <0, 0, 0>, <1, 1, 0.001>" + string + "   pigment {image_map { png \"" + file.getName() + "\" map_type 0 interpolate 2 once } }" + string + "   scale 20.0 rotate <90, 0, 0>" + string + "   translate <-10.0, 0, -10.0>" : "   <-10.0, -0.15, -10.0>," + string + "   <10.0, 0.0, 10.0>" + string + "   pigment { color rgb <0.5 0.75 0.8> }";
        String string4 = PovExporter.makeTerrainString(file2, file, string);
        String[] stringArray = new String[]{"// lights", "light_source { <-1, 9, -4> color rgb <0.5 0.5 0.5>}", "light_source { <1, 6, -14> color rgb <0.6 0.6 0.6>}", "light_source { <11, 12, 8> color rgb <0.3 0.3 0.3>}"};
        String[] stringArray2 = new String[]{"// lights from NW", "light_source { <-10, 10, 10> color rgb <1.5 1.5 1.5> parallel }"};
        String[] stringArray3 = file2 == null ? stringArray : stringArray2;
        String[] stringArray4 = new String[]{"global_settings { ambient_light rgb <4, 4, 4> }", "", "// Background and camera", "background { color rgb <0, 0, 0> }", "camera {", "  location <" + this._cameraX + ", " + this._cameraY + ", " + this._cameraZ + ">", "  look_at  <0, 0, 0>", "}", "", "// Global declares", "#declare point_rod =", "  cylinder {", "   <0, 0, 0>,", "   <0, 1, 0>,", "   0.15", "   open", "   texture {", "    pigment { color rgb <0.5 0.5 0.5> }", bl ? "   } no_shadow" : "   }", "  }", "", "#declare waypoint_sphere =", "  sphere {", "   <0, 0, 0>, 0.4", "    texture {", "       pigment {color rgb <0.1 0.1 1.0>}", "       finish { phong 1 }", bl ? "    } no_shadow" : "    }", "  }", "#declare track_sphere0 =", "  sphere {", "   <0, 0, 0>, 0.3", "   texture {", "      pigment {color rgb <0.1 0.6 0.1>}", "      finish { phong 1 }", "   }", " }", "#declare track_sphere1 =", "  sphere {", "   <0, 0, 0>, 0.3", "   texture {", "      pigment {color rgb <0.4 0.9 0.2>}", "      finish { phong 1 }", "   }", " }", "#declare track_sphere2 =", "  sphere {", "   <0, 0, 0>, 0.3", "   texture {", "      pigment {color rgb <0.7 0.8 0.2>}", "      finish { phong 1 }", "   }", " }", "#declare track_sphere3 =", "  sphere {", "   <0, 0, 0>, 0.3", "   texture {", "      pigment {color rgb <0.5 0.8 0.6>}", "      finish { phong 1 }", "   }", " }", "#declare track_sphere4 =", "  sphere {", "   <0, 0, 0>, 0.3", "   texture {", "      pigment {color rgb <0.2 0.9 0.9>}", "      finish { phong 1 }", "   }", " }", "#declare track_sphere5 =", "  sphere {", "   <0, 0, 0>, 0.3", "   texture {", "      pigment {color rgb <1.0 1.0 1.0>}", "      finish { phong 1 }", "   }", " }", "#declare track_sphere_t =", "  sphere {", "   <0, 0, 0>, 0.25", "   texture {", "      pigment {color rgb <0.6 1.0 0.2>}", "      finish { phong 1 }", "   } no_shadow", " }", "#declare wall_colour = rgbt <0.5, 0.5, 0.5, 0.3>;", "", "// Base plane", "box {", string3, "}", "", string4, "// Cardinal letters N,S,E,W", "text {", "  ttf \"" + string2 + "\" \"" + I18nManager.getText("cardinal.n") + "\" 0.3, 0", "  pigment { color rgb <1 1 1> }", "  translate <0, 0.2, 10.0>", "}", "text {", "  ttf \"" + string2 + "\" \"" + I18nManager.getText("cardinal.s") + "\" 0.3, 0", "  pigment { color rgb <1 1 1> }", "  translate <0, 0.2, -10.0>", "}", "text {", "  ttf \"" + string2 + "\" \"" + I18nManager.getText("cardinal.e") + "\" 0.3, 0", "  pigment { color rgb <1 1 1> }", "  translate <9.7, 0.2, 0>", "}", "text {", "  ttf \"" + string2 + "\" \"" + I18nManager.getText("cardinal.w") + "\" 0.3, 0", "  pigment { color rgb <1 1 1> }", "  translate <-10.3, 0.2, 0>", "}"};
        this.writeLinesToFile(fileWriter, string, stringArray4);
        this.writeLinesToFile(fileWriter, string, stringArray3);
    }

    private void writeLinesToFile(FileWriter fileWriter, String string, String[] stringArray) throws IOException {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            fileWriter.write(string2);
            fileWriter.write(string);
            ++n2;
        }
        fileWriter.write(string);
    }

    private static String makeTerrainString(File file, File file2, String string) {
        if (file == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("//Terrain").append(string).append("height_field {").append(string).append("\tpng \"").append(file.getName()).append("\" smooth").append(string).append("\tfinish {diffuse 0.7 phong 0.2}").append(string);
        if (file2 != null) {
            stringBuilder.append("\tpigment {image_map { png \"").append(file2.getName()).append("\"  } rotate x*90}").append(string);
        } else {
            stringBuilder.append("\tpigment {color rgb <0.55 0.7 0.55> }").append(string);
        }
        stringBuilder.append("\tscale 20.0").append(string).append("\ttranslate <-10.0, 0, -10.0>").append(string).append("}");
        return stringBuilder.toString();
    }

    private static void writeDataPointsBallsAndSticks(FileWriter fileWriter, ThreeDModel threeDModel, String string) throws IOException {
        fileWriter.write("// Data points:");
        fileWriter.write(string);
        int n = threeDModel.getNumPoints();
        int n2 = 0;
        while (n2 < n) {
            if (threeDModel.getPointType(n2) == 1) {
                fileWriter.write("object { waypoint_sphere translate <" + threeDModel.getScaledHorizValue(n2) + "," + threeDModel.getScaledAltValue(n2) + "," + threeDModel.getScaledVertValue(n2) + "> }");
            } else {
                fileWriter.write("object { track_sphere" + PovExporter.checkHeightCode(threeDModel.getPointHeightCode(n2)) + " translate <" + threeDModel.getScaledHorizValue(n2) + "," + threeDModel.getScaledAltValue(n2) + "," + threeDModel.getScaledVertValue(n2) + "> }");
            }
            fileWriter.write(string);
            if (threeDModel.getScaledAltValue(n2) > 0.0) {
                fileWriter.write("object { point_rod translate <" + threeDModel.getScaledHorizValue(n2) + ",0," + threeDModel.getScaledVertValue(n2) + "> scale <1," + threeDModel.getScaledAltValue(n2) + ",1> }");
                fileWriter.write(string);
            }
            ++n2;
        }
        fileWriter.write(string);
    }

    private static void writeDataPointsTubesAndWalls(FileWriter fileWriter, ThreeDModel threeDModel, String string) throws IOException {
        fileWriter.write("// Data points:");
        fileWriter.write(string);
        int n = threeDModel.getNumPoints();
        int n2 = 0;
        while (n2 < n) {
            if (threeDModel.getPointType(n2) == 1) {
                fileWriter.write("object { waypoint_sphere translate <" + threeDModel.getScaledHorizValue(n2) + "," + threeDModel.getScaledAltValue(n2) + "," + threeDModel.getScaledVertValue(n2) + "> }");
                if (threeDModel.getScaledAltValue(n2) > 0.0) {
                    fileWriter.write(string);
                    fileWriter.write("object { point_rod translate <" + threeDModel.getScaledHorizValue(n2) + ",0," + threeDModel.getScaledVertValue(n2) + "> scale <1," + threeDModel.getScaledAltValue(n2) + ",1> }");
                }
                fileWriter.write(string);
            }
            ++n2;
        }
        fileWriter.write(string);
        for (ModelSegment modelSegment : PovExporter.getSegmentList(threeDModel)) {
            int n3 = modelSegment.getNumTrackPoints();
            if (n3 <= 1) {
                int n4 = modelSegment.getStartIndex();
                fileWriter.write("object { track_sphere_t translate <" + threeDModel.getScaledHorizValue(n4) + "," + threeDModel.getScaledAltValue(n4) + "," + threeDModel.getScaledVertValue(n4) + "> }");
            } else {
                PovExporter.writeSphereSweep(fileWriter, threeDModel, modelSegment, string);
            }
            if (n3 <= 1) continue;
            PovExporter.writePolygonWall(fileWriter, threeDModel, modelSegment, string);
        }
    }

    private static void writeSphereSweep(FileWriter fileWriter, ThreeDModel threeDModel, ModelSegment modelSegment, String string) throws IOException {
        fileWriter.write("// Sphere sweep:");
        fileWriter.write(string);
        String string2 = modelSegment.getNumTrackPoints() < 5 ? "linear_spline" : "cubic_spline";
        fileWriter.write("sphere_sweep { ");
        fileWriter.write(string2);
        fileWriter.write(" " + modelSegment.getNumTrackPoints() + ",");
        fileWriter.write(string);
        int n = modelSegment.getStartIndex();
        while (n <= modelSegment.getEndIndex()) {
            if (threeDModel.getPointType(n) != 1) {
                fileWriter.write("  <" + threeDModel.getScaledHorizValue(n) + "," + threeDModel.getScaledAltValue(n) + "," + threeDModel.getScaledVertValue(n) + ">, 0.25");
                fileWriter.write(string);
            }
            ++n;
        }
        fileWriter.write("  tolerance 0.1");
        fileWriter.write(string);
        fileWriter.write("  texture { pigment {color rgb <0.6 1.0 0.2>}  finish {phong 1} }");
        fileWriter.write(string);
        fileWriter.write("  no_shadow");
        fileWriter.write(string);
        fileWriter.write("}");
        fileWriter.write(string);
    }

    private static void writePolygonWall(FileWriter fileWriter, ThreeDModel threeDModel, ModelSegment modelSegment, String string) throws IOException {
        fileWriter.write(string);
        fileWriter.write("// wall between sweep and floor:");
        fileWriter.write(string);
        int n = -1;
        int n2 = modelSegment.getStartIndex();
        while (n2 <= modelSegment.getEndIndex()) {
            if (threeDModel.getPointType(n2) != 1) {
                double d;
                double d2;
                double d3;
                if (n >= 0 && (d3 = Math.sqrt((d2 = threeDModel.getScaledHorizValue(n2) - threeDModel.getScaledHorizValue(n)) * d2 + (d = threeDModel.getScaledVertValue(n2) - threeDModel.getScaledVertValue(n)) * d)) > 0.0) {
                    fileWriter.write("polygon {");
                    fileWriter.write("  5, <" + threeDModel.getScaledHorizValue(n) + ", 0.0, " + threeDModel.getScaledVertValue(n) + ">,");
                    fileWriter.write(" <" + threeDModel.getScaledHorizValue(n) + ", " + threeDModel.getScaledAltValue(n) + ", " + threeDModel.getScaledVertValue(n) + ">,");
                    fileWriter.write(" <" + threeDModel.getScaledHorizValue(n2) + ", " + threeDModel.getScaledAltValue(n2) + ", " + threeDModel.getScaledVertValue(n2) + ">,");
                    fileWriter.write(" <" + threeDModel.getScaledHorizValue(n2) + ", 0.0, " + threeDModel.getScaledVertValue(n2) + ">,");
                    fileWriter.write(" <" + threeDModel.getScaledHorizValue(n) + ", 0.0, " + threeDModel.getScaledVertValue(n) + ">");
                    fileWriter.write("  pigment { color wall_colour } no_shadow");
                    fileWriter.write("}");
                    fileWriter.write(string);
                }
                n = n2;
            }
            ++n2;
        }
    }

    private static byte checkHeightCode(byte by) {
        if (by < 0) {
            return 0;
        }
        if (by > 5) {
            return 5;
        }
        return by;
    }

    private static String checkCoordinate(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {}
        return "" + d;
    }

    private static ArrayList<ModelSegment> getSegmentList(ThreeDModel threeDModel) {
        ArrayList<ModelSegment> arrayList = new ArrayList<ModelSegment>();
        if (threeDModel != null && threeDModel.getNumPoints() > 0) {
            ModelSegment modelSegment = null;
            int n = 0;
            int n2 = 0;
            while (n2 < threeDModel.getNumPoints()) {
                if (threeDModel.getPointType(n2) != 1) {
                    if (threeDModel.getPointType(n2) == 3 || modelSegment == null) {
                        if (modelSegment != null) {
                            modelSegment.setEndIndex(n2 - 1);
                            modelSegment.setNumTrackPoints(n);
                            arrayList.add(modelSegment);
                            n = 0;
                        }
                        modelSegment = new ModelSegment(n2);
                    }
                    ++n;
                }
                ++n2;
            }
            if (modelSegment != null && n > 0) {
                modelSegment.setEndIndex(threeDModel.getNumPoints() - 1);
                modelSegment.setNumTrackPoints(n);
                arrayList.add(modelSegment);
            }
        }
        return arrayList;
    }
}

