/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyFile;
import org.jruby.ir.IRScope;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JRubyFile;
import org.jruby.util.OneShotClassLoader;

public class CompiledScriptLoader {
    public static IRScope loadScriptFromFile(Ruby runtime2, InputStream inStream, File resourcePath, String resourceName, boolean isAbsolute) {
        String name2 = CompiledScriptLoader.getFilenameFromPathAndName(resourcePath, resourceName, isAbsolute);
        try {
            Class clazz = CompiledScriptLoader.loadCompiledScriptFromClass(runtime2, inStream);
            try {
                Method method2 = clazz.getMethod("loadIR", Ruby.class, String.class);
                IRScope iRScope = (IRScope)method2.invoke(null, runtime2, name2);
                return iRScope;
            }
            catch (Exception e) {
                try {
                    if (runtime2.getDebug().isTrue()) {
                        e.printStackTrace();
                    }
                    throw runtime2.newLoadError(name2 + " is not compiled Ruby; use java_import to load normal classes");
                }
                catch (IOException e2) {
                    throw runtime2.newIOErrorFromException(e2);
                }
                catch (LinkageError le) {
                    if (runtime2.getDebug().isTrue()) {
                        le.printStackTrace();
                    }
                    throw runtime2.newLoadError("Linkage error loading compiled script; you may need to recompile '" + name2 + "': " + le);
                }
            }
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException ioe) {
                throw runtime2.newIOErrorFromException(ioe);
            }
        }
    }

    private static Class loadCompiledScriptFromClass(Ruby runtime2, InputStream in) throws IOException {
        int read2;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((read2 = in.read(buf)) != -1) {
            baos.write(buf, 0, read2);
        }
        buf = baos.toByteArray();
        JRubyClassLoader jcl = runtime2.getJRubyClassLoader();
        OneShotClassLoader oscl = new OneShotClassLoader(jcl);
        ClassReader cr = new ClassReader(buf);
        String className = cr.getClassName().replace('/', '.');
        return oscl.defineClass(className, buf);
    }

    public static String getFilenameFromPathAndName(File resourcePath, String resourceName, boolean isAbsolute) {
        return JRubyFile.normalizeSeps(resourcePath != null && !isAbsolute ? RubyFile.canonicalize(resourcePath.getPath()) : resourceName);
    }
}

