/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IMultiModuleEntry;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;

public class ClasspathJrt
extends ClasspathLocation
implements IMultiModuleEntry {
    public File file;
    protected ZipFile annotationZipFile;
    protected boolean closeZipFileAtEnd;
    protected static HashMap<String, Map<String, IModule>> ModulesCache = new HashMap();
    public final Set<String> moduleNamesCache;
    protected List<String> annotationPaths;

    public ClasspathJrt(File file, boolean bl, AccessRuleSet accessRuleSet, String string) {
        super(accessRuleSet, string);
        this.file = file;
        this.closeZipFileAtEnd = bl;
        this.moduleNamesCache = new HashSet<String>();
    }

    public List fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter classpathSectionProblemReporter) {
        return null;
    }

    @Override
    public char[][] getModulesDeclaringPackage(String string, String string2) {
        List<String> list = JRTUtil.getModulesDeclaringPackage(this.file, string, string2);
        return CharOperation.toCharArrays(list);
    }

    @Override
    public boolean hasCompilationUnit(String string, String string2) {
        return JRTUtil.hasCompilationUnit(this.file, string, string2);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, String string3) {
        return this.findClass(cArray, string, string2, string3, false);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, String string3, boolean bl) {
        block9: {
            if (!this.isPackage(string, string2)) {
                return null;
            }
            try {
                Object object;
                IBinaryType iBinaryType;
                block10: {
                    iBinaryType = ClassFileReader.readFromModule(this.file, string2, string3, this.moduleNamesCache::contains);
                    if (iBinaryType == null) break block9;
                    if (this.annotationPaths != null) {
                        object = string3.substring(0, string3.length() - "CLASS".length() - 1);
                        for (String string4 : this.annotationPaths) {
                            try {
                                if (this.annotationZipFile == null) {
                                    this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(string4, null);
                                }
                                if ((iBinaryType = ExternalAnnotationDecorator.create(iBinaryType, string4, (String)object, this.annotationZipFile)).getExternalAnnotationStatus() != BinaryTypeBinding.ExternalAnnotationStatus.TYPE_IS_ANNOTATED) continue;
                                break block10;
                            }
                            catch (IOException iOException) {
                            }
                        }
                        iBinaryType = new ExternalAnnotationDecorator(iBinaryType, null);
                    }
                }
                if ((object = iBinaryType.getModule()) == null && string2 != null) {
                    object = string2.toCharArray();
                }
                return new NameEnvironmentAnswer(iBinaryType, this.fetchAccessRestriction(string3), (char[])object);
            }
            catch (IOException | ClassFormatException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean hasAnnotationFileFor(String string) {
        return false;
    }

    @Override
    public char[][][] findTypeNames(final String string, final String string2) {
        if (!this.isPackage(string, string2)) {
            return null;
        }
        final char[] cArray = string.toCharArray();
        final ArrayList arrayList = new ArrayList();
        try {
            JRTUtil.walkModuleImage(this.file, new JRTUtil.JrtFileVisitor<Path>(){

                @Override
                public FileVisitResult visitPackage(Path path, Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (string.startsWith(path.toString())) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path path, Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path path3 = path.getParent();
                    if (path3 == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!path3.toString().equals(string)) {
                        return FileVisitResult.CONTINUE;
                    }
                    String string3 = path.getName(path.getNameCount() - 1).toString();
                    ClasspathJrt.this.addTypeName(arrayList, string3, -1, cArray);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitModule(Path path, String string3) throws IOException {
                    if (string2 == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!string2.equals(string3)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            }, 7);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n = arrayList.size();
        if (n != 0) {
            char[][][] cArrayArray = new char[n][][];
            arrayList.toArray((T[])cArrayArray);
            return cArrayArray;
        }
        return null;
    }

    protected void addTypeName(ArrayList arrayList, String string, int n, char[] cArray) {
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            String string2 = string.substring(n + 1, n2);
            arrayList.add(CharOperation.arrayConcat(CharOperation.splitOn('/', cArray), string2.toCharArray()));
        }
    }

    @Override
    public void initialize() throws IOException {
        this.loadModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadModules() {
        Map<String, IModule> map = ModulesCache.get(this.file.getPath());
        if (map == null) {
            try {
                final HashMap hashMap = new HashMap();
                JRTUtil.walkModuleImage(this.file, new JRTUtil.JrtFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitPackage(Path path, Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitModule(Path path, String string) throws IOException {
                        ClasspathJrt.this.acceptModule(JRTUtil.getClassfileContent(ClasspathJrt.this.file, "module-info.class", string), (Map<String, IModule>)hashMap);
                        ClasspathJrt.this.moduleNamesCache.add(string);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }, 4);
                HashMap<String, Map<String, IModule>> hashMap2 = ModulesCache;
                synchronized (hashMap2) {
                    if (ModulesCache.get(this.file.getPath()) == null) {
                        ModulesCache.put(this.file.getPath(), Collections.unmodifiableMap(hashMap));
                    }
                }
            }
            catch (IOException iOException) {}
        } else {
            this.moduleNamesCache.addAll(map.keySet());
        }
    }

    void acceptModule(ClassFileReader classFileReader, Map<String, IModule> map) {
        IBinaryModule iBinaryModule;
        if (classFileReader != null && (iBinaryModule = classFileReader.getModuleDeclaration()) != null) {
            map.put(String.valueOf(iBinaryModule.name()), iBinaryModule);
        }
    }

    void acceptModule(byte[] byArray, Map<String, IModule> map) {
        if (byArray == null) {
            return;
        }
        ClassFileReader classFileReader = null;
        try {
            classFileReader = new ClassFileReader(byArray, "module-info.class".toCharArray());
        }
        catch (ClassFormatException classFormatException) {
            classFormatException.printStackTrace();
        }
        if (classFileReader != null) {
            this.acceptModule(classFileReader, map);
        }
    }

    @Override
    public Collection<String> getModuleNames(Collection<String> collection, Function<String, IModule> function) {
        Map<String, IModule> map = ModulesCache.get(this.file.getPath());
        return this.selectModules(map.keySet(), collection, function);
    }

    @Override
    protected <T> List<String> allModules(Iterable<T> iterable, Function<T, String> function, Function<T, IModule> function2) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (T t : iterable) {
            string = function.apply(t);
            if (!"java.se".equals(string)) continue;
            arrayList.add(string);
            bl = true;
            break;
        }
        block1: for (T t : iterable) {
            IModule iModule;
            boolean bl2;
            string = function.apply(t);
            boolean bl3 = string.startsWith("java.");
            boolean bl4 = bl2 = !bl3;
            if (!bl) {
                bl2 |= bl3;
            }
            if (!bl2 || (iModule = function2.apply(t)) == null) continue;
            for (IModule.IPackageExport iPackageExport : iModule.exports()) {
                if (iPackageExport.isQualified()) continue;
                arrayList.add(string);
                continue block1;
            }
        }
        return arrayList;
    }

    @Override
    public void reset() {
        if (this.closeZipFileAtEnd && this.annotationZipFile != null) {
            try {
                this.annotationZipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.annotationZipFile = null;
        }
        if (this.annotationPaths != null) {
            this.annotationPaths = null;
        }
    }

    public String toString() {
        return "Classpath for JRT System " + this.file.getPath();
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            String string = this.getPath();
            char[] cArray = string.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(cArray, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(cArray, 0, CharOperation.lastIndexOf('.', cArray));
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            try {
                this.path = this.file.getCanonicalPath();
            }
            catch (IOException iOException) {
                this.path = this.file.getAbsolutePath();
            }
        }
        return this.path;
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public boolean hasModule() {
        return true;
    }

    @Override
    public IModule getModule(char[] cArray) {
        Map<String, IModule> map = ModulesCache.get(this.file.getPath());
        if (map != null) {
            return map.get(String.valueOf(cArray));
        }
        return null;
    }

    @Override
    public boolean servesModule(char[] cArray) {
        return this.getModule(cArray) != null;
    }
}

