/* promotion-type-selector-dialog.c generated by valac 0.56.0, the Vala compiler
 * generated from promotion-type-selector-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2020 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "libchess.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <librsvg/rsvg.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PROMOTION_TYPE_SELECTOR_DIALOG (promotion_type_selector_dialog_get_type ())
#define PROMOTION_TYPE_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialog))
#define PROMOTION_TYPE_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialogClass))
#define IS_PROMOTION_TYPE_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG))
#define IS_PROMOTION_TYPE_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG))
#define PROMOTION_TYPE_SELECTOR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialogClass))

typedef struct _PromotionTypeSelectorDialog PromotionTypeSelectorDialog;
typedef struct _PromotionTypeSelectorDialogClass PromotionTypeSelectorDialogClass;
typedef struct _PromotionTypeSelectorDialogPrivate PromotionTypeSelectorDialogPrivate;
enum  {
	PROMOTION_TYPE_SELECTOR_DIALOG_0_PROPERTY,
	PROMOTION_TYPE_SELECTOR_DIALOG_NUM_PROPERTIES
};
static GParamSpec* promotion_type_selector_dialog_properties[PROMOTION_TYPE_SELECTOR_DIALOG_NUM_PROPERTIES];
typedef enum  {
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_QUEEN,
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_KNIGHT,
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_ROOK,
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_BISHOP
} PromotionTypeSelectorDialogSelectedType;

#define PROMOTION_TYPE_SELECTOR_DIALOG_TYPE_SELECTED_TYPE (promotion_type_selector_dialog_selected_type_get_type ())
typedef enum  {
	CHESS_WINDOW_LAYOUT_MODE_NORMAL,
	CHESS_WINDOW_LAYOUT_MODE_NARROW
} ChessWindowLayoutMode;

#define CHESS_WINDOW_TYPE_LAYOUT_MODE (chess_window_layout_mode_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PromotionTypeSelectorDialog {
	GtkDialog parent_instance;
	PromotionTypeSelectorDialogPrivate * priv;
};

struct _PromotionTypeSelectorDialogClass {
	GtkDialogClass parent_class;
};

struct _PromotionTypeSelectorDialogPrivate {
	GtkBox* button_box;
	GtkImage* queen_image;
	GtkImage* knight_image;
	GtkImage* rook_image;
	GtkImage* bishop_image;
};

static gint PromotionTypeSelectorDialog_private_offset;
static gpointer promotion_type_selector_dialog_parent_class = NULL;

VALA_EXTERN GType promotion_type_selector_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PromotionTypeSelectorDialog, g_object_unref)
static GType promotion_type_selector_dialog_selected_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GType chess_window_layout_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PromotionTypeSelectorDialog* promotion_type_selector_dialog_new (GtkWindow* window,
                                                                 Color color,
                                                                 const gchar* theme,
                                                                 ChessWindowLayoutMode layout_mode);
VALA_EXTERN PromotionTypeSelectorDialog* promotion_type_selector_dialog_construct (GType object_type,
                                                                       GtkWindow* window,
                                                                       Color color,
                                                                       const gchar* theme,
                                                                       ChessWindowLayoutMode layout_mode);
static void promotion_type_selector_dialog_set_piece_image (PromotionTypeSelectorDialog* self,
                                                     GtkImage* image,
                                                     const gchar* resource_path);
static void promotion_type_selector_dialog_queen_selected_cb (PromotionTypeSelectorDialog* self,
                                                       GtkButton* button);
static void _promotion_type_selector_dialog_queen_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self);
static void promotion_type_selector_dialog_knight_selected_cb (PromotionTypeSelectorDialog* self,
                                                        GtkButton* button);
static void _promotion_type_selector_dialog_knight_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
static void promotion_type_selector_dialog_rook_selected_cb (PromotionTypeSelectorDialog* self,
                                                      GtkButton* button);
static void _promotion_type_selector_dialog_rook_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self);
static void promotion_type_selector_dialog_bishop_selected_cb (PromotionTypeSelectorDialog* self,
                                                        GtkButton* button);
static void _promotion_type_selector_dialog_bishop_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
static void promotion_type_selector_dialog_finalize (GObject * obj);
static GType promotion_type_selector_dialog_get_type_once (void);

static inline gpointer
promotion_type_selector_dialog_get_instance_private (PromotionTypeSelectorDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PromotionTypeSelectorDialog_private_offset);
}

static GType
promotion_type_selector_dialog_selected_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_QUEEN, "PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_QUEEN", "queen"}, {PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_KNIGHT, "PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_KNIGHT", "knight"}, {PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_ROOK, "PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_ROOK", "rook"}, {PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_BISHOP, "PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_BISHOP", "bishop"}, {0, NULL, NULL}};
	GType promotion_type_selector_dialog_selected_type_type_id;
	promotion_type_selector_dialog_selected_type_type_id = g_enum_register_static ("PromotionTypeSelectorDialogSelectedType", values);
	return promotion_type_selector_dialog_selected_type_type_id;
}

static GType
promotion_type_selector_dialog_selected_type_get_type (void)
{
	static volatile gsize promotion_type_selector_dialog_selected_type_type_id__once = 0;
	if (g_once_init_enter (&promotion_type_selector_dialog_selected_type_type_id__once)) {
		GType promotion_type_selector_dialog_selected_type_type_id;
		promotion_type_selector_dialog_selected_type_type_id = promotion_type_selector_dialog_selected_type_get_type_once ();
		g_once_init_leave (&promotion_type_selector_dialog_selected_type_type_id__once, promotion_type_selector_dialog_selected_type_type_id);
	}
	return promotion_type_selector_dialog_selected_type_type_id__once;
}

PromotionTypeSelectorDialog*
promotion_type_selector_dialog_construct (GType object_type,
                                          GtkWindow* window,
                                          Color color,
                                          const gchar* theme,
                                          ChessWindowLayoutMode layout_mode)
{
	PromotionTypeSelectorDialog * self = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* color_string = NULL;
	gchar* _tmp2_;
	gchar* resource_path = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkImage* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkImage* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkImage* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkImage* _tmp22_;
	const gchar* _tmp23_;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (theme != NULL, NULL);
	self = (PromotionTypeSelectorDialog*) g_object_new (object_type, NULL);
	gtk_window_set_transient_for ((GtkWindow*) self, window);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	if (layout_mode == CHESS_WINDOW_LAYOUT_MODE_NARROW) {
		GtkBox* _tmp0_;
		_tmp0_ = self->priv->button_box;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp0_, GTK_ORIENTATION_VERTICAL);
	}
	if (color == COLOR_WHITE) {
		_tmp1_ = "white";
	} else {
		_tmp1_ = "black";
	}
	_tmp2_ = g_strdup (_tmp1_);
	color_string = _tmp2_;
	_tmp3_ = g_strdup_printf ("%sQueen.svg", color_string);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_build_path ("/", "/org/gnome/Chess/pieces", theme, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	resource_path = _tmp6_;
	_tmp7_ = self->priv->queen_image;
	_tmp8_ = resource_path;
	promotion_type_selector_dialog_set_piece_image (self, _tmp7_, _tmp8_);
	_tmp9_ = g_strdup_printf ("%sKnight.svg", color_string);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_build_path ("/", "/org/gnome/Chess/pieces", theme, _tmp10_, NULL);
	_g_free0 (resource_path);
	resource_path = _tmp11_;
	_g_free0 (_tmp10_);
	_tmp12_ = self->priv->knight_image;
	_tmp13_ = resource_path;
	promotion_type_selector_dialog_set_piece_image (self, _tmp12_, _tmp13_);
	_tmp14_ = g_strdup_printf ("%sRook.svg", color_string);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_build_path ("/", "/org/gnome/Chess/pieces", theme, _tmp15_, NULL);
	_g_free0 (resource_path);
	resource_path = _tmp16_;
	_g_free0 (_tmp15_);
	_tmp17_ = self->priv->rook_image;
	_tmp18_ = resource_path;
	promotion_type_selector_dialog_set_piece_image (self, _tmp17_, _tmp18_);
	_tmp19_ = g_strdup_printf ("%sBishop.svg", color_string);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_build_path ("/", "/org/gnome/Chess/pieces", theme, _tmp20_, NULL);
	_g_free0 (resource_path);
	resource_path = _tmp21_;
	_g_free0 (_tmp20_);
	_tmp22_ = self->priv->bishop_image;
	_tmp23_ = resource_path;
	promotion_type_selector_dialog_set_piece_image (self, _tmp22_, _tmp23_);
	_g_free0 (resource_path);
	_g_free0 (color_string);
	return self;
}

PromotionTypeSelectorDialog*
promotion_type_selector_dialog_new (GtkWindow* window,
                                    Color color,
                                    const gchar* theme,
                                    ChessWindowLayoutMode layout_mode)
{
	return promotion_type_selector_dialog_construct (TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, window, color, theme, layout_mode);
}

static void
promotion_type_selector_dialog_set_piece_image (PromotionTypeSelectorDialog* self,
                                                GtkImage* image,
                                                const gchar* resource_path)
{
	static const gint size = 48;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (resource_path != NULL);
	{
		GInputStream* stream = NULL;
		GInputStream* _tmp0_;
		RsvgHandle* h = NULL;
		GInputStream* _tmp1_;
		RsvgHandle* _tmp2_;
		cairo_surface_t* s = NULL;
		cairo_surface_t* _tmp3_;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp4_;
		cairo_t* _tmp5_;
		RsvgHandle* _tmp6_;
		cairo_t* _tmp7_;
		RsvgRectangle _tmp8_ = {0};
		GdkPixbuf* p = NULL;
		cairo_surface_t* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		_tmp0_ = g_resources_open_stream (resource_path, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
		stream = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = stream;
		_tmp2_ = rsvg_handle_new_from_stream_sync (_tmp1_, NULL, RSVG_HANDLE_FLAGS_NONE, NULL, &_inner_error0_);
		h = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			goto __catch0_g_error;
		}
		_tmp3_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, size, size);
		s = _tmp3_;
		_tmp4_ = s;
		_tmp5_ = cairo_create (_tmp4_);
		c = _tmp5_;
		_tmp6_ = h;
		_tmp7_ = c;
		memset (&_tmp8_, 0, sizeof (RsvgRectangle));
		_tmp8_.width = (gdouble) size;
		_tmp8_.height = (gdouble) size;
		_tmp8_.x = (gdouble) 0;
		_tmp8_.y = (gdouble) 0;
		rsvg_handle_render_document (_tmp6_, _tmp7_, &_tmp8_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_cairo_destroy0 (c);
			_cairo_surface_destroy0 (s);
			_g_object_unref0 (h);
			_g_object_unref0 (stream);
			goto __catch0_g_error;
		}
		_tmp9_ = s;
		_tmp10_ = gdk_pixbuf_get_from_surface (_tmp9_, 0, 0, size, size);
		p = _tmp10_;
		_tmp11_ = p;
		gtk_image_set_from_pixbuf (image, _tmp11_);
		g_object_set ((GtkWidget*) image, "height-request", size, NULL);
		_g_object_unref0 (p);
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (s);
		_g_object_unref0 (h);
		_g_object_unref0 (stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("promotion-type-selector-dialog.vala:77: Failed to load piece image %s:" \
" %s", resource_path, _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
promotion_type_selector_dialog_queen_selected_cb (PromotionTypeSelectorDialog* self,
                                                  GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gtk_dialog_response ((GtkDialog*) self, (gint) PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_QUEEN);
}

static void
_promotion_type_selector_dialog_queen_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self)
{
	promotion_type_selector_dialog_queen_selected_cb ((PromotionTypeSelectorDialog*) self, _sender);
}

static void
promotion_type_selector_dialog_knight_selected_cb (PromotionTypeSelectorDialog* self,
                                                   GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gtk_dialog_response ((GtkDialog*) self, (gint) PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_KNIGHT);
}

static void
_promotion_type_selector_dialog_knight_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	promotion_type_selector_dialog_knight_selected_cb ((PromotionTypeSelectorDialog*) self, _sender);
}

static void
promotion_type_selector_dialog_rook_selected_cb (PromotionTypeSelectorDialog* self,
                                                 GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gtk_dialog_response ((GtkDialog*) self, (gint) PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_ROOK);
}

static void
_promotion_type_selector_dialog_rook_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self)
{
	promotion_type_selector_dialog_rook_selected_cb ((PromotionTypeSelectorDialog*) self, _sender);
}

static void
promotion_type_selector_dialog_bishop_selected_cb (PromotionTypeSelectorDialog* self,
                                                   GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gtk_dialog_response ((GtkDialog*) self, (gint) PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_BISHOP);
}

static void
_promotion_type_selector_dialog_bishop_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	promotion_type_selector_dialog_bishop_selected_cb ((PromotionTypeSelectorDialog*) self, _sender);
}

static void
promotion_type_selector_dialog_class_init (PromotionTypeSelectorDialogClass * klass,
                                           gpointer klass_data)
{
	promotion_type_selector_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PromotionTypeSelectorDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = promotion_type_selector_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Chess/ui/promotion-type-selector.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_box", FALSE, PromotionTypeSelectorDialog_private_offset + G_STRUCT_OFFSET (PromotionTypeSelectorDialogPrivate, button_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "queen_image", FALSE, PromotionTypeSelectorDialog_private_offset + G_STRUCT_OFFSET (PromotionTypeSelectorDialogPrivate, queen_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "knight_image", FALSE, PromotionTypeSelectorDialog_private_offset + G_STRUCT_OFFSET (PromotionTypeSelectorDialogPrivate, knight_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rook_image", FALSE, PromotionTypeSelectorDialog_private_offset + G_STRUCT_OFFSET (PromotionTypeSelectorDialogPrivate, rook_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bishop_image", FALSE, PromotionTypeSelectorDialog_private_offset + G_STRUCT_OFFSET (PromotionTypeSelectorDialogPrivate, bishop_image));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "queen_selected_cb", G_CALLBACK(_promotion_type_selector_dialog_queen_selected_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "knight_selected_cb", G_CALLBACK(_promotion_type_selector_dialog_knight_selected_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "rook_selected_cb", G_CALLBACK(_promotion_type_selector_dialog_rook_selected_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "bishop_selected_cb", G_CALLBACK(_promotion_type_selector_dialog_bishop_selected_cb_gtk_button_clicked));
}

static void
promotion_type_selector_dialog_instance_init (PromotionTypeSelectorDialog * self,
                                              gpointer klass)
{
	self->priv = promotion_type_selector_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
promotion_type_selector_dialog_finalize (GObject * obj)
{
	PromotionTypeSelectorDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialog);
	G_OBJECT_CLASS (promotion_type_selector_dialog_parent_class)->finalize (obj);
}

static GType
promotion_type_selector_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PromotionTypeSelectorDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) promotion_type_selector_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PromotionTypeSelectorDialog), 0, (GInstanceInitFunc) promotion_type_selector_dialog_instance_init, NULL };
	GType promotion_type_selector_dialog_type_id;
	promotion_type_selector_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PromotionTypeSelectorDialog", &g_define_type_info, 0);
	PromotionTypeSelectorDialog_private_offset = g_type_add_instance_private (promotion_type_selector_dialog_type_id, sizeof (PromotionTypeSelectorDialogPrivate));
	return promotion_type_selector_dialog_type_id;
}

GType
promotion_type_selector_dialog_get_type (void)
{
	static volatile gsize promotion_type_selector_dialog_type_id__once = 0;
	if (g_once_init_enter (&promotion_type_selector_dialog_type_id__once)) {
		GType promotion_type_selector_dialog_type_id;
		promotion_type_selector_dialog_type_id = promotion_type_selector_dialog_get_type_once ();
		g_once_init_leave (&promotion_type_selector_dialog_type_id__once, promotion_type_selector_dialog_type_id);
	}
	return promotion_type_selector_dialog_type_id__once;
}

