/* world-location-dialog.c generated by valac 0.56.0, the Vala compiler
 * generated from world-location-dialog.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <libgweather/gweather.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define CLOCKS_WORLD_LOCATION_DIALOG_RESULT_COUNT_LIMIT 12
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_WORLD_TYPE_CLOCK_LOCATION (clocks_world_clock_location_get_type ())
#define CLOCKS_WORLD_CLOCK_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_CLOCK_LOCATION, ClocksWorldClockLocation))
#define CLOCKS_WORLD_CLOCK_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_CLOCK_LOCATION, ClocksWorldClockLocationClass))
#define CLOCKS_WORLD_IS_CLOCK_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_CLOCK_LOCATION))
#define CLOCKS_WORLD_IS_CLOCK_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_CLOCK_LOCATION))
#define CLOCKS_WORLD_CLOCK_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_CLOCK_LOCATION, ClocksWorldClockLocationClass))

typedef struct _ClocksWorldClockLocation ClocksWorldClockLocation;
typedef struct _ClocksWorldClockLocationClass ClocksWorldClockLocationClass;
typedef struct _ClocksWorldClockLocationPrivate ClocksWorldClockLocationPrivate;
enum  {
	CLOCKS_WORLD_CLOCK_LOCATION_0_PROPERTY,
	CLOCKS_WORLD_CLOCK_LOCATION_LOCATION_PROPERTY,
	CLOCKS_WORLD_CLOCK_LOCATION_SELECTED_PROPERTY,
	CLOCKS_WORLD_CLOCK_LOCATION_NUM_PROPERTIES
};
static GParamSpec* clocks_world_clock_location_properties[CLOCKS_WORLD_CLOCK_LOCATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_WORLD_TYPE_LOCATION_DIALOG (clocks_world_location_dialog_get_type ())
#define CLOCKS_WORLD_LOCATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog))
#define CLOCKS_WORLD_LOCATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogClass))
#define CLOCKS_WORLD_IS_LOCATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG))
#define CLOCKS_WORLD_IS_LOCATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_LOCATION_DIALOG))
#define CLOCKS_WORLD_LOCATION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogClass))

typedef struct _ClocksWorldLocationDialog ClocksWorldLocationDialog;
typedef struct _ClocksWorldLocationDialogClass ClocksWorldLocationDialogClass;
typedef struct _ClocksWorldLocationDialogPrivate ClocksWorldLocationDialogPrivate;

#define CLOCKS_WORLD_TYPE_FACE (clocks_world_face_get_type ())
#define CLOCKS_WORLD_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace))
#define CLOCKS_WORLD_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFaceClass))
#define CLOCKS_WORLD_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_FACE))
#define CLOCKS_WORLD_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_FACE))
#define CLOCKS_WORLD_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFaceClass))

typedef struct _ClocksWorldFace ClocksWorldFace;
typedef struct _ClocksWorldFaceClass ClocksWorldFaceClass;

#define CLOCKS_WORLD_TYPE_LOCATION_DIALOG_ROW (clocks_world_location_dialog_row_get_type ())
#define CLOCKS_WORLD_LOCATION_DIALOG_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG_ROW, ClocksWorldLocationDialogRow))
#define CLOCKS_WORLD_LOCATION_DIALOG_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_LOCATION_DIALOG_ROW, ClocksWorldLocationDialogRowClass))
#define CLOCKS_WORLD_IS_LOCATION_DIALOG_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG_ROW))
#define CLOCKS_WORLD_IS_LOCATION_DIALOG_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_LOCATION_DIALOG_ROW))
#define CLOCKS_WORLD_LOCATION_DIALOG_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG_ROW, ClocksWorldLocationDialogRowClass))

typedef struct _ClocksWorldLocationDialogRow ClocksWorldLocationDialogRow;
typedef struct _ClocksWorldLocationDialogRowClass ClocksWorldLocationDialogRowClass;
enum  {
	CLOCKS_WORLD_LOCATION_DIALOG_0_PROPERTY,
	CLOCKS_WORLD_LOCATION_DIALOG_NUM_PROPERTIES
};
static GParamSpec* clocks_world_location_dialog_properties[CLOCKS_WORLD_LOCATION_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
enum  {
	CLOCKS_WORLD_LOCATION_DIALOG_LOCATION_ADDED_SIGNAL,
	CLOCKS_WORLD_LOCATION_DIALOG_NUM_SIGNALS
};
static guint clocks_world_location_dialog_signals[CLOCKS_WORLD_LOCATION_DIALOG_NUM_SIGNALS] = {0};

struct _ClocksWorldClockLocation {
	GObject parent_instance;
	ClocksWorldClockLocationPrivate * priv;
};

struct _ClocksWorldClockLocationClass {
	GObjectClass parent_class;
};

struct _ClocksWorldClockLocationPrivate {
	GWeatherLocation* _location;
	gboolean _selected;
};

struct _ClocksWorldLocationDialog {
	GtkWindow parent_instance;
	ClocksWorldLocationDialogPrivate * priv;
};

struct _ClocksWorldLocationDialogClass {
	GtkWindowClass parent_class;
};

struct _ClocksWorldLocationDialogPrivate {
	GtkStack* stack;
	GtkWidget* empty_search;
	GtkWidget* search_results;
	GtkSearchEntry* location_entry;
	GtkListBox* listbox;
	GtkButton* button_add;
	ClocksWorldFace* world;
	GListStore* locations;
	ClocksWorldLocationDialogRow* _selected_row;
};

static gint ClocksWorldClockLocation_private_offset;
static gpointer clocks_world_clock_location_parent_class = NULL;
static gint ClocksWorldLocationDialog_private_offset;
static gpointer clocks_world_location_dialog_parent_class = NULL;

VALA_EXTERN GType clocks_world_clock_location_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldClockLocation, g_object_unref)
VALA_EXTERN ClocksWorldClockLocation* clocks_world_clock_location_new (GWeatherLocation* location,
                                                           gboolean selected);
VALA_EXTERN ClocksWorldClockLocation* clocks_world_clock_location_construct (GType object_type,
                                                                 GWeatherLocation* location,
                                                                 gboolean selected);
VALA_EXTERN GWeatherLocation* clocks_world_clock_location_get_location (ClocksWorldClockLocation* self);
VALA_EXTERN void clocks_world_clock_location_set_location (ClocksWorldClockLocation* self,
                                               GWeatherLocation* value);
VALA_EXTERN gboolean clocks_world_clock_location_get_selected (ClocksWorldClockLocation* self);
VALA_EXTERN void clocks_world_clock_location_set_selected (ClocksWorldClockLocation* self,
                                               gboolean value);
static void clocks_world_clock_location_finalize (GObject * obj);
static GType clocks_world_clock_location_get_type_once (void);
static void _vala_clocks_world_clock_location_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_clocks_world_clock_location_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
VALA_EXTERN GType clocks_world_location_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldLocationDialog, g_object_unref)
VALA_EXTERN GType clocks_world_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldFace, g_object_unref)
VALA_EXTERN GType clocks_world_location_dialog_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldLocationDialogRow, g_object_unref)
VALA_EXTERN ClocksWorldLocationDialog* clocks_world_location_dialog_new (GtkWindow* parent,
                                                             ClocksWorldFace* world_face);
VALA_EXTERN ClocksWorldLocationDialog* clocks_world_location_dialog_construct (GType object_type,
                                                                   GtkWindow* parent,
                                                                   ClocksWorldFace* world_face);
static GtkWidget* __lambda13_ (ClocksWorldLocationDialog* self,
                        GObject* data);
VALA_EXTERN ClocksWorldLocationDialogRow* clocks_world_location_dialog_row_new (ClocksWorldClockLocation* data);
VALA_EXTERN ClocksWorldLocationDialogRow* clocks_world_location_dialog_row_construct (GType object_type,
                                                                          ClocksWorldClockLocation* data);
static GtkWidget* ___lambda13__gtk_list_box_create_widget_func (GObject* item,
                                                         gpointer self);
VALA_EXTERN GWeatherLocation* clocks_world_location_dialog_get_selected_location (ClocksWorldLocationDialog* self);
static ClocksWorldLocationDialogRow* clocks_world_location_dialog_get_selected_row (ClocksWorldLocationDialog* self);
VALA_EXTERN ClocksWorldClockLocation* clocks_world_location_dialog_row_get_data (ClocksWorldLocationDialogRow* self);
static void clocks_world_location_dialog_on_search_mode_notify (ClocksWorldLocationDialog* self,
                                                         GObject* object,
                                                         GParamSpec* param);
static void _clocks_world_location_dialog_on_search_mode_notify_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self);
static void clocks_world_location_dialog_item_activated (ClocksWorldLocationDialog* self,
                                                  GtkListBoxRow* listbox_row);
static void clocks_world_location_dialog_set_selected_row (ClocksWorldLocationDialog* self,
                                                    ClocksWorldLocationDialogRow* value);
static void _clocks_world_location_dialog_item_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                              GtkListBoxRow* row,
                                                                              gpointer self);
static void clocks_world_location_dialog_on_search_changed (ClocksWorldLocationDialog* self);
static void clocks_world_location_dialog_query_locations (ClocksWorldLocationDialog* self,
                                                   GWeatherLocation* location,
                                                   const gchar* search);
static gint __lambda14_ (ClocksWorldLocationDialog* self,
                  GObject* a,
                  GObject* b);
static gint ___lambda14__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void _clocks_world_location_dialog_on_search_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                      gpointer self);
static void clocks_world_location_dialog_add_button_clicked (ClocksWorldLocationDialog* self);
static void _clocks_world_location_dialog_add_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self);
VALA_EXTERN gboolean clocks_world_face_location_exists (ClocksWorldFace* self,
                                            GWeatherLocation* location);
static void clocks_world_location_dialog_finalize (GObject * obj);
static GType clocks_world_location_dialog_get_type_once (void);
static void _vala_clocks_world_location_dialog_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_clocks_world_location_dialog_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
clocks_world_clock_location_get_instance_private (ClocksWorldClockLocation* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksWorldClockLocation_private_offset);
}

ClocksWorldClockLocation*
clocks_world_clock_location_construct (GType object_type,
                                       GWeatherLocation* location,
                                       gboolean selected)
{
	ClocksWorldClockLocation * self = NULL;
	g_return_val_if_fail (location != NULL, NULL);
	self = (ClocksWorldClockLocation*) g_object_new (object_type, "location", location, "selected", selected, NULL);
	return self;
}

ClocksWorldClockLocation*
clocks_world_clock_location_new (GWeatherLocation* location,
                                 gboolean selected)
{
	return clocks_world_clock_location_construct (CLOCKS_WORLD_TYPE_CLOCK_LOCATION, location, selected);
}

GWeatherLocation*
clocks_world_clock_location_get_location (ClocksWorldClockLocation* self)
{
	GWeatherLocation* result;
	GWeatherLocation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
clocks_world_clock_location_set_location (ClocksWorldClockLocation* self,
                                          GWeatherLocation* value)
{
	GWeatherLocation* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_world_clock_location_get_location (self);
	if (old_value != value) {
		GWeatherLocation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_location);
		self->priv->_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_clock_location_properties[CLOCKS_WORLD_CLOCK_LOCATION_LOCATION_PROPERTY]);
	}
}

gboolean
clocks_world_clock_location_get_selected (ClocksWorldClockLocation* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_selected;
	return result;
}

void
clocks_world_clock_location_set_selected (ClocksWorldClockLocation* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_world_clock_location_get_selected (self);
	if (old_value != value) {
		self->priv->_selected = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_clock_location_properties[CLOCKS_WORLD_CLOCK_LOCATION_SELECTED_PROPERTY]);
	}
}

static void
clocks_world_clock_location_class_init (ClocksWorldClockLocationClass * klass,
                                        gpointer klass_data)
{
	clocks_world_clock_location_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksWorldClockLocation_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_clock_location_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_clock_location_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_clock_location_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_CLOCK_LOCATION_LOCATION_PROPERTY, clocks_world_clock_location_properties[CLOCKS_WORLD_CLOCK_LOCATION_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", gweather_location_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_CLOCK_LOCATION_SELECTED_PROPERTY, clocks_world_clock_location_properties[CLOCKS_WORLD_CLOCK_LOCATION_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
clocks_world_clock_location_instance_init (ClocksWorldClockLocation * self,
                                           gpointer klass)
{
	self->priv = clocks_world_clock_location_get_instance_private (self);
}

static void
clocks_world_clock_location_finalize (GObject * obj)
{
	ClocksWorldClockLocation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_CLOCK_LOCATION, ClocksWorldClockLocation);
	_g_object_unref0 (self->priv->_location);
	G_OBJECT_CLASS (clocks_world_clock_location_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_world_clock_location_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldClockLocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_clock_location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldClockLocation), 0, (GInstanceInitFunc) clocks_world_clock_location_instance_init, NULL };
	GType clocks_world_clock_location_type_id;
	clocks_world_clock_location_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksWorldClockLocation", &g_define_type_info, 0);
	ClocksWorldClockLocation_private_offset = g_type_add_instance_private (clocks_world_clock_location_type_id, sizeof (ClocksWorldClockLocationPrivate));
	return clocks_world_clock_location_type_id;
}

GType
clocks_world_clock_location_get_type (void)
{
	static volatile gsize clocks_world_clock_location_type_id__once = 0;
	if (g_once_init_enter (&clocks_world_clock_location_type_id__once)) {
		GType clocks_world_clock_location_type_id;
		clocks_world_clock_location_type_id = clocks_world_clock_location_get_type_once ();
		g_once_init_leave (&clocks_world_clock_location_type_id__once, clocks_world_clock_location_type_id);
	}
	return clocks_world_clock_location_type_id__once;
}

static void
_vala_clocks_world_clock_location_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	ClocksWorldClockLocation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_CLOCK_LOCATION, ClocksWorldClockLocation);
	switch (property_id) {
		case CLOCKS_WORLD_CLOCK_LOCATION_LOCATION_PROPERTY:
		g_value_set_object (value, clocks_world_clock_location_get_location (self));
		break;
		case CLOCKS_WORLD_CLOCK_LOCATION_SELECTED_PROPERTY:
		g_value_set_boolean (value, clocks_world_clock_location_get_selected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_world_clock_location_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	ClocksWorldClockLocation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_CLOCK_LOCATION, ClocksWorldClockLocation);
	switch (property_id) {
		case CLOCKS_WORLD_CLOCK_LOCATION_LOCATION_PROPERTY:
		clocks_world_clock_location_set_location (self, g_value_get_object (value));
		break;
		case CLOCKS_WORLD_CLOCK_LOCATION_SELECTED_PROPERTY:
		clocks_world_clock_location_set_selected (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
clocks_world_location_dialog_get_instance_private (ClocksWorldLocationDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksWorldLocationDialog_private_offset);
}

static GtkWidget*
__lambda13_ (ClocksWorldLocationDialog* self,
             GObject* data)
{
	ClocksWorldLocationDialogRow* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = clocks_world_location_dialog_row_new (G_TYPE_CHECK_INSTANCE_CAST (data, CLOCKS_WORLD_TYPE_CLOCK_LOCATION, ClocksWorldClockLocation));
	g_object_ref_sink (_tmp0_);
	result = (GtkWidget*) _tmp0_;
	return result;
}

static GtkWidget*
___lambda13__gtk_list_box_create_widget_func (GObject* item,
                                              gpointer self)
{
	GtkWidget* result;
	result = __lambda13_ ((ClocksWorldLocationDialog*) self, item);
	return result;
}

ClocksWorldLocationDialog*
clocks_world_location_dialog_construct (GType object_type,
                                        GtkWindow* parent,
                                        ClocksWorldFace* world_face)
{
	ClocksWorldLocationDialog * self = NULL;
	GtkSearchEntry* _tmp0_;
	ClocksWorldFace* _tmp1_;
	GListStore* _tmp2_;
	GtkListBox* _tmp3_;
	GListStore* _tmp4_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (world_face != NULL, NULL);
	self = (ClocksWorldLocationDialog*) g_object_new (object_type, "transient-for", parent, NULL);
	_tmp0_ = self->priv->location_entry;
	gtk_search_entry_set_key_capture_widget (_tmp0_, (GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (world_face);
	_g_object_unref0 (self->priv->world);
	self->priv->world = _tmp1_;
	_tmp2_ = g_list_store_new (CLOCKS_WORLD_TYPE_CLOCK_LOCATION);
	_g_object_unref0 (self->priv->locations);
	self->priv->locations = _tmp2_;
	_tmp3_ = self->priv->listbox;
	_tmp4_ = self->priv->locations;
	gtk_list_box_bind_model (_tmp3_, (GListModel*) _tmp4_, ___lambda13__gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	return self;
}

ClocksWorldLocationDialog*
clocks_world_location_dialog_new (GtkWindow* parent,
                                  ClocksWorldFace* world_face)
{
	return clocks_world_location_dialog_construct (CLOCKS_WORLD_TYPE_LOCATION_DIALOG, parent, world_face);
}

GWeatherLocation*
clocks_world_location_dialog_get_selected_location (ClocksWorldLocationDialog* self)
{
	ClocksWorldLocationDialogRow* _tmp0_;
	ClocksWorldLocationDialogRow* _tmp1_;
	ClocksWorldLocationDialogRow* _tmp2_;
	ClocksWorldLocationDialogRow* _tmp3_;
	ClocksWorldClockLocation* _tmp4_;
	ClocksWorldClockLocation* _tmp5_;
	GWeatherLocation* _tmp6_;
	GWeatherLocation* _tmp7_;
	GWeatherLocation* _tmp8_;
	GWeatherLocation* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_world_location_dialog_get_selected_row (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = clocks_world_location_dialog_get_selected_row (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = clocks_world_location_dialog_row_get_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CLOCKS_WORLD_TYPE_LOCATION_DIALOG_ROW, ClocksWorldLocationDialogRow));
	_tmp5_ = _tmp4_;
	_tmp6_ = clocks_world_clock_location_get_location (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	result = _tmp8_;
	return result;
}

static void
clocks_world_location_dialog_on_search_mode_notify (ClocksWorldLocationDialog* self,
                                                    GObject* object,
                                                    GParamSpec* param)
{
	GtkSearchBar* search_bar = NULL;
	GtkSearchBar* _tmp0_;
	GtkSearchBar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, gtk_search_bar_get_type (), GtkSearchBar));
	search_bar = _tmp0_;
	_tmp1_ = search_bar;
	g_object_get (_tmp1_, "search-mode-enabled", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		GtkSearchBar* _tmp4_;
		_tmp4_ = search_bar;
		g_object_set (_tmp4_, "search-mode-enabled", TRUE, NULL);
	}
	_g_object_unref0 (search_bar);
}

static void
_clocks_world_location_dialog_on_search_mode_notify_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self)
{
	clocks_world_location_dialog_on_search_mode_notify ((ClocksWorldLocationDialog*) self, _sender, pspec);
}

static void
clocks_world_location_dialog_item_activated (ClocksWorldLocationDialog* self,
                                             GtkListBoxRow* listbox_row)
{
	ClocksWorldLocationDialogRow* row = NULL;
	ClocksWorldLocationDialogRow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ClocksWorldLocationDialogRow* _tmp2_;
	ClocksWorldLocationDialogRow* _tmp3_;
	ClocksWorldLocationDialogRow* _tmp11_;
	ClocksWorldClockLocation* _tmp12_;
	ClocksWorldClockLocation* _tmp13_;
	ClocksWorldLocationDialogRow* _tmp14_;
	ClocksWorldClockLocation* _tmp15_;
	ClocksWorldClockLocation* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	ClocksWorldLocationDialogRow* _tmp19_;
	ClocksWorldClockLocation* _tmp20_;
	ClocksWorldClockLocation* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (listbox_row != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (listbox_row, CLOCKS_WORLD_TYPE_LOCATION_DIALOG_ROW, ClocksWorldLocationDialogRow));
	row = _tmp0_;
	_tmp2_ = clocks_world_location_dialog_get_selected_row (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ClocksWorldLocationDialogRow* _tmp4_;
		ClocksWorldLocationDialogRow* _tmp5_;
		ClocksWorldLocationDialogRow* _tmp6_;
		_tmp4_ = clocks_world_location_dialog_get_selected_row (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = row;
		_tmp1_ = _tmp5_ != _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ClocksWorldLocationDialogRow* _tmp7_;
		ClocksWorldLocationDialogRow* _tmp8_;
		ClocksWorldClockLocation* _tmp9_;
		ClocksWorldClockLocation* _tmp10_;
		_tmp7_ = clocks_world_location_dialog_get_selected_row (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = clocks_world_location_dialog_row_get_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, CLOCKS_WORLD_TYPE_LOCATION_DIALOG_ROW, ClocksWorldLocationDialogRow));
		_tmp10_ = _tmp9_;
		clocks_world_clock_location_set_selected (_tmp10_, FALSE);
	}
	_tmp11_ = row;
	_tmp12_ = clocks_world_location_dialog_row_get_data (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = row;
	_tmp15_ = clocks_world_location_dialog_row_get_data (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = clocks_world_clock_location_get_selected (_tmp16_);
	_tmp18_ = _tmp17_;
	clocks_world_clock_location_set_selected (_tmp13_, !_tmp18_);
	_tmp19_ = row;
	_tmp20_ = clocks_world_location_dialog_row_get_data (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = clocks_world_clock_location_get_selected (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_) {
		ClocksWorldLocationDialogRow* _tmp24_;
		_tmp24_ = row;
		clocks_world_location_dialog_set_selected_row (self, _tmp24_);
	} else {
		clocks_world_location_dialog_set_selected_row (self, NULL);
	}
	_g_object_unref0 (row);
}

static void
_clocks_world_location_dialog_item_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                         GtkListBoxRow* row,
                                                                         gpointer self)
{
	clocks_world_location_dialog_item_activated ((ClocksWorldLocationDialog*) self, row);
}

static gint
__lambda14_ (ClocksWorldLocationDialog* self,
             GObject* a,
             GObject* b)
{
	gchar* name_a = NULL;
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* name_b = NULL;
	GWeatherLocation* _tmp4_;
	GWeatherLocation* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GCompareFunc _tmp8_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = clocks_world_clock_location_get_location (G_TYPE_CHECK_INSTANCE_CAST (a, CLOCKS_WORLD_TYPE_CLOCK_LOCATION, ClocksWorldClockLocation));
	_tmp1_ = _tmp0_;
	_tmp2_ = gweather_location_get_sort_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	name_a = _tmp3_;
	_tmp4_ = clocks_world_clock_location_get_location (G_TYPE_CHECK_INSTANCE_CAST (b, CLOCKS_WORLD_TYPE_CLOCK_LOCATION, ClocksWorldClockLocation));
	_tmp5_ = _tmp4_;
	_tmp6_ = gweather_location_get_sort_name (_tmp5_);
	_tmp7_ = g_strdup (_tmp6_);
	name_b = _tmp7_;
	_tmp8_ = ((GCompareFunc) g_strcmp0);
	result = _tmp8_ (name_a, name_b);
	_g_free0 (name_b);
	_g_free0 (name_a);
	return result;
}

static gint
___lambda14__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda14_ ((ClocksWorldLocationDialog*) self, (GObject*) a, (GObject*) b);
	return result;
}

static void
clocks_world_location_dialog_on_search_changed (ClocksWorldLocationDialog* self)
{
	GListStore* _tmp0_;
	GtkSearchEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* search = NULL;
	GtkSearchEntry* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GWeatherLocation* world_location = NULL;
	GWeatherLocation* _tmp13_;
	GWeatherLocation* _tmp14_;
	GWeatherLocation* _tmp15_;
	const gchar* _tmp16_;
	GListStore* _tmp17_;
	GListStore* _tmp20_;
	GtkStack* _tmp21_;
	GtkWidget* _tmp22_;
	g_return_if_fail (self != NULL);
	clocks_world_location_dialog_set_selected_row (self, NULL);
	_tmp0_ = self->priv->locations;
	g_list_store_remove_all (_tmp0_);
	_tmp1_ = self->priv->location_entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		GtkStack* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp4_ = self->priv->stack;
		_tmp5_ = self->priv->empty_search;
		gtk_stack_set_visible_child (_tmp4_, _tmp5_);
		return;
	}
	_tmp6_ = self->priv->location_entry;
	_tmp7_ = gtk_editable_get_text ((GtkEditable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_utf8_normalize (_tmp8_, (gssize) -1, G_NORMALIZE_DEFAULT);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_utf8_casefold (_tmp10_, (gssize) -1);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	search = _tmp12_;
	_tmp13_ = gweather_location_get_world ();
	world_location = _tmp13_;
	_tmp14_ = world_location;
	if (_tmp14_ == NULL) {
		_g_object_unref0 (world_location);
		_g_free0 (search);
		return;
	}
	_tmp15_ = world_location;
	_tmp16_ = search;
	clocks_world_location_dialog_query_locations (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gweather_location_get_type (), GWeatherLocation), _tmp16_);
	_tmp17_ = self->priv->locations;
	if (g_list_model_get_n_items ((GListModel*) _tmp17_) == ((guint) 0)) {
		GtkStack* _tmp18_;
		GtkWidget* _tmp19_;
		_tmp18_ = self->priv->stack;
		_tmp19_ = self->priv->empty_search;
		gtk_stack_set_visible_child (_tmp18_, _tmp19_);
		_g_object_unref0 (world_location);
		_g_free0 (search);
		return;
	}
	_tmp20_ = self->priv->locations;
	g_list_store_sort (_tmp20_, ___lambda14__gcompare_data_func, self);
	_tmp21_ = self->priv->stack;
	_tmp22_ = self->priv->search_results;
	gtk_stack_set_visible_child (_tmp21_, _tmp22_);
	_g_object_unref0 (world_location);
	_g_free0 (search);
}

static void
_clocks_world_location_dialog_on_search_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                 gpointer self)
{
	clocks_world_location_dialog_on_search_changed ((ClocksWorldLocationDialog*) self);
}

static void
clocks_world_location_dialog_add_button_clicked (ClocksWorldLocationDialog* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, clocks_world_location_dialog_signals[CLOCKS_WORLD_LOCATION_DIALOG_LOCATION_ADDED_SIGNAL], 0);
	gtk_window_close ((GtkWindow*) self);
}

static void
_clocks_world_location_dialog_add_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self)
{
	clocks_world_location_dialog_add_button_clicked ((ClocksWorldLocationDialog*) self);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gpointer
_g_time_zone_ref0 (gpointer self)
{
	return self ? g_time_zone_ref (self) : NULL;
}

static void
clocks_world_location_dialog_query_locations (ClocksWorldLocationDialog* self,
                                              GWeatherLocation* location,
                                              const gchar* search)
{
	GListStore* _tmp0_;
	GWeatherLocation* loc = NULL;
	GWeatherLocation* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (search != NULL);
	_tmp0_ = self->priv->locations;
	if (g_list_model_get_n_items ((GListModel*) _tmp0_) >= ((guint) CLOCKS_WORLD_LOCATION_DIALOG_RESULT_COUNT_LIMIT)) {
		return;
	}
	switch (gweather_location_get_level (location)) {
		case GWEATHER_LOCATION_CITY:
		{
			gboolean contains_name = FALSE;
			const gchar* _tmp1_;
			gchar* country_name = NULL;
			gchar* _tmp2_;
			const gchar* _tmp3_;
			gboolean _tmp8_ = FALSE;
			const gchar* _tmp9_;
			gboolean contains_country_name = FALSE;
			gchar* timezone_name = NULL;
			GTimeZone* timezone = NULL;
			GTimeZone* _tmp11_;
			GTimeZone* _tmp12_;
			GTimeZone* _tmp13_;
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_;
			gboolean contains_timezone_name = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			_tmp1_ = gweather_location_get_sort_name (location);
			contains_name = string_contains (_tmp1_, search);
			_tmp2_ = gweather_location_get_country_name (location);
			country_name = _tmp2_;
			_tmp3_ = country_name;
			if (_tmp3_ != NULL) {
				const gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp4_ = country_name;
				_tmp5_ = g_utf8_normalize ((const gchar*) _tmp4_, (gssize) -1, G_NORMALIZE_DEFAULT);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_utf8_casefold (_tmp6_, (gssize) -1);
				_g_free0 (country_name);
				country_name = _tmp7_;
				_g_free0 (_tmp6_);
			}
			_tmp9_ = country_name;
			if (_tmp9_ != NULL) {
				const gchar* _tmp10_;
				_tmp10_ = country_name;
				_tmp8_ = string_contains ((const gchar*) _tmp10_, search);
			} else {
				_tmp8_ = FALSE;
			}
			contains_country_name = _tmp8_;
			timezone_name = NULL;
			_tmp11_ = gweather_location_get_timezone (location);
			_tmp12_ = _g_time_zone_ref0 (_tmp11_);
			timezone = _tmp12_;
			_tmp13_ = timezone;
			if (_tmp13_ != NULL) {
				GTimeZone* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp14_ = timezone;
				_tmp15_ = g_time_zone_get_identifier (_tmp14_);
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (timezone_name);
				timezone_name = _tmp16_;
				_tmp17_ = timezone_name;
				if (_tmp17_ != NULL) {
					const gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp18_ = timezone_name;
					_tmp19_ = g_utf8_normalize ((const gchar*) _tmp18_, (gssize) -1, G_NORMALIZE_DEFAULT);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_utf8_casefold (_tmp20_, (gssize) -1);
					_g_free0 (timezone_name);
					timezone_name = _tmp21_;
					_g_free0 (_tmp20_);
				}
			}
			_tmp23_ = timezone_name;
			if (_tmp23_ != NULL) {
				const gchar* _tmp24_;
				_tmp24_ = timezone_name;
				_tmp22_ = string_contains ((const gchar*) _tmp24_, search);
			} else {
				_tmp22_ = FALSE;
			}
			contains_timezone_name = _tmp22_;
			if (contains_name) {
				_tmp26_ = TRUE;
			} else {
				_tmp26_ = contains_country_name;
			}
			if (_tmp26_) {
				_tmp25_ = TRUE;
			} else {
				_tmp25_ = contains_timezone_name;
			}
			if (_tmp25_) {
				gboolean selected = FALSE;
				ClocksWorldFace* _tmp27_;
				GListStore* _tmp28_;
				ClocksWorldClockLocation* _tmp29_;
				ClocksWorldClockLocation* _tmp30_;
				_tmp27_ = self->priv->world;
				selected = clocks_world_face_location_exists (_tmp27_, location);
				_tmp28_ = self->priv->locations;
				_tmp29_ = clocks_world_clock_location_new (location, selected);
				_tmp30_ = _tmp29_;
				g_list_store_append (_tmp28_, (GObject*) _tmp30_);
				_g_object_unref0 (_tmp30_);
			}
			_g_time_zone_unref0 (timezone);
			_g_free0 (timezone_name);
			_g_free0 (country_name);
			return;
		}
		case GWEATHER_LOCATION_NAMED_TIMEZONE:
		{
			const gchar* _tmp31_;
			_tmp31_ = gweather_location_get_sort_name (location);
			if (string_contains (_tmp31_, search)) {
				gboolean selected = FALSE;
				ClocksWorldFace* _tmp32_;
				GListStore* _tmp33_;
				ClocksWorldClockLocation* _tmp34_;
				ClocksWorldClockLocation* _tmp35_;
				_tmp32_ = self->priv->world;
				selected = clocks_world_face_location_exists (_tmp32_, location);
				_tmp33_ = self->priv->locations;
				_tmp34_ = clocks_world_clock_location_new (location, selected);
				_tmp35_ = _tmp34_;
				g_list_store_append (_tmp33_, (GObject*) _tmp35_);
				_g_object_unref0 (_tmp35_);
			}
			return;
		}
		default:
		{
			break;
		}
	}
	_tmp36_ = gweather_location_next_child (location, NULL);
	loc = _tmp36_;
	while (TRUE) {
		GWeatherLocation* _tmp37_;
		GWeatherLocation* _tmp38_;
		GListStore* _tmp39_;
		GWeatherLocation* _tmp40_;
		GWeatherLocation* _tmp41_;
		GWeatherLocation* _tmp42_;
		_tmp37_ = loc;
		if (!(_tmp37_ != NULL)) {
			break;
		}
		_tmp38_ = loc;
		clocks_world_location_dialog_query_locations (self, _tmp38_, search);
		_tmp39_ = self->priv->locations;
		if (g_list_model_get_n_items ((GListModel*) _tmp39_) >= ((guint) CLOCKS_WORLD_LOCATION_DIALOG_RESULT_COUNT_LIMIT)) {
			_g_object_unref0 (loc);
			return;
		}
		_tmp40_ = loc;
		_tmp41_ = _g_object_ref0 (_tmp40_);
		_tmp42_ = gweather_location_next_child (location, _tmp41_);
		_g_object_unref0 (loc);
		loc = _tmp42_;
	}
	_g_object_unref0 (loc);
}

static ClocksWorldLocationDialogRow*
clocks_world_location_dialog_get_selected_row (ClocksWorldLocationDialog* self)
{
	ClocksWorldLocationDialogRow* result;
	ClocksWorldLocationDialogRow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_row;
	result = _tmp0_;
	return result;
}

static void
clocks_world_location_dialog_set_selected_row (ClocksWorldLocationDialog* self,
                                               ClocksWorldLocationDialogRow* value)
{
	ClocksWorldLocationDialogRow* _tmp0_;
	GtkButton* _tmp1_;
	ClocksWorldLocationDialogRow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_selected_row);
	self->priv->_selected_row = _tmp0_;
	_tmp1_ = self->priv->button_add;
	_tmp2_ = self->priv->_selected_row;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, _tmp2_ != NULL);
}

static void
clocks_world_location_dialog_class_init (ClocksWorldLocationDialogClass * klass,
                                         gpointer klass_data)
{
	clocks_world_location_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksWorldLocationDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_location_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_location_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_location_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/world-location-dialog.ui");
	clocks_world_location_dialog_signals[CLOCKS_WORLD_LOCATION_DIALOG_LOCATION_ADDED_SIGNAL] = g_signal_new ("location-added", CLOCKS_WORLD_TYPE_LOCATION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ClocksWorldLocationDialog_private_offset + G_STRUCT_OFFSET (ClocksWorldLocationDialogPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "empty_search", FALSE, ClocksWorldLocationDialog_private_offset + G_STRUCT_OFFSET (ClocksWorldLocationDialogPrivate, empty_search));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_results", FALSE, ClocksWorldLocationDialog_private_offset + G_STRUCT_OFFSET (ClocksWorldLocationDialogPrivate, search_results));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "location_entry", FALSE, ClocksWorldLocationDialog_private_offset + G_STRUCT_OFFSET (ClocksWorldLocationDialogPrivate, location_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "listbox", FALSE, ClocksWorldLocationDialog_private_offset + G_STRUCT_OFFSET (ClocksWorldLocationDialogPrivate, listbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_add", FALSE, ClocksWorldLocationDialog_private_offset + G_STRUCT_OFFSET (ClocksWorldLocationDialogPrivate, button_add));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_search_mode_notify", G_CALLBACK(_clocks_world_location_dialog_on_search_mode_notify_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "item_activated", G_CALLBACK(_clocks_world_location_dialog_item_activated_gtk_list_box_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_search_changed", G_CALLBACK(_clocks_world_location_dialog_on_search_changed_gtk_search_entry_search_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "add_button_clicked", G_CALLBACK(_clocks_world_location_dialog_add_button_clicked_gtk_button_clicked));
}

static void
clocks_world_location_dialog_instance_init (ClocksWorldLocationDialog * self,
                                            gpointer klass)
{
	self->priv = clocks_world_location_dialog_get_instance_private (self);
	self->priv->_selected_row = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
clocks_world_location_dialog_finalize (GObject * obj)
{
	ClocksWorldLocationDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog);
	_g_object_unref0 (self->priv->world);
	_g_object_unref0 (self->priv->locations);
	_g_object_unref0 (self->priv->_selected_row);
	G_OBJECT_CLASS (clocks_world_location_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_world_location_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldLocationDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_location_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldLocationDialog), 0, (GInstanceInitFunc) clocks_world_location_dialog_instance_init, NULL };
	GType clocks_world_location_dialog_type_id;
	clocks_world_location_dialog_type_id = g_type_register_static (gtk_window_get_type (), "ClocksWorldLocationDialog", &g_define_type_info, 0);
	ClocksWorldLocationDialog_private_offset = g_type_add_instance_private (clocks_world_location_dialog_type_id, sizeof (ClocksWorldLocationDialogPrivate));
	return clocks_world_location_dialog_type_id;
}

GType
clocks_world_location_dialog_get_type (void)
{
	static volatile gsize clocks_world_location_dialog_type_id__once = 0;
	if (g_once_init_enter (&clocks_world_location_dialog_type_id__once)) {
		GType clocks_world_location_dialog_type_id;
		clocks_world_location_dialog_type_id = clocks_world_location_dialog_get_type_once ();
		g_once_init_leave (&clocks_world_location_dialog_type_id__once, clocks_world_location_dialog_type_id);
	}
	return clocks_world_location_dialog_type_id__once;
}

static void
_vala_clocks_world_location_dialog_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	ClocksWorldLocationDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_world_location_dialog_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	ClocksWorldLocationDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

