/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.5.0
 *
 * Copyright (c) 2021 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 30 "/build/pyqt5/src/PyQt5-5.15.6/sip/QtGui/qvector4d.sip"
#include <qvector4d.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.6/build/QtGui/sipQtGuiQVector4D.cpp"

#line 26 "/build/pyqt5/src/PyQt5-5.15.6/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.6/build/QtGui/sipQtGuiQVector4D.cpp"
#line 98 "/build/pyqt5/src/PyQt5-5.15.6/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.6/build/QtGui/sipQtGuiQVector4D.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.6/sip/QtGui/qvector2d.sip"
#include <qvector2d.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.6/build/QtGui/sipQtGuiQVector4D.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.6/sip/QtGui/qvector3d.sip"
#include <qvector3d.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.6/build/QtGui/sipQtGuiQVector4D.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.6/sip/QtGui/qmatrix4x4.sip"
#include <qmatrix4x4.h>
#line 45 "/build/pyqt5/src/PyQt5-5.15.6/build/QtGui/sipQtGuiQVector4D.cpp"


PyDoc_STRVAR(doc_QVector4D_length, "length(self) -> float");

extern "C" {static PyObject *meth_QVector4D_length(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_length(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->length();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_length, doc_QVector4D_length);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_lengthSquared, "lengthSquared(self) -> float");

extern "C" {static PyObject *meth_QVector4D_lengthSquared(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_lengthSquared(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->lengthSquared();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_lengthSquared, doc_QVector4D_lengthSquared);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_normalized, "normalized(self) -> QVector4D");

extern "C" {static PyObject *meth_QVector4D_normalized(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_normalized(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D(sipCpp->normalized());

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_normalized, doc_QVector4D_normalized);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_normalize, "normalize(self)");

extern "C" {static PyObject *meth_QVector4D_normalize(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_normalize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
            sipCpp->normalize();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_normalize, doc_QVector4D_normalize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_dotProduct, "dotProduct(QVector4D, QVector4D) -> float");

extern "C" {static PyObject *meth_QVector4D_dotProduct(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_dotProduct(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D* a0;
        const  ::QVector4D* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_QVector4D, &a0, sipType_QVector4D, &a1))
        {
            float sipRes;

            sipRes =  ::QVector4D::dotProduct(*a0,*a1);

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_dotProduct, doc_QVector4D_dotProduct);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_toVector2D, "toVector2D(self) -> QVector2D");

extern "C" {static PyObject *meth_QVector4D_toVector2D(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_toVector2D(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
             ::QVector2D*sipRes;

            sipRes = new  ::QVector2D(sipCpp->toVector2D());

            return sipConvertFromNewType(sipRes,sipType_QVector2D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_toVector2D, doc_QVector4D_toVector2D);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_toVector2DAffine, "toVector2DAffine(self) -> QVector2D");

extern "C" {static PyObject *meth_QVector4D_toVector2DAffine(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_toVector2DAffine(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
             ::QVector2D*sipRes;

            sipRes = new  ::QVector2D(sipCpp->toVector2DAffine());

            return sipConvertFromNewType(sipRes,sipType_QVector2D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_toVector2DAffine, doc_QVector4D_toVector2DAffine);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_toVector3D, "toVector3D(self) -> QVector3D");

extern "C" {static PyObject *meth_QVector4D_toVector3D(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_toVector3D(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
             ::QVector3D*sipRes;

            sipRes = new  ::QVector3D(sipCpp->toVector3D());

            return sipConvertFromNewType(sipRes,sipType_QVector3D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_toVector3D, doc_QVector4D_toVector3D);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_toVector3DAffine, "toVector3DAffine(self) -> QVector3D");

extern "C" {static PyObject *meth_QVector4D_toVector3DAffine(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_toVector3DAffine(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
             ::QVector3D*sipRes;

            sipRes = new  ::QVector3D(sipCpp->toVector3DAffine());

            return sipConvertFromNewType(sipRes,sipType_QVector3D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_toVector3DAffine, doc_QVector4D_toVector3DAffine);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QVector4D_isNull(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_isNull, doc_QVector4D_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_x, "x(self) -> float");

extern "C" {static PyObject *meth_QVector4D_x(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_x(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->x();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_x, doc_QVector4D_x);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_y, "y(self) -> float");

extern "C" {static PyObject *meth_QVector4D_y(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_y(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->y();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_y, doc_QVector4D_y);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_z, "z(self) -> float");

extern "C" {static PyObject *meth_QVector4D_z(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_z(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->z();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_z, doc_QVector4D_z);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_w, "w(self) -> float");

extern "C" {static PyObject *meth_QVector4D_w(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_w(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->w();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_w, doc_QVector4D_w);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_setX, "setX(self, float)");

extern "C" {static PyObject *meth_QVector4D_setX(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_setX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
         ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QVector4D, &sipCpp, &a0))
        {
            sipCpp->setX(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_setX, doc_QVector4D_setX);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_setY, "setY(self, float)");

extern "C" {static PyObject *meth_QVector4D_setY(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_setY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
         ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QVector4D, &sipCpp, &a0))
        {
            sipCpp->setY(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_setY, doc_QVector4D_setY);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_setZ, "setZ(self, float)");

extern "C" {static PyObject *meth_QVector4D_setZ(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_setZ(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
         ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QVector4D, &sipCpp, &a0))
        {
            sipCpp->setZ(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_setZ, doc_QVector4D_setZ);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_setW, "setW(self, float)");

extern "C" {static PyObject *meth_QVector4D_setW(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_setW(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
         ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QVector4D, &sipCpp, &a0))
        {
            sipCpp->setW(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_setW, doc_QVector4D_setW);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_toPoint, "toPoint(self) -> QPoint");

extern "C" {static PyObject *meth_QVector4D_toPoint(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_toPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
             ::QPoint*sipRes;

            sipRes = new  ::QPoint(sipCpp->toPoint());

            return sipConvertFromNewType(sipRes,sipType_QPoint,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_toPoint, doc_QVector4D_toPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector4D_toPointF, "toPointF(self) -> QPointF");

extern "C" {static PyObject *meth_QVector4D_toPointF(PyObject *, PyObject *);}
static PyObject *meth_QVector4D_toPointF(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector4D, &sipCpp))
        {
             ::QPointF*sipRes;

            sipRes = new  ::QPointF(sipCpp->toPointF());

            return sipConvertFromNewType(sipRes,sipType_QPointF,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName_toPointF, doc_QVector4D_toPointF);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QVector4D___eq__(PyObject *,PyObject *);}
static PyObject *slot_QVector4D___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QVector4D *sipCpp = reinterpret_cast< ::QVector4D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector4D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector4D, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, eq_slot, sipType_QVector4D, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QVector4D___ne__(PyObject *,PyObject *);}
static PyObject *slot_QVector4D___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QVector4D *sipCpp = reinterpret_cast< ::QVector4D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector4D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector4D, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, ne_slot, sipType_QVector4D, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QVector4D___truediv__(PyObject *,PyObject *);}
static PyObject *slot_QVector4D___truediv__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D* a0;
        float a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QVector4D, &a0, &a1))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D((*a0 / a1));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    {
        const  ::QVector4D* a0;
        const  ::QVector4D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector4D, &a0, sipType_QVector4D, &a1))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D((*a0 / *a1));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, truediv_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QVector4D___add__(PyObject *,PyObject *);}
static PyObject *slot_QVector4D___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D* a0;
        const  ::QVector4D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector4D, &a0, sipType_QVector4D, &a1))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D((*a0 + *a1));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QVector4D___sub__(PyObject *,PyObject *);}
static PyObject *slot_QVector4D___sub__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D* a0;
        const  ::QVector4D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector4D, &a0, sipType_QVector4D, &a1))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D((*a0 - *a1));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, sub_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QVector4D___mul__(PyObject *,PyObject *);}
static PyObject *slot_QVector4D___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D* a0;
        const  ::QMatrix4x4* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector4D, &a0, sipType_QMatrix4x4, &a1))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D((*a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    {
        float a0;
        const  ::QVector4D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "fJ9", &a0, sipType_QVector4D, &a1))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D((a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    {
        const  ::QVector4D* a0;
        float a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QVector4D, &a0, &a1))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D((*a0 * a1));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    {
        const  ::QVector4D* a0;
        const  ::QVector4D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector4D, &a0, sipType_QVector4D, &a1))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D((*a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, mul_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QVector4D___neg__(PyObject *);}
static PyObject *slot_QVector4D___neg__(PyObject *sipSelf)
{
     ::QVector4D *sipCpp = reinterpret_cast< ::QVector4D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector4D));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D(-(*sipCpp));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QVector4D___getitem__(PyObject *,PyObject *);}
static PyObject *slot_QVector4D___getitem__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QVector4D *sipCpp = reinterpret_cast< ::QVector4D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector4D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            float sipRes;

            sipRes = (*sipCpp)[a0];

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector4D, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QVector4D___itruediv__(PyObject *,PyObject *);}
static PyObject *slot_QVector4D___itruediv__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector4D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QVector4D *sipCpp = reinterpret_cast< ::QVector4D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector4D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            sipCpp-> ::QVector4D::operator/=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const  ::QVector4D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector4D, &a0))
        {
            sipCpp-> ::QVector4D::operator/=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector4D___imul__(PyObject *,PyObject *);}
static PyObject *slot_QVector4D___imul__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector4D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QVector4D *sipCpp = reinterpret_cast< ::QVector4D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector4D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            sipCpp-> ::QVector4D::operator*=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const  ::QVector4D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector4D, &a0))
        {
            sipCpp-> ::QVector4D::operator*=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector4D___isub__(PyObject *,PyObject *);}
static PyObject *slot_QVector4D___isub__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector4D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QVector4D *sipCpp = reinterpret_cast< ::QVector4D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector4D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector4D, &a0))
        {
            sipCpp-> ::QVector4D::operator-=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector4D___iadd__(PyObject *,PyObject *);}
static PyObject *slot_QVector4D___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector4D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QVector4D *sipCpp = reinterpret_cast< ::QVector4D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector4D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector4D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector4D, &a0))
        {
            sipCpp-> ::QVector4D::operator+=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector4D___repr__(PyObject *);}
static PyObject *slot_QVector4D___repr__(PyObject *sipSelf)
{
     ::QVector4D *sipCpp = reinterpret_cast< ::QVector4D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector4D));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 49 "/build/pyqt5/src/PyQt5-5.15.6/sip/QtGui/qvector4d.sip"
        PyObject *x = PyFloat_FromDouble(sipCpp->x());
        PyObject *y = PyFloat_FromDouble(sipCpp->y());
        PyObject *z = PyFloat_FromDouble(sipCpp->z());
        PyObject *w = PyFloat_FromDouble(sipCpp->w());
        
        if (x && y && z && w)
        {
        #if PY_MAJOR_VERSION >= 3
            sipRes = PyUnicode_FromFormat("PyQt5.QtGui.QVector4D(%R, %R, %R, %R)", x,
                    y, z, w);
        #else
            sipRes = PyString_FromString("PyQt5.QtGui.QVector4D(");
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(x));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(y));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(z));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(w));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
        #endif
        }
        
        Py_XDECREF(x);
        Py_XDECREF(y);
        Py_XDECREF(z);
        Py_XDECREF(w);
#line 1097 "/build/pyqt5/src/PyQt5-5.15.6/build/QtGui/sipQtGuiQVector4D.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QVector4D(void *, int);}
static void release_QVector4D(void *sipCppV, int)
{
    delete reinterpret_cast< ::QVector4D *>(sipCppV);
}


extern "C" {static PyObject *pickle_QVector4D(void *);}
static PyObject *pickle_QVector4D(void *sipCppV)
{
     ::QVector4D *sipCpp = reinterpret_cast< ::QVector4D *>(sipCppV);
    PyObject *sipRes;

#line 34 "/build/pyqt5/src/PyQt5-5.15.6/sip/QtGui/qvector4d.sip"
    sipRes = Py_BuildValue((char *)"dddd", (double)sipCpp->x(),
            (double)sipCpp->y(), (double)sipCpp->z(), (double)sipCpp->w());
#line 1124 "/build/pyqt5/src/PyQt5-5.15.6/build/QtGui/sipQtGuiQVector4D.cpp"

    return sipRes;
}


extern "C" {static void *array_QVector4D(Py_ssize_t);}
static void *array_QVector4D(Py_ssize_t sipNrElem)
{
    return new  ::QVector4D[sipNrElem];
}


extern "C" {static void assign_QVector4D(void *, Py_ssize_t, void *);}
static void assign_QVector4D(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QVector4D *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QVector4D *>(sipSrc);
}


extern "C" {static void *copy_QVector4D(const void *, Py_ssize_t);}
static void *copy_QVector4D(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QVector4D(reinterpret_cast<const  ::QVector4D *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QVector4D(sipSimpleWrapper *);}
static void dealloc_QVector4D(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QVector4D(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QVector4D(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QVector4D(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::QVector4D *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new  ::QVector4D();

            return sipCpp;
        }
    }

    {
        float a0;
        float a1;
        float a2;
        float a3;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "ffff", &a0, &a1, &a2, &a3))
        {
            sipCpp = new  ::QVector4D(a0,a1,a2,a3);

            return sipCpp;
        }
    }

    {
        const  ::QPoint* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QPoint, &a0))
        {
            sipCpp = new  ::QVector4D(*a0);

            return sipCpp;
        }
    }

    {
        const  ::QPointF* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QPointF, &a0, &a0State))
        {
            sipCpp = new  ::QVector4D(*a0);
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            return sipCpp;
        }
    }

    {
        const  ::QVector2D* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVector2D, &a0))
        {
            sipCpp = new  ::QVector4D(*a0);

            return sipCpp;
        }
    }

    {
        const  ::QVector2D* a0;
        float a1;
        float a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9ff", sipType_QVector2D, &a0, &a1, &a2))
        {
            sipCpp = new  ::QVector4D(*a0,a1,a2);

            return sipCpp;
        }
    }

    {
        const  ::QVector3D* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVector3D, &a0))
        {
            sipCpp = new  ::QVector4D(*a0);

            return sipCpp;
        }
    }

    {
        const  ::QVector3D* a0;
        float a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9f", sipType_QVector3D, &a0, &a1))
        {
            sipCpp = new  ::QVector4D(*a0,a1);

            return sipCpp;
        }
    }

    {
        const  ::QVector4D* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVector4D, &a0))
        {
            sipCpp = new  ::QVector4D(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QVector4D[] = {
    {(void *)slot_QVector4D___eq__, eq_slot},
    {(void *)slot_QVector4D___ne__, ne_slot},
    {(void *)slot_QVector4D___truediv__, truediv_slot},
    {(void *)slot_QVector4D___add__, add_slot},
    {(void *)slot_QVector4D___sub__, sub_slot},
    {(void *)slot_QVector4D___mul__, mul_slot},
    {(void *)slot_QVector4D___neg__, neg_slot},
    {(void *)slot_QVector4D___getitem__, getitem_slot},
    {(void *)slot_QVector4D___itruediv__, itruediv_slot},
    {(void *)slot_QVector4D___imul__, imul_slot},
    {(void *)slot_QVector4D___isub__, isub_slot},
    {(void *)slot_QVector4D___iadd__, iadd_slot},
    {(void *)slot_QVector4D___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QVector4D[] = {
    {sipName_dotProduct, meth_QVector4D_dotProduct, METH_VARARGS, doc_QVector4D_dotProduct},
    {sipName_isNull, meth_QVector4D_isNull, METH_VARARGS, doc_QVector4D_isNull},
    {sipName_length, meth_QVector4D_length, METH_VARARGS, doc_QVector4D_length},
    {sipName_lengthSquared, meth_QVector4D_lengthSquared, METH_VARARGS, doc_QVector4D_lengthSquared},
    {sipName_normalize, meth_QVector4D_normalize, METH_VARARGS, doc_QVector4D_normalize},
    {sipName_normalized, meth_QVector4D_normalized, METH_VARARGS, doc_QVector4D_normalized},
    {sipName_setW, meth_QVector4D_setW, METH_VARARGS, doc_QVector4D_setW},
    {sipName_setX, meth_QVector4D_setX, METH_VARARGS, doc_QVector4D_setX},
    {sipName_setY, meth_QVector4D_setY, METH_VARARGS, doc_QVector4D_setY},
    {sipName_setZ, meth_QVector4D_setZ, METH_VARARGS, doc_QVector4D_setZ},
    {sipName_toPoint, meth_QVector4D_toPoint, METH_VARARGS, doc_QVector4D_toPoint},
    {sipName_toPointF, meth_QVector4D_toPointF, METH_VARARGS, doc_QVector4D_toPointF},
    {sipName_toVector2D, meth_QVector4D_toVector2D, METH_VARARGS, doc_QVector4D_toVector2D},
    {sipName_toVector2DAffine, meth_QVector4D_toVector2DAffine, METH_VARARGS, doc_QVector4D_toVector2DAffine},
    {sipName_toVector3D, meth_QVector4D_toVector3D, METH_VARARGS, doc_QVector4D_toVector3D},
    {sipName_toVector3DAffine, meth_QVector4D_toVector3DAffine, METH_VARARGS, doc_QVector4D_toVector3DAffine},
    {sipName_w, meth_QVector4D_w, METH_VARARGS, doc_QVector4D_w},
    {sipName_x, meth_QVector4D_x, METH_VARARGS, doc_QVector4D_x},
    {sipName_y, meth_QVector4D_y, METH_VARARGS, doc_QVector4D_y},
    {sipName_z, meth_QVector4D_z, METH_VARARGS, doc_QVector4D_z}
};

PyDoc_STRVAR(doc_QVector4D, "\1QVector4D()\n"
"QVector4D(float, float, float, float)\n"
"QVector4D(QPoint)\n"
"QVector4D(Union[QPointF, QPoint])\n"
"QVector4D(QVector2D)\n"
"QVector4D(QVector2D, float, float)\n"
"QVector4D(QVector3D)\n"
"QVector4D(QVector3D, float)\n"
"QVector4D(QVector4D)");


static pyqt5ClassPluginDef plugin_QVector4D = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtGui_QVector4D = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QVector4D,
        SIP_NULLPTR,
        &plugin_QVector4D
    },
    {
        sipNameNr_QVector4D,
        {0, 0, 1},
        20, methods_QVector4D,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QVector4D,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QVector4D,
    init_type_QVector4D,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QVector4D,
    assign_QVector4D,
    array_QVector4D,
    copy_QVector4D,
    release_QVector4D,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    pickle_QVector4D,
    SIP_NULLPTR,
    SIP_NULLPTR
};
