/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.1
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 26 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 29 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"

#line 26 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qcalendar.sip"
#include <qcalendar.h>
#line 33 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"
#line 254 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 36 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"
#line 26 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 150 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qtextstream.sip"
#include <qtextstream.h>
#line 41 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"
#line 26 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qtimezone.sip"
#include <qtimezone.h>
#line 44 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"
#line 24 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 47 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"
#line 30 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
#include <QHash>
#line 50 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"


PyDoc_STRVAR(doc_QDate_toPyDate, "toPyDate(self) -> datetime.date");

extern "C" {static PyObject *meth_QDate_toPyDate(PyObject *, PyObject *);}
static PyObject *meth_QDate_toPyDate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 85 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
        // Convert to a Python date object.
        sipDateDef py_date;
        
        py_date.pd_year = sipCpp->year();
        py_date.pd_month = sipCpp->month();
        py_date.pd_day = sipCpp->day();
        
        sipRes = sipFromDate(&py_date);
#line 77 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_toPyDate, doc_QDate_toPyDate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QDate_isNull(PyObject *, PyObject *);}
static PyObject *meth_QDate_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_isNull, doc_QDate_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_isValid, "isValid(self) -> bool\n"
"isValid(int, int, int) -> bool");

extern "C" {static PyObject *meth_QDate_isValid(PyObject *, PyObject *);}
static PyObject *meth_QDate_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int a0;
        int a1;
        int a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "Ciii", &sipSelf, &a0, &a1, &a2))
        {
            bool sipRes;

            sipRes =  ::QDate::isValid(a0,a1,a2);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_isValid, doc_QDate_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_year, "year(self) -> int\n"
"year(self, QCalendar) -> int");

extern "C" {static PyObject *meth_QDate_year(PyObject *, PyObject *);}
static PyObject *meth_QDate_year(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->year();

            return PyLong_FromLong(sipRes);
        }
    }

    {
         ::QCalendar* a0;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDate, &sipCpp, sipType_QCalendar, &a0))
        {
            int sipRes;

            sipRes = sipCpp->year(*a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_year, doc_QDate_year);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_month, "month(self) -> int\n"
"month(self, QCalendar) -> int");

extern "C" {static PyObject *meth_QDate_month(PyObject *, PyObject *);}
static PyObject *meth_QDate_month(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->month();

            return PyLong_FromLong(sipRes);
        }
    }

    {
         ::QCalendar* a0;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDate, &sipCpp, sipType_QCalendar, &a0))
        {
            int sipRes;

            sipRes = sipCpp->month(*a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_month, doc_QDate_month);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_day, "day(self) -> int\n"
"day(self, QCalendar) -> int");

extern "C" {static PyObject *meth_QDate_day(PyObject *, PyObject *);}
static PyObject *meth_QDate_day(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->day();

            return PyLong_FromLong(sipRes);
        }
    }

    {
         ::QCalendar* a0;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDate, &sipCpp, sipType_QCalendar, &a0))
        {
            int sipRes;

            sipRes = sipCpp->day(*a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_day, doc_QDate_day);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_dayOfWeek, "dayOfWeek(self) -> int\n"
"dayOfWeek(self, QCalendar) -> int");

extern "C" {static PyObject *meth_QDate_dayOfWeek(PyObject *, PyObject *);}
static PyObject *meth_QDate_dayOfWeek(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->dayOfWeek();

            return PyLong_FromLong(sipRes);
        }
    }

    {
         ::QCalendar* a0;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDate, &sipCpp, sipType_QCalendar, &a0))
        {
            int sipRes;

            sipRes = sipCpp->dayOfWeek(*a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_dayOfWeek, doc_QDate_dayOfWeek);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_dayOfYear, "dayOfYear(self) -> int\n"
"dayOfYear(self, QCalendar) -> int");

extern "C" {static PyObject *meth_QDate_dayOfYear(PyObject *, PyObject *);}
static PyObject *meth_QDate_dayOfYear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->dayOfYear();

            return PyLong_FromLong(sipRes);
        }
    }

    {
         ::QCalendar* a0;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDate, &sipCpp, sipType_QCalendar, &a0))
        {
            int sipRes;

            sipRes = sipCpp->dayOfYear(*a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_dayOfYear, doc_QDate_dayOfYear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_daysInMonth, "daysInMonth(self) -> int\n"
"daysInMonth(self, QCalendar) -> int");

extern "C" {static PyObject *meth_QDate_daysInMonth(PyObject *, PyObject *);}
static PyObject *meth_QDate_daysInMonth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->daysInMonth();

            return PyLong_FromLong(sipRes);
        }
    }

    {
         ::QCalendar* a0;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDate, &sipCpp, sipType_QCalendar, &a0))
        {
            int sipRes;

            sipRes = sipCpp->daysInMonth(*a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_daysInMonth, doc_QDate_daysInMonth);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_daysInYear, "daysInYear(self) -> int\n"
"daysInYear(self, QCalendar) -> int");

extern "C" {static PyObject *meth_QDate_daysInYear(PyObject *, PyObject *);}
static PyObject *meth_QDate_daysInYear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->daysInYear();

            return PyLong_FromLong(sipRes);
        }
    }

    {
         ::QCalendar* a0;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDate, &sipCpp, sipType_QCalendar, &a0))
        {
            int sipRes;

            sipRes = sipCpp->daysInYear(*a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_daysInYear, doc_QDate_daysInYear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_weekNumber, "weekNumber(self) -> Tuple[int, int]");

extern "C" {static PyObject *meth_QDate_weekNumber(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDate_weekNumber(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QDate *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->weekNumber(&a0);

            return sipBuildResult(0,"(ii)",sipRes,a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_weekNumber, doc_QDate_weekNumber);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_toString, "toString(self, format: Qt.DateFormat = Qt.TextDate) -> str\n"
"toString(self, str, cal: QCalendar = QCalendar()) -> str");

extern "C" {static PyObject *meth_QDate_toString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDate_toString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Qt::DateFormat a0 = Qt::TextDate;
        const  ::QDate *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_QDate, &sipCpp, sipType_Qt_DateFormat, &a0))
        {
             ::QString*sipRes;

            sipRes = new  ::QString(sipCpp->toString(a0));

            return sipConvertFromNewType(sipRes,sipType_QString,SIP_NULLPTR);
        }
    }

    {
        const  ::QString* a0;
        int a0State = 0;
         ::QCalendar a1def = QCalendar();
         ::QCalendar* a1 = &a1def;
        const  ::QDate *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_cal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J9", &sipSelf, sipType_QDate, &sipCpp, sipType_QString, &a0, &a0State, sipType_QCalendar, &a1))
        {
             ::QString*sipRes;

            sipRes = new  ::QString(sipCpp->toString(*a0,*a1));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes,sipType_QString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_toString, doc_QDate_toString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_addDays, "addDays(self, int) -> QDate");

extern "C" {static PyObject *meth_QDate_addDays(PyObject *, PyObject *);}
static PyObject *meth_QDate_addDays(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qint64 a0;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QDate, &sipCpp, &a0))
        {
             ::QDate*sipRes;

            sipRes = new  ::QDate(sipCpp->addDays(a0));

            return sipConvertFromNewType(sipRes,sipType_QDate,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_addDays, doc_QDate_addDays);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_addMonths, "addMonths(self, int) -> QDate\n"
"addMonths(self, int, QCalendar) -> QDate");

extern "C" {static PyObject *meth_QDate_addMonths(PyObject *, PyObject *);}
static PyObject *meth_QDate_addMonths(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDate, &sipCpp, &a0))
        {
             ::QDate*sipRes;

            sipRes = new  ::QDate(sipCpp->addMonths(a0));

            return sipConvertFromNewType(sipRes,sipType_QDate,SIP_NULLPTR);
        }
    }

    {
        int a0;
         ::QCalendar* a1;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ9", &sipSelf, sipType_QDate, &sipCpp, &a0, sipType_QCalendar, &a1))
        {
             ::QDate*sipRes;

            sipRes = new  ::QDate(sipCpp->addMonths(a0,*a1));

            return sipConvertFromNewType(sipRes,sipType_QDate,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_addMonths, doc_QDate_addMonths);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_addYears, "addYears(self, int) -> QDate\n"
"addYears(self, int, QCalendar) -> QDate");

extern "C" {static PyObject *meth_QDate_addYears(PyObject *, PyObject *);}
static PyObject *meth_QDate_addYears(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDate, &sipCpp, &a0))
        {
             ::QDate*sipRes;

            sipRes = new  ::QDate(sipCpp->addYears(a0));

            return sipConvertFromNewType(sipRes,sipType_QDate,SIP_NULLPTR);
        }
    }

    {
        int a0;
         ::QCalendar* a1;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ9", &sipSelf, sipType_QDate, &sipCpp, &a0, sipType_QCalendar, &a1))
        {
             ::QDate*sipRes;

            sipRes = new  ::QDate(sipCpp->addYears(a0,*a1));

            return sipConvertFromNewType(sipRes,sipType_QDate,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_addYears, doc_QDate_addYears);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_currentDate, "currentDate() -> QDate");

extern "C" {static PyObject *meth_QDate_currentDate(PyObject *, PyObject *);}
static PyObject *meth_QDate_currentDate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
             ::QDate*sipRes;

            sipRes = new  ::QDate( ::QDate::currentDate());

            return sipConvertFromNewType(sipRes,sipType_QDate,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_currentDate, doc_QDate_currentDate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_fromString, "fromString(str, format: Qt.DateFormat = Qt.TextDate) -> QDate\n"
"fromString(str, str, cal: QCalendar = QCalendar()) -> QDate");

extern "C" {static PyObject *meth_QDate_fromString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDate_fromString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QString* a0;
        int a0State = 0;
         ::Qt::DateFormat a1 = Qt::TextDate;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ1|E", &sipSelf, sipType_QString, &a0, &a0State, sipType_Qt_DateFormat, &a1))
        {
             ::QDate*sipRes;

            sipRes = new  ::QDate( ::QDate::fromString(*a0,a1));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes,sipType_QDate,SIP_NULLPTR);
        }
    }

    {
        const  ::QString* a0;
        int a0State = 0;
        const  ::QString* a1;
        int a1State = 0;
         ::QCalendar a2def = QCalendar();
         ::QCalendar* a2 = &a2def;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_cal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ1J1|J9", &sipSelf, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, sipType_QCalendar, &a2))
        {
             ::QDate*sipRes;

            sipRes = new  ::QDate( ::QDate::fromString(*a0,*a1,*a2));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes,sipType_QDate,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_fromString, doc_QDate_fromString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_isLeapYear, "isLeapYear(int) -> bool");

extern "C" {static PyObject *meth_QDate_isLeapYear(PyObject *, PyObject *);}
static PyObject *meth_QDate_isLeapYear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "Ci", &sipSelf, &a0))
        {
            bool sipRes;

            sipRes =  ::QDate::isLeapYear(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_isLeapYear, doc_QDate_isLeapYear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_fromJulianDay, "fromJulianDay(int) -> QDate");

extern "C" {static PyObject *meth_QDate_fromJulianDay(PyObject *, PyObject *);}
static PyObject *meth_QDate_fromJulianDay(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qint64 a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "Cn", &sipSelf, &a0))
        {
             ::QDate*sipRes;

            sipRes = new  ::QDate( ::QDate::fromJulianDay(a0));

            return sipConvertFromNewType(sipRes,sipType_QDate,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_fromJulianDay, doc_QDate_fromJulianDay);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_toJulianDay, "toJulianDay(self) -> int");

extern "C" {static PyObject *meth_QDate_toJulianDay(PyObject *, PyObject *);}
static PyObject *meth_QDate_toJulianDay(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
             ::qint64 sipRes;

            sipRes = sipCpp->toJulianDay();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_toJulianDay, doc_QDate_toJulianDay);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_setDate, "setDate(self, int, int, int) -> bool\n"
"setDate(self, int, int, int, QCalendar) -> bool");

extern "C" {static PyObject *meth_QDate_setDate(PyObject *, PyObject *);}
static PyObject *meth_QDate_setDate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        int a2;
         ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Biii", &sipSelf, sipType_QDate, &sipCpp, &a0, &a1, &a2))
        {
            bool sipRes;

            sipRes = sipCpp->setDate(a0,a1,a2);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int a0;
        int a1;
        int a2;
         ::QCalendar* a3;
         ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiiiJ9", &sipSelf, sipType_QDate, &sipCpp, &a0, &a1, &a2, sipType_QCalendar, &a3))
        {
            bool sipRes;

            sipRes = sipCpp->setDate(a0,a1,a2,*a3);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_setDate, doc_QDate_setDate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_getDate, "getDate(self) -> Tuple[int, int, int]");

extern "C" {static PyObject *meth_QDate_getDate(PyObject *, PyObject *);}
static PyObject *meth_QDate_getDate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        int a2;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            sipCpp->getDate(&a0,&a1,&a2);

            return sipBuildResult(0,"(iii)",a0,a1,a2);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_getDate, doc_QDate_getDate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_startOfDay, "startOfDay(self, spec: Qt.TimeSpec = Qt.LocalTime, offsetSeconds: int = 0) -> QDateTime\n"
"startOfDay(self, QTimeZone) -> QDateTime");

extern "C" {static PyObject *meth_QDate_startOfDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDate_startOfDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Qt::TimeSpec a0 = Qt::LocalTime;
        int a1 = 0;
        const  ::QDate *sipCpp;

        static const char *sipKwdList[] = {
            sipName_spec,
            sipName_offsetSeconds,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|Ei", &sipSelf, sipType_QDate, &sipCpp, sipType_Qt_TimeSpec, &a0, &a1))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->startOfDay(a0,a1));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    {
        const  ::QTimeZone* a0;
        const  ::QDate *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QDate, &sipCpp, sipType_QTimeZone, &a0))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->startOfDay(*a0));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_startOfDay, doc_QDate_startOfDay);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_endOfDay, "endOfDay(self, spec: Qt.TimeSpec = Qt.LocalTime, offsetSeconds: int = 0) -> QDateTime\n"
"endOfDay(self, QTimeZone) -> QDateTime");

extern "C" {static PyObject *meth_QDate_endOfDay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDate_endOfDay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Qt::TimeSpec a0 = Qt::LocalTime;
        int a1 = 0;
        const  ::QDate *sipCpp;

        static const char *sipKwdList[] = {
            sipName_spec,
            sipName_offsetSeconds,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|Ei", &sipSelf, sipType_QDate, &sipCpp, sipType_Qt_TimeSpec, &a0, &a1))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->endOfDay(a0,a1));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    {
        const  ::QTimeZone* a0;
        const  ::QDate *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QDate, &sipCpp, sipType_QTimeZone, &a0))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->endOfDay(*a0));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_endOfDay, doc_QDate_endOfDay);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDate_daysTo, "daysTo(self, Union[QDate, datetime.date]) -> int");

extern "C" {static PyObject *meth_QDate_daysTo(PyObject *, PyObject *);}
static PyObject *meth_QDate_daysTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDate* a0;
        int a0State = 0;
        const  ::QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDate, &sipCpp, sipType_QDate, &a0, &a0State))
        {
             ::qint64 sipRes;

            sipRes = sipCpp->daysTo(*a0);
            sipReleaseType(a0, sipType_QDate, a0State);

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDate, sipName_daysTo, doc_QDate_daysTo);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QDate___eq__(PyObject *,PyObject *);}
static PyObject *slot_QDate___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QDate *sipCpp = reinterpret_cast< ::QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDate* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDate, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);
            sipReleaseType(a0, sipType_QDate, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, eq_slot, sipType_QDate, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QDate___ne__(PyObject *,PyObject *);}
static PyObject *slot_QDate___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QDate *sipCpp = reinterpret_cast< ::QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDate* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDate, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);
            sipReleaseType(a0, sipType_QDate, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, ne_slot, sipType_QDate, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QDate___lt__(PyObject *,PyObject *);}
static PyObject *slot_QDate___lt__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QDate *sipCpp = reinterpret_cast< ::QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDate* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDate, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator<((*sipCpp), *a0);
            sipReleaseType(a0, sipType_QDate, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, lt_slot, sipType_QDate, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QDate___le__(PyObject *,PyObject *);}
static PyObject *slot_QDate___le__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QDate *sipCpp = reinterpret_cast< ::QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDate* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDate, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator<=((*sipCpp), *a0);
            sipReleaseType(a0, sipType_QDate, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, le_slot, sipType_QDate, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QDate___gt__(PyObject *,PyObject *);}
static PyObject *slot_QDate___gt__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QDate *sipCpp = reinterpret_cast< ::QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDate* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDate, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator>((*sipCpp), *a0);
            sipReleaseType(a0, sipType_QDate, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, gt_slot, sipType_QDate, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QDate___ge__(PyObject *,PyObject *);}
static PyObject *slot_QDate___ge__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QDate *sipCpp = reinterpret_cast< ::QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDate* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDate, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator>=((*sipCpp), *a0);
            sipReleaseType(a0, sipType_QDate, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, ge_slot, sipType_QDate, sipSelf, sipArg);
}


extern "C" {static int slot_QDate___bool__(PyObject *);}
static int slot_QDate___bool__(PyObject *sipSelf)
{
     ::QDate *sipCpp = reinterpret_cast< ::QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 98 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
        sipRes = !sipCpp->isNull();
#line 1259 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static Py_hash_t slot_QDate___hash__(PyObject *);}
static Py_hash_t slot_QDate___hash__(PyObject *sipSelf)
{
     ::QDate *sipCpp = reinterpret_cast< ::QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return 0;


    {
        {
            Py_hash_t sipRes = 0;

#line 80 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
        sipRes = qHash(sipCpp->toString(Qt::ISODate));
#line 1284 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QDate___repr__(PyObject *);}
static PyObject *slot_QDate___repr__(PyObject *sipSelf)
{
     ::QDate *sipCpp = reinterpret_cast< ::QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 66 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
        if (sipCpp->isNull())
        {
            sipRes = PyUnicode_FromString("PyQt6.QtCore.QDate()");
        }
        else
        {
            sipRes = PyUnicode_FromFormat(
                    "PyQt6.QtCore.QDate(%i, %i, %i)", sipCpp->year(),
                    sipCpp->month(), sipCpp->day());
        }
#line 1318 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QDate(void *, int);}
static void release_QDate(void *sipCppV, int)
{
    delete reinterpret_cast< ::QDate *>(sipCppV);
}


extern "C" {static PyObject *pickle_QDate(void *);}
static PyObject *pickle_QDate(void *sipCppV)
{
     ::QDate *sipCpp = reinterpret_cast< ::QDate *>(sipCppV);
    PyObject *sipRes;

#line 57 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
    sipRes = Py_BuildValue("iii", sipCpp->year(), sipCpp->month(), sipCpp->day());
#line 1344 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"

    return sipRes;
}


extern "C" {static void *array_QDate(Py_ssize_t);}
static void *array_QDate(Py_ssize_t sipNrElem)
{
    return new  ::QDate[sipNrElem];
}


extern "C" {static void assign_QDate(void *, Py_ssize_t, void *);}
static void assign_QDate(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QDate *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QDate *>(sipSrc);
}


extern "C" {static void *copy_QDate(const void *, Py_ssize_t);}
static void *copy_QDate(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QDate(reinterpret_cast<const  ::QDate *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QDate(sipSimpleWrapper *);}
static void dealloc_QDate(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QDate(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QDate(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QDate(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::QDate *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new  ::QDate();

            return sipCpp;
        }
    }

    {
        int a0;
        int a1;
        int a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "iii", &a0, &a1, &a2))
        {
            sipCpp = new  ::QDate(a0,a1,a2);

            return sipCpp;
        }
    }

    {
        int a0;
        int a1;
        int a2;
         ::QCalendar* a3;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "iiiJ9", &a0, &a1, &a2, sipType_QCalendar, &a3))
        {
            sipCpp = new  ::QDate(a0,a1,a2,*a3);

            return sipCpp;
        }
    }

    {
        const  ::QDate* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QDate, &a0, &a0State))
        {
            sipCpp = new  ::QDate(*a0);
            sipReleaseType(const_cast< ::QDate *>(a0), sipType_QDate, a0State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static int convertTo_QDate(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QDate(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
     ::QDate **sipCppPtr = reinterpret_cast< ::QDate **>(sipCppPtrV);

#line 34 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
// Allow a Python date object whenever a QDate is expected.

if (sipIsErr == NULL)
    return (sipGetDate(sipPy, 0) ||
            sipCanConvertToType(sipPy, sipType_QDate, SIP_NO_CONVERTORS));

sipDateDef py_date;

if (sipGetDate(sipPy, &py_date))
{
    *sipCppPtr = new QDate(py_date.pd_year,
                           py_date.pd_month,
                           py_date.pd_day);

    return sipGetState(sipTransferObj);
}

*sipCppPtr = reinterpret_cast<QDate *>(sipConvertToType(sipPy, sipType_QDate, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

return 0;
#line 1465 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDate.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QDate[] = {
    {(void *)slot_QDate___eq__, eq_slot},
    {(void *)slot_QDate___ne__, ne_slot},
    {(void *)slot_QDate___lt__, lt_slot},
    {(void *)slot_QDate___le__, le_slot},
    {(void *)slot_QDate___gt__, gt_slot},
    {(void *)slot_QDate___ge__, ge_slot},
    {(void *)slot_QDate___bool__, bool_slot},
    {(void *)slot_QDate___hash__, hash_slot},
    {(void *)slot_QDate___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QDate[] = {
    {sipName_addDays, meth_QDate_addDays, METH_VARARGS, doc_QDate_addDays},
    {sipName_addMonths, meth_QDate_addMonths, METH_VARARGS, doc_QDate_addMonths},
    {sipName_addYears, meth_QDate_addYears, METH_VARARGS, doc_QDate_addYears},
    {sipName_currentDate, meth_QDate_currentDate, METH_VARARGS, doc_QDate_currentDate},
    {sipName_day, meth_QDate_day, METH_VARARGS, doc_QDate_day},
    {sipName_dayOfWeek, meth_QDate_dayOfWeek, METH_VARARGS, doc_QDate_dayOfWeek},
    {sipName_dayOfYear, meth_QDate_dayOfYear, METH_VARARGS, doc_QDate_dayOfYear},
    {sipName_daysInMonth, meth_QDate_daysInMonth, METH_VARARGS, doc_QDate_daysInMonth},
    {sipName_daysInYear, meth_QDate_daysInYear, METH_VARARGS, doc_QDate_daysInYear},
    {sipName_daysTo, meth_QDate_daysTo, METH_VARARGS, doc_QDate_daysTo},
    {sipName_endOfDay, SIP_MLMETH_CAST(meth_QDate_endOfDay), METH_VARARGS|METH_KEYWORDS, doc_QDate_endOfDay},
    {sipName_fromJulianDay, meth_QDate_fromJulianDay, METH_VARARGS, doc_QDate_fromJulianDay},
    {sipName_fromString, SIP_MLMETH_CAST(meth_QDate_fromString), METH_VARARGS|METH_KEYWORDS, doc_QDate_fromString},
    {sipName_getDate, meth_QDate_getDate, METH_VARARGS, doc_QDate_getDate},
    {sipName_isLeapYear, meth_QDate_isLeapYear, METH_VARARGS, doc_QDate_isLeapYear},
    {sipName_isNull, meth_QDate_isNull, METH_VARARGS, doc_QDate_isNull},
    {sipName_isValid, meth_QDate_isValid, METH_VARARGS, doc_QDate_isValid},
    {sipName_month, meth_QDate_month, METH_VARARGS, doc_QDate_month},
    {sipName_setDate, meth_QDate_setDate, METH_VARARGS, doc_QDate_setDate},
    {sipName_startOfDay, SIP_MLMETH_CAST(meth_QDate_startOfDay), METH_VARARGS|METH_KEYWORDS, doc_QDate_startOfDay},
    {sipName_toJulianDay, meth_QDate_toJulianDay, METH_VARARGS, doc_QDate_toJulianDay},
    {sipName_toPyDate, meth_QDate_toPyDate, METH_VARARGS, doc_QDate_toPyDate},
    {sipName_toString, SIP_MLMETH_CAST(meth_QDate_toString), METH_VARARGS|METH_KEYWORDS, doc_QDate_toString},
    {sipName_weekNumber, SIP_MLMETH_CAST(meth_QDate_weekNumber), METH_VARARGS|METH_KEYWORDS, doc_QDate_weekNumber},
    {sipName_year, meth_QDate_year, METH_VARARGS, doc_QDate_year}
};

PyDoc_STRVAR(doc_QDate, "\1QDate()\n"
"QDate(int, int, int)\n"
"QDate(int, int, int, QCalendar)\n"
"QDate(QDate)");


sipClassTypeDef sipTypeDef_QtCore_QDate = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QDate,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_QDate,
        {0, 0, 1},
        25, methods_QDate,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QDate,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QDate,
    init_type_QDate,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QDate,
    assign_QDate,
    array_QDate,
    copy_QDate,
    release_QDate,
    SIP_NULLPTR,
    convertTo_QDate,
    SIP_NULLPTR,
    SIP_NULLPTR,
    pickle_QDate,
    SIP_NULLPTR,
    SIP_NULLPTR
};
