/* rygel-http-post.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-http-post.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;
typedef struct _RygelHTTPPostPrivate RygelHTTPPostPrivate;
enum  {
	RYGEL_HTTP_POST_0_PROPERTY,
	RYGEL_HTTP_POST_NUM_PROPERTIES
};
static GParamSpec* rygel_http_post_properties[RYGEL_HTTP_POST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_OBJECT_REMOVAL_QUEUE (rygel_object_removal_queue_get_type ())
#define RYGEL_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueue))
#define RYGEL_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_OBJECT_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))

typedef struct _RygelObjectRemovalQueue RygelObjectRemovalQueue;
typedef struct _RygelObjectRemovalQueueClass RygelObjectRemovalQueueClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHttpPostHandleData RygelHttpPostHandleData;

#define RYGEL_TYPE_CONTENT_DIRECTORY_ERROR (rygel_content_directory_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHttpPostHandleRealData RygelHttpPostHandleRealData;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _RygelHttpPostWaitForItemData RygelHttpPostWaitForItemData;
typedef struct _RygelHttpPostFinalizePostData RygelHttpPostFinalizePostData;
typedef struct _RygelHttpPostRemoveItemData RygelHttpPostRemoveItemData;

struct _RygelHTTPPost {
	RygelHTTPRequest parent_instance;
	RygelHTTPPostPrivate * priv;
};

struct _RygelHTTPPostClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPPostPrivate {
	GSourceFunc handle_continue;
	gpointer handle_continue_target;
	GDestroyNotify handle_continue_target_destroy_notify;
	GFile* file;
	GFile* dotfile;
	GOutputStream* stream;
};

struct _RygelHttpPostHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelHTTPPost* self;
	RygelObjectRemovalQueue* queue;
	RygelObjectRemovalQueue* _tmp0_;
	RygelObjectRemovalQueue* _tmp1_;
	RygelMediaObject* _tmp2_;
	GError* _error_;
	RygelObjectRemovalQueue* _tmp3_;
	RygelMediaObject* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _inner_error0_;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()

struct _RygelHttpPostHandleRealData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelHTTPPost* self;
	RygelMediaFileItem* item;
	RygelMediaObject* _tmp0_;
	RygelMediaFileItem* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* msg;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	RygelMediaObject* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	GFile* _tmp10_;
	GCancellable* _tmp11_;
	GCancellable* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	RygelMediaObject* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GFile* _tmp28_;
	GFileOutputStream* _tmp29_;
	GFile* _tmp30_;
	GCancellable* _tmp31_;
	GCancellable* _tmp32_;
	GFileOutputStream* _tmp33_;
	GFileOutputStream* _tmp34_;
	SoupMessage* _tmp35_;
	SoupMessage* _tmp36_;
	SoupServer* _tmp37_;
	SoupMessage* _tmp38_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	RygelHTTPPost* self;
	RygelMediaContainer* container;
	gpointer _async_data_;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	guint source_id;
};

struct _RygelHttpPostWaitForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelHTTPPost* self;
	RygelMediaContainer* container;
	gchar* id;
	guint timeout;
	Block6Data* _data6_;
	RygelMediaFileItem* item;
	gboolean _tmp0_;
	RygelMediaFileItem* _tmp1_;
	RygelMediaFileItem* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	RygelMediaObject* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	RygelMediaObject* _tmp8_;
	RygelMediaFileItem* _tmp9_;
	RygelMediaFileItem* _tmp10_;
	RygelMediaFileItem* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	Block7Data* _data7_;
	gulong update_id;
	gulong _tmp14_;
	GError* _inner_error0_;
};

struct _RygelHttpPostFinalizePostData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelHTTPPost* self;
	GOutputStream* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GSourceFunc _tmp3_;
	gpointer _tmp3__target;
	SoupServer* _tmp4_;
	SoupMessage* _tmp5_;
	RygelMediaObject* _tmp6_;
	RygelMediaContainer* _tmp7_;
	RygelMediaContainer* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaObject* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GCancellable* _tmp16_;
	GCancellable* _tmp17_;
	GError* move_error;
	GFile* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	SoupServer* _tmp23_;
	SoupMessage* _tmp24_;
	GSourceFunc _tmp25_;
	gpointer _tmp25__target;
	RygelMediaObject* _tmp26_;
	RygelMediaContainer* _tmp27_;
	RygelMediaContainer* _tmp28_;
	RygelMediaObject* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	SoupServer* _tmp32_;
	SoupMessage* _tmp33_;
	GSourceFunc _tmp34_;
	gpointer _tmp34__target;
	GError* _inner_error0_;
};

struct _RygelHttpPostRemoveItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelHTTPPost* self;
	RygelObjectRemovalQueue* queue;
	RygelObjectRemovalQueue* _tmp0_;
	RygelMediaObject* _tmp1_;
};

static gint RygelHTTPPost_private_offset;
static gpointer rygel_http_post_parent_class = NULL;

VALA_EXTERN GType rygel_http_post_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server,
                                    SoupServer* server,
                                    SoupMessage* msg);
VALA_EXTERN RygelHTTPPost* rygel_http_post_construct (GType object_type,
                                          RygelHTTPServer* http_server,
                                          SoupServer* server,
                                          SoupMessage* msg);
static void rygel_http_post_on_request_cancelled (RygelHTTPPost* self);
static void _rygel_http_post_on_request_cancelled_gfunc (gconstpointer data,
                                                  gpointer self);
static void rygel_http_post_real_handle_data_free (gpointer _data);
static void rygel_http_post_real_handle (RygelHTTPRequest* base,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static gboolean rygel_http_post_real_handle_co (RygelHttpPostHandleData* _data_);
VALA_EXTERN GType rygel_object_removal_queue_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelObjectRemovalQueue* rygel_object_removal_queue_get_default (void);
VALA_EXTERN gboolean rygel_object_removal_queue_dequeue (RygelObjectRemovalQueue* self,
                                             RygelMediaObject* object);
static void rygel_http_post_handle_real (RygelHTTPPost* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void rygel_http_post_handle_real_finish (RygelHTTPPost* self,
                                         GAsyncResult* _res_,
                                         GError** error);
static void rygel_http_post_handle_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
VALA_EXTERN void rygel_object_removal_queue_remove_now (RygelObjectRemovalQueue* self,
                                            RygelMediaObject* object,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
VALA_EXTERN void rygel_object_removal_queue_remove_now_finish (RygelObjectRemovalQueue* self,
                                                   GAsyncResult* _res_);
static void rygel_http_post_handle_real_data_free (gpointer _data);
static gboolean rygel_http_post_handle_real_co (RygelHttpPostHandleRealData* _data_);
VALA_EXTERN GQuark rygel_content_directory_error_quark (void);
GType rygel_content_directory_error_get_type (void) G_GNUC_CONST ;
static void rygel_http_post_handle_real_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void rygel_http_post_on_got_chunk (RygelHTTPPost* self,
                                   SoupMessage* msg,
                                   SoupBuffer* chunk);
static void _rygel_http_post_on_got_chunk_soup_message_got_chunk (SoupMessage* _sender,
                                                           SoupBuffer* chunk,
                                                           gpointer self);
static void rygel_http_post_on_got_body (RygelHTTPPost* self,
                                  SoupMessage* msg);
static void _rygel_http_post_on_got_body_soup_message_got_body (SoupMessage* _sender,
                                                         gpointer self);
static gboolean _rygel_http_post_handle_real_co_gsource_func (gpointer self);
static void rygel_http_post_finalize_post (RygelHTTPPost* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static void rygel_http_post_finalize_post_finish (RygelHTTPPost* self,
                                           GAsyncResult* _res_);
static void rygel_http_post_wait_for_item_data_free (gpointer _data);
static void rygel_http_post_wait_for_item (RygelHTTPPost* self,
                                    RygelMediaContainer* container,
                                    const gchar* id,
                                    guint timeout,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static void rygel_http_post_wait_for_item_finish (RygelHTTPPost* self,
                                           GAsyncResult* _res_);
static gboolean rygel_http_post_wait_for_item_co (RygelHttpPostWaitForItemData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void rygel_http_post_wait_for_item_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean ____lambda13_ (Block7Data* _data7_);
static gboolean _____lambda13__gsource_func (gpointer self);
static void ____lambda14_ (Block7Data* _data7_);
static void _____lambda14__rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                             RygelMediaContainer* container,
                                                             RygelMediaObject* object,
                                                             RygelObjectEventType event_type,
                                                             gboolean sub_tree_update,
                                                             gpointer self);
static void rygel_http_post_finalize_post_data_free (gpointer _data);
static gboolean rygel_http_post_finalize_post_co (RygelHttpPostFinalizePostData* _data_);
static void rygel_http_post_finalize_post_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void rygel_http_post_disconnect_message_signals (RygelHTTPPost* self);
static void rygel_http_post_remove_item (RygelHTTPPost* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void rygel_http_post_remove_item_finish (RygelHTTPPost* self,
                                         GAsyncResult* _res_);
static void rygel_http_post_remove_item_data_free (gpointer _data);
static gboolean rygel_http_post_remove_item_co (RygelHttpPostRemoveItemData* _data_);
static void rygel_http_post_remove_item_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void rygel_http_post_finalize (GObject * obj);
static GType rygel_http_post_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_http_post_get_instance_private (RygelHTTPPost* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPPost_private_offset);
}

static void
_rygel_http_post_on_request_cancelled_gfunc (gconstpointer data,
                                             gpointer self)
{
	rygel_http_post_on_request_cancelled ((RygelHTTPPost*) self);
}

RygelHTTPPost*
rygel_http_post_construct (GType object_type,
                           RygelHTTPServer* http_server,
                           SoupServer* server,
                           SoupMessage* msg)
{
	RygelHTTPPost * self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	SoupMessageBody* _tmp2_;
	g_return_val_if_fail (http_server != NULL, NULL);
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	self = (RygelHTTPPost*) rygel_http_request_construct (object_type, http_server, server, msg);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = _tmp0_;
	g_cancellable_connect (_tmp1_, (GCallback) _rygel_http_post_on_request_cancelled_gfunc, g_object_ref (self), g_object_unref);
	_tmp2_ = msg->request_body;
	soup_message_body_set_accumulate (_tmp2_, FALSE);
	return self;
}

RygelHTTPPost*
rygel_http_post_new (RygelHTTPServer* http_server,
                     SoupServer* server,
                     SoupMessage* msg)
{
	return rygel_http_post_construct (RYGEL_TYPE_HTTP_POST, http_server, server, msg);
}

static void
rygel_http_post_real_handle_data_free (gpointer _data)
{
	RygelHttpPostHandleData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpPostHandleData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_http_post_real_handle (RygelHTTPRequest* base,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	RygelHTTPPost * self;
	RygelHttpPostHandleData* _data_;
	RygelHTTPPost* _tmp0_;
	self = (RygelHTTPPost*) base;
	_data_ = g_slice_new0 (RygelHttpPostHandleData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_http_post_real_handle_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_post_real_handle_co (_data_);
}

static void
rygel_http_post_handle_finish (RygelHTTPRequest* base,
                               GAsyncResult* _res_,
                               GError** error)
{
	RygelHttpPostHandleData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_http_post_handle_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	RygelHttpPostHandleData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_post_real_handle_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
rygel_http_post_real_handle_co (RygelHttpPostHandleData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_object_removal_queue_get_default ();
	_data_->queue = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->queue;
	_data_->_tmp2_ = ((RygelHTTPRequest*) _data_->self)->object;
	rygel_object_removal_queue_dequeue (_data_->_tmp1_, _data_->_tmp2_);
	{
		_data_->_state_ = 1;
		rygel_http_post_handle_real (_data_->self, rygel_http_post_handle_ready, _data_);
		return FALSE;
		_state_1:
		rygel_http_post_handle_real_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->queue;
		_data_->_tmp4_ = ((RygelHTTPRequest*) _data_->self)->object;
		_data_->_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_state_ = 2;
		rygel_object_removal_queue_remove_now (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp6_, rygel_http_post_handle_ready, _data_);
		return FALSE;
		_state_2:
		rygel_object_removal_queue_remove_now_finish (_data_->_tmp3_, _data_->_res_);
		_data_->_tmp7_ = _data_->_error_;
		_data_->_tmp8_ = _g_error_copy0 (_data_->_tmp7_);
		_data_->_inner_error0_ = _data_->_tmp8_;
		_g_error_free0 (_data_->_error_);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->queue);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->queue);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_http_post_handle_real_data_free (gpointer _data)
{
	RygelHttpPostHandleRealData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpPostHandleRealData, _data_);
}

static void
rygel_http_post_handle_real (RygelHTTPPost* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	RygelHttpPostHandleRealData* _data_;
	RygelHTTPPost* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelHttpPostHandleRealData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_http_post_handle_real_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_post_handle_real_co (_data_);
}

static void
rygel_http_post_handle_real_finish (RygelHTTPPost* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	RygelHttpPostHandleRealData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_http_post_handle_real_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	RygelHttpPostHandleRealData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_post_handle_real_co (_data_);
}

static void
_rygel_http_post_on_got_chunk_soup_message_got_chunk (SoupMessage* _sender,
                                                      SoupBuffer* chunk,
                                                      gpointer self)
{
	rygel_http_post_on_got_chunk ((RygelHTTPPost*) self, _sender, chunk);
}

static void
_rygel_http_post_on_got_body_soup_message_got_body (SoupMessage* _sender,
                                                    gpointer self)
{
	rygel_http_post_on_got_body ((RygelHTTPPost*) self, _sender);
}

static gboolean
_rygel_http_post_handle_real_co_gsource_func (gpointer self)
{
	gboolean result;
	result = rygel_http_post_handle_real_co (self);
	return result;
}

static gboolean
rygel_http_post_handle_real_co (RygelHttpPostHandleRealData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem));
	_data_->item = _data_->_tmp1_;
	_data_->_tmp2_ = rygel_media_file_item_get_place_holder (_data_->item);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (!_data_->_tmp3_) {
		_data_->_tmp4_ = g_strdup (_ ("Pushing data to non-empty item “%s” not allowed"));
		_data_->msg = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->msg;
		_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->object;
		_data_->_tmp7_ = rygel_media_object_get_id (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _data_->_tmp5_, _data_->_tmp8_);
		_data_->_inner_error0_ = _data_->_tmp9_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->msg);
		_g_object_unref0 (_data_->item);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_state_ = 1;
	rygel_media_object_get_writable ((RygelMediaObject*) _data_->item, _data_->_tmp12_, rygel_http_post_handle_real_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp13_ = rygel_media_object_get_writable_finish ((RygelMediaObject*) _data_->item, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp10_ = _data_->_tmp13_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->item);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->_tmp10_;
	_data_->_tmp10_ = NULL;
	_g_object_unref0 (_data_->self->priv->file);
	_data_->self->priv->file = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->self->priv->file;
	if (_data_->_tmp15_ == NULL) {
		_data_->_tmp16_ = ((RygelHTTPRequest*) _data_->self)->object;
		_data_->_tmp17_ = rygel_media_object_get_id (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _ ("No writable URI for %s available"), _data_->_tmp18_);
		_data_->_inner_error0_ = _data_->_tmp19_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp10_);
		_g_object_unref0 (_data_->item);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = _data_->self->priv->file;
	_data_->_tmp21_ = g_file_get_parent (_data_->_tmp20_);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = _data_->self->priv->file;
	_data_->_tmp24_ = g_file_get_basename (_data_->_tmp23_);
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = g_strconcat (".", _data_->_tmp25_, NULL);
	_data_->_tmp27_ = _data_->_tmp26_;
	_data_->_tmp28_ = g_file_get_child (_data_->_tmp22_, _data_->_tmp27_);
	_g_object_unref0 (_data_->self->priv->dotfile);
	_data_->self->priv->dotfile = _data_->_tmp28_;
	_g_free0 (_data_->_tmp27_);
	_g_free0 (_data_->_tmp25_);
	_g_object_unref0 (_data_->_tmp22_);
	_data_->_tmp30_ = _data_->self->priv->dotfile;
	_data_->_tmp31_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_state_ = 2;
	g_file_replace_async (_data_->_tmp30_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_LOW, _data_->_tmp32_, rygel_http_post_handle_real_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp33_ = g_file_replace_finish (_data_->_tmp30_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp29_ = _data_->_tmp33_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp10_);
		_g_object_unref0 (_data_->item);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp34_ = _data_->_tmp29_;
	_data_->_tmp29_ = NULL;
	_g_object_unref0 (_data_->self->priv->stream);
	_data_->self->priv->stream = (GOutputStream*) _data_->_tmp34_;
	_data_->_tmp35_ = ((RygelHTTPRequest*) _data_->self)->msg;
	g_signal_connect_object (_data_->_tmp35_, "got-chunk", (GCallback) _rygel_http_post_on_got_chunk_soup_message_got_chunk, _data_->self, 0);
	_data_->_tmp36_ = ((RygelHTTPRequest*) _data_->self)->msg;
	g_signal_connect_object (_data_->_tmp36_, "got-body", (GCallback) _rygel_http_post_on_got_body_soup_message_got_body, _data_->self, 0);
	_data_->_tmp37_ = ((RygelHTTPRequest*) _data_->self)->server;
	_data_->_tmp38_ = ((RygelHTTPRequest*) _data_->self)->msg;
	soup_server_unpause_message (_data_->_tmp37_, _data_->_tmp38_);
	(_data_->self->priv->handle_continue_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->handle_continue_target_destroy_notify (_data_->self->priv->handle_continue_target), NULL);
	_data_->self->priv->handle_continue = NULL;
	_data_->self->priv->handle_continue_target = NULL;
	_data_->self->priv->handle_continue_target_destroy_notify = NULL;
	_data_->self->priv->handle_continue = _rygel_http_post_handle_real_co_gsource_func;
	_data_->self->priv->handle_continue_target = _data_;
	_data_->self->priv->handle_continue_target_destroy_notify = NULL;
	_data_->_state_ = 3;
	return FALSE;
	_state_3:
	;
	_g_object_unref0 (_data_->_tmp29_);
	_g_object_unref0 (_data_->_tmp10_);
	_g_object_unref0 (_data_->item);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_http_post_on_got_body (RygelHTTPPost* self,
                             SoupMessage* msg)
{
	SoupMessage* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = ((RygelHTTPRequest*) self)->msg;
	if (_tmp0_ != msg) {
		return;
	}
	rygel_http_post_finalize_post (self, NULL, NULL);
}

static void
rygel_http_post_wait_for_item_data_free (gpointer _data)
{
	RygelHttpPostWaitForItemData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpPostWaitForItemData, _data_);
}

static void
rygel_http_post_wait_for_item (RygelHTTPPost* self,
                               RygelMediaContainer* container,
                               const gchar* id,
                               guint timeout,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	RygelHttpPostWaitForItemData* _data_;
	RygelHTTPPost* _tmp0_;
	RygelMediaContainer* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (id != NULL);
	_data_ = g_slice_new0 (RygelHttpPostWaitForItemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_http_post_wait_for_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (container);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp1_;
	_tmp2_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_data_->timeout = timeout;
	rygel_http_post_wait_for_item_co (_data_);
}

static void
rygel_http_post_wait_for_item_finish (RygelHTTPPost* self,
                                      GAsyncResult* _res_)
{
	RygelHttpPostWaitForItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Waits for an item with @id to change its state to non-placeholder under
     * @container, but at most @timeout seconds.
     *
     * @param container The container to watch for changes
     * @param id The child id to look for
     * @param timeout Seconds to wait befor cancelling
     */
static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		RygelHTTPPost* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->container);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
rygel_http_post_wait_for_item_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	RygelHttpPostWaitForItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_post_wait_for_item_co (_data_);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		RygelHTTPPost* self;
		self = _data7_->_data6_->self;
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
____lambda13_ (Block7Data* _data7_)
{
	Block6Data* _data6_;
	RygelHTTPPost* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) _data6_->container);
	_tmp1_ = _tmp0_;
	g_debug ("rygel-http-post.vala:136: Timeout on waiting for 'updated' signal on '" \
"%s'.", _tmp1_);
	_data7_->source_id = (guint) 0;
	rygel_http_post_wait_for_item_co (_data6_->_async_data_);
	result = FALSE;
	return result;
}

static gboolean
_____lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda13_ (self);
	return result;
}

static void
____lambda14_ (Block7Data* _data7_)
{
	Block6Data* _data6_;
	RygelHTTPPost* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) _data6_->container);
	_tmp1_ = _tmp0_;
	g_debug ("rygel-http-post.vala:145: Finished waiting for update signal from cont" \
"ainer '%s'", _tmp1_);
	rygel_http_post_wait_for_item_co (_data6_->_async_data_);
}

static void
_____lambda14__rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                        RygelMediaContainer* container,
                                                        RygelMediaObject* object,
                                                        RygelObjectEventType event_type,
                                                        gboolean sub_tree_update,
                                                        gpointer self)
{
	____lambda14_ (self);
}

static gboolean
rygel_http_post_wait_for_item_co (RygelHttpPostWaitForItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data6_->container);
	_data_->_data6_->container = _data_->container;
	_data_->_data6_->_async_data_ = _data_;
	_data_->item = NULL;
	while (TRUE) {
		_data_->_tmp1_ = _data_->item;
		if (_data_->_tmp1_ == NULL) {
			_data_->_tmp0_ = TRUE;
		} else {
			_data_->_tmp2_ = _data_->item;
			_data_->_tmp3_ = rygel_media_file_item_get_place_holder (_data_->_tmp2_);
			_data_->_tmp4_ = _data_->_tmp3_;
			_data_->_tmp0_ = _data_->_tmp4_;
		}
		if (!_data_->_tmp0_) {
			break;
		}
		{
			_data_->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_state_ = 1;
			rygel_media_container_find_object (_data_->_data6_->container, _data_->id, _data_->_tmp7_, rygel_http_post_wait_for_item_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp8_ = rygel_media_container_find_object_finish (_data_->_data6_->container, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp8_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp9_ = _g_object_ref0 (RYGEL_IS_MEDIA_FILE_ITEM (_data_->_tmp5_) ? ((RygelMediaFileItem*) _data_->_tmp5_) : NULL);
			_g_object_unref0 (_data_->item);
			_data_->item = _data_->_tmp9_;
			_g_object_unref0 (_data_->_tmp5_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			break;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->item);
			block6_data_unref (_data_->_data6_);
			_data_->_data6_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp10_ = _data_->item;
		if (_data_->_tmp10_ == NULL) {
			g_warning ("rygel-http-post.vala:128: Item %s disappeared, stop waiting for it", _data_->id);
			break;
		}
		_data_->_tmp11_ = _data_->item;
		_data_->_tmp12_ = rygel_media_file_item_get_place_holder (_data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		if (_data_->_tmp13_) {
			_data_->_data7_ = g_slice_new0 (Block7Data);
			_data_->_data7_->_ref_count_ = 1;
			_data_->_data7_->_data6_ = block6_data_ref (_data_->_data6_);
			_data_->_data7_->source_id = (guint) 0;
			_data_->_data7_->source_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _data_->timeout, _____lambda13__gsource_func, block7_data_ref (_data_->_data7_), block7_data_unref);
			_data_->_tmp14_ = g_signal_connect_data (_data_->_data6_->container, "container-updated", (GCallback) _____lambda14__rygel_media_container_container_updated, block7_data_ref (_data_->_data7_), (GClosureNotify) block7_data_unref, 0);
			_data_->update_id = _data_->_tmp14_;
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
			g_signal_handler_disconnect ((GObject*) _data_->_data6_->container, _data_->update_id);
			if (_data_->_data7_->source_id != ((guint) 0)) {
				g_source_remove (_data_->_data7_->source_id);
			} else {
				block7_data_unref (_data_->_data7_);
				_data_->_data7_ = NULL;
				break;
			}
			block7_data_unref (_data_->_data7_);
			_data_->_data7_ = NULL;
		}
	}
	_g_object_unref0 (_data_->item);
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_http_post_finalize_post_data_free (gpointer _data)
{
	RygelHttpPostFinalizePostData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpPostFinalizePostData, _data_);
}

static void
rygel_http_post_finalize_post (RygelHTTPPost* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	RygelHttpPostFinalizePostData* _data_;
	RygelHTTPPost* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelHttpPostFinalizePostData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_http_post_finalize_post_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_post_finalize_post_co (_data_);
}

static void
rygel_http_post_finalize_post_finish (RygelHTTPPost* self,
                                      GAsyncResult* _res_)
{
	RygelHttpPostFinalizePostData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_http_post_finalize_post_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	RygelHttpPostFinalizePostData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_post_finalize_post_co (_data_);
}

static gboolean
rygel_http_post_finalize_post_co (RygelHttpPostFinalizePostData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->stream;
		_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		g_output_stream_close (_data_->_tmp0_, _data_->_tmp2_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_INTERNAL_SERVER_ERROR, NULL);
		_data_->_tmp3_ = _data_->self->priv->handle_continue;
		_data_->_tmp3__target = _data_->self->priv->handle_continue_target;
		_data_->_tmp3_ (_data_->_tmp3__target);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = ((RygelHTTPRequest*) _data_->self)->server;
	_data_->_tmp5_ = ((RygelHTTPRequest*) _data_->self)->msg;
	soup_server_pause_message (_data_->_tmp4_, _data_->_tmp5_);
	_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_tmp7_ = rygel_media_object_get_parent (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_tmp12_ = rygel_media_object_get_id (_data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	g_debug ("Waiting for update signal from container '%s' after pushing" " content to its child item '%s'…", _data_->_tmp10_, _data_->_tmp13_);
	{
		_data_->_tmp14_ = _data_->self->priv->dotfile;
		_data_->_tmp15_ = _data_->self->priv->file;
		_data_->_tmp16_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp17_ = _data_->_tmp16_;
		g_file_move (_data_->_tmp14_, _data_->_tmp15_, G_FILE_COPY_NONE, _data_->_tmp17_, NULL, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->move_error = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp18_ = _data_->self->priv->dotfile;
		_data_->_tmp19_ = g_file_get_uri (_data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp21_ = _data_->move_error;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_warning (_ ("Failed to move dotfile %s: %s"), _data_->_tmp20_, _data_->_tmp22_);
		_g_free0 (_data_->_tmp20_);
		_data_->_tmp23_ = ((RygelHTTPRequest*) _data_->self)->server;
		_data_->_tmp24_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_server_unpause_message (_data_->_tmp23_, _data_->_tmp24_);
		rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_INTERNAL_SERVER_ERROR, NULL);
		_data_->_tmp25_ = _data_->self->priv->handle_continue;
		_data_->_tmp25__target = _data_->self->priv->handle_continue_target;
		_data_->_tmp25_ (_data_->_tmp25__target);
		_g_error_free0 (_data_->move_error);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp26_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_tmp27_ = rygel_media_object_get_parent (_data_->_tmp26_);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_tmp30_ = rygel_media_object_get_id (_data_->_tmp29_);
	_data_->_tmp31_ = _data_->_tmp30_;
	_data_->_state_ = 1;
	rygel_http_post_wait_for_item (_data_->self, _data_->_tmp28_, _data_->_tmp31_, (guint) 5, rygel_http_post_finalize_post_ready, _data_);
	return FALSE;
	_state_1:
	rygel_http_post_wait_for_item_finish (_data_->self, _data_->_res_);
	_data_->_tmp32_ = ((RygelHTTPRequest*) _data_->self)->server;
	_data_->_tmp33_ = ((RygelHTTPRequest*) _data_->self)->msg;
	soup_server_unpause_message (_data_->_tmp32_, _data_->_tmp33_);
	rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_OK, NULL);
	_data_->_tmp34_ = _data_->self->priv->handle_continue;
	_data_->_tmp34__target = _data_->self->priv->handle_continue_target;
	_data_->_tmp34_ (_data_->_tmp34__target);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_http_post_on_got_chunk (RygelHTTPPost* self,
                              SoupMessage* msg,
                              SoupBuffer* chunk)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (chunk != NULL);
	{
		GOutputStream* _tmp0_;
		guint8* _tmp1_;
		gint _tmp1__length1;
		GCancellable* _tmp2_;
		GCancellable* _tmp3_;
		_tmp0_ = self->priv->stream;
		_tmp1_ = chunk->data;
		_tmp1__length1 = chunk->length;
		_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp3_ = _tmp2_;
		g_output_stream_write_all (_tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, _tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		GSourceFunc _tmp8_;
		gpointer _tmp8__target;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		rygel_http_post_disconnect_message_signals (self);
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR, _tmp5_);
		_tmp7_ = _tmp6_;
		rygel_http_request_handle_error ((RygelHTTPRequest*) self, _tmp7_);
		_g_error_free0 (_tmp7_);
		_tmp8_ = self->priv->handle_continue;
		_tmp8__target = self->priv->handle_continue_target;
		_tmp8_ (_tmp8__target);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
rygel_http_post_on_request_cancelled (RygelHTTPPost* self)
{
	g_return_if_fail (self != NULL);
	rygel_http_post_remove_item (self, NULL, NULL);
}

static void
rygel_http_post_remove_item_data_free (gpointer _data)
{
	RygelHttpPostRemoveItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpPostRemoveItemData, _data_);
}

static void
rygel_http_post_remove_item (RygelHTTPPost* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	RygelHttpPostRemoveItemData* _data_;
	RygelHTTPPost* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelHttpPostRemoveItemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_http_post_remove_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_post_remove_item_co (_data_);
}

static void
rygel_http_post_remove_item_finish (RygelHTTPPost* self,
                                    GAsyncResult* _res_)
{
	RygelHttpPostRemoveItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_http_post_remove_item_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	RygelHttpPostRemoveItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_post_remove_item_co (_data_);
}

static gboolean
rygel_http_post_remove_item_co (RygelHttpPostRemoveItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_object_removal_queue_get_default ();
	_data_->queue = _data_->_tmp0_;
	_data_->_tmp1_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_state_ = 1;
	rygel_object_removal_queue_remove_now (_data_->queue, (RygelMediaObject*) (RYGEL_IS_MEDIA_FILE_ITEM (_data_->_tmp1_) ? ((RygelMediaFileItem*) _data_->_tmp1_) : NULL), NULL, rygel_http_post_remove_item_ready, _data_);
	return FALSE;
	_state_1:
	rygel_object_removal_queue_remove_now_finish (_data_->queue, _data_->_res_);
	_g_object_unref0 (_data_->queue);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_http_post_disconnect_message_signals (RygelHTTPPost* self)
{
	SoupMessage* _tmp0_;
	guint _tmp1_;
	SoupMessage* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((RygelHTTPRequest*) self)->msg;
	g_signal_parse_name ("got-body", soup_message_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _rygel_http_post_on_got_body_soup_message_got_body, self);
	_tmp2_ = ((RygelHTTPRequest*) self)->msg;
	g_signal_parse_name ("got-chunk", soup_message_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _rygel_http_post_on_got_chunk_soup_message_got_chunk, self);
}

static void
rygel_http_post_class_init (RygelHTTPPostClass * klass,
                            gpointer klass_data)
{
	rygel_http_post_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPPost_private_offset);
	((RygelHTTPRequestClass *) klass)->handle = (void (*) (RygelHTTPRequest*, GAsyncReadyCallback, gpointer)) rygel_http_post_real_handle;
	((RygelHTTPRequestClass *) klass)->handle_finish = (void (*) (RygelHTTPRequest*, GAsyncResult*, GError**)) rygel_http_post_handle_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_post_finalize;
}

static void
rygel_http_post_instance_init (RygelHTTPPost * self,
                               gpointer klass)
{
	self->priv = rygel_http_post_get_instance_private (self);
}

static void
rygel_http_post_finalize (GObject * obj)
{
	RygelHTTPPost * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_POST, RygelHTTPPost);
	(self->priv->handle_continue_target_destroy_notify == NULL) ? NULL : (self->priv->handle_continue_target_destroy_notify (self->priv->handle_continue_target), NULL);
	self->priv->handle_continue = NULL;
	self->priv->handle_continue_target = NULL;
	self->priv->handle_continue_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->dotfile);
	_g_object_unref0 (self->priv->stream);
	G_OBJECT_CLASS (rygel_http_post_parent_class)->finalize (obj);
}

/**
 * Responsible for handling HTTP POST client requests.
 */
static GType
rygel_http_post_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPostClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_post_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPost), 0, (GInstanceInitFunc) rygel_http_post_instance_init, NULL };
	GType rygel_http_post_type_id;
	rygel_http_post_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPPost", &g_define_type_info, 0);
	RygelHTTPPost_private_offset = g_type_add_instance_private (rygel_http_post_type_id, sizeof (RygelHTTPPostPrivate));
	return rygel_http_post_type_id;
}

GType
rygel_http_post_get_type (void)
{
	static volatile gsize rygel_http_post_type_id__once = 0;
	if (g_once_init_enter (&rygel_http_post_type_id__once)) {
		GType rygel_http_post_type_id;
		rygel_http_post_type_id = rygel_http_post_get_type_once ();
		g_once_init_leave (&rygel_http_post_type_id__once, rygel_http_post_type_id);
	}
	return rygel_http_post_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

