/* rygel-wmp-hacks.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-wmp-hacks.vala, do not modify */

/*
 * Copyright (C) 2012 Nokia Corporation.
 *
 * Author: Lukasz Pawlik <lukasz.pawlik@comarch.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "rygel-server.h"
#include <gio/gio.h>
#include <libsoup/soup.h>

#define RYGEL_WMP_HACKS_AGENT ".*Windows-Media-Player/12\\.0.*"

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_WMP_HACKS (rygel_wmp_hacks_get_type ())
#define RYGEL_WMP_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMP_HACKS, RygelWMPHacks))
#define RYGEL_WMP_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMP_HACKS, RygelWMPHacksClass))
#define RYGEL_IS_WMP_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMP_HACKS))
#define RYGEL_IS_WMP_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMP_HACKS))
#define RYGEL_WMP_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMP_HACKS, RygelWMPHacksClass))

typedef struct _RygelWMPHacks RygelWMPHacks;
typedef struct _RygelWMPHacksClass RygelWMPHacksClass;
typedef struct _RygelWMPHacksPrivate RygelWMPHacksPrivate;
enum  {
	RYGEL_WMP_HACKS_0_PROPERTY,
	RYGEL_WMP_HACKS_NUM_PROPERTIES
};
static GParamSpec* rygel_wmp_hacks_properties[RYGEL_WMP_HACKS_NUM_PROPERTIES];

#define RYGEL_TYPE_CLIENT_HACKS_ERROR (rygel_client_hacks_error_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelWmpHacksSearchData RygelWmpHacksSearchData;

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
	GRegex* agent_regex;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
	void (*translate_container_id) (RygelClientHacks* self, RygelMediaQueryAction* action, gchar** container_id);
	void (*apply) (RygelClientHacks* self, RygelMediaObject* object);
	void (*filter_sort_criteria) (RygelClientHacks* self, gchar** sort_criteria);
	gboolean (*force_seek) (RygelClientHacks* self);
	void (*modify_headers) (RygelClientHacks* self, RygelHTTPRequest* request);
	void (*search) (RygelClientHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelClientHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelWMPHacks {
	RygelClientHacks parent_instance;
	RygelWMPHacksPrivate * priv;
};

struct _RygelWMPHacksClass {
	RygelClientHacksClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

struct _RygelWmpHacksSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelWMPHacks* self;
	RygelSearchableContainer* container;
	RygelSearchExpression* expression;
	guint offset;
	guint requested;
	gchar* sort_criteria;
	GCancellable* cancellable;
	guint total_matches;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	guint _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	GError* _inner_error0_;
};

static gpointer rygel_wmp_hacks_parent_class = NULL;

VALA_EXTERN GType rygel_client_hacks_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_media_query_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_wmp_hacks_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void rygel_client_hacks_search (RygelClientHacks* self,
                                RygelSearchableContainer* container,
                                RygelSearchExpression* expression,
                                guint offset,
                                guint max_count,
                                const gchar* sort_criteria,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN RygelMediaObjects* rygel_client_hacks_search_finish (RygelClientHacks* self,
                                                     GAsyncResult* _res_,
                                                     guint* total_matches,
                                                     GError** error);
VALA_EXTERN GQuark rygel_client_hacks_error_quark (void);
GType rygel_client_hacks_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelWMPHacks* rygel_wmp_hacks_new (SoupMessage* message,
                                    GError** error);
VALA_EXTERN RygelWMPHacks* rygel_wmp_hacks_construct (GType object_type,
                                          SoupMessage* message,
                                          GError** error);
VALA_EXTERN RygelClientHacks* rygel_client_hacks_construct (GType object_type,
                                                const gchar* agent,
                                                SoupMessage* message,
                                                GError** error);
static void rygel_wmp_hacks_real_search_data_free (gpointer _data);
static void rygel_wmp_hacks_real_search (RygelClientHacks* base,
                                  RygelSearchableContainer* container,
                                  RygelSearchExpression* expression,
                                  guint offset,
                                  guint requested,
                                  const gchar* sort_criteria,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static gboolean rygel_wmp_hacks_real_search_co (RygelWmpHacksSearchData* _data_);
static void rygel_wmp_hacks_search_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static GType rygel_wmp_hacks_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

RygelWMPHacks*
rygel_wmp_hacks_construct (GType object_type,
                           SoupMessage* message,
                           GError** error)
{
	RygelWMPHacks * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (RygelWMPHacks*) rygel_client_hacks_construct (object_type, RYGEL_WMP_HACKS_AGENT, message, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_CLIENT_HACKS_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

RygelWMPHacks*
rygel_wmp_hacks_new (SoupMessage* message,
                     GError** error)
{
	return rygel_wmp_hacks_construct (RYGEL_TYPE_WMP_HACKS, message, error);
}

static void
rygel_wmp_hacks_real_search_data_free (gpointer _data)
{
	RygelWmpHacksSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelWmpHacksSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}

static void
rygel_wmp_hacks_real_search (RygelClientHacks* base,
                             RygelSearchableContainer* container,
                             RygelSearchExpression* expression,
                             guint offset,
                             guint requested,
                             const gchar* sort_criteria,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	RygelWMPHacks * self;
	RygelWmpHacksSearchData* _data_;
	RygelWMPHacks* _tmp0_;
	RygelSearchableContainer* _tmp1_;
	RygelSearchExpression* _tmp2_;
	gchar* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (container != NULL);
	g_return_if_fail (sort_criteria != NULL);
	self = (RygelWMPHacks*) base;
	_data_ = g_slice_new0 (RygelWmpHacksSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_wmp_hacks_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (container);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp1_;
	_tmp2_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp2_;
	_data_->offset = offset;
	_data_->requested = requested;
	_tmp3_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_wmp_hacks_real_search_co (_data_);
}

static RygelMediaObjects*
rygel_wmp_hacks_search_finish (RygelClientHacks* base,
                               GAsyncResult* _res_,
                               guint* total_matches,
                               GError** error)
{
	RygelMediaObjects* result;
	RygelWmpHacksSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_wmp_hacks_search_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	RygelWmpHacksSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_wmp_hacks_real_search_co (_data_);
}

static gboolean
rygel_wmp_hacks_real_search_co (RygelWmpHacksSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_search (_data_->container, _data_->expression, _data_->offset, (guint) 0, _data_->sort_criteria, _data_->cancellable, rygel_wmp_hacks_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = rygel_searchable_container_search_finish (_data_->container, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error0_);
	_data_->total_matches = _data_->_tmp1_;
	_data_->_tmp0_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_wmp_hacks_class_init (RygelWMPHacksClass * klass,
                            gpointer klass_data)
{
	rygel_wmp_hacks_parent_class = g_type_class_peek_parent (klass);
	((RygelClientHacksClass *) klass)->search = (void (*) (RygelClientHacks*, RygelSearchableContainer*, RygelSearchExpression*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_wmp_hacks_real_search;
	((RygelClientHacksClass *) klass)->search_finish = (RygelMediaObjects* (*) (RygelClientHacks*, GAsyncResult*, guint*, GError**)) rygel_wmp_hacks_search_finish;
}

static void
rygel_wmp_hacks_instance_init (RygelWMPHacks * self,
                               gpointer klass)
{
}

static GType
rygel_wmp_hacks_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelWMPHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_wmp_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelWMPHacks), 0, (GInstanceInitFunc) rygel_wmp_hacks_instance_init, NULL };
	GType rygel_wmp_hacks_type_id;
	rygel_wmp_hacks_type_id = g_type_register_static (RYGEL_TYPE_CLIENT_HACKS, "RygelWMPHacks", &g_define_type_info, 0);
	return rygel_wmp_hacks_type_id;
}

GType
rygel_wmp_hacks_get_type (void)
{
	static volatile gsize rygel_wmp_hacks_type_id__once = 0;
	if (g_once_init_enter (&rygel_wmp_hacks_type_id__once)) {
		GType rygel_wmp_hacks_type_id;
		rygel_wmp_hacks_type_id = rygel_wmp_hacks_get_type_once ();
		g_once_init_leave (&rygel_wmp_hacks_type_id__once, rygel_wmp_hacks_type_id);
	}
	return rygel_wmp_hacks_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

