/* rygel-media-export-query-container.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-media-export-query-container.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-media-export.h"
#include <glib-object.h>
#include "rygel-server.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_ITEM_PREFIX "virtual-id:"

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;
typedef struct _RygelMediaExportQueryContainerPrivate RygelMediaExportQueryContainerPrivate;
enum  {
	RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_EXPRESSION_PROPERTY,
	RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_query_container_properties[RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_NUM_PROPERTIES];
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaExportQueryContainerSearchData RygelMediaExportQueryContainerSearchData;

struct _RygelMediaExportQueryContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportQueryContainerPrivate * priv;
};

struct _RygelMediaExportQueryContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};

struct _RygelMediaExportQueryContainerPrivate {
	RygelSearchExpression* _expression;
};

struct _RygelMediaExportQueryContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaExportQueryContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	guint total_matches;
	RygelMediaObjects* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	RygelMediaObjects* _tmp5_;
	guint _tmp6_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* _tmp8_;
	GError* _inner_error0_;
};

static gint RygelMediaExportQueryContainer_private_offset;
static gpointer rygel_media_export_query_container_parent_class = NULL;

VALA_EXTERN GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type,
                                                                              RygelSearchExpression* expression,
                                                                              const gchar* id,
                                                                              const gchar* name);
static void rygel_media_export_query_container_real_search_data_free (gpointer _data);
static void rygel_media_export_query_container_real_search (RygelMediaExportDBContainer* base,
                                                     RygelSearchExpression* expression,
                                                     guint offset,
                                                     guint max_count,
                                                     const gchar* sort_criteria,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean rygel_media_export_query_container_real_search_co (RygelMediaExportQueryContainerSearchData* _data_);
static void rygel_media_export_query_container_search_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
VALA_EXTERN RygelSearchExpression* rygel_media_export_query_container_get_expression (RygelMediaExportQueryContainer* self);
VALA_EXTERN void rygel_media_export_query_container_set_expression (RygelMediaExportQueryContainer* self,
                                                        RygelSearchExpression* value);
static void rygel_media_export_query_container_finalize (GObject * obj);
static GType rygel_media_export_query_container_get_type_once (void);
static void _vala_rygel_media_export_query_container_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_rygel_media_export_query_container_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
rygel_media_export_query_container_get_instance_private (RygelMediaExportQueryContainer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaExportQueryContainer_private_offset);
}

RygelMediaExportQueryContainer*
rygel_media_export_query_container_construct (GType object_type,
                                              RygelSearchExpression* expression,
                                              const gchar* id,
                                              const gchar* name)
{
	RygelMediaExportQueryContainer * self = NULL;
	g_return_val_if_fail (expression != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (RygelMediaExportQueryContainer*) g_object_new (object_type, "id", id, "parent", NULL, "title", name, "child-count", 0, "expression", expression, NULL);
	return self;
}

static void
rygel_media_export_query_container_real_search_data_free (gpointer _data)
{
	RygelMediaExportQueryContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportQueryContainerSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}

static void
rygel_media_export_query_container_real_search (RygelMediaExportDBContainer* base,
                                                RygelSearchExpression* expression,
                                                guint offset,
                                                guint max_count,
                                                const gchar* sort_criteria,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	RygelMediaExportQueryContainer * self;
	RygelMediaExportQueryContainerSearchData* _data_;
	RygelMediaExportQueryContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (sort_criteria != NULL);
	self = (RygelMediaExportQueryContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportQueryContainerSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_query_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp2_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	rygel_media_export_query_container_real_search_co (_data_);
}

static RygelMediaObjects*
rygel_media_export_query_container_search_finish (RygelMediaExportDBContainer* base,
                                                  GAsyncResult* _res_,
                                                  guint* total_matches,
                                                  GError** error)
{
	RygelMediaObjects* result;
	RygelMediaExportQueryContainerSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_media_export_query_container_search_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	RygelMediaExportQueryContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_query_container_real_search_co (_data_);
}

static gboolean
rygel_media_export_query_container_real_search_co (RygelMediaExportQueryContainerSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->expression == NULL) {
		_data_->_tmp1_ = g_strdup ("null");
		_g_free0 (_data_->_tmp0_);
		_data_->_tmp0_ = _data_->_tmp1_;
	} else {
		_data_->_tmp2_ = rygel_search_expression_to_string (_data_->expression);
		_g_free0 (_data_->_tmp0_);
		_data_->_tmp0_ = _data_->_tmp2_;
	}
	_data_->_tmp3_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	g_debug ("rygel-media-export-query-container.vala:51: Running search %s on query" \
" container %s", _data_->_tmp0_, _data_->_tmp4_);
	_data_->_tmp6_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->expression, _data_->offset, _data_->max_count, _data_->sort_criteria, _data_->cancellable, rygel_media_export_query_container_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error0_);
	_data_->total_matches = _data_->_tmp6_;
	_data_->_tmp5_ = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->_tmp5_;
	_data_->_tmp5_ = NULL;
	_data_->result = _data_->_tmp8_;
	_g_object_unref0 (_data_->_tmp5_);
	_g_free0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

RygelSearchExpression*
rygel_media_export_query_container_get_expression (RygelMediaExportQueryContainer* self)
{
	RygelSearchExpression* result;
	RygelSearchExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression;
	result = _tmp0_;
	return result;
}

void
rygel_media_export_query_container_set_expression (RygelMediaExportQueryContainer* self,
                                                   RygelSearchExpression* value)
{
	RygelSearchExpression* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_export_query_container_get_expression (self);
	if (old_value != value) {
		RygelSearchExpression* _tmp0_;
		_tmp0_ = _rygel_search_expression_ref0 (value);
		_rygel_search_expression_unref0 (self->priv->_expression);
		self->priv->_expression = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_export_query_container_properties[RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_EXPRESSION_PROPERTY]);
	}
}

static void
rygel_media_export_query_container_class_init (RygelMediaExportQueryContainerClass * klass,
                                               gpointer klass_data)
{
	rygel_media_export_query_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaExportQueryContainer_private_offset);
	((RygelMediaExportDBContainerClass *) klass)->search = (void (*) (RygelMediaExportDBContainer*, RygelSearchExpression*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_media_export_query_container_real_search;
	((RygelMediaExportDBContainerClass *) klass)->search_finish = (RygelMediaObjects* (*) (RygelMediaExportDBContainer*, GAsyncResult*, guint*, GError**)) rygel_media_export_query_container_search_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_query_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_query_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_query_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_EXPRESSION_PROPERTY, rygel_media_export_query_container_properties[RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_EXPRESSION_PROPERTY] = rygel_param_spec_search_expression ("expression", "expression", "expression", RYGEL_TYPE_SEARCH_EXPRESSION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
rygel_media_export_query_container_instance_init (RygelMediaExportQueryContainer * self,
                                                  gpointer klass)
{
	self->priv = rygel_media_export_query_container_get_instance_private (self);
}

static void
rygel_media_export_query_container_finalize (GObject * obj)
{
	RygelMediaExportQueryContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer);
	_rygel_search_expression_unref0 (self->priv->_expression);
	G_OBJECT_CLASS (rygel_media_export_query_container_parent_class)->finalize (obj);
}

static GType
rygel_media_export_query_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportQueryContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_query_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportQueryContainer), 0, (GInstanceInitFunc) rygel_media_export_query_container_instance_init, NULL };
	GType rygel_media_export_query_container_type_id;
	rygel_media_export_query_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, "RygelMediaExportQueryContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	RygelMediaExportQueryContainer_private_offset = g_type_add_instance_private (rygel_media_export_query_container_type_id, sizeof (RygelMediaExportQueryContainerPrivate));
	return rygel_media_export_query_container_type_id;
}

GType
rygel_media_export_query_container_get_type (void)
{
	static volatile gsize rygel_media_export_query_container_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_export_query_container_type_id__once)) {
		GType rygel_media_export_query_container_type_id;
		rygel_media_export_query_container_type_id = rygel_media_export_query_container_get_type_once ();
		g_once_init_leave (&rygel_media_export_query_container_type_id__once, rygel_media_export_query_container_type_id);
	}
	return rygel_media_export_query_container_type_id__once;
}

static void
_vala_rygel_media_export_query_container_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	RygelMediaExportQueryContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_EXPRESSION_PROPERTY:
		rygel_value_set_search_expression (value, rygel_media_export_query_container_get_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_export_query_container_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	RygelMediaExportQueryContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_EXPRESSION_PROPERTY:
		rygel_media_export_query_container_set_expression (self, rygel_value_get_search_expression (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

