/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.files;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.files.FileType;
import org.islandoftex.arara.api.rules.Directive;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.rules.Directives;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/islandoftex/arara/core/files/ProjectFile;", "Lorg/islandoftex/arara/api/files/ProjectFile;", "path", "Ljava/nio/file/Path;", "fileType", "Lorg/islandoftex/arara/api/files/FileType;", "priority", "", "(Ljava/nio/file/Path;Lorg/islandoftex/arara/api/files/FileType;I)V", "getFileType", "()Lorg/islandoftex/arara/api/files/FileType;", "getPath", "()Ljava/nio/file/Path;", "getPriority", "()I", "equals", "", "other", "", "fetchDirectives", "", "Lorg/islandoftex/arara/api/rules/Directive;", "parseOnlyHeader", "hashCode", "toString", "", "Companion", "core"})
public class ProjectFile
implements org.islandoftex.arara.api.files.ProjectFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private final FileType fileType;
    private final int priority;
    public static final int DEFAULT_PRIORITY = 0;

    public ProjectFile(@NotNull Path path2, @NotNull FileType fileType, int priority) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(fileType, "fileType");
        this.path = path2;
        this.fileType = fileType;
        this.priority = priority;
    }

    public /* synthetic */ ProjectFile(Path path2, FileType fileType, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(path2, fileType, n);
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return this.fileType;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProjectFile)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getPath(), ((ProjectFile)other).getPath())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getFileType(), ((ProjectFile)other).getFileType())) {
            return false;
        }
        return this.getPriority() == ((ProjectFile)other).getPriority();
    }

    public int hashCode() {
        int result2 = ((Object)this.getPath()).hashCode();
        result2 = 31 * result2 + this.getFileType().hashCode();
        result2 = 31 * result2 + this.getPriority();
        return result2;
    }

    @Override
    @NotNull
    public List<Directive> fetchDirectives(boolean parseOnlyHeader) {
        try {
            Path path2 = this.getPath();
            List<String> list = Files.readAllLines(path2, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, "readAllLines(this, charset)");
            return Directives.extractDirectives(list, LinearExecutor.INSTANCE.getExecutionOptions().getParseOnlyHeader(), this.getFileType());
        }
        catch (IOException ioexception) {
            throw new AraraException(LanguageController.getMessages().getERROR_EXTRACTOR_IO_ERROR(), ioexception);
        }
    }

    @NotNull
    public String toString() {
        return "ProjectFile(path=" + this.getPath() + ", fileType=" + this.getFileType() + ", priority=" + this.getPriority() + ')';
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/islandoftex/arara/core/files/ProjectFile$Companion;", "", "()V", "DEFAULT_PRIORITY", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

