/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.albatross;

import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.table.ColumnBuilder;
import com.github.ajalt.mordant.table.ColumnWidth;
import com.github.ajalt.mordant.table.SectionBuilder;
import com.github.ajalt.mordant.table.TableBuilder;
import com.github.ajalt.mordant.table.TableDslKt;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.islandoftex.albatross.Configuration;
import org.islandoftex.albatross.FCList;
import org.islandoftex.albatross.FontEntry;
import org.islandoftex.albatross.Settings;
import org.islandoftex.albatross.Viewer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0006\u0010\f\u001a\u00020\rJ$\u0010\u000e\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J\u0016\u0010\u0011\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/islandoftex/albatross/Viewer;", "", "configuration", "Lorg/islandoftex/albatross/Configuration;", "codepoints", "", "", "(Lorg/islandoftex/albatross/Configuration;Ljava/util/List;)V", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "toGlyph", "codepoint", "view", "", "viewEntries", "fonts", "Lorg/islandoftex/albatross/FontEntry;", "viewNoEntries", "viewNotFound", "albatross"})
public final class Viewer {
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final List<String> codepoints;
    @NotNull
    private final Terminal terminal;

    public Viewer(@NotNull Configuration configuration, @NotNull List<String> codepoints) {
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(codepoints, "codepoints");
        this.configuration = configuration;
        this.codepoints = codepoints;
        this.terminal = new Terminal(this.configuration.getAnsiLevel(), null, null, null, null, 0, null, 126, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void view() {
        if (!FCList.isAvailable()) {
            this.viewNotFound();
        } else if (this.configuration.getMatchAny()) {
            Iterable $this$forEach$iv = this.codepoints;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                List<FontEntry> fonts = FCList.getFonts(it);
                if (fonts.isEmpty()) {
                    this.viewNoEntries(CollectionsKt.listOf(it));
                    continue;
                }
                this.viewEntries(CollectionsKt.listOf(it), fonts);
            }
        } else {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.codepoints;
            boolean $i$f$flatMap = false;
            Iterable element$iv = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = FCList.getFonts(it);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List fonts = CollectionsKt.distinct((List)destination$iv$iv);
            if (fonts.isEmpty()) {
                this.viewNoEntries(this.codepoints);
            } else {
                this.viewEntries(this.codepoints, CollectionsKt.toList(fonts));
            }
        }
    }

    private final void viewNoEntries(List<String> codepoint) {
        this.terminal.println(TableDslKt.table((Function1<? super TableBuilder, Unit>)new Function1<TableBuilder, Unit>(codepoint, this){
            final /* synthetic */ List<String> $codepoint;
            final /* synthetic */ Viewer this$0;
            {
                this.$codepoint = $codepoint;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TableBuilder $this$table) {
                String string;
                Intrinsics.checkNotNullParameter($this$table, "$this$table");
                TableBuilder tableBuilder = $this$table;
                TextStyle textStyle = Settings.INSTANCE.getCliTextStyle();
                if (this.$codepoint.size() == 1) {
                    string = "Unicode code point " + this.$codepoint + " mapping to " + Viewer.access$toGlyph(this.this$0, CollectionsKt.first(this.$codepoint));
                } else {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.$codepoint;
                    Viewer viewer = this.this$0;
                    StringBuilder stringBuilder = new StringBuilder().append("Unicode code points ").append(this.$codepoint).append(" mapping to ");
                    TextStyle textStyle2 = textStyle;
                    TableBuilder tableBuilder2 = tableBuilder;
                    boolean $i$f$map = false;
                    void var5_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string2 = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(Viewer.access$toGlyph(viewer, (String)it));
                    }
                    collection = (List)destination$iv$iv;
                    tableBuilder = tableBuilder2;
                    textStyle = textStyle2;
                    string = stringBuilder.append(collection).toString();
                }
                TableBuilder.DefaultImpls.captionTop$default(tableBuilder, textStyle.invoke(string), null, 2, null);
                $this$table.setBorderStyle(Viewer.access$getConfiguration$p(this.this$0).getBorderStyle());
                $this$table.setBorderTextStyle(Settings.INSTANCE.getBorderColour());
                $this$table.column(0, viewNoEntries.2.INSTANCE);
                $this$table.body(viewNoEntries.3.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void viewEntries(List<String> codepoint, List<FontEntry> fonts) {
        String caption;
        String string;
        String detailString;
        String key$iv$iv;
        Object $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = fonts;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            FontEntry it = (FontEntry)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map entries = destination$iv$iv;
        $this$groupByTo$iv$iv = ", font details,";
        String it = $this$groupByTo$iv$iv;
        boolean bl3 = false;
        Object object = this.configuration.getDetailed() ? $this$groupByTo$iv$iv : null;
        if (object == null) {
            object = detailString = "";
        }
        if (codepoint.size() == 1) {
            string = "Unicode code point " + codepoint + detailString + " mapping to " + this.toGlyph(CollectionsKt.first(codepoint));
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$groupByTo$iv$iv = codepoint;
            StringBuilder stringBuilder = new StringBuilder().append("Unicode code points ").append(codepoint).append(detailString).append(" mapping to ");
            boolean $i$f$map = false;
            void bl3 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                key$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(this.toGlyph((String)it2));
            }
            string = caption = stringBuilder.append((List)destination$iv$iv2).toString();
        }
        if (!this.configuration.getDetailed()) {
            this.terminal.println(TableDslKt.table((Function1<? super TableBuilder, Unit>)new Function1<TableBuilder, Unit>(caption, this, (Map<String, ? extends List<FontEntry>>)entries){
                final /* synthetic */ String $caption;
                final /* synthetic */ Viewer this$0;
                final /* synthetic */ Map<String, List<FontEntry>> $entries;
                {
                    this.$caption = $caption;
                    this.this$0 = $receiver;
                    this.$entries = $entries;
                    super(1);
                }

                public final void invoke(@NotNull TableBuilder $this$table) {
                    Intrinsics.checkNotNullParameter($this$table, "$this$table");
                    TableBuilder.DefaultImpls.captionTop$default($this$table, Settings.INSTANCE.getCliTitleStyle().invoke(this.$caption), null, 2, null);
                    $this$table.setBorderStyle(Viewer.access$getConfiguration$p(this.this$0).getBorderStyle());
                    $this$table.setBorderTextStyle(Settings.INSTANCE.getBorderColour());
                    $this$table.column(0, (Function1<? super ColumnBuilder, Unit>)new Function1<ColumnBuilder, Unit>(this.this$0){
                        final /* synthetic */ Viewer this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull ColumnBuilder $this$column) {
                            Intrinsics.checkNotNullParameter($this$column, "$this$column");
                            $this$column.setWidth(new ColumnWidth.Expand(Viewer.access$getConfiguration$p(this.this$0).getShowStyles() ? 40 : 100));
                            $this$column.setOverflowWrap(OverflowWrap.BREAK_WORD);
                            $this$column.setWhitespace(Whitespace.PRE_WRAP);
                        }
                    });
                    if (Viewer.access$getConfiguration$p(this.this$0).getShowStyles()) {
                        $this$table.column(1, viewEntries.2.INSTANCE);
                    }
                    $this$table.header((Function1<? super SectionBuilder, Unit>)new Function1<SectionBuilder, Unit>(this.this$0){
                        final /* synthetic */ Viewer this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull SectionBuilder $this$header) {
                            Intrinsics.checkNotNullParameter($this$header, "$this$header");
                            if (Viewer.access$getConfiguration$p(this.this$0).getShowStyles()) {
                                Object[] objectArray = new Object[]{Settings.INSTANCE.getCliHeaderStyle().invoke("Font name"), Settings.INSTANCE.getCliHeaderStyle().invoke("Available styles")};
                                SectionBuilder.DefaultImpls.row$default($this$header, objectArray, null, 2, null);
                            } else {
                                Object[] objectArray = new Object[]{Settings.INSTANCE.getCliHeaderStyle().invoke("Font name")};
                                SectionBuilder.DefaultImpls.row$default($this$header, objectArray, null, 2, null);
                            }
                        }
                    });
                    $this$table.body((Function1<? super SectionBuilder, Unit>)new Function1<SectionBuilder, Unit>(this.this$0, this.$entries){
                        final /* synthetic */ Viewer this$0;
                        final /* synthetic */ Map<String, List<FontEntry>> $entries;
                        {
                            this.this$0 = $receiver;
                            this.$entries = $entries;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull SectionBuilder $this$body) {
                            Intrinsics.checkNotNullParameter($this$body, "$this$body");
                            $this$body.setStyle(Settings.INSTANCE.getCliTextStyle());
                            if (Viewer.access$getConfiguration$p(this.this$0).getShowStyles()) {
                                Map<String, List<FontEntry>> $this$forEach$iv = this.$entries;
                                boolean $i$f$forEach = false;
                                Iterator<Map.Entry<String, List<FontEntry>>> iterator2 = $this$forEach$iv.entrySet().iterator();
                                while (iterator2.hasNext()) {
                                    Collection<List<String>> collection;
                                    void $this$mapTo$iv$iv;
                                    void $this$map$iv;
                                    Map.Entry<String, List<FontEntry>> element$iv;
                                    Map.Entry<String, List<FontEntry>> $dstr$name$font = element$iv = iterator2.next();
                                    boolean bl = false;
                                    String name = $dstr$name$font.getKey();
                                    List<FontEntry> font = $dstr$name$font.getValue();
                                    Object[] objectArray = new Object[2];
                                    objectArray[0] = name;
                                    Iterable iterable = font;
                                    int n = 1;
                                    Object[] objectArray2 = objectArray;
                                    SectionBuilder sectionBuilder = $this$body;
                                    boolean $i$f$map = false;
                                    void var16_23 = $this$map$iv;
                                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                    boolean $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        void it;
                                        FontEntry fontEntry = (FontEntry)item$iv$iv;
                                        collection = destination$iv$iv;
                                        boolean bl2 = false;
                                        collection.add(it.getStyles());
                                    }
                                    collection = (List)destination$iv$iv;
                                    objectArray2[n] = CollectionsKt.joinToString$default(CollectionsKt.distinct((Iterable)CollectionsKt.flatten((Iterable)collection)), ", ", null, null, 0, null, null, 62, null);
                                    SectionBuilder.DefaultImpls.row$default(sectionBuilder, objectArray, null, 2, null);
                                }
                            } else {
                                Iterable $this$forEach$iv = this.$entries.keySet();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    String it = (String)element$iv;
                                    boolean bl = false;
                                    Object[] objectArray = new Object[]{it};
                                    SectionBuilder.DefaultImpls.row$default($this$body, objectArray, null, 2, null);
                                }
                            }
                        }
                    });
                }
            }));
        } else {
            Map $this$forEach$iv = entries;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it3 = element$iv = iterator3.next();
                boolean bl5 = false;
                this.terminal.println(TableDslKt.table((Function1<? super TableBuilder, Unit>)new Function1<TableBuilder, Unit>(caption, this, it3){
                    final /* synthetic */ String $caption;
                    final /* synthetic */ Viewer this$0;
                    final /* synthetic */ Map.Entry<String, List<FontEntry>> $it;
                    {
                        this.$caption = $caption;
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(1);
                    }

                    public final void invoke(@NotNull TableBuilder $this$table) {
                        Intrinsics.checkNotNullParameter($this$table, "$this$table");
                        TableBuilder.DefaultImpls.captionTop$default($this$table, Settings.INSTANCE.getCliTitleStyle().invoke(this.$caption), null, 2, null);
                        $this$table.setBorderStyle(Viewer.access$getConfiguration$p(this.this$0).getBorderStyle());
                        $this$table.column(0, viewEntries.2.1.INSTANCE);
                        $this$table.column(1, viewEntries.2.2.INSTANCE);
                        $this$table.body((Function1<? super SectionBuilder, Unit>)new Function1<SectionBuilder, Unit>(this.$it, this.this$0){
                            final /* synthetic */ Map.Entry<String, List<FontEntry>> $it;
                            final /* synthetic */ Viewer this$0;
                            {
                                this.$it = $it;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull SectionBuilder $this$body) {
                                FontEntry it;
                                Collection<List<String>> collection;
                                Iterable $this$mapTo$iv$iv;
                                Iterable $this$map$iv;
                                Intrinsics.checkNotNullParameter($this$body, "$this$body");
                                Object[] objectArray = new Object[]{Settings.INSTANCE.getCliHeaderStyle().invoke("Name"), Settings.INSTANCE.getCliTextStyle().invoke(this.$it.getKey())};
                                SectionBuilder.DefaultImpls.row$default($this$body, objectArray, null, 2, null);
                                objectArray = new Object[2];
                                objectArray[0] = Settings.INSTANCE.getCliHeaderStyle().invoke("Type");
                                Iterable iterable = this.$it.getValue();
                                TextStyle textStyle = Settings.INSTANCE.getCliTextStyle();
                                int n = 1;
                                Object[] objectArray2 = objectArray;
                                SectionBuilder sectionBuilder = $this$body;
                                boolean $i$f$map = false;
                                void var5_9 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    FontEntry fontEntry = (FontEntry)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add((List<String>)((Object)it.getDescription()));
                                }
                                collection = (List)destination$iv$iv;
                                objectArray2[n] = textStyle.invoke(CollectionsKt.joinToString$default(CollectionsKt.distinct((Iterable)collection), ", ", null, null, 0, null, null, 62, null));
                                SectionBuilder.DefaultImpls.row$default(sectionBuilder, objectArray, null, 2, null);
                                objectArray = new Object[]{Settings.INSTANCE.getCliHeaderStyle().invoke("Files"), TableDslKt.table((Function1<? super TableBuilder, Unit>)new Function1<TableBuilder, Unit>(this.this$0, this.$it){
                                    final /* synthetic */ Viewer this$0;
                                    final /* synthetic */ Map.Entry<String, List<FontEntry>> $it;
                                    {
                                        this.this$0 = $receiver;
                                        this.$it = $it;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull TableBuilder $this$table) {
                                        Intrinsics.checkNotNullParameter($this$table, "$this$table");
                                        $this$table.setOuterBorder(false);
                                        $this$table.setBorderStyle(Viewer.access$getConfiguration$p(this.this$0).getBorderStyle());
                                        $this$table.column(0, viewEntries.2.1.INSTANCE);
                                        $this$table.body((Function1<? super SectionBuilder, Unit>)new Function1<SectionBuilder, Unit>(this.$it){
                                            final /* synthetic */ Map.Entry<String, List<FontEntry>> $it;
                                            {
                                                this.$it = $it;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull SectionBuilder $this$body) {
                                                Intrinsics.checkNotNullParameter($this$body, "$this$body");
                                                Iterable $this$forEach$iv = this.$it.getValue();
                                                boolean $i$f$forEach = false;
                                                for (T element$iv : $this$forEach$iv) {
                                                    FontEntry it = (FontEntry)element$iv;
                                                    boolean bl = false;
                                                    Object[] objectArray = new Object[]{Settings.INSTANCE.getCliPathStyle().invoke(((Object)it.getPath()).toString())};
                                                    SectionBuilder.DefaultImpls.row$default($this$body, objectArray, null, 2, null);
                                                }
                                            }
                                        });
                                    }
                                })};
                                SectionBuilder.DefaultImpls.row$default($this$body, objectArray, null, 2, null);
                                if (Viewer.access$getConfiguration$p(this.this$0).getShowStyles()) {
                                    objectArray = new Object[2];
                                    objectArray[0] = Settings.INSTANCE.getCliHeaderStyle().invoke("Styles");
                                    $this$map$iv = this.$it.getValue();
                                    textStyle = Settings.INSTANCE.getCliTextStyle();
                                    n = 1;
                                    objectArray2 = objectArray;
                                    sectionBuilder = $this$body;
                                    $i$f$map = false;
                                    $this$mapTo$iv$iv = $this$map$iv;
                                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                    $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        it = (FontEntry)item$iv$iv;
                                        collection = destination$iv$iv;
                                        boolean bl = false;
                                        collection.add(it.getStyles());
                                    }
                                    collection = (List)destination$iv$iv;
                                    objectArray2[n] = textStyle.invoke(CollectionsKt.joinToString$default(CollectionsKt.distinct((Iterable)CollectionsKt.flatten((Iterable)collection)), ", ", null, null, 0, null, null, 62, null));
                                    SectionBuilder.DefaultImpls.row$default(sectionBuilder, objectArray, null, 2, null);
                                }
                            }
                        });
                    }
                }));
            }
        }
    }

    private final void viewNotFound() {
        this.terminal.println(TableDslKt.table((Function1<? super TableBuilder, Unit>)new Function1<TableBuilder, Unit>(this){
            final /* synthetic */ Viewer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull TableBuilder $this$table) {
                Intrinsics.checkNotNullParameter($this$table, "$this$table");
                TableBuilder.DefaultImpls.captionTop$default($this$table, Settings.INSTANCE.getCliTitleStyle().invoke("Attention!"), null, 2, null);
                $this$table.setBorderStyle(Viewer.access$getConfiguration$p(this.this$0).getBorderStyle());
                $this$table.column(0, viewNotFound.1.INSTANCE);
                $this$table.body(viewNotFound.2.INSTANCE);
            }
        }));
    }

    private final String toGlyph(String codepoint) {
        char[] cArray = Character.toChars(Integer.parseInt(codepoint, CharsKt.checkRadix(16)));
        Intrinsics.checkNotNullExpressionValue(cArray, "toChars(codepoint.toInt(16))");
        return StringsKt.concatToString(cArray);
    }

    public static final /* synthetic */ String access$toGlyph(Viewer $this, String codepoint) {
        return $this.toGlyph(codepoint);
    }

    public static final /* synthetic */ Configuration access$getConfiguration$p(Viewer $this) {
        return $this.configuration;
    }
}

