/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.JmolMeasurementClient;
import org.jmol.atomdata.RadiusData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.TickInfo;
import org.jmol.shape.AtomShape;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Font;
import org.jmol.util.Point3fi;

public class Measures
extends AtomShape
implements JmolMeasurementClient {
    private BS bsSelected;
    private String strFormat;
    private boolean mustBeConnected = false;
    private boolean mustNotBeConnected = false;
    private RadiusData radiusData;
    private Boolean intramolecular;
    private boolean measureAllModels;
    public int measurementCount = 0;
    public final Lst<Measurement> measurements = new Lst();
    public MeasurementPending mPending;
    public short colix;
    TickInfo tickInfo;
    public TickInfo defaultTickInfo;
    public Font font3d;
    private Map<String, Integer> htMin;
    private int tokAction;

    @Override
    protected void initModelSet() {
        int i = this.measurements.size();
        while (--i >= 0) {
            Measurement m = (Measurement)this.measurements.get(i);
            if (m == null) continue;
            m.ms = this.ms;
        }
    }

    @Override
    public void initShape() {
        if (this.font3d == null) {
            this.font3d = this.vwr.gdata.getFont3D(18.0f);
        }
    }

    @Override
    protected void setSize(int size, BS bsSelected) {
        this.mad = (short)size;
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bsIgnored) {
        if ("clearModelIndex" == propertyName) {
            for (int i = 0; i < this.measurementCount; ++i) {
                ((Measurement)this.measurements.get(i)).setModelIndex((short)0);
            }
            return;
        }
        if ("color" == propertyName) {
            this.setColor(C.getColixO(value));
            return;
        }
        if ("font" == propertyName) {
            this.font3d = (Font)value;
            return;
        }
        if ("hideAll" == propertyName) {
            this.showHide((Boolean)value);
            return;
        }
        if ("pending" == propertyName) {
            this.mPending = (MeasurementPending)value;
            if (this.mPending == null) {
                return;
            }
            if (this.mPending.count > 1) {
                this.vwr.setStatusMeasuring("measurePending", this.mPending.count, Measures.getMessage(this.mPending, false), this.mPending.value);
            }
            return;
        }
        boolean isRefresh = "refresh" == propertyName;
        if (isRefresh || "refreshTrajectories" == propertyName) {
            int i = this.measurements.size();
            while (--i >= 0) {
                Measurement mt = (Measurement)this.measurements.get(i);
                if (mt == null || !isRefresh && !mt.isTrajectory) continue;
                mt.refresh(null);
            }
            return;
        }
        if ("select" == propertyName) {
            BS bs = (BS)value;
            if (BSUtil.cardinalityOf(bs) == 0) {
                this.bsSelected = null;
            } else {
                this.bsSelected = new BS();
                this.bsSelected.or(bs);
            }
            return;
        }
        if ("setFormats" == propertyName) {
            this.setFormats((String)value);
            return;
        }
        this.measureAllModels = this.vwr.getBoolean(603979877);
        if ("delete" == propertyName) {
            this.deleteO(value);
            this.setIndices();
            return;
        }
        this.bsSelected = null;
        if ("maps" == propertyName) {
            int[][] maps = (int[][])value;
            for (int i = 0; i < maps.length; ++i) {
                int len = maps[i].length;
                if (len < 2 || len > 4) continue;
                int[] v = new int[len + 1];
                v[0] = len;
                System.arraycopy(maps[i], 0, v, 1, len);
                this.toggleOn(v);
            }
        } else if ("measure" == propertyName) {
            MeasurementData md = (MeasurementData)value;
            this.tickInfo = md.tickInfo;
            if (md.tickInfo != null && md.tickInfo.id.equals("default")) {
                this.defaultTickInfo = md.tickInfo;
                return;
            }
            if (md.isAll && md.points.size() == 2 && md.points.get(0) instanceof BS) {
                int type = Measurement.nmrType(this.vwr.getDistanceUnits(md.strFormat));
                switch (type) {
                    case 2: {
                        md.htMin = this.vwr.getNMRCalculation().getMinDistances(md);
                    }
                }
            }
            this.tickInfo = md.tickInfo;
            this.radiusData = md.radiusData;
            this.htMin = md.htMin;
            this.mustBeConnected = md.mustBeConnected;
            this.mustNotBeConnected = md.mustNotBeConnected;
            this.intramolecular = md.intramolecular;
            this.strFormat = md.strFormat;
            if (md.isAll) {
                if (this.tickInfo != null) {
                    this.define(md, 12291);
                }
                this.define(md, md.tokAction);
                this.setIndices();
                return;
            }
            Measurement m = this.setSingleItem(md.points);
            if (md.thisID != null) {
                m.thisID = md.thisID;
                m.mad = md.mad;
                if (md.colix != 0) {
                    m.colix = md.colix;
                }
                m.strFormat = md.strFormat;
                m.text = md.text;
            }
            m.units = md.units;
            m.property = md.property;
            m.fixedValue = md.fixedValue;
            switch (md.tokAction) {
                case 266284: {
                    this.doAction(md, md.thisID, 266284);
                    break;
                }
                case 12291: {
                    this.defineAll(Integer.MIN_VALUE, m, true, false, false);
                    this.setIndices();
                    break;
                }
                case 1073742335: {
                    this.showHideM(m, false);
                    break;
                }
                case 1073742334: {
                    this.showHideM(m, true);
                    break;
                }
                case 1665140738: {
                    if (md.thisID == null) break;
                    this.doAction(md, md.thisID, 1665140738);
                    break;
                }
                case 12290: {
                    if (md.thisID == null) {
                        this.deleteM(m);
                    } else {
                        this.deleteO(md.thisID);
                    }
                    this.toggle(m);
                    break;
                }
                case 268435538: {
                    this.toggle(m);
                }
            }
            return;
        }
        if ("clear" == propertyName) {
            this.clear();
            return;
        }
        if ("deleteModelAtoms" == propertyName) {
            int modelIndex = ((int[])((Object[])value)[2])[0];
            int firstAtomDeleted = ((int[])((Object[])value)[2])[1];
            int nAtomsDeleted = ((int[])((Object[])value)[2])[2];
            int atomMax = firstAtomDeleted + nAtomsDeleted;
            int i = this.measurementCount;
            block15: while (--i >= 0) {
                Measurement mt = (Measurement)this.measurements.get(i);
                int[] indices = mt.countPlusIndices;
                for (int j = 1; j <= indices[0]; ++j) {
                    int iAtom = indices[j];
                    if (iAtom >= firstAtomDeleted) {
                        if (iAtom < atomMax) {
                            this.deleteI(i);
                            continue block15;
                        }
                        int n = j;
                        indices[n] = indices[n] - nAtomsDeleted;
                        continue;
                    }
                    if (iAtom >= 0) continue;
                    Point3fi pt = mt.getAtom(j);
                    if (pt.mi > modelIndex) {
                        pt.mi = (short)(pt.mi - 1);
                        continue;
                    }
                    if (pt.mi != modelIndex) continue;
                    this.deleteI(i);
                    continue block15;
                }
            }
            return;
        }
        if ("reformatDistances" == propertyName) {
            this.reformatDistances();
            return;
        }
        if ("hide" == propertyName) {
            if (value instanceof String) {
                this.doAction(null, (String)value, 12294);
            } else {
                this.showHideM(new Measurement().setPoints(this.ms, (int[])value, null, null), true);
            }
            return;
        }
        if ("refresh" == propertyName) {
            this.doAction((MeasurementData)value, null, 266284);
            return;
        }
        if ("show" == propertyName) {
            if (value instanceof String) {
                this.doAction(null, (String)value, 134222350);
            } else {
                this.showHideM(new Measurement().setPoints(this.ms, (int[])value, null, null), false);
            }
            return;
        }
        if ("toggle" == propertyName) {
            if (value instanceof String) {
                this.doAction(null, (String)value, 268435538);
            } else {
                this.toggle(new Measurement().setPoints(this.ms, (int[])value, null, null));
            }
            return;
        }
        if ("toggleOn" == propertyName) {
            if (value instanceof String) {
                this.doAction(null, (String)value, 1073742335);
            } else {
                this.toggleOn((int[])value);
            }
            return;
        }
    }

    private Measurement setSingleItem(Lst<Object> vector) {
        Point3fi[] points = new Point3fi[4];
        int[] indices = new int[5];
        indices[0] = vector.size();
        int i = vector.size();
        while (--i >= 0) {
            Object value = vector.get(i);
            if (value instanceof BS) {
                int atomIndex = ((BS)value).nextSetBit(0);
                if (atomIndex < 0) {
                    return null;
                }
                indices[i + 1] = atomIndex;
                continue;
            }
            points[i] = (Point3fi)value;
            indices[i + 1] = -2 - i;
        }
        return new Measurement().setPoints(this.ms, indices, points, this.tickInfo == null ? this.defaultTickInfo : this.tickInfo);
    }

    @Override
    public Object getProperty(String property, int index) {
        if ("pending".equals(property)) {
            return this.mPending;
        }
        if ("count".equals(property)) {
            return this.measurementCount;
        }
        if ("countPlusIndices".equals(property)) {
            return index < this.measurementCount ? ((Measurement)this.measurements.get((int)index)).countPlusIndices : null;
        }
        if ("stringValue".equals(property)) {
            return index < this.measurementCount ? ((Measurement)this.measurements.get(index)).getString() : null;
        }
        if ("pointInfo".equals(property)) {
            return ((Measurement)this.measurements.get(index / 10)).getLabel(index % 10, false, false);
        }
        if ("info".equals(property)) {
            return this.getAllInfo();
        }
        if ("infostring".equals(property)) {
            return this.getAllInfoAsString();
        }
        return null;
    }

    public void clear() {
        if (this.measurementCount == 0) {
            return;
        }
        this.measurementCount = 0;
        this.measurements.clear();
        this.mPending = null;
        this.vwr.setStatusMeasuring("measureDeleted", -1, "all", 0.0f);
    }

    private void setColor(short colix) {
        if (this.bsColixSet == null) {
            this.bsColixSet = new BS();
        }
        if (this.bsSelected == null) {
            this.colix = colix;
        }
        int i = this.measurements.size();
        while (--i >= 0) {
            Measurement mt = (Measurement)this.measurements.get(i);
            if (mt == null || (this.bsSelected == null || !this.bsSelected.get(i)) && (this.bsSelected != null || colix != 0 && mt.colix != 0)) continue;
            mt.colix = colix;
            this.bsColixSet.set(i);
        }
    }

    private void setFormats(String format) {
        if (format != null && format.length() == 0) {
            format = null;
        }
        int i = this.measurements.size();
        while (--i >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(i)) continue;
            ((Measurement)this.measurements.get(i)).formatMeasurementAs(format, null, false);
        }
    }

    private void showHide(boolean isHide) {
        int i = this.measurements.size();
        while (--i >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(i)) continue;
            ((Measurement)this.measurements.get((int)i)).isHidden = isHide;
        }
    }

    private void showHideM(Measurement m, boolean isHide) {
        int i = this.find(m);
        if (i >= 0) {
            ((Measurement)this.measurements.get((int)i)).isHidden = isHide;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void toggle(Measurement m) {
        this.radiusData = null;
        this.htMin = null;
        i = this.find(m);
        if (i < 0) ** GOTO lbl-1000
        mt = (Measurement)this.measurements.get(i);
        if (!mt.isHidden) {
            this.defineAll(i, mt, true, false, false);
        } else lbl-1000:
        // 2 sources

        {
            this.defineAll(-1, m, false, true, false);
        }
        this.setIndices();
    }

    private void toggleOn(int[] indices) {
        this.radiusData = null;
        this.htMin = null;
        this.bsSelected = new BS();
        Measurement m = new Measurement().setPoints(this.ms, indices, null, this.defaultTickInfo);
        this.defineAll(Integer.MIN_VALUE, m, false, true, true);
        int i = this.find(m);
        if (i >= 0) {
            this.bsSelected.set(i);
        }
        this.setIndices();
        this.reformatDistances();
    }

    private void deleteM(Measurement m) {
        this.radiusData = null;
        this.htMin = null;
        int i = this.find(m);
        if (i >= 0) {
            this.defineAll(i, (Measurement)this.measurements.get(i), true, false, false);
        }
        this.setIndices();
    }

    private void deleteO(Object value) {
        if (value instanceof Integer) {
            this.deleteI((Integer)value);
        } else if (value instanceof String) {
            this.doAction(null, (String)value, 12291);
        } else if (AU.isAI(value)) {
            this.defineAll(Integer.MIN_VALUE, new Measurement().setPoints(this.ms, (int[])value, null, null), true, false, false);
        }
    }

    private void defineAll(int iPt, Measurement m, boolean isDelete, boolean isShow, boolean doSelect) {
        if (!this.measureAllModels) {
            if (isDelete) {
                if (iPt == Integer.MIN_VALUE) {
                    iPt = this.find(m);
                }
                if (iPt >= 0) {
                    this.deleteI(iPt);
                }
                return;
            }
            this.defineMeasurement(iPt, m, doSelect);
            return;
        }
        if (isShow) {
            this.defineAll(iPt, m, true, false, false);
            if (isDelete) {
                return;
            }
        }
        Lst<Object> points = new Lst<Object>();
        int nPoints = m.count;
        Atom[] atoms = this.ms.at;
        for (int i = 1; i <= nPoints; ++i) {
            int atomIndex = m.getAtomIndex(i);
            points.addLast(atomIndex >= 0 ? this.ms.getAtoms(1094715393, atoms[atomIndex].getAtomNumber()) : m.getAtom(i));
        }
        this.define(new MeasurementData().init(null, this.vwr, points).set(this.tokAction, this.htMin, this.radiusData, m.property, this.strFormat, null, this.tickInfo, this.mustBeConnected, this.mustNotBeConnected, this.intramolecular, true, 0, (short)0, null, Float.NaN), isDelete ? 12291 : 12290);
    }

    private int find(Measurement m) {
        return m.thisID == null ? Measurement.find(this.measurements, m) : -1;
    }

    private void setIndices() {
        for (int i = 0; i < this.measurementCount; ++i) {
            ((Measurement)this.measurements.get((int)i)).index = i;
        }
    }

    private void define(MeasurementData md, int tokAction) {
        this.tokAction = tokAction;
        md.define(this, this.ms);
    }

    @Override
    public void processNextMeasure(Measurement m) {
        int iThis = this.find(m);
        if (iThis >= 0) {
            if (this.tokAction == 12291) {
                this.deleteI(iThis);
            } else if (this.strFormat != null) {
                ((Measurement)this.measurements.get(iThis)).formatMeasurementAs(this.strFormat, null, true);
            } else {
                ((Measurement)this.measurements.get((int)iThis)).isHidden = this.tokAction == 1073742334;
            }
        } else if (this.tokAction == 12290 || this.tokAction == 268435538) {
            m.tickInfo = this.tickInfo == null ? this.defaultTickInfo : this.tickInfo;
            this.defineMeasurement(-1, m, true);
        }
    }

    private void defineMeasurement(int i, Measurement m, boolean doSelect) {
        float value = m.getMeasurement(null);
        if (this.htMin != null && !m.isMin(this.htMin) || this.radiusData != null && !m.isInRange(this.radiusData, value)) {
            return;
        }
        if (i == Integer.MIN_VALUE) {
            i = this.find(m);
        }
        if (i >= 0) {
            ((Measurement)this.measurements.get((int)i)).isHidden = false;
            if (doSelect) {
                this.bsSelected.set(i);
            }
            return;
        }
        Measurement measureNew = new Measurement().setM(this.ms, m, value, m.colix == 0 ? this.colix : m.colix, this.strFormat, this.measurementCount);
        if (!measureNew.isValid) {
            return;
        }
        this.measurements.addLast(measureNew);
        this.vwr.setStatusMeasuring("measureCompleted", this.measurementCount++, Measures.getMessage(measureNew, false), measureNew.value);
    }

    private static String getMessage(Measurement m, boolean asBitSet) {
        SB sb = new SB();
        sb.append("[");
        for (int i = 1; i <= m.count; ++i) {
            if (i > 1) {
                sb.append(", ");
            }
            sb.append(m.getLabel(i, asBitSet, false));
        }
        sb.append(", ");
        sb.append(m.getString());
        sb.append("]");
        return sb.toString();
    }

    private void deleteI(int i) {
        if (i >= this.measurements.size() || i < 0) {
            return;
        }
        String msg = Measures.getMessage((Measurement)this.measurements.get(i), true);
        this.measurements.removeItemAt(i);
        --this.measurementCount;
        this.vwr.setStatusMeasuring("measureDeleted", i, msg, 0.0f);
    }

    private void doAction(MeasurementData md, String id, int tok) {
        id = id.toUpperCase().replace('?', '*');
        boolean isWild = PT.isWild(id);
        int i = this.measurements.size();
        while (--i >= 0) {
            Measurement m = (Measurement)this.measurements.get(i);
            if (m.thisID == null || !m.thisID.equalsIgnoreCase(id) && (!isWild || !PT.isMatch(m.thisID.toUpperCase(), id, true, true))) continue;
            switch (tok) {
                case 266284: {
                    if (md.colix != 0) {
                        m.colix = md.colix;
                    }
                    if (md.mad != 0) {
                        m.mad = md.mad;
                    }
                    if (md.strFormat != null) {
                        m.strFormat = m.strFormat.substring(0, 2) + md.strFormat.substring(2);
                    }
                    if (md.text != null) {
                        if (m.text == null) {
                            m.text = md.text;
                        } else {
                            if (md.text.font != null) {
                                m.text.font = md.text.font;
                            }
                            m.text.text = null;
                            if (md.text.align != 0) {
                                m.text.align = md.text.align;
                            }
                            if (md.colix != 0) {
                                m.labelColix = m.text.colix = md.text.colix;
                            }
                        }
                    }
                    m.formatMeasurement(null);
                    break;
                }
                case 1665140738: {
                    m.mad = md.mad;
                    break;
                }
                case 12291: {
                    String msg = Measures.getMessage((Measurement)this.measurements.get(i), true);
                    this.measurements.removeItemAt(i);
                    --this.measurementCount;
                    this.vwr.setStatusMeasuring("measureDeleted", i, msg, 0.0f);
                    break;
                }
                case 134222350: {
                    m.isHidden = false;
                    break;
                }
                case 12294: {
                    m.isHidden = true;
                    break;
                }
                case 268435538: {
                    m.isHidden = !m.isHidden;
                    break;
                }
                case 1073742335: {
                    m.isHidden = false;
                }
            }
        }
    }

    private void reformatDistances() {
        int i = this.measurementCount;
        while (--i >= 0) {
            ((Measurement)this.measurements.get(i)).reformatDistanceIfSelected();
        }
    }

    private Lst<Map<String, Object>> getAllInfo() {
        Lst<Map<String, Object>> info = new Lst<Map<String, Object>>();
        for (int i = 0; i < this.measurementCount; ++i) {
            info.addLast(this.getInfo(i));
        }
        return info;
    }

    private String getAllInfoAsString() {
        String info = "Measurement Information";
        for (int i = 0; i < this.measurementCount; ++i) {
            info = info + "\n" + this.getInfoAsString(i);
        }
        return info;
    }

    private Map<String, Object> getInfo(int index) {
        Measurement m = (Measurement)this.measurements.get(index);
        int count = m.count;
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("index", index);
        info.put("type", count == 2 ? "distance" : (count == 3 ? "angle" : "dihedral"));
        info.put("strMeasurement", m.getString());
        info.put("count", count);
        info.put("id", "" + m.thisID);
        info.put("value", Float.valueOf(m.value));
        info.put("hidden", m.isHidden);
        info.put("visible", m.isVisible);
        TickInfo tickInfo = m.tickInfo;
        if (tickInfo != null) {
            info.put("ticks", tickInfo.ticks);
            if (tickInfo.scale != null) {
                info.put("tickScale", tickInfo.scale);
            }
            if (tickInfo.tickLabelFormats != null) {
                info.put("tickLabelFormats", tickInfo.tickLabelFormats);
            }
            if (!Float.isNaN(tickInfo.first)) {
                info.put("tickStart", Float.valueOf(tickInfo.first));
            }
        }
        Lst atomsInfo = new Lst();
        Atom[] atoms = this.ms.at;
        for (int i = 1; i <= count; ++i) {
            Hashtable<String, Object> atomInfo = new Hashtable<String, Object>();
            int atomIndex = m.getAtomIndex(i);
            atomInfo.put("_ipt", atomIndex);
            atomInfo.put("coord", Escape.eP(m.getAtom(i)));
            atomInfo.put("atomno", atomIndex < 0 ? -1 : atoms[atomIndex].getAtomNumber());
            atomInfo.put("info", atomIndex < 0 ? "<point>" : atoms[atomIndex].getInfo());
            atomsInfo.addLast(atomInfo);
        }
        info.put("atoms", atomsInfo);
        return info;
    }

    @Override
    public String getInfoAsString(int index) {
        return ((Measurement)this.measurements.get(index)).getInfoAsString(null);
    }

    public void setVisibilityInfo() {
        BS bsModels = this.vwr.getVisibleFramesBitSet();
        int i = this.measurementCount;
        block0: while (--i >= 0) {
            Measurement m = (Measurement)this.measurements.get(i);
            m.isVisible = false;
            if (this.mad == 0 || m.isHidden) continue;
            for (int iAtom = m.count; iAtom > 0; --iAtom) {
                short modelIndex;
                int atomIndex = m.getAtomIndex(iAtom);
                if (atomIndex >= 0 ? !this.ms.at[atomIndex].isClickable() : (modelIndex = m.getAtom((int)iAtom).mi) >= 0 && !bsModels.get(modelIndex)) continue block0;
            }
            m.isVisible = true;
        }
    }
}

