# This file has been autogenerated by the pywayland scanner

# Copyright © 2014      Jonas Ådahl
# Copyright © 2015      Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations


from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from ..wayland import WlRegion


class ZwpConfinedPointerV1(Interface):
    """Confined pointer object

    The wp_confined_pointer interface represents a confined pointer state.

    This object will send the event 'confined' when the confinement is
    activated. Whenever the confinement is activated, it is guaranteed that the
    surface the pointer is confined to will already have received pointer focus
    and that the pointer will be within the region passed to the request
    creating this object. It is up to the compositor to decide whether this
    requires some user interaction and if the pointer will warp to within the
    passed region if outside.

    To unconfine the pointer, send the destroy request. This will also destroy
    the wp_confined_pointer object.

    If the compositor decides to unconfine the pointer the unconfined event is
    sent. The wp_confined_pointer object is at this point defunct and should be
    destroyed.
    """

    name = "zwp_confined_pointer_v1"
    version = 1


class ZwpConfinedPointerV1Proxy(Proxy[ZwpConfinedPointerV1]):
    interface = ZwpConfinedPointerV1

    @ZwpConfinedPointerV1.request()
    def destroy(self) -> None:
        """Destroy the confined pointer object

        Destroy the confined pointer object. If applicable, the compositor will
        unconfine the pointer.
        """
        self._marshal(0)
        self._destroy()

    @ZwpConfinedPointerV1.request(
        Argument(ArgumentType.Object, interface=WlRegion, nullable=True),
    )
    def set_region(self, region: WlRegion | None) -> None:
        """Set a new confine region

        Set a new region used to confine the pointer.

        The new confine region is double-buffered. The new confine region will
        only take effect when the associated surface gets its pending state
        applied. See :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` for details.

        If the confinement is active when the new confinement region is applied
        and the pointer ends up outside of newly applied region, the pointer
        may warped to a position within the new confinement region. If warped,
        a :func:`WlPointer.motion()
        <pywayland.protocol.wayland.WlPointer.motion>` event will be emitted,
        but no wp_relative_pointer.relative_motion event.

        The compositor may also, instead of using the new region, unconfine the
        pointer.

        For details about the confine region, see wp_confined_pointer.

        :param region:
            region of surface
        :type region:
            :class:`~pywayland.protocol.wayland.WlRegion` or `None`
        """
        self._marshal(1, region)


class ZwpConfinedPointerV1Resource(Resource):
    interface = ZwpConfinedPointerV1

    @ZwpConfinedPointerV1.event()
    def confined(self) -> None:
        """Pointer confined

        Notification that the pointer confinement of the seat's pointer is
        activated.
        """
        self._post_event(0)

    @ZwpConfinedPointerV1.event()
    def unconfined(self) -> None:
        """Pointer unconfined

        Notification that the pointer confinement of the seat's pointer is no
        longer active. If this is a oneshot pointer confinement (see
        wp_pointer_constraints.lifetime) this object is now defunct and should
        be destroyed. If this is a persistent pointer confinement (see
        wp_pointer_constraints.lifetime) this pointer confinement may again
        reactivate in the future.
        """
        self._post_event(1)


class ZwpConfinedPointerV1Global(Global):
    interface = ZwpConfinedPointerV1


ZwpConfinedPointerV1._gen_c()
ZwpConfinedPointerV1.proxy_class = ZwpConfinedPointerV1Proxy
ZwpConfinedPointerV1.resource_class = ZwpConfinedPointerV1Resource
ZwpConfinedPointerV1.global_class = ZwpConfinedPointerV1Global
