
/* Copyright © 2015-2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/* This file generated from vk_entrypoints_gen.py, don't edit directly. */

#include "v3dv_entrypoints.h"

/* Weak aliases for all potential implementations. These will resolve to
 * NULL if they're not defined, which lets the resolve_entrypoint() function
 * either pick the correct entry point.
 *
 * MSVC uses different decorated names for 32-bit versus 64-bit. Declare
 * all argument sizes for 32-bit because computing the actual size would be
 * difficult.
 */




#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateInstance@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateInstance=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateInstance(const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyInstance@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyInstance=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyInstance(VkInstance instance, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDevices@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_EnumeratePhysicalDevices=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_EnumeratePhysicalDevices(VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetInstanceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetInstanceProcAddr=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL v3dv_GetInstanceProcAddr(VkInstance instance, const char* pName) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceVersion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_EnumerateInstanceVersion=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_EnumerateInstanceVersion(uint32_t* pApiVersion) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceLayerProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_EnumerateInstanceLayerProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_EnumerateInstanceLayerProperties(uint32_t* pPropertyCount, VkLayerProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateInstanceExtensionProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_EnumerateInstanceExtensionProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_EnumerateInstanceExtensionProperties(const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateAndroidSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateAndroidSurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateAndroidSurfaceKHR(VkInstance instance, const VkAndroidSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayPlaneSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateDisplayPlaneSurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateDisplayPlaneSurfaceKHR(VkInstance instance, const VkDisplaySurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroySurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroySurfaceKHR(VkInstance instance, VkSurfaceKHR surface, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_VI_NN
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateViSurfaceNN@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateViSurfaceNN=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateViSurfaceNN(VkInstance instance, const VkViSurfaceCreateInfoNN* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_VI_NN
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWaylandSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateWaylandSurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateWaylandSurfaceKHR(VkInstance instance, const VkWaylandSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateWin32SurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateWin32SurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateWin32SurfaceKHR(VkInstance instance, const VkWin32SurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXlibSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateXlibSurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateXlibSurfaceKHR(VkInstance instance, const VkXlibSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateXcbSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateXcbSurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateXcbSurfaceKHR(VkInstance instance, const VkXcbSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDirectFBSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateDirectFBSurfaceEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateDirectFBSurfaceEXT(VkInstance instance, const VkDirectFBSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImagePipeSurfaceFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateImagePipeSurfaceFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateImagePipeSurfaceFUCHSIA(VkInstance instance, const VkImagePipeSurfaceCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_GGP
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateStreamDescriptorSurfaceGGP@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateStreamDescriptorSurfaceGGP=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateStreamDescriptorSurfaceGGP(VkInstance instance, const VkStreamDescriptorSurfaceCreateInfoGGP* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_GGP
#ifdef VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateScreenSurfaceQNX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateScreenSurfaceQNX=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateScreenSurfaceQNX(VkInstance instance, const VkScreenSurfaceCreateInfoQNX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugReportCallbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateDebugReportCallbackEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateDebugReportCallbackEXT(VkInstance instance, const VkDebugReportCallbackCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugReportCallbackEXT* pCallback) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugReportCallbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyDebugReportCallbackEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyDebugReportCallbackEXT(VkInstance instance, VkDebugReportCallbackEXT callback, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugReportMessageEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DebugReportMessageEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DebugReportMessageEXT(VkInstance instance, VkDebugReportFlagsEXT flags, VkDebugReportObjectTypeEXT objectType, uint64_t object, size_t location, int32_t messageCode, const char* pLayerPrefix, const char* pMessage) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroups@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_EnumeratePhysicalDeviceGroups=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_EnumeratePhysicalDeviceGroups(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceGroupsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_EnumeratePhysicalDeviceGroupsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_EnumeratePhysicalDeviceGroupsKHR(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_IOS_MVK
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIOSSurfaceMVK@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateIOSSurfaceMVK=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateIOSSurfaceMVK(VkInstance instance, const VkIOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMacOSSurfaceMVK@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateMacOSSurfaceMVK=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateMacOSSurfaceMVK(VkInstance instance, const VkMacOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_MACOS_MVK
#ifdef VK_USE_PLATFORM_METAL_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateMetalSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateMetalSurfaceEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateMetalSurfaceEXT(VkInstance instance, const VkMetalSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_METAL_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDebugUtilsMessengerEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateDebugUtilsMessengerEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateDebugUtilsMessengerEXT(VkInstance instance, const VkDebugUtilsMessengerCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugUtilsMessengerEXT* pMessenger) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDebugUtilsMessengerEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyDebugUtilsMessengerEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyDebugUtilsMessengerEXT(VkInstance instance, VkDebugUtilsMessengerEXT messenger, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SubmitDebugUtilsMessageEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_SubmitDebugUtilsMessageEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_SubmitDebugUtilsMessageEXT(VkInstance instance, VkDebugUtilsMessageSeverityFlagBitsEXT messageSeverity, VkDebugUtilsMessageTypeFlagsEXT messageTypes, const VkDebugUtilsMessengerCallbackDataEXT* pCallbackData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateHeadlessSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateHeadlessSurfaceEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateHeadlessSurfaceEXT(VkInstance instance, const VkHeadlessSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif

const struct vk_instance_entrypoint_table v3dv_instance_entrypoints = {
    .CreateInstance = v3dv_CreateInstance,
    .DestroyInstance = v3dv_DestroyInstance,
    .EnumeratePhysicalDevices = v3dv_EnumeratePhysicalDevices,
    .GetInstanceProcAddr = v3dv_GetInstanceProcAddr,
    .EnumerateInstanceVersion = v3dv_EnumerateInstanceVersion,
    .EnumerateInstanceLayerProperties = v3dv_EnumerateInstanceLayerProperties,
    .EnumerateInstanceExtensionProperties = v3dv_EnumerateInstanceExtensionProperties,
#ifdef VK_USE_PLATFORM_ANDROID_KHR
    .CreateAndroidSurfaceKHR = v3dv_CreateAndroidSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateAndroidSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_ANDROID_KHR
    .CreateDisplayPlaneSurfaceKHR = v3dv_CreateDisplayPlaneSurfaceKHR,
    .DestroySurfaceKHR = v3dv_DestroySurfaceKHR,
#ifdef VK_USE_PLATFORM_VI_NN
    .CreateViSurfaceNN = v3dv_CreateViSurfaceNN,
#elif defined(_MSC_VER)
    .CreateViSurfaceNN = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_VI_NN
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
    .CreateWaylandSurfaceKHR = v3dv_CreateWaylandSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateWaylandSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .CreateWin32SurfaceKHR = v3dv_CreateWin32SurfaceKHR,
#elif defined(_MSC_VER)
    .CreateWin32SurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
    .CreateXlibSurfaceKHR = v3dv_CreateXlibSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateXlibSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
    .CreateXcbSurfaceKHR = v3dv_CreateXcbSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateXcbSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
    .CreateDirectFBSurfaceEXT = v3dv_CreateDirectFBSurfaceEXT,
#elif defined(_MSC_VER)
    .CreateDirectFBSurfaceEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_FUCHSIA
    .CreateImagePipeSurfaceFUCHSIA = v3dv_CreateImagePipeSurfaceFUCHSIA,
#elif defined(_MSC_VER)
    .CreateImagePipeSurfaceFUCHSIA = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_GGP
    .CreateStreamDescriptorSurfaceGGP = v3dv_CreateStreamDescriptorSurfaceGGP,
#elif defined(_MSC_VER)
    .CreateStreamDescriptorSurfaceGGP = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_GGP
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    .CreateScreenSurfaceQNX = v3dv_CreateScreenSurfaceQNX,
#elif defined(_MSC_VER)
    .CreateScreenSurfaceQNX = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_SCREEN_QNX
    .CreateDebugReportCallbackEXT = v3dv_CreateDebugReportCallbackEXT,
    .DestroyDebugReportCallbackEXT = v3dv_DestroyDebugReportCallbackEXT,
    .DebugReportMessageEXT = v3dv_DebugReportMessageEXT,
    .EnumeratePhysicalDeviceGroups = v3dv_EnumeratePhysicalDeviceGroups,
    .EnumeratePhysicalDeviceGroupsKHR = v3dv_EnumeratePhysicalDeviceGroupsKHR,
#ifdef VK_USE_PLATFORM_IOS_MVK
    .CreateIOSSurfaceMVK = v3dv_CreateIOSSurfaceMVK,
#elif defined(_MSC_VER)
    .CreateIOSSurfaceMVK = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
    .CreateMacOSSurfaceMVK = v3dv_CreateMacOSSurfaceMVK,
#elif defined(_MSC_VER)
    .CreateMacOSSurfaceMVK = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_MACOS_MVK
#ifdef VK_USE_PLATFORM_METAL_EXT
    .CreateMetalSurfaceEXT = v3dv_CreateMetalSurfaceEXT,
#elif defined(_MSC_VER)
    .CreateMetalSurfaceEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_METAL_EXT
    .CreateDebugUtilsMessengerEXT = v3dv_CreateDebugUtilsMessengerEXT,
    .DestroyDebugUtilsMessengerEXT = v3dv_DestroyDebugUtilsMessengerEXT,
    .SubmitDebugUtilsMessageEXT = v3dv_SubmitDebugUtilsMessageEXT,
    .CreateHeadlessSurfaceEXT = v3dv_CreateHeadlessSurfaceEXT,
};


#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceQueueFamilyProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceMemoryProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceFeatures=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceFormatProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceImageFormatProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateDevice=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateDevice(VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceLayerProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_EnumerateDeviceLayerProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_EnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumerateDeviceExtensionProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_EnumerateDeviceExtensionProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_EnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceSparseImageFormatProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceDisplayPropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPropertiesKHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlanePropertiesKHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneSupportedDisplaysKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDisplayPlaneSupportedDisplaysKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, uint32_t planeIndex, uint32_t* pDisplayCount, VkDisplayKHR* pDisplays) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDisplayModePropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModePropertiesKHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDisplayModeKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateDisplayModeKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateDisplayModeKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, const VkDisplayModeCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDisplayModeKHR* pMode) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDisplayPlaneCapabilitiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkDisplayModeKHR mode, uint32_t planeIndex, VkDisplayPlaneCapabilitiesKHR* pCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceSurfaceSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, VkSurfaceKHR surface, VkBool32* pSupported) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilitiesKHR* pSurfaceCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormatsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceSurfaceFormatsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pSurfaceFormatCount, VkSurfaceFormatKHR* pSurfaceFormats) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceSurfacePresentModesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct wl_display* display) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceWin32PresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceWin32PresentationSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL v3dv_GetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXlibPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceXlibPresentationSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL v3dv_GetPhysicalDeviceXlibPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, Display* dpy, VisualID visualID) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceXcbPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceXcbPresentationSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL v3dv_GetPhysicalDeviceXcbPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, xcb_connection_t* connection, xcb_visualid_t visual_id) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, IDirectFB* dfb) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceScreenPresentationSupportQNX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceScreenPresentationSupportQNX=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL v3dv_GetPhysicalDeviceScreenPresentationSupportQNX(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct _screen_window* window) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkExternalMemoryHandleTypeFlagsNV externalHandleType, VkExternalImageFormatPropertiesNV* pExternalImageFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceFeatures2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFeatures2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceFeatures2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceFeatures2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceProperties2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceFormatProperties2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceFormatProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceFormatProperties2KHR(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceImageFormatProperties2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceImageFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceImageFormatProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceQueueFamilyProperties2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceMemoryProperties2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMemoryProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceMemoryProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceMemoryProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceSparseImageFormatProperties2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceSparseImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceExternalBufferProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceExternalBufferProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphoreProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceExternalSemaphoreProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceExternalSemaphoreProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFenceProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceExternalFenceProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceExternalFenceProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceExternalFencePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceExternalFencePropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceExternalFencePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ReleaseDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ReleaseDisplayEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_ReleaseDisplayEXT(VkPhysicalDevice physicalDevice, VkDisplayKHR display) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireXlibDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_AcquireXlibDisplayEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_AcquireXlibDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, VkDisplayKHR display) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRandROutputDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetRandROutputDisplayEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, RROutput rrOutput, VkDisplayKHR* pDisplay) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireWinrtDisplayNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_AcquireWinrtDisplayNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_AcquireWinrtDisplayNV(VkPhysicalDevice physicalDevice, VkDisplayKHR display) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetWinrtDisplayNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetWinrtDisplayNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetWinrtDisplayNV(VkPhysicalDevice physicalDevice, uint32_t deviceRelativeId, VkDisplayKHR* pDisplay) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilities2EXT* pSurfaceCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDevicePresentRectanglesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDevicePresentRectanglesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pRectCount, VkRect2D* pRects) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceMultisamplePropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceMultisamplePropertiesEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceMultisamplePropertiesEXT(VkPhysicalDevice physicalDevice, VkSampleCountFlagBits samples, VkMultisamplePropertiesEXT* pMultisampleProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkSurfaceCapabilities2KHR* pSurfaceCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfaceFormats2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceSurfaceFormats2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceSurfaceFormats2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pSurfaceFormatCount, VkSurfaceFormat2KHR* pSurfaceFormats) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceDisplayProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayProperties2KHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlaneProperties2KHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayModeProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDisplayModeProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModeProperties2KHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDisplayPlaneCapabilities2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDisplayPlaneCapabilities2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetDisplayPlaneCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkDisplayPlaneInfo2KHR* pDisplayPlaneInfo, VkDisplayPlaneCapabilities2KHR* pCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, uint32_t* pTimeDomainCount, VkTimeDomainEXT* pTimeDomains) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesNV* pProperties) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSurfacePresentModes2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceSurfacePresentModes2EXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceSurfacePresentModes2EXT(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterKHR* pCounters, VkPerformanceCounterDescriptionKHR* pCounterDescriptions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(VkPhysicalDevice physicalDevice, const VkQueryPoolPerformanceCreateInfoKHR* pPerformanceQueryCreateInfo, uint32_t* pNumPasses) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(VkPhysicalDevice physicalDevice, uint32_t* pCombinationCount, VkFramebufferMixedSamplesCombinationNV* pCombinations) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceToolProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceToolProperties(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceToolPropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceToolPropertiesEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceToolPropertiesEXT(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceFragmentShadingRatesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceFragmentShadingRatesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceFragmentShadingRatesKHR(VkPhysicalDevice physicalDevice, uint32_t* pFragmentShadingRateCount, VkPhysicalDeviceFragmentShadingRateKHR* pFragmentShadingRates) __attribute__ ((weak));
#endif
#ifdef VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceVideoCapabilitiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceVideoCapabilitiesKHR(VkPhysicalDevice physicalDevice, const VkVideoProfileKHR* pVideoProfile, VkVideoCapabilitiesKHR* pCapabilities) __attribute__ ((weak));
#endif
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoFormatInfoKHR* pVideoFormatInfo, uint32_t* pVideoFormatPropertyCount, VkVideoFormatPropertiesKHR* pVideoFormatProperties) __attribute__ ((weak));
#endif
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireDrmDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_AcquireDrmDisplayEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_AcquireDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, VkDisplayKHR display) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDrmDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDrmDisplayEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, uint32_t connectorId, VkDisplayKHR* display) __attribute__ ((weak));
#endif

const struct vk_physical_device_entrypoint_table v3dv_physical_device_entrypoints = {
    .GetPhysicalDeviceProperties = v3dv_GetPhysicalDeviceProperties,
    .GetPhysicalDeviceQueueFamilyProperties = v3dv_GetPhysicalDeviceQueueFamilyProperties,
    .GetPhysicalDeviceMemoryProperties = v3dv_GetPhysicalDeviceMemoryProperties,
    .GetPhysicalDeviceFeatures = v3dv_GetPhysicalDeviceFeatures,
    .GetPhysicalDeviceFormatProperties = v3dv_GetPhysicalDeviceFormatProperties,
    .GetPhysicalDeviceImageFormatProperties = v3dv_GetPhysicalDeviceImageFormatProperties,
    .CreateDevice = v3dv_CreateDevice,
    .EnumerateDeviceLayerProperties = v3dv_EnumerateDeviceLayerProperties,
    .EnumerateDeviceExtensionProperties = v3dv_EnumerateDeviceExtensionProperties,
    .GetPhysicalDeviceSparseImageFormatProperties = v3dv_GetPhysicalDeviceSparseImageFormatProperties,
    .GetPhysicalDeviceDisplayPropertiesKHR = v3dv_GetPhysicalDeviceDisplayPropertiesKHR,
    .GetPhysicalDeviceDisplayPlanePropertiesKHR = v3dv_GetPhysicalDeviceDisplayPlanePropertiesKHR,
    .GetDisplayPlaneSupportedDisplaysKHR = v3dv_GetDisplayPlaneSupportedDisplaysKHR,
    .GetDisplayModePropertiesKHR = v3dv_GetDisplayModePropertiesKHR,
    .CreateDisplayModeKHR = v3dv_CreateDisplayModeKHR,
    .GetDisplayPlaneCapabilitiesKHR = v3dv_GetDisplayPlaneCapabilitiesKHR,
    .GetPhysicalDeviceSurfaceSupportKHR = v3dv_GetPhysicalDeviceSurfaceSupportKHR,
    .GetPhysicalDeviceSurfaceCapabilitiesKHR = v3dv_GetPhysicalDeviceSurfaceCapabilitiesKHR,
    .GetPhysicalDeviceSurfaceFormatsKHR = v3dv_GetPhysicalDeviceSurfaceFormatsKHR,
    .GetPhysicalDeviceSurfacePresentModesKHR = v3dv_GetPhysicalDeviceSurfacePresentModesKHR,
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
    .GetPhysicalDeviceWaylandPresentationSupportKHR = v3dv_GetPhysicalDeviceWaylandPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceWaylandPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceWin32PresentationSupportKHR = v3dv_GetPhysicalDeviceWin32PresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceWin32PresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
    .GetPhysicalDeviceXlibPresentationSupportKHR = v3dv_GetPhysicalDeviceXlibPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceXlibPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
    .GetPhysicalDeviceXcbPresentationSupportKHR = v3dv_GetPhysicalDeviceXcbPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceXcbPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
    .GetPhysicalDeviceDirectFBPresentationSupportEXT = v3dv_GetPhysicalDeviceDirectFBPresentationSupportEXT,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceDirectFBPresentationSupportEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    .GetPhysicalDeviceScreenPresentationSupportQNX = v3dv_GetPhysicalDeviceScreenPresentationSupportQNX,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceScreenPresentationSupportQNX = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_SCREEN_QNX
    .GetPhysicalDeviceExternalImageFormatPropertiesNV = v3dv_GetPhysicalDeviceExternalImageFormatPropertiesNV,
    .GetPhysicalDeviceFeatures2 = v3dv_GetPhysicalDeviceFeatures2,
    .GetPhysicalDeviceFeatures2KHR = v3dv_GetPhysicalDeviceFeatures2KHR,
    .GetPhysicalDeviceProperties2 = v3dv_GetPhysicalDeviceProperties2,
    .GetPhysicalDeviceProperties2KHR = v3dv_GetPhysicalDeviceProperties2KHR,
    .GetPhysicalDeviceFormatProperties2 = v3dv_GetPhysicalDeviceFormatProperties2,
    .GetPhysicalDeviceFormatProperties2KHR = v3dv_GetPhysicalDeviceFormatProperties2KHR,
    .GetPhysicalDeviceImageFormatProperties2 = v3dv_GetPhysicalDeviceImageFormatProperties2,
    .GetPhysicalDeviceImageFormatProperties2KHR = v3dv_GetPhysicalDeviceImageFormatProperties2KHR,
    .GetPhysicalDeviceQueueFamilyProperties2 = v3dv_GetPhysicalDeviceQueueFamilyProperties2,
    .GetPhysicalDeviceQueueFamilyProperties2KHR = v3dv_GetPhysicalDeviceQueueFamilyProperties2KHR,
    .GetPhysicalDeviceMemoryProperties2 = v3dv_GetPhysicalDeviceMemoryProperties2,
    .GetPhysicalDeviceMemoryProperties2KHR = v3dv_GetPhysicalDeviceMemoryProperties2KHR,
    .GetPhysicalDeviceSparseImageFormatProperties2 = v3dv_GetPhysicalDeviceSparseImageFormatProperties2,
    .GetPhysicalDeviceSparseImageFormatProperties2KHR = v3dv_GetPhysicalDeviceSparseImageFormatProperties2KHR,
    .GetPhysicalDeviceExternalBufferProperties = v3dv_GetPhysicalDeviceExternalBufferProperties,
    .GetPhysicalDeviceExternalBufferPropertiesKHR = v3dv_GetPhysicalDeviceExternalBufferPropertiesKHR,
    .GetPhysicalDeviceExternalSemaphoreProperties = v3dv_GetPhysicalDeviceExternalSemaphoreProperties,
    .GetPhysicalDeviceExternalSemaphorePropertiesKHR = v3dv_GetPhysicalDeviceExternalSemaphorePropertiesKHR,
    .GetPhysicalDeviceExternalFenceProperties = v3dv_GetPhysicalDeviceExternalFenceProperties,
    .GetPhysicalDeviceExternalFencePropertiesKHR = v3dv_GetPhysicalDeviceExternalFencePropertiesKHR,
    .ReleaseDisplayEXT = v3dv_ReleaseDisplayEXT,
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    .AcquireXlibDisplayEXT = v3dv_AcquireXlibDisplayEXT,
#elif defined(_MSC_VER)
    .AcquireXlibDisplayEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    .GetRandROutputDisplayEXT = v3dv_GetRandROutputDisplayEXT,
#elif defined(_MSC_VER)
    .GetRandROutputDisplayEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .AcquireWinrtDisplayNV = v3dv_AcquireWinrtDisplayNV,
#elif defined(_MSC_VER)
    .AcquireWinrtDisplayNV = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetWinrtDisplayNV = v3dv_GetWinrtDisplayNV,
#elif defined(_MSC_VER)
    .GetWinrtDisplayNV = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceSurfaceCapabilities2EXT = v3dv_GetPhysicalDeviceSurfaceCapabilities2EXT,
    .GetPhysicalDevicePresentRectanglesKHR = v3dv_GetPhysicalDevicePresentRectanglesKHR,
    .GetPhysicalDeviceMultisamplePropertiesEXT = v3dv_GetPhysicalDeviceMultisamplePropertiesEXT,
    .GetPhysicalDeviceSurfaceCapabilities2KHR = v3dv_GetPhysicalDeviceSurfaceCapabilities2KHR,
    .GetPhysicalDeviceSurfaceFormats2KHR = v3dv_GetPhysicalDeviceSurfaceFormats2KHR,
    .GetPhysicalDeviceDisplayProperties2KHR = v3dv_GetPhysicalDeviceDisplayProperties2KHR,
    .GetPhysicalDeviceDisplayPlaneProperties2KHR = v3dv_GetPhysicalDeviceDisplayPlaneProperties2KHR,
    .GetDisplayModeProperties2KHR = v3dv_GetDisplayModeProperties2KHR,
    .GetDisplayPlaneCapabilities2KHR = v3dv_GetDisplayPlaneCapabilities2KHR,
    .GetPhysicalDeviceCalibrateableTimeDomainsEXT = v3dv_GetPhysicalDeviceCalibrateableTimeDomainsEXT,
    .GetPhysicalDeviceCooperativeMatrixPropertiesNV = v3dv_GetPhysicalDeviceCooperativeMatrixPropertiesNV,
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceSurfacePresentModes2EXT = v3dv_GetPhysicalDeviceSurfacePresentModes2EXT,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceSurfacePresentModes2EXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
    .EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = v3dv_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR,
    .GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = v3dv_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR,
    .GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = v3dv_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV,
    .GetPhysicalDeviceToolProperties = v3dv_GetPhysicalDeviceToolProperties,
    .GetPhysicalDeviceToolPropertiesEXT = v3dv_GetPhysicalDeviceToolPropertiesEXT,
    .GetPhysicalDeviceFragmentShadingRatesKHR = v3dv_GetPhysicalDeviceFragmentShadingRatesKHR,
#ifdef VK_ENABLE_BETA_EXTENSIONS
    .GetPhysicalDeviceVideoCapabilitiesKHR = v3dv_GetPhysicalDeviceVideoCapabilitiesKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceVideoCapabilitiesKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
    .GetPhysicalDeviceVideoFormatPropertiesKHR = v3dv_GetPhysicalDeviceVideoFormatPropertiesKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceVideoFormatPropertiesKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_ENABLE_BETA_EXTENSIONS
    .AcquireDrmDisplayEXT = v3dv_AcquireDrmDisplayEXT,
    .GetDrmDisplayEXT = v3dv_GetDrmDisplayEXT,
};


#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceProcAddr=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL v3dv_GetDeviceProcAddr(VkDevice device, const char* pName) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceProcAddr=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL ver42_GetDeviceProcAddr(VkDevice device, const char* pName) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyDevice=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyDevice=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceQueue=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceQueue=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSubmit@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_QueueSubmit=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSubmit@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_QueueSubmit=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_QueueWaitIdle=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_QueueWaitIdle(VkQueue queue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_QueueWaitIdle=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_QueueWaitIdle(VkQueue queue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DeviceWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DeviceWaitIdle=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_DeviceWaitIdle(VkDevice device) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DeviceWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DeviceWaitIdle=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_DeviceWaitIdle(VkDevice device) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_AllocateMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_AllocateMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_FreeMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_FreeMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_MapMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_MapMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UnmapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_UnmapMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_UnmapMemory(VkDevice device, VkDeviceMemory memory) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UnmapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_UnmapMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_UnmapMemory(VkDevice device, VkDeviceMemory memory) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FlushMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_FlushMappedMemoryRanges=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FlushMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_FlushMappedMemoryRanges=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_InvalidateMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_InvalidateMappedMemoryRanges=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_InvalidateMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_InvalidateMappedMemoryRanges=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceMemoryCommitment@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceMemoryCommitment=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceMemoryCommitment@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceMemoryCommitment=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetBufferMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetBufferMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_BindBufferMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_BindBufferMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetImageMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetImageMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_BindImageMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_BindImageMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetImageSparseMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetImageSparseMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueBindSparse@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_QueueBindSparse=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueBindSparse@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_QueueBindSparse=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateFence=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateFence=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyFence=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyFence=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ResetFences=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_ResetFences=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetFenceStatus=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetFenceStatus(VkDevice device, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetFenceStatus=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetFenceStatus(VkDevice device, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_WaitForFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_WaitForFences=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_WaitForFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_WaitForFences=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateSemaphore=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateSemaphore=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroySemaphore=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroySemaphore=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetEventStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetEventStatus=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetEventStatus(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetEventStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetEventStatus=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetEventStatus(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_SetEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_SetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_SetEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_SetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ResetEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_ResetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_ResetEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_ResetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateQueryPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateQueryPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyQueryPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyQueryPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetQueryPoolResults=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetQueryPoolResults=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ResetQueryPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_ResetQueryPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetQueryPoolEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ResetQueryPoolEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_ResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetQueryPoolEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_ResetQueryPoolEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_ResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateBufferView=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateBufferView=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyBufferView=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyBufferView=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSubresourceLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetImageSubresourceLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSubresourceLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetImageSubresourceLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateImageView=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateImageView=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyImageView=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyImageView=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateShaderModule=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateShaderModule=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyShaderModule=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyShaderModule=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreatePipelineCache=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreatePipelineCache=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyPipelineCache=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyPipelineCache=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPipelineCacheData@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPipelineCacheData=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPipelineCacheData@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetPipelineCacheData=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergePipelineCaches@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_MergePipelineCaches=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergePipelineCaches@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_MergePipelineCaches=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateGraphicsPipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateGraphicsPipelines=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateGraphicsPipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateGraphicsPipelines=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateComputePipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateComputePipelines=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateComputePipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateComputePipelines=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyPipeline=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyPipeline=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreatePipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreatePipelineLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreatePipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreatePipelineLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyPipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyPipelineLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyPipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyPipelineLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateSampler=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateSampler=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroySampler=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroySampler=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateDescriptorSetLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateDescriptorSetLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyDescriptorSetLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyDescriptorSetLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateDescriptorPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateDescriptorPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyDescriptorPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyDescriptorPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ResetDescriptorPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_ResetDescriptorPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_AllocateDescriptorSets=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_AllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_AllocateDescriptorSets=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_AllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_FreeDescriptorSets=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_FreeDescriptorSets=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_UpdateDescriptorSets=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_UpdateDescriptorSets=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateFramebuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateFramebuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyFramebuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyFramebuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateRenderPass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateRenderPass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyRenderPass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyRenderPass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRenderAreaGranularity@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetRenderAreaGranularity=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRenderAreaGranularity@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetRenderAreaGranularity=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateCommandPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateCommandPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyCommandPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyCommandPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ResetCommandPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_ResetCommandPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AllocateCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_AllocateCommandBuffers=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AllocateCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_AllocateCommandBuffers=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_FreeCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_FreeCommandBuffers=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_FreeCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_FreeCommandBuffers=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BeginCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_BeginCommandBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_BeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BeginCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_BeginCommandBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_BeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_EndCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_EndCommandBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_EndCommandBuffer(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_EndCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_EndCommandBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_EndCommandBuffer(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ResetCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ResetCommandBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ResetCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_ResetCommandBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdBindPipeline=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdBindPipeline=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetViewport=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetViewport=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetScissor@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetScissor=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetScissor@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetScissor=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetLineWidth@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetLineWidth=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetLineWidth@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetLineWidth=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBias@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetDepthBias=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBias@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetDepthBias=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetBlendConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetBlendConstants=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetBlendConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetBlendConstants=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDepthBounds@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetDepthBounds=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDepthBounds@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetDepthBounds=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilCompareMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetStencilCompareMask=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilCompareMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetStencilCompareMask=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilWriteMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetStencilWriteMask=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilWriteMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetStencilWriteMask=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetStencilReference@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetStencilReference=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetStencilReference@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetStencilReference=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdBindDescriptorSets=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdBindDescriptorSets=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindIndexBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdBindIndexBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindIndexBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdBindIndexBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindVertexBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdBindVertexBuffers=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindVertexBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdBindVertexBuffers=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDraw@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDraw=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDraw@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDraw=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexed@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDrawIndexed=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexed@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDrawIndexed=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDrawMultiEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDrawMultiEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawMultiIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDrawMultiIndexedEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawMultiIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDrawMultiIndexedEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDrawIndirect=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDrawIndirect=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDrawIndexedIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDrawIndexedIndirect=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDrawIndexedIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDrawIndexedIndirect=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatch@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDispatch=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatch@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDispatch=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDispatchIndirect=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDispatchIndirect=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSubpassShadingHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSubpassShadingHUAWEI=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSubpassShadingHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSubpassShadingHUAWEI=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdCopyBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdCopyBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdCopyImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdCopyImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBlitImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdBlitImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBlitImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdBlitImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyBufferToImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdCopyBufferToImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyBufferToImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdCopyBufferToImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyImageToBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdCopyImageToBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyImageToBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdCopyImageToBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdUpdateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdUpdateBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdUpdateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdUpdateBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdFillBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdFillBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdFillBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdFillBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearColorImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdClearColorImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearColorImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdClearColorImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearDepthStencilImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdClearDepthStencilImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearDepthStencilImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdClearDepthStencilImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdClearAttachments@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdClearAttachments=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdClearAttachments@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdClearAttachments=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResolveImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdResolveImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResolveImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdResolveImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdResetEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdResetEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWaitEvents@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdWaitEvents=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWaitEvents@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdWaitEvents=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPipelineBarrier@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdPipelineBarrier=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPipelineBarrier@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdPipelineBarrier=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdBeginQuery=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdBeginQuery=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdEndQuery=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdEndQuery=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdBeginConditionalRenderingEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdBeginConditionalRenderingEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdEndConditionalRenderingEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdEndConditionalRenderingEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdResetQueryPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdResetQueryPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdWriteTimestamp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdWriteTimestamp=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdWriteTimestamp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdWriteTimestamp=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdCopyQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdCopyQueryPoolResults=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdCopyQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdCopyQueryPoolResults=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdPushConstants=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdPushConstants=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBeginRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdBeginRenderPass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBeginRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdBeginRenderPass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdNextSubpass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdNextSubpass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdNextSubpass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdNextSubpass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdEndRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdEndRenderPass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdEndRenderPass(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdEndRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdEndRenderPass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdEndRenderPass(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteCommands@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdExecuteCommands=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteCommands@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdExecuteCommands=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSharedSwapchainsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateSharedSwapchainsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSharedSwapchainsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateSharedSwapchainsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateSwapchainKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateSwapchainKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroySwapchainKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroySwapchainKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainImagesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetSwapchainImagesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainImagesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetSwapchainImagesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImageKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_AcquireNextImageKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImageKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_AcquireNextImageKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueuePresentKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_QueuePresentKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_QueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueuePresentKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_QueuePresentKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_QueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectNameEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DebugMarkerSetObjectNameEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectNameEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DebugMarkerSetObjectNameEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DebugMarkerSetObjectTagEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DebugMarkerSetObjectTagEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DebugMarkerSetObjectTagEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DebugMarkerSetObjectTagEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerBeginEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDebugMarkerBeginEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerBeginEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDebugMarkerBeginEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerEndEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDebugMarkerEndEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerEndEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDebugMarkerEndEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDebugMarkerInsertEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDebugMarkerInsertEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDebugMarkerInsertEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDebugMarkerInsertEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetMemoryWin32HandleNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory, VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetMemoryWin32HandleNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory, VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdExecuteGeneratedCommandsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdExecuteGeneratedCommandsNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdExecuteGeneratedCommandsNV(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdExecuteGeneratedCommandsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdExecuteGeneratedCommandsNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdExecuteGeneratedCommandsNV(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPreprocessGeneratedCommandsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdPreprocessGeneratedCommandsNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdPreprocessGeneratedCommandsNV(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPreprocessGeneratedCommandsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdPreprocessGeneratedCommandsNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdPreprocessGeneratedCommandsNV(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdBindPipelineShaderGroupNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdBindPipelineShaderGroupNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdBindPipelineShaderGroupNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, uint32_t groupIndex) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdBindPipelineShaderGroupNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdBindPipelineShaderGroupNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdBindPipelineShaderGroupNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, uint32_t groupIndex) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetGeneratedCommandsMemoryRequirementsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetGeneratedCommandsMemoryRequirementsNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetGeneratedCommandsMemoryRequirementsNV(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetGeneratedCommandsMemoryRequirementsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetGeneratedCommandsMemoryRequirementsNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetGeneratedCommandsMemoryRequirementsNV(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateIndirectCommandsLayoutNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateIndirectCommandsLayoutNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateIndirectCommandsLayoutNV(VkDevice device, const VkIndirectCommandsLayoutCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutNV* pIndirectCommandsLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateIndirectCommandsLayoutNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateIndirectCommandsLayoutNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateIndirectCommandsLayoutNV(VkDevice device, const VkIndirectCommandsLayoutCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutNV* pIndirectCommandsLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyIndirectCommandsLayoutNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyIndirectCommandsLayoutNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyIndirectCommandsLayoutNV(VkDevice device, VkIndirectCommandsLayoutNV indirectCommandsLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyIndirectCommandsLayoutNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyIndirectCommandsLayoutNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyIndirectCommandsLayoutNV(VkDevice device, VkIndirectCommandsLayoutNV indirectCommandsLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdPushDescriptorSetKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdPushDescriptorSetKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_TrimCommandPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_TrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_TrimCommandPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_TrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_TrimCommandPoolKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_TrimCommandPoolKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_TrimCommandPoolKHR(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_TrimCommandPoolKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_TrimCommandPoolKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_TrimCommandPoolKHR(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetMemoryWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetMemoryWin32HandleKHR(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetMemoryWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetMemoryWin32HandleKHR(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryWin32HandlePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetMemoryWin32HandlePropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle, VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryWin32HandlePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetMemoryWin32HandlePropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle, VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetMemoryFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetMemoryFdKHR(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetMemoryFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetMemoryFdKHR(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryFdPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetMemoryFdPropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetMemoryFdPropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd, VkMemoryFdPropertiesKHR* pMemoryFdProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryFdPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetMemoryFdPropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetMemoryFdPropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd, VkMemoryFdPropertiesKHR* pMemoryFdProperties) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetMemoryZirconHandleFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetMemoryZirconHandleFUCHSIA(VkDevice device, const VkMemoryGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetMemoryZirconHandleFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetMemoryZirconHandleFUCHSIA(VkDevice device, const VkMemoryGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryZirconHandlePropertiesFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetMemoryZirconHandlePropertiesFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetMemoryZirconHandlePropertiesFUCHSIA(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle, VkMemoryZirconHandlePropertiesFUCHSIA* pMemoryZirconHandleProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryZirconHandlePropertiesFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetMemoryZirconHandlePropertiesFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetMemoryZirconHandlePropertiesFUCHSIA(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle, VkMemoryZirconHandlePropertiesFUCHSIA* pMemoryZirconHandleProperties) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetMemoryRemoteAddressNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetMemoryRemoteAddressNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetMemoryRemoteAddressNV(VkDevice device, const VkMemoryGetRemoteAddressInfoNV* pMemoryGetRemoteAddressInfo, VkRemoteAddressNV* pAddress) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetMemoryRemoteAddressNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetMemoryRemoteAddressNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetMemoryRemoteAddressNV(VkDevice device, const VkMemoryGetRemoteAddressInfoNV* pMemoryGetRemoteAddressInfo, VkRemoteAddressNV* pAddress) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetSemaphoreWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetSemaphoreWin32HandleKHR(VkDevice device, const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetSemaphoreWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetSemaphoreWin32HandleKHR(VkDevice device, const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ImportSemaphoreWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_ImportSemaphoreWin32HandleKHR(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_ImportSemaphoreWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_ImportSemaphoreWin32HandleKHR(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetSemaphoreFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetSemaphoreFdKHR(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetSemaphoreFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetSemaphoreFdKHR(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ImportSemaphoreFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_ImportSemaphoreFdKHR(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_ImportSemaphoreFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_ImportSemaphoreFdKHR(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSemaphoreZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetSemaphoreZirconHandleFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkSemaphoreGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSemaphoreZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetSemaphoreZirconHandleFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkSemaphoreGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportSemaphoreZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ImportSemaphoreZirconHandleFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_ImportSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkImportSemaphoreZirconHandleInfoFUCHSIA* pImportSemaphoreZirconHandleInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportSemaphoreZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_ImportSemaphoreZirconHandleFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_ImportSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkImportSemaphoreZirconHandleInfoFUCHSIA* pImportSemaphoreZirconHandleInfo) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetFenceWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetFenceWin32HandleKHR(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetFenceWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetFenceWin32HandleKHR(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ImportFenceWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_ImportFenceWin32HandleKHR(VkDevice device, const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_ImportFenceWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_ImportFenceWin32HandleKHR(VkDevice device, const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetFenceFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetFenceFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetFenceFdKHR(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetFenceFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetFenceFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetFenceFdKHR(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_ImportFenceFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_ImportFenceFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_ImportFenceFdKHR(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_ImportFenceFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_ImportFenceFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_ImportFenceFdKHR(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DisplayPowerControlEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DisplayPowerControlEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_DisplayPowerControlEXT(VkDevice device, VkDisplayKHR display, const VkDisplayPowerInfoEXT* pDisplayPowerInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DisplayPowerControlEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DisplayPowerControlEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_DisplayPowerControlEXT(VkDevice device, VkDisplayKHR display, const VkDisplayPowerInfoEXT* pDisplayPowerInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDeviceEventEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_RegisterDeviceEventEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_RegisterDeviceEventEXT(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDeviceEventEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_RegisterDeviceEventEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_RegisterDeviceEventEXT(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_RegisterDisplayEventEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_RegisterDisplayEventEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_RegisterDisplayEventEXT(VkDevice device, VkDisplayKHR display, const VkDisplayEventInfoEXT* pDisplayEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_RegisterDisplayEventEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_RegisterDisplayEventEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_RegisterDisplayEventEXT(VkDevice device, VkDisplayKHR display, const VkDisplayEventInfoEXT* pDisplayEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainCounterEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetSwapchainCounterEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetSwapchainCounterEXT(VkDevice device, VkSwapchainKHR swapchain, VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainCounterEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetSwapchainCounterEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetSwapchainCounterEXT(VkDevice device, VkSwapchainKHR swapchain, VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeatures@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceGroupPeerMemoryFeatures=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeatures@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceGroupPeerMemoryFeatures=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPeerMemoryFeaturesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceGroupPeerMemoryFeaturesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPeerMemoryFeaturesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceGroupPeerMemoryFeaturesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_BindBufferMemory2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_BindBufferMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_BindBufferMemory2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_BindBufferMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindBufferMemory2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_BindBufferMemory2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_BindBufferMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindBufferMemory2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_BindBufferMemory2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_BindBufferMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_BindImageMemory2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_BindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_BindImageMemory2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_BindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_BindImageMemory2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_BindImageMemory2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_BindImageMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_BindImageMemory2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_BindImageMemory2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_BindImageMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetDeviceMask=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetDeviceMask=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDeviceMaskKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetDeviceMaskKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetDeviceMaskKHR(VkCommandBuffer commandBuffer, uint32_t deviceMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDeviceMaskKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetDeviceMaskKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetDeviceMaskKHR(VkCommandBuffer commandBuffer, uint32_t deviceMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupPresentCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceGroupPresentCapabilitiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetDeviceGroupPresentCapabilitiesKHR(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupPresentCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceGroupPresentCapabilitiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetDeviceGroupPresentCapabilitiesKHR(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceGroupSurfacePresentModesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceGroupSurfacePresentModesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetDeviceGroupSurfacePresentModesKHR(VkDevice device, VkSurfaceKHR surface, VkDeviceGroupPresentModeFlagsKHR* pModes) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceGroupSurfacePresentModesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceGroupSurfacePresentModesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetDeviceGroupSurfacePresentModesKHR(VkDevice device, VkSurfaceKHR surface, VkDeviceGroupPresentModeFlagsKHR* pModes) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireNextImage2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_AcquireNextImage2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_AcquireNextImage2KHR(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo, uint32_t* pImageIndex) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireNextImage2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_AcquireNextImage2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_AcquireNextImage2KHR(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo, uint32_t* pImageIndex) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBase@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDispatchBase=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBase@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDispatchBase=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdDispatchBaseKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdDispatchBaseKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdDispatchBaseKHR(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdDispatchBaseKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdDispatchBaseKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdDispatchBaseKHR(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateDescriptorUpdateTemplate=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateDescriptorUpdateTemplate(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateDescriptorUpdateTemplate=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateDescriptorUpdateTemplate(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateDescriptorUpdateTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateDescriptorUpdateTemplateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateDescriptorUpdateTemplateKHR(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateDescriptorUpdateTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateDescriptorUpdateTemplateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateDescriptorUpdateTemplateKHR(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyDescriptorUpdateTemplate=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyDescriptorUpdateTemplate=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyDescriptorUpdateTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyDescriptorUpdateTemplateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyDescriptorUpdateTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyDescriptorUpdateTemplateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_UpdateDescriptorSetWithTemplate=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_UpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_UpdateDescriptorSetWithTemplate=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_UpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_UpdateDescriptorSetWithTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_UpdateDescriptorSetWithTemplateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_UpdateDescriptorSetWithTemplateKHR(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_UpdateDescriptorSetWithTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_UpdateDescriptorSetWithTemplateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_UpdateDescriptorSetWithTemplateKHR(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdPushDescriptorSetWithTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdPushDescriptorSetWithTemplateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdPushDescriptorSetWithTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdPushDescriptorSetWithTemplateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_SetHdrMetadataEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_SetHdrMetadataEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_SetHdrMetadataEXT(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains, const VkHdrMetadataEXT* pMetadata) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_SetHdrMetadataEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_SetHdrMetadataEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_SetHdrMetadataEXT(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains, const VkHdrMetadataEXT* pMetadata) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainStatusKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetSwapchainStatusKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetSwapchainStatusKHR(VkDevice device, VkSwapchainKHR swapchain) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainStatusKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetSwapchainStatusKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetSwapchainStatusKHR(VkDevice device, VkSwapchainKHR swapchain) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetRefreshCycleDurationGOOGLE@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetRefreshCycleDurationGOOGLE=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetRefreshCycleDurationGOOGLE(VkDevice device, VkSwapchainKHR swapchain, VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetRefreshCycleDurationGOOGLE@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetRefreshCycleDurationGOOGLE=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetRefreshCycleDurationGOOGLE(VkDevice device, VkSwapchainKHR swapchain, VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetPastPresentationTimingGOOGLE@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetPastPresentationTimingGOOGLE=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetPastPresentationTimingGOOGLE(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pPresentationTimingCount, VkPastPresentationTimingGOOGLE* pPresentationTimings) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetPastPresentationTimingGOOGLE@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetPastPresentationTimingGOOGLE=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetPastPresentationTimingGOOGLE(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pPresentationTimingCount, VkPastPresentationTimingGOOGLE* pPresentationTimings) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetViewportWScalingNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetViewportWScalingNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetViewportWScalingNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportWScalingNV* pViewportWScalings) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetViewportWScalingNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetViewportWScalingNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetViewportWScalingNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportWScalingNV* pViewportWScalings) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetDiscardRectangleEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetDiscardRectangleEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetDiscardRectangleEXT(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle, uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetDiscardRectangleEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetDiscardRectangleEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetDiscardRectangleEXT(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle, uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CmdSetSampleLocationsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CmdSetSampleLocationsEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_CmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CmdSetSampleLocationsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CmdSetSampleLocationsEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_CmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetBufferMemoryRequirements2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetBufferMemoryRequirements2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetBufferMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetBufferMemoryRequirements2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetBufferMemoryRequirements2KHR(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetBufferMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetBufferMemoryRequirements2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetBufferMemoryRequirements2KHR(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetImageMemoryRequirements2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetImageMemoryRequirements2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetImageMemoryRequirements2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetImageMemoryRequirements2KHR(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetImageMemoryRequirements2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetImageMemoryRequirements2KHR(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetImageSparseMemoryRequirements2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetImageSparseMemoryRequirements2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetImageSparseMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetImageSparseMemoryRequirements2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetImageSparseMemoryRequirements2KHR(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetImageSparseMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetImageSparseMemoryRequirements2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetImageSparseMemoryRequirements2KHR(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceBufferMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceBufferMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceBufferMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceBufferMemoryRequirementsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDeviceBufferMemoryRequirementsKHR(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceBufferMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceBufferMemoryRequirementsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDeviceBufferMemoryRequirementsKHR(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceImageMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceImageMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceImageMemoryRequirementsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDeviceImageMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceImageMemoryRequirementsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDeviceImageMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceImageSparseMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceImageSparseMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceImageSparseMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceImageSparseMemoryRequirementsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDeviceImageSparseMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceImageSparseMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceImageSparseMemoryRequirementsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDeviceImageSparseMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateSamplerYcbcrConversion=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateSamplerYcbcrConversion=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateSamplerYcbcrConversionKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateSamplerYcbcrConversionKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateSamplerYcbcrConversionKHR(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateSamplerYcbcrConversionKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateSamplerYcbcrConversionKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateSamplerYcbcrConversionKHR(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroySamplerYcbcrConversion=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroySamplerYcbcrConversion=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroySamplerYcbcrConversionKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroySamplerYcbcrConversionKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroySamplerYcbcrConversionKHR(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroySamplerYcbcrConversionKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroySamplerYcbcrConversionKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroySamplerYcbcrConversionKHR(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDeviceQueue2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDeviceQueue2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDeviceQueue2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDeviceQueue2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_CreateValidationCacheEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_CreateValidationCacheEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_CreateValidationCacheEXT(VkDevice device, const VkValidationCacheCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkValidationCacheEXT* pValidationCache) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_CreateValidationCacheEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_CreateValidationCacheEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_CreateValidationCacheEXT(VkDevice device, const VkValidationCacheCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkValidationCacheEXT* pValidationCache) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_DestroyValidationCacheEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_DestroyValidationCacheEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_DestroyValidationCacheEXT(VkDevice device, VkValidationCacheEXT validationCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_DestroyValidationCacheEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_DestroyValidationCacheEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_DestroyValidationCacheEXT(VkDevice device, VkValidationCacheEXT validationCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetValidationCacheDataEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetValidationCacheDataEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetValidationCacheDataEXT(VkDevice device, VkValidationCacheEXT validationCache, size_t* pDataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetValidationCacheDataEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetValidationCacheDataEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetValidationCacheDataEXT(VkDevice device, VkValidationCacheEXT validationCache, size_t* pDataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_MergeValidationCachesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_MergeValidationCachesEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_MergeValidationCachesEXT(VkDevice device, VkValidationCacheEXT dstCache, uint32_t srcCacheCount, const VkValidationCacheEXT* pSrcCaches) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_MergeValidationCachesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_MergeValidationCachesEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_MergeValidationCachesEXT(VkDevice device, VkValidationCacheEXT dstCache, uint32_t srcCacheCount, const VkValidationCacheEXT* pSrcCaches) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDescriptorSetLayoutSupport=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDescriptorSetLayoutSupport=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetDescriptorSetLayoutSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetDescriptorSetLayoutSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL v3dv_GetDescriptorSetLayoutSupportKHR(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetDescriptorSetLayoutSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetDescriptorSetLayoutSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL ver42_GetDescriptorSetLayoutSupportKHR(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetSwapchainGrallocUsageANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetSwapchainGrallocUsageANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, int* grallocUsage) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetSwapchainGrallocUsageANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetSwapchainGrallocUsageANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, int* grallocUsage) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetSwapchainGrallocUsage2ANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_GetSwapchainGrallocUsage2ANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_GetSwapchainGrallocUsage2ANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, VkSwapchainImageUsageFlagsANDROID swapchainImageUsage, uint64_t* grallocConsumerUsage, uint64_t* grallocProducerUsage) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_GetSwapchainGrallocUsage2ANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_GetSwapchainGrallocUsage2ANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_GetSwapchainGrallocUsage2ANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, VkSwapchainImageUsageFlagsANDROID swapchainImageUsage, uint64_t* grallocConsumerUsage, uint64_t* grallocProducerUsage) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_AcquireImageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_AcquireImageANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_AcquireImageANDROID(VkDevice device, VkImage image, int nativeFenceFd, VkSemaphore semaphore, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_AcquireImageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_AcquireImageANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_AcquireImageANDROID(VkDevice device, VkImage image, int nativeFenceFd, VkSemaphore semaphore, VkFence fence) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_QueueSignalReleaseImageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:v3dv_QueueSignalReleaseImageANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL v3dv_QueueSignalReleaseImageANDROID(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int* pNativeFenceFd) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_ver42_QueueSignalReleaseImageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:ver42_QueueSignalReleaseImageANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL ver42_QueueSignalReleaseImageANDROID(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int* pNativeFenceFd) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_v3dv_GetShaderInfoAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_v3dv_GetShaderInfoAMD@8=_v