// qtwebengine/common/media/webrtc_logging.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "qtwebengine/common/media/webrtc_logging.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "qtwebengine/common/media/webrtc_logging.mojom-params-data.h"
#include "qtwebengine/common/media/webrtc_logging.mojom-shared-message-ids.h"

#include "qtwebengine/common/media/webrtc_logging.mojom-import-headers.h"


#ifndef QTWEBENGINE_COMMON_MEDIA_WEBRTC_LOGGING_MOJOM_JUMBO_H_
#define QTWEBENGINE_COMMON_MEDIA_WEBRTC_LOGGING_MOJOM_JUMBO_H_
#endif
namespace chrome {
namespace mojom {
WebRtcLoggingMessage::WebRtcLoggingMessage()
    : timestamp(),
      data() {}

WebRtcLoggingMessage::WebRtcLoggingMessage(
    ::base::Time timestamp_in,
    const std::string& data_in)
    : timestamp(std::move(timestamp_in)),
      data(std::move(data_in)) {}

WebRtcLoggingMessage::~WebRtcLoggingMessage() = default;

void WebRtcLoggingMessage::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("timestamp", base::trace_event::ValueToString(this->timestamp, "<value of type ::base::Time>"));
  value->SetString("data", this->data);
}

bool WebRtcLoggingMessage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char WebRtcLoggingClient::Name_[] = "chrome.mojom.WebRtcLoggingClient";

WebRtcLoggingClientProxy::WebRtcLoggingClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebRtcLoggingClientProxy::OnAddMessages(
    std::vector<WebRtcLoggingMessagePtr> in_messages) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "chrome::mojom::WebRtcLoggingClient::OnAddMessages", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("messages");
      for (const auto& item0 : in_messages) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebRtcLoggingClient_OnAddMessages_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::chrome::mojom::internal::WebRtcLoggingClient_OnAddMessages_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->messages)::BaseType::BufferWriter
      messages_writer;
  const mojo::internal::ContainerValidateParams messages_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::chrome::mojom::WebRtcLoggingMessageDataView>>(
      in_messages, buffer, &messages_writer, &messages_validate_params,
      &serialization_context);
  params->messages.Set(
      messages_writer.is_null() ? nullptr : messages_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->messages.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null messages in WebRtcLoggingClient.OnAddMessages request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebRtcLoggingClient::Name_);
  message.set_method_name("OnAddMessages");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebRtcLoggingClientProxy::OnStopped(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "chrome::mojom::WebRtcLoggingClient::OnStopped");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebRtcLoggingClient_OnStopped_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::chrome::mojom::internal::WebRtcLoggingClient_OnStopped_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebRtcLoggingClient::Name_);
  message.set_method_name("OnStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebRtcLoggingClientStubDispatch::Accept(
    WebRtcLoggingClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWebRtcLoggingClient_OnAddMessages_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)chrome::mojom::WebRtcLoggingClient::OnAddMessages",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)chrome::mojom::WebRtcLoggingClient::OnAddMessages");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebRtcLoggingClient_OnAddMessages_Params_Data* params =
          reinterpret_cast<internal::WebRtcLoggingClient_OnAddMessages_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<WebRtcLoggingMessagePtr> p_messages{};
      WebRtcLoggingClient_OnAddMessages_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMessages(&p_messages))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebRtcLoggingClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAddMessages(
std::move(p_messages));
      return true;
    }
    case internal::kWebRtcLoggingClient_OnStopped_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)chrome::mojom::WebRtcLoggingClient::OnStopped",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)chrome::mojom::WebRtcLoggingClient::OnStopped");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebRtcLoggingClient_OnStopped_Params_Data* params =
          reinterpret_cast<internal::WebRtcLoggingClient_OnStopped_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebRtcLoggingClient_OnStopped_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebRtcLoggingClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStopped();
      return true;
    }
  }
  return false;
}

// static
bool WebRtcLoggingClientStubDispatch::AcceptWithResponder(
    WebRtcLoggingClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebRtcLoggingClient_OnAddMessages_Name: {
      break;
    }
    case internal::kWebRtcLoggingClient_OnStopped_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebRtcLoggingClientValidationInfo[] = {
    {internal::kWebRtcLoggingClient_OnAddMessages_Name,
     {&internal::WebRtcLoggingClient_OnAddMessages_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebRtcLoggingClient_OnStopped_Name,
     {&internal::WebRtcLoggingClient_OnStopped_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebRtcLoggingClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::chrome::mojom::WebRtcLoggingClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebRtcLoggingClientValidationInfo);
}

const char WebRtcLoggingAgent::Name_[] = "chrome.mojom.WebRtcLoggingAgent";

WebRtcLoggingAgentProxy::WebRtcLoggingAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebRtcLoggingAgentProxy::Start(
    ::mojo::PendingRemote<WebRtcLoggingClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "chrome::mojom::WebRtcLoggingAgent::Start", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebRtcLoggingAgent_Start_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::chrome::mojom::internal::WebRtcLoggingAgent_Start_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::chrome::mojom::WebRtcLoggingClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in WebRtcLoggingAgent.Start request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebRtcLoggingAgent::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebRtcLoggingAgentProxy::Stop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "chrome::mojom::WebRtcLoggingAgent::Stop");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebRtcLoggingAgent_Stop_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::chrome::mojom::internal::WebRtcLoggingAgent_Stop_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebRtcLoggingAgent::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebRtcLoggingAgentStubDispatch::Accept(
    WebRtcLoggingAgent* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWebRtcLoggingAgent_Start_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)chrome::mojom::WebRtcLoggingAgent::Start",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)chrome::mojom::WebRtcLoggingAgent::Start");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebRtcLoggingAgent_Start_Params_Data* params =
          reinterpret_cast<internal::WebRtcLoggingAgent_Start_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<WebRtcLoggingClient> p_client{};
      WebRtcLoggingAgent_Start_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebRtcLoggingAgent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(
std::move(p_client));
      return true;
    }
    case internal::kWebRtcLoggingAgent_Stop_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)chrome::mojom::WebRtcLoggingAgent::Stop",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)chrome::mojom::WebRtcLoggingAgent::Stop");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebRtcLoggingAgent_Stop_Params_Data* params =
          reinterpret_cast<internal::WebRtcLoggingAgent_Stop_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebRtcLoggingAgent_Stop_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebRtcLoggingAgent::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop();
      return true;
    }
  }
  return false;
}

// static
bool WebRtcLoggingAgentStubDispatch::AcceptWithResponder(
    WebRtcLoggingAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebRtcLoggingAgent_Start_Name: {
      break;
    }
    case internal::kWebRtcLoggingAgent_Stop_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebRtcLoggingAgentValidationInfo[] = {
    {internal::kWebRtcLoggingAgent_Start_Name,
     {&internal::WebRtcLoggingAgent_Start_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebRtcLoggingAgent_Stop_Name,
     {&internal::WebRtcLoggingAgent_Stop_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebRtcLoggingAgentRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::chrome::mojom::WebRtcLoggingAgent::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebRtcLoggingAgentValidationInfo);
}

}  // namespace mojom
}  // namespace chrome

namespace mojo {


// static
bool StructTraits<::chrome::mojom::WebRtcLoggingMessage::DataView, ::chrome::mojom::WebRtcLoggingMessagePtr>::Read(
    ::chrome::mojom::WebRtcLoggingMessage::DataView input,
    ::chrome::mojom::WebRtcLoggingMessagePtr* output) {
  bool success = true;
  ::chrome::mojom::WebRtcLoggingMessagePtr result(::chrome::mojom::WebRtcLoggingMessage::New());
  
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif