// services/network/public/mojom/client_security_state.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/client_security_state.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "services/network/public/mojom/client_security_state.mojom-params-data.h"
namespace network {
namespace mojom {

std::ostream& operator<<(std::ostream& os, PrivateNetworkRequestPolicy value) {
  switch(value) {
    case PrivateNetworkRequestPolicy::kAllow:
      return os << "PrivateNetworkRequestPolicy::kAllow";
    case PrivateNetworkRequestPolicy::kBlockFromInsecureToMorePrivate:
      return os << "PrivateNetworkRequestPolicy::kBlockFromInsecureToMorePrivate";
    default:
      return os << "Unknown PrivateNetworkRequestPolicy value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool ClientSecurityState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ClientSecurityState_Data* object = static_cast<const ClientSecurityState_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cross_origin_embedder_policy, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cross_origin_embedder_policy, validation_context))
    return false;


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->ip_address_space, validation_context))
    return false;


  if (!::network::mojom::internal::PrivateNetworkRequestPolicy_Data
        ::Validate(object->private_network_request_policy, validation_context))
    return false;

  return true;
}

ClientSecurityState_Data::ClientSecurityState_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network