// services/network/public/mojom/proxy_config.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/proxy_config.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/proxy_config.mojom-params-data.h"
#include "services/network/public/mojom/proxy_config.mojom-shared-message-ids.h"

#include "services/network/public/mojom/proxy_config.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
ProxyBypassRules::ProxyBypassRules()
    : rules() {}

ProxyBypassRules::ProxyBypassRules(
    WTF::Vector<WTF::String> rules_in)
    : rules(std::move(rules_in)) {}

ProxyBypassRules::~ProxyBypassRules() = default;

void ProxyBypassRules::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("rules");
  for (const auto& item0 : this->rules) {
    value->AppendString(item0.Utf8());
  }
  value->EndArray();
}

bool ProxyBypassRules::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyList::ProxyList()
    : proxies() {}

ProxyList::ProxyList(
    WTF::Vector<WTF::String> proxies_in)
    : proxies(std::move(proxies_in)) {}

ProxyList::~ProxyList() = default;

void ProxyList::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("proxies");
  for (const auto& item0 : this->proxies) {
    value->AppendString(item0.Utf8());
  }
  value->EndArray();
}

bool ProxyList::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyRules::ProxyRules()
    : bypass_rules(),
      reverse_bypass(),
      type(),
      single_proxies(),
      proxies_for_http(),
      proxies_for_https(),
      proxies_for_ftp(),
      fallback_proxies() {}

ProxyRules::ProxyRules(
    ProxyBypassRulesPtr bypass_rules_in,
    bool reverse_bypass_in,
    ProxyRulesType type_in,
    ProxyListPtr single_proxies_in,
    ProxyListPtr proxies_for_http_in,
    ProxyListPtr proxies_for_https_in,
    ProxyListPtr proxies_for_ftp_in,
    ProxyListPtr fallback_proxies_in)
    : bypass_rules(std::move(bypass_rules_in)),
      reverse_bypass(std::move(reverse_bypass_in)),
      type(std::move(type_in)),
      single_proxies(std::move(single_proxies_in)),
      proxies_for_http(std::move(proxies_for_http_in)),
      proxies_for_https(std::move(proxies_for_https_in)),
      proxies_for_ftp(std::move(proxies_for_ftp_in)),
      fallback_proxies(std::move(fallback_proxies_in)) {}

ProxyRules::~ProxyRules() = default;

void ProxyRules::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->bypass_rules.is_null()) {
    value->SetString("bypass_rules", "nullptr");
  } else {
    value->BeginDictionary("bypass_rules");
    this->bypass_rules->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("reverse_bypass", this->reverse_bypass);
  value->SetString("type", base::trace_event::ValueToString(this->type));
  if (this->single_proxies.is_null()) {
    value->SetString("single_proxies", "nullptr");
  } else {
    value->BeginDictionary("single_proxies");
    this->single_proxies->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->proxies_for_http.is_null()) {
    value->SetString("proxies_for_http", "nullptr");
  } else {
    value->BeginDictionary("proxies_for_http");
    this->proxies_for_http->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->proxies_for_https.is_null()) {
    value->SetString("proxies_for_https", "nullptr");
  } else {
    value->BeginDictionary("proxies_for_https");
    this->proxies_for_https->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->proxies_for_ftp.is_null()) {
    value->SetString("proxies_for_ftp", "nullptr");
  } else {
    value->BeginDictionary("proxies_for_ftp");
    this->proxies_for_ftp->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->fallback_proxies.is_null()) {
    value->SetString("fallback_proxies", "nullptr");
  } else {
    value->BeginDictionary("fallback_proxies");
    this->fallback_proxies->AsValueInto(value);
    value->EndDictionary();
  }
}

bool ProxyRules::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyConfig::ProxyConfig()
    : auto_detect(),
      pac_url(),
      pac_mandatory(),
      proxy_rules() {}

ProxyConfig::ProxyConfig(
    bool auto_detect_in,
    const ::WTF::String& pac_url_in,
    bool pac_mandatory_in,
    ProxyRulesPtr proxy_rules_in)
    : auto_detect(std::move(auto_detect_in)),
      pac_url(std::move(pac_url_in)),
      pac_mandatory(std::move(pac_mandatory_in)),
      proxy_rules(std::move(proxy_rules_in)) {}

ProxyConfig::~ProxyConfig() = default;

void ProxyConfig::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("auto_detect", this->auto_detect);
  value->SetString("pac_url", base::trace_event::ValueToString(this->pac_url, "<value of type const ::WTF::String&>"));
  value->SetBoolean("pac_mandatory", this->pac_mandatory);
  if (this->proxy_rules.is_null()) {
    value->SetString("proxy_rules", "nullptr");
  } else {
    value->BeginDictionary("proxy_rules");
    this->proxy_rules->AsValueInto(value);
    value->EndDictionary();
  }
}

bool ProxyConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::ProxyBypassRules::DataView, ::network::mojom::blink::ProxyBypassRulesPtr>::Read(
    ::network::mojom::blink::ProxyBypassRules::DataView input,
    ::network::mojom::blink::ProxyBypassRulesPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyBypassRulesPtr result(::network::mojom::blink::ProxyBypassRules::New());
  
      if (success && !input.ReadRules(&result->rules))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ProxyList::DataView, ::network::mojom::blink::ProxyListPtr>::Read(
    ::network::mojom::blink::ProxyList::DataView input,
    ::network::mojom::blink::ProxyListPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyListPtr result(::network::mojom::blink::ProxyList::New());
  
      if (success && !input.ReadProxies(&result->proxies))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ProxyRules::DataView, ::network::mojom::blink::ProxyRulesPtr>::Read(
    ::network::mojom::blink::ProxyRules::DataView input,
    ::network::mojom::blink::ProxyRulesPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyRulesPtr result(::network::mojom::blink::ProxyRules::New());
  
      if (success && !input.ReadBypassRules(&result->bypass_rules))
        success = false;
      if (success)
        result->reverse_bypass = input.reverse_bypass();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadSingleProxies(&result->single_proxies))
        success = false;
      if (success && !input.ReadProxiesForHttp(&result->proxies_for_http))
        success = false;
      if (success && !input.ReadProxiesForHttps(&result->proxies_for_https))
        success = false;
      if (success && !input.ReadProxiesForFtp(&result->proxies_for_ftp))
        success = false;
      if (success && !input.ReadFallbackProxies(&result->fallback_proxies))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ProxyConfig::DataView, ::network::mojom::blink::ProxyConfigPtr>::Read(
    ::network::mojom::blink::ProxyConfig::DataView input,
    ::network::mojom::blink::ProxyConfigPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyConfigPtr result(::network::mojom::blink::ProxyConfig::New());
  
      if (success)
        result->auto_detect = input.auto_detect();
      if (success && !input.ReadPacUrl(&result->pac_url))
        success = false;
      if (success)
        result->pac_mandatory = input.pac_mandatory();
      if (success && !input.ReadProxyRules(&result->proxy_rules))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif