// third_party/blink/public/mojom/worker/shared_worker_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/shared_worker_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/worker/shared_worker_factory.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/shared_worker_factory.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/shared_worker_factory.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_FACTORY_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_FACTORY_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char kNavigation_SharedWorkerSpec[] = "navigation:shared_worker";
const char SharedWorkerFactory::Name_[] = "blink.mojom.SharedWorkerFactory";

SharedWorkerFactoryProxy::SharedWorkerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedWorkerFactoryProxy::CreateSharedWorker(
    ::blink::mojom::SharedWorkerInfoPtr in_info, const ::blink::SharedWorkerToken& in_token, const ::url::Origin& in_constructor_origin, const std::string& in_user_agent, const ::blink::UserAgentMetadata& in_ua_metadata, bool in_pause_on_start, const ::base::UnguessableToken& in_devtools_worker_token, ::blink::mojom::RendererPreferencesPtr in_renderer_preferences, ::mojo::PendingReceiver<::blink::mojom::RendererPreferenceWatcher> in_preference_watcher_receiver, ::mojo::PendingRemote<::blink::mojom::WorkerContentSettingsProxy> in_content_settings, ::blink::mojom::ServiceWorkerContainerInfoForClientPtr in_service_worker_container_info, const base::Optional<::base::UnguessableToken>& in_appcache_host_id, ::blink::mojom::WorkerMainScriptLoadParamsPtr in_main_script_load_params, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories, ::blink::mojom::ControllerServiceWorkerInfoPtr in_controller_info, ::mojo::PendingRemote<::blink::mojom::SharedWorkerHost> in_host, ::mojo::PendingReceiver<::blink::mojom::SharedWorker> in_shared_worker, ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> in_browser_interface_broker, int64_t in_ukm_source_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerFactory::CreateSharedWorker", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_info.is_null()) {
        raw_value->SetString("info", "nullptr");
      } else {
        raw_value->BeginDictionary("info");
        in_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("token", base::trace_event::ValueToString(in_token, "<value of type const ::blink::SharedWorkerToken&>"));
      raw_value->SetString("constructor_origin", base::trace_event::ValueToString(in_constructor_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetString("user_agent", in_user_agent);
      raw_value->SetString("ua_metadata", base::trace_event::ValueToString(in_ua_metadata, "<value of type const ::blink::UserAgentMetadata&>"));
      raw_value->SetBoolean("pause_on_start", in_pause_on_start);
      raw_value->SetString("devtools_worker_token", base::trace_event::ValueToString(in_devtools_worker_token, "<value of type const ::base::UnguessableToken&>"));
      if (in_renderer_preferences.is_null()) {
        raw_value->SetString("renderer_preferences", "nullptr");
      } else {
        raw_value->BeginDictionary("renderer_preferences");
        in_renderer_preferences->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("preference_watcher_receiver", in_preference_watcher_receiver.is_valid());
      raw_value->SetBoolean("content_settings", in_content_settings.is_valid());
      if (in_service_worker_container_info.is_null()) {
        raw_value->SetString("service_worker_container_info", "nullptr");
      } else {
        raw_value->BeginDictionary("service_worker_container_info");
        in_service_worker_container_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("appcache_host_id", base::trace_event::ValueToString(in_appcache_host_id, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      if (in_main_script_load_params.is_null()) {
        raw_value->SetString("main_script_load_params", "nullptr");
      } else {
        raw_value->BeginDictionary("main_script_load_params");
        in_main_script_load_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("subresource_loader_factories", base::trace_event::ValueToString(in_subresource_loader_factories, "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>"));
      if (in_controller_info.is_null()) {
        raw_value->SetString("controller_info", "nullptr");
      } else {
        raw_value->BeginDictionary("controller_info");
        in_controller_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("host", in_host.is_valid());
      raw_value->SetBoolean("shared_worker", in_shared_worker.is_valid());
      raw_value->SetBoolean("browser_interface_broker", in_browser_interface_broker.is_valid());
      raw_value->SetString("ukm_source_id", base::NumberToString(in_ukm_source_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSharedWorkerFactory_CreateSharedWorker_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SharedWorkerFactory_CreateSharedWorker_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->info)::BaseType::BufferWriter
      info_writer;
  mojo::internal::Serialize<::blink::mojom::SharedWorkerInfoDataView>(
      in_info, buffer, &info_writer, &serialization_context);
  params->info.Set(
      info_writer.is_null() ? nullptr : info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in SharedWorkerFactory.CreateSharedWorker request");
  typename decltype(params->token)::BaseType::BufferWriter
      token_writer;
  mojo::internal::Serialize<::blink::mojom::SharedWorkerTokenDataView>(
      in_token, buffer, &token_writer, &serialization_context);
  params->token.Set(
      token_writer.is_null() ? nullptr : token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in SharedWorkerFactory.CreateSharedWorker request");
  typename decltype(params->constructor_origin)::BaseType::BufferWriter
      constructor_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_constructor_origin, buffer, &constructor_origin_writer, &serialization_context);
  params->constructor_origin.Set(
      constructor_origin_writer.is_null() ? nullptr : constructor_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->constructor_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null constructor_origin in SharedWorkerFactory.CreateSharedWorker request");
  typename decltype(params->user_agent)::BaseType::BufferWriter
      user_agent_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_user_agent, buffer, &user_agent_writer, &serialization_context);
  params->user_agent.Set(
      user_agent_writer.is_null() ? nullptr : user_agent_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->user_agent.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_agent in SharedWorkerFactory.CreateSharedWorker request");
  typename decltype(params->ua_metadata)::BaseType::BufferWriter
      ua_metadata_writer;
  mojo::internal::Serialize<::blink::mojom::UserAgentMetadataDataView>(
      in_ua_metadata, buffer, &ua_metadata_writer, &serialization_context);
  params->ua_metadata.Set(
      ua_metadata_writer.is_null() ? nullptr : ua_metadata_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ua_metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ua_metadata in SharedWorkerFactory.CreateSharedWorker request");
  params->pause_on_start = in_pause_on_start;
  typename decltype(params->devtools_worker_token)::BaseType::BufferWriter
      devtools_worker_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_worker_token, buffer, &devtools_worker_token_writer, &serialization_context);
  params->devtools_worker_token.Set(
      devtools_worker_token_writer.is_null() ? nullptr : devtools_worker_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtools_worker_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_worker_token in SharedWorkerFactory.CreateSharedWorker request");
  typename decltype(params->renderer_preferences)::BaseType::BufferWriter
      renderer_preferences_writer;
  mojo::internal::Serialize<::blink::mojom::RendererPreferencesDataView>(
      in_renderer_preferences, buffer, &renderer_preferences_writer, &serialization_context);
  params->renderer_preferences.Set(
      renderer_preferences_writer.is_null() ? nullptr : renderer_preferences_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->renderer_preferences.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null renderer_preferences in SharedWorkerFactory.CreateSharedWorker request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::RendererPreferenceWatcherInterfaceBase>>(
      in_preference_watcher_receiver, &params->preference_watcher_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->preference_watcher_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid preference_watcher_receiver in SharedWorkerFactory.CreateSharedWorker request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::WorkerContentSettingsProxyInterfaceBase>>(
      in_content_settings, &params->content_settings, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->content_settings),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid content_settings in SharedWorkerFactory.CreateSharedWorker request");
  typename decltype(params->service_worker_container_info)::BaseType::BufferWriter
      service_worker_container_info_writer;
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerContainerInfoForClientDataView>(
      in_service_worker_container_info, buffer, &service_worker_container_info_writer, &serialization_context);
  params->service_worker_container_info.Set(
      service_worker_container_info_writer.is_null() ? nullptr : service_worker_container_info_writer.data());
  typename decltype(params->appcache_host_id)::BaseType::BufferWriter
      appcache_host_id_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_appcache_host_id, buffer, &appcache_host_id_writer, &serialization_context);
  params->appcache_host_id.Set(
      appcache_host_id_writer.is_null() ? nullptr : appcache_host_id_writer.data());
  typename decltype(params->main_script_load_params)::BaseType::BufferWriter
      main_script_load_params_writer;
  mojo::internal::Serialize<::blink::mojom::WorkerMainScriptLoadParamsDataView>(
      in_main_script_load_params, buffer, &main_script_load_params_writer, &serialization_context);
  params->main_script_load_params.Set(
      main_script_load_params_writer.is_null() ? nullptr : main_script_load_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->main_script_load_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_script_load_params in SharedWorkerFactory.CreateSharedWorker request");
  typename decltype(params->subresource_loader_factories)::BaseType::BufferWriter
      subresource_loader_factories_writer;
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
      in_subresource_loader_factories, buffer, &subresource_loader_factories_writer, &serialization_context);
  params->subresource_loader_factories.Set(
      subresource_loader_factories_writer.is_null() ? nullptr : subresource_loader_factories_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->subresource_loader_factories.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subresource_loader_factories in SharedWorkerFactory.CreateSharedWorker request");
  typename decltype(params->controller_info)::BaseType::BufferWriter
      controller_info_writer;
  mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerInfoDataView>(
      in_controller_info, buffer, &controller_info_writer, &serialization_context);
  params->controller_info.Set(
      controller_info_writer.is_null() ? nullptr : controller_info_writer.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::SharedWorkerHostInterfaceBase>>(
      in_host, &params->host, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid host in SharedWorkerFactory.CreateSharedWorker request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SharedWorkerInterfaceBase>>(
      in_shared_worker, &params->shared_worker, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->shared_worker),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid shared_worker in SharedWorkerFactory.CreateSharedWorker request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
      in_browser_interface_broker, &params->browser_interface_broker, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->browser_interface_broker),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid browser_interface_broker in SharedWorkerFactory.CreateSharedWorker request");
  params->ukm_source_id = in_ukm_source_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerFactory::Name_);
  message.set_method_name("CreateSharedWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SharedWorkerFactoryStubDispatch::Accept(
    SharedWorkerFactory* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSharedWorkerFactory_CreateSharedWorker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerFactory::CreateSharedWorker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerFactory::CreateSharedWorker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerFactory_CreateSharedWorker_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerFactory_CreateSharedWorker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::SharedWorkerInfoPtr p_info{};
      ::blink::SharedWorkerToken p_token{};
      ::url::Origin p_constructor_origin{};
      std::string p_user_agent{};
      ::blink::UserAgentMetadata p_ua_metadata{};
      bool p_pause_on_start{};
      ::base::UnguessableToken p_devtools_worker_token{};
      ::blink::mojom::RendererPreferencesPtr p_renderer_preferences{};
      ::mojo::PendingReceiver<::blink::mojom::RendererPreferenceWatcher> p_preference_watcher_receiver{};
      ::mojo::PendingRemote<::blink::mojom::WorkerContentSettingsProxy> p_content_settings{};
      ::blink::mojom::ServiceWorkerContainerInfoForClientPtr p_service_worker_container_info{};
      base::Optional<::base::UnguessableToken> p_appcache_host_id{};
      ::blink::mojom::WorkerMainScriptLoadParamsPtr p_main_script_load_params{};
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      ::blink::mojom::ControllerServiceWorkerInfoPtr p_controller_info{};
      ::mojo::PendingRemote<::blink::mojom::SharedWorkerHost> p_host{};
      ::mojo::PendingReceiver<::blink::mojom::SharedWorker> p_shared_worker{};
      ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> p_browser_interface_broker{};
      int64_t p_ukm_source_id{};
      SharedWorkerFactory_CreateSharedWorker_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadConstructorOrigin(&p_constructor_origin))
        success = false;
      if (success && !input_data_view.ReadUserAgent(&p_user_agent))
        success = false;
      if (success && !input_data_view.ReadUaMetadata(&p_ua_metadata))
        success = false;
      if (success)
        p_pause_on_start = input_data_view.pause_on_start();
      if (success && !input_data_view.ReadDevtoolsWorkerToken(&p_devtools_worker_token))
        success = false;
      if (success && !input_data_view.ReadRendererPreferences(&p_renderer_preferences))
        success = false;
      if (success) {
        p_preference_watcher_receiver =
            input_data_view.TakePreferenceWatcherReceiver<decltype(p_preference_watcher_receiver)>();
      }
      if (success) {
        p_content_settings =
            input_data_view.TakeContentSettings<decltype(p_content_settings)>();
      }
      if (success && !input_data_view.ReadServiceWorkerContainerInfo(&p_service_worker_container_info))
        success = false;
      if (success && !input_data_view.ReadAppcacheHostId(&p_appcache_host_id))
        success = false;
      if (success && !input_data_view.ReadMainScriptLoadParams(&p_main_script_load_params))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (success && !input_data_view.ReadControllerInfo(&p_controller_info))
        success = false;
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success) {
        p_shared_worker =
            input_data_view.TakeSharedWorker<decltype(p_shared_worker)>();
      }
      if (success) {
        p_browser_interface_broker =
            input_data_view.TakeBrowserInterfaceBroker<decltype(p_browser_interface_broker)>();
      }
      if (success)
        p_ukm_source_id = input_data_view.ukm_source_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSharedWorker(
std::move(p_info), 
std::move(p_token), 
std::move(p_constructor_origin), 
std::move(p_user_agent), 
std::move(p_ua_metadata), 
std::move(p_pause_on_start), 
std::move(p_devtools_worker_token), 
std::move(p_renderer_preferences), 
std::move(p_preference_watcher_receiver), 
std::move(p_content_settings), 
std::move(p_service_worker_container_info), 
std::move(p_appcache_host_id), 
std::move(p_main_script_load_params), 
std::move(p_subresource_loader_factories), 
std::move(p_controller_info), 
std::move(p_host), 
std::move(p_shared_worker), 
std::move(p_browser_interface_broker), 
std::move(p_ukm_source_id));
      return true;
    }
  }
  return false;
}

// static
bool SharedWorkerFactoryStubDispatch::AcceptWithResponder(
    SharedWorkerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSharedWorkerFactory_CreateSharedWorker_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSharedWorkerFactoryValidationInfo[] = {
    {internal::kSharedWorkerFactory_CreateSharedWorker_Name,
     {&internal::SharedWorkerFactory_CreateSharedWorker_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SharedWorkerFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SharedWorkerFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSharedWorkerFactoryValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif