// This file is generated by kconfig_compiler_kf5 from klipper.kcfg.
// All changes you do to this file will be lost.

#include "klippersettings.h"

#include <klocalizedstring.h>

#include <qglobal.h>
#include <QFile>

class KlipperSettingsHelper
{
  public:
    KlipperSettingsHelper() : q(nullptr) {}
    ~KlipperSettingsHelper() { delete q; q = nullptr; }
    KlipperSettingsHelper(const KlipperSettingsHelper&) = delete;
    KlipperSettingsHelper& operator=(const KlipperSettingsHelper&) = delete;
    KlipperSettings *q;
};
Q_GLOBAL_STATIC(KlipperSettingsHelper, s_globalKlipperSettings)
KlipperSettings *KlipperSettings::self()
{
  if (!s_globalKlipperSettings()->q) {
    new KlipperSettings;
    s_globalKlipperSettings()->q->read();
  }

  return s_globalKlipperSettings()->q;
}

KlipperSettings::KlipperSettings( )
  : KConfigSkeleton( QStringLiteral( "klipperrc" ) )
{
  Q_ASSERT(!s_globalKlipperSettings()->q);
  s_globalKlipperSettings()->q = this;
  setCurrentGroup( QStringLiteral( "General" ) );

  mVersionItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Version" ), mVersion );
  mVersionItem->setLabel( i18n("Klipper version") );
  addItem( mVersionItem, QStringLiteral( "Version" ) );
  mKeepClipboardContentsItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "KeepClipboardContents" ), mKeepClipboardContents, true );
  mKeepClipboardContentsItem->setLabel( i18n("Save history across desktop sessions") );
  mKeepClipboardContentsItem->setToolTip( i18n("Retain the clipboard history, so it will be available the next time you log in.") );
  addItem( mKeepClipboardContentsItem, QStringLiteral( "KeepClipboardContents" ) );
  mPreventEmptyClipboardItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "NoEmptyClipboard" ), mPreventEmptyClipboard, true );
  mPreventEmptyClipboardItem->setLabel( i18n("Prevent the clipboard from being cleared") );
  mPreventEmptyClipboardItem->setWhatsThis( i18n("Do not allow the clipboard to be cleared, for example when an application exits.") );
  addItem( mPreventEmptyClipboardItem, QStringLiteral( "PreventEmptyClipboard" ) );
  mSynchronizeItem = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Synchronize" ), mSynchronize, 3 );
  mSynchronizeItem->setLabel( i18n("Backwards compatibility, don't touch.") );
  addItem( mSynchronizeItem, QStringLiteral( "Synchronize" ) );
  mSyncClipboardsItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "SyncClipboards" ), mSyncClipboards, false );
  mSyncClipboardsItem->setLabel( i18n("Keep the selection and clipboard the same") );
  mSyncClipboardsItem->setWhatsThis( i18n("Content selected with the cursor is automatically copied to the clipboard so that it can be pasted with either a Paste action or a middle-click.<br/><a href=\"1\">More about the selection and clipboard</a>.") );
  addItem( mSyncClipboardsItem, QStringLiteral( "SyncClipboards" ) );
  mIgnoreSelectionItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "IgnoreSelection" ), mIgnoreSelection, true );
  mIgnoreSelectionItem->setLabel( i18n("Ignore the selection") );
  mIgnoreSelectionItem->setWhatsThis( i18n("Content selected with the cursor but not explicitly copied to the clipboard is not automatically stored in the clipboard history, and can only be pasted using a middle-click.") );
  addItem( mIgnoreSelectionItem, QStringLiteral( "IgnoreSelection" ) );
  mSelectionTextOnlyItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "SelectionTextOnly" ), mSelectionTextOnly, true );
  mSelectionTextOnlyItem->setLabel( i18n("Text selection only") );
  mSelectionTextOnlyItem->setWhatsThis( i18n("Only store text selections in the clipboard history, not images or any other type of data.") );
  addItem( mSelectionTextOnlyItem, QStringLiteral( "SelectionTextOnly" ) );
  mIgnoreImagesItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "IgnoreImages" ), mIgnoreImages, true );
  mIgnoreImagesItem->setLabel( i18n("Always ignore images") );
  mIgnoreImagesItem->setWhatsThis( i18n("Do not store images in the clipboard history, even if explicitly copied.") );
  addItem( mIgnoreImagesItem, QStringLiteral( "IgnoreImages" ) );
  mUseGUIRegExpEditorItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseGUIRegExpEditor" ), mUseGUIRegExpEditor, true );
  mUseGUIRegExpEditorItem->setLabel( i18n("Use graphical regexp editor") );
  addItem( mUseGUIRegExpEditorItem, QStringLiteral( "UseGUIRegExpEditor" ) );
  mURLGrabberEnabledItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "URLGrabberEnabled" ), mURLGrabberEnabled, false );
  mURLGrabberEnabledItem->setLabel( i18n("Immediately on selection") );
  mURLGrabberEnabledItem->setToolTip( i18n("Show the popup menu of applicable actions as soon as a selection is made.") );
  addItem( mURLGrabberEnabledItem, QStringLiteral( "URLGrabberEnabled" ) );
  QStringList defaultNoActionsForWM_CLASS;
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "Navigator" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "navigator:browser" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "konqueror" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "keditbookmarks" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "mozilla-bin" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "Mozilla" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "Opera main window" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "opera" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "gnumeric" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "Gnumeric" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "Galeon" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "kcontrol" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "ksirc" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "MozillaFirebird-bin" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "firefox-bin" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "Firefox-bin" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "klipper" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "Gecko" ) );
  defaultNoActionsForWM_CLASS.append( QString::fromUtf8( "gecko" ) );

  mNoActionsForWM_CLASSItem = new KConfigSkeleton::ItemStringList( currentGroup(), QStringLiteral( "NoActionsForWM_CLASS" ), mNoActionsForWM_CLASS, defaultNoActionsForWM_CLASS );
  mNoActionsForWM_CLASSItem->setLabel( i18n("No actions for WM_CLASS") );
  addItem( mNoActionsForWM_CLASSItem, QStringLiteral( "NoActionsForWM_CLASS" ) );
  mTimeoutForActionPopupsItem = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "TimeoutForActionPopups" ), mTimeoutForActionPopups, 8 );
  mTimeoutForActionPopupsItem->setMinValue(0);
  mTimeoutForActionPopupsItem->setMaxValue(200);
  mTimeoutForActionPopupsItem->setLabel( i18n("Automatic action menu time:") );
  mTimeoutForActionPopupsItem->setToolTip( i18n("Display the automatic action popup menu for this time.") );
  addItem( mTimeoutForActionPopupsItem, QStringLiteral( "TimeoutForActionPopups" ) );
  mMaxClipItemsItem = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "MaxClipItems" ), mMaxClipItems, 20 );
  mMaxClipItemsItem->setMinValue(1);
  mMaxClipItemsItem->setMaxValue(2048);
  mMaxClipItemsItem->setLabel( i18n("History size:") );
  mMaxClipItemsItem->setToolTip( i18n("The clipboard history will store up to this many items.") );
  addItem( mMaxClipItemsItem, QStringLiteral( "MaxClipItems" ) );
  mActionListItem = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "ActionListChanged" ), mActionList, -1 );
  mActionListItem->setLabel( i18n("Dummy entry for indicating changes in an action's tree widget") );
  addItem( mActionListItem, QStringLiteral( "ActionList" ) );
  mPopupInfoMessageShownItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "PopupInfoMessageShown" ), mPopupInfoMessageShown, true );
  mPopupInfoMessageShownItem->setLabel( i18n("PopupInfoMessageShown") );
  addItem( mPopupInfoMessageShownItem, QStringLiteral( "PopupInfoMessageShown" ) );
  mActionsInfoMessageShownItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ActionsInfoMessageShown" ), mActionsInfoMessageShown, true );
  mActionsInfoMessageShownItem->setLabel( i18n("ActionsInfoMessageShown") );
  addItem( mActionsInfoMessageShownItem, QStringLiteral( "ActionsInfoMessageShown" ) );

  setCurrentGroup( QStringLiteral( "Actions" ) );

  mStripWhiteSpaceItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "StripWhiteSpace" ), mStripWhiteSpace, true );
  mStripWhiteSpaceItem->setLabel( i18n("Trim whitespace from selection") );
  mStripWhiteSpaceItem->setWhatsThis( i18n("Remove any whitespace from the start and end of selected text, before performing an action. For example, this ensures that a URL pasted in a browser is interpreted as expected. The text saved on the clipboard is not affected.") );
  addItem( mStripWhiteSpaceItem, QStringLiteral( "StripWhiteSpace" ) );
  mReplayActionInHistoryItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ReplayActionInHistory" ), mReplayActionInHistory, false );
  mReplayActionInHistoryItem->setLabel( i18n("For an item chosen from history") );
  mReplayActionInHistoryItem->setToolTip( i18n("Show the popup menu of applicable actions if an entry is chosen from the clipboard history.") );
  addItem( mReplayActionInHistoryItem, QStringLiteral( "ReplayActionInHistory" ) );
  mEnableMagicMimeActionsItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "EnableMagicMimeActions" ), mEnableMagicMimeActions, true );
  mEnableMagicMimeActionsItem->setLabel( i18n("Include MIME actions") );
  mEnableMagicMimeActionsItem->setWhatsThis( i18n("If a file name or URL is selected, include applications that can accept its MIME type in the popup menu.") );
  addItem( mEnableMagicMimeActionsItem, QStringLiteral( "EnableMagicMimeActions" ) );
}

KlipperSettings::~KlipperSettings()
{
  if (s_globalKlipperSettings.exists() && !s_globalKlipperSettings.isDestroyed()) {
    s_globalKlipperSettings()->q = nullptr;
  }
}

