/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.jnati.deploy.artefact.Artefact;
import net.sf.jnati.deploy.source.ArtefactSource;
import org.apache.log4j.Logger;

public class JarSource
extends ArtefactSource {
    private static final Logger LOG = Logger.getLogger(JarSource.class);
    private static final String FS = "/";
    private static final String METAINF = "META-INF";
    private final Artefact artefact;
    private JarFile jar;
    private final String basePath;
    private File file;

    public JarSource(JarFile jar, Artefact artefact) {
        this.jar = jar;
        this.artefact = artefact;
        this.basePath = this.getBasePath();
    }

    public JarSource(File file, Artefact artefact) throws IOException {
        this.file = file;
        this.artefact = artefact;
        this.basePath = this.getBasePath();
    }

    private String getBasePath() {
        return "META-INF/" + this.artefact.getId() + FS + this.artefact.getVersion() + FS + this.artefact.getOsArch() + FS;
    }

    public InputStream openFile(String path) throws IOException {
        JarEntry entry = this.getEntry(path);
        if (entry == null) {
            throw new FileNotFoundException("File not found: " + path);
        }
        return this.jar.getInputStream(entry);
    }

    private JarEntry getEntry(String path) throws IOException {
        if (this.jar == null) {
            LOG.debug("Opening jar: " + this.file);
            this.jar = new JarFile(this.file);
        }
        String name = this.basePath + path;
        JarEntry entry = this.jar.getJarEntry(name);
        return entry;
    }

    public boolean containsFile(String path) throws IOException {
        JarEntry entry = this.getEntry(path);
        return entry != null & !entry.isDirectory();
    }

    public void close() throws IOException {
        if (this.jar != null) {
            this.jar.close();
            this.jar = null;
        }
    }

    public boolean isLocal() {
        return false;
    }

    public File getPath() {
        return null;
    }
}

