"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _common = require("../../common");

var _helpers = require("./utils/helpers");

var _configSchema = require("@osd/config-schema");

var _constants = require("./utils/constants");

var _metricHelper = require("./utils/metricHelper");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(router) {
  router.get({
    path: `${_common.API_PREFIX}/getReportSource/{reportSourceType}`,
    validate: {
      params: _configSchema.schema.object({
        reportSourceType: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    let responseParams;

    if (request.params.reportSourceType === 'dashboard') {
      const params = {
        index: '.kibana',
        q: 'type:dashboard',
        size: _constants.DEFAULT_MAX_SIZE
      };
      responseParams = params;
    } else if (request.params.reportSourceType === 'visualization') {
      const params = {
        index: '.kibana',
        q: 'type:visualization',
        size: _constants.DEFAULT_MAX_SIZE
      };
      responseParams = params;
    } else if (request.params.reportSourceType === 'search') {
      const params = {
        index: '.kibana',
        q: 'type:search',
        size: _constants.DEFAULT_MAX_SIZE
      };
      responseParams = params;
    }

    try {
      const opensearchResp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', responseParams);
      (0, _metricHelper.addToMetric)('report_source', 'list', 'count');
      return response.ok({
        body: opensearchResp
      });
    } catch (error) {
      //@ts-ignore
      context.reporting_plugin.logger.error(`Failed to get reports source for ${request.params.reportSourceType}: ${error}`);
      (0, _metricHelper.addToMetric)('report_source', 'list', (0, _helpers.checkErrorType)(error));
      return response.custom({
        statusCode: error.statusCode,
        body: (0, _helpers.parseOpenSearchErrorResponse)(error)
      });
    }
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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