"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WINDOW = exports.TRIGGER_TYPE = exports.SELECTOR = exports.SECURITY_CONSTANTS = exports.SCHEDULE_TYPE = exports.REPORT_TYPE = exports.REPORT_STATE = exports.REPORT_DEFINITION_STATUS = exports.INTERVAL = exports.GLOBAL_BASIC_COUNTER = exports.FORMAT = exports.EXTRA_HEADERS = exports.DELIVERY_TYPE = exports.DELIVERY_CHANNEL = exports.DEFAULT_ROLLING_COUNTER = exports.DEFAULT_REPORT_HEADER = exports.DEFAULT_MAX_SIZE = exports.DATA_REPORT_CONFIG = exports.CHROMIUM_PATH = exports.CAPACITY = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let FORMAT;
exports.FORMAT = FORMAT;

(function (FORMAT) {
  FORMAT["pdf"] = "pdf";
  FORMAT["png"] = "png";
  FORMAT["csv"] = "csv";
})(FORMAT || (exports.FORMAT = FORMAT = {}));

let REPORT_STATE;
exports.REPORT_STATE = REPORT_STATE;

(function (REPORT_STATE) {
  REPORT_STATE["created"] = "Created";
  REPORT_STATE["error"] = "Error";
  REPORT_STATE["pending"] = "Pending";
  REPORT_STATE["shared"] = "Shared";
})(REPORT_STATE || (exports.REPORT_STATE = REPORT_STATE = {}));

let REPORT_DEFINITION_STATUS;
exports.REPORT_DEFINITION_STATUS = REPORT_DEFINITION_STATUS;

(function (REPORT_DEFINITION_STATUS) {
  REPORT_DEFINITION_STATUS["active"] = "Active";
  REPORT_DEFINITION_STATUS["disabled"] = "Disabled";
})(REPORT_DEFINITION_STATUS || (exports.REPORT_DEFINITION_STATUS = REPORT_DEFINITION_STATUS = {}));

let DELIVERY_CHANNEL;
exports.DELIVERY_CHANNEL = DELIVERY_CHANNEL;

(function (DELIVERY_CHANNEL) {
  DELIVERY_CHANNEL["email"] = "Email";
  DELIVERY_CHANNEL["slack"] = "Slack";
  DELIVERY_CHANNEL["chime"] = "Chime";
  DELIVERY_CHANNEL["opensearchDashboards"] = "OpenSearch Dashboards user";
})(DELIVERY_CHANNEL || (exports.DELIVERY_CHANNEL = DELIVERY_CHANNEL = {}));

let SCHEDULE_TYPE;
exports.SCHEDULE_TYPE = SCHEDULE_TYPE;

(function (SCHEDULE_TYPE) {
  SCHEDULE_TYPE["recurring"] = "Recurring";
  SCHEDULE_TYPE["cron"] = "Cron based";
})(SCHEDULE_TYPE || (exports.SCHEDULE_TYPE = SCHEDULE_TYPE = {}));

let REPORT_TYPE;
exports.REPORT_TYPE = REPORT_TYPE;

(function (REPORT_TYPE) {
  REPORT_TYPE["savedSearch"] = "Saved search";
  REPORT_TYPE["dashboard"] = "Dashboard";
  REPORT_TYPE["visualization"] = "Visualization";
  REPORT_TYPE["notebook"] = "Notebook";
})(REPORT_TYPE || (exports.REPORT_TYPE = REPORT_TYPE = {}));

let DATA_REPORT_CONFIG;
exports.DATA_REPORT_CONFIG = DATA_REPORT_CONFIG;

(function (DATA_REPORT_CONFIG) {
  DATA_REPORT_CONFIG["excelDateFormat"] = "MM/DD/YYYY h:mm:ss.SSS a";
})(DATA_REPORT_CONFIG || (exports.DATA_REPORT_CONFIG = DATA_REPORT_CONFIG = {}));

let TRIGGER_TYPE;
exports.TRIGGER_TYPE = TRIGGER_TYPE;

(function (TRIGGER_TYPE) {
  TRIGGER_TYPE["schedule"] = "Schedule";
  TRIGGER_TYPE["onDemand"] = "On demand";
})(TRIGGER_TYPE || (exports.TRIGGER_TYPE = TRIGGER_TYPE = {}));

let DELIVERY_TYPE;
exports.DELIVERY_TYPE = DELIVERY_TYPE;

(function (DELIVERY_TYPE) {
  DELIVERY_TYPE["opensearchDashboardsUser"] = "OpenSearch Dashboards user";
  DELIVERY_TYPE["channel"] = "Channel";
})(DELIVERY_TYPE || (exports.DELIVERY_TYPE = DELIVERY_TYPE = {}));

let SELECTOR; // https://www.elastic.co/guide/en/elasticsearch/reference/6.8/search-request-from-size.html

exports.SELECTOR = SELECTOR;

(function (SELECTOR) {
  SELECTOR["dashboard"] = "#dashboardViewport";
  SELECTOR["visualization"] = ".visEditor__content";
  SELECTOR["notebook"] = ".euiPageBody";
})(SELECTOR || (exports.SELECTOR = SELECTOR = {}));

const DEFAULT_MAX_SIZE = 10000;
exports.DEFAULT_MAX_SIZE = DEFAULT_MAX_SIZE;
const DEFAULT_REPORT_HEADER = '<h1>OpenSearch Dashboards Reports</h1>';
exports.DEFAULT_REPORT_HEADER = DEFAULT_REPORT_HEADER;
const SECURITY_CONSTANTS = {
  TENANT_LOCAL_STORAGE_KEY: 'opendistro::security::tenant::show_popup'
};
exports.SECURITY_CONSTANTS = SECURITY_CONSTANTS;
const EXTRA_HEADERS = ['cookie', 'x-proxy-user', 'x-proxy-roles', 'x-forwarded-for'];
exports.EXTRA_HEADERS = EXTRA_HEADERS;
const CHROMIUM_PATH = `${__dirname}/../../../.chromium/headless_shell`;
/**
 * Metric constants
 */

exports.CHROMIUM_PATH = CHROMIUM_PATH;
const WINDOW = 3600;
exports.WINDOW = WINDOW;
const INTERVAL = 60;
exports.INTERVAL = INTERVAL;
const CAPACITY = WINDOW / INTERVAL * 2;
exports.CAPACITY = CAPACITY;
const GLOBAL_BASIC_COUNTER = {
  report: {
    create: {
      total: 0
    },
    create_from_definition: {
      total: 0
    },
    download: {
      total: 0
    },
    list: {
      total: 0
    },
    info: {
      total: 0
    }
  },
  report_definition: {
    create: {
      total: 0
    },
    list: {
      total: 0
    },
    info: {
      total: 0
    },
    update: {
      total: 0
    },
    delete: {
      total: 0
    }
  },
  report_source: {
    list: {
      total: 0
    }
  },
  dashboard: {
    pdf: {
      download: {
        total: 0
      }
    },
    png: {
      download: {
        total: 0
      }
    }
  },
  visualization: {
    pdf: {
      download: {
        total: 0
      }
    },
    png: {
      download: {
        total: 0
      }
    }
  },
  notebook: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  saved_search: {
    csv: {
      download: {
        total: 0
      }
    }
  }
};
exports.GLOBAL_BASIC_COUNTER = GLOBAL_BASIC_COUNTER;
const DEFAULT_ROLLING_COUNTER = {
  report: {
    create: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    create_from_definition: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    download: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    info: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  report_definition: {
    create: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    info: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    update: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    delete: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  report_source: {
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  dashboard: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  visualization: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  notebook: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  saved_search: {
    csv: {
      download: {
        count: 0
      }
    }
  }
};
exports.DEFAULT_ROLLING_COUNTER = DEFAULT_ROLLING_COUNTER;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbnN0YW50cy50cyJdLCJuYW1lcyI6WyJGT1JNQVQiLCJSRVBPUlRfU1RBVEUiLCJSRVBPUlRfREVGSU5JVElPTl9TVEFUVVMiLCJERUxJVkVSWV9DSEFOTkVMIiwiU0NIRURVTEVfVFlQRSIsIlJFUE9SVF9UWVBFIiwiREFUQV9SRVBPUlRfQ09ORklHIiwiVFJJR0dFUl9UWVBFIiwiREVMSVZFUllfVFlQRSIsIlNFTEVDVE9SIiwiREVGQVVMVF9NQVhfU0laRSIsIkRFRkFVTFRfUkVQT1JUX0hFQURFUiIsIlNFQ1VSSVRZX0NPTlNUQU5UUyIsIlRFTkFOVF9MT0NBTF9TVE9SQUdFX0tFWSIsIkVYVFJBX0hFQURFUlMiLCJDSFJPTUlVTV9QQVRIIiwiX19kaXJuYW1lIiwiV0lORE9XIiwiSU5URVJWQUwiLCJDQVBBQ0lUWSIsIkdMT0JBTF9CQVNJQ19DT1VOVEVSIiwicmVwb3J0IiwiY3JlYXRlIiwidG90YWwiLCJjcmVhdGVfZnJvbV9kZWZpbml0aW9uIiwiZG93bmxvYWQiLCJsaXN0IiwiaW5mbyIsInJlcG9ydF9kZWZpbml0aW9uIiwidXBkYXRlIiwiZGVsZXRlIiwicmVwb3J0X3NvdXJjZSIsImRhc2hib2FyZCIsInBkZiIsInBuZyIsInZpc3VhbGl6YXRpb24iLCJub3RlYm9vayIsImNvdW50Iiwic2F2ZWRfc2VhcmNoIiwiY3N2IiwiREVGQVVMVF9ST0xMSU5HX0NPVU5URVIiLCJzeXN0ZW1fZXJyb3IiLCJ1c2VyX2Vycm9yIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7SUFJWUEsTTs7O1dBQUFBLE07QUFBQUEsRUFBQUEsTTtBQUFBQSxFQUFBQSxNO0FBQUFBLEVBQUFBLE07R0FBQUEsTSxzQkFBQUEsTTs7SUFNQUMsWTs7O1dBQUFBLFk7QUFBQUEsRUFBQUEsWTtBQUFBQSxFQUFBQSxZO0FBQUFBLEVBQUFBLFk7QUFBQUEsRUFBQUEsWTtHQUFBQSxZLDRCQUFBQSxZOztJQU9BQyx3Qjs7O1dBQUFBLHdCO0FBQUFBLEVBQUFBLHdCO0FBQUFBLEVBQUFBLHdCO0dBQUFBLHdCLHdDQUFBQSx3Qjs7SUFLQUMsZ0I7OztXQUFBQSxnQjtBQUFBQSxFQUFBQSxnQjtBQUFBQSxFQUFBQSxnQjtBQUFBQSxFQUFBQSxnQjtBQUFBQSxFQUFBQSxnQjtHQUFBQSxnQixnQ0FBQUEsZ0I7O0lBT0FDLGE7OztXQUFBQSxhO0FBQUFBLEVBQUFBLGE7QUFBQUEsRUFBQUEsYTtHQUFBQSxhLDZCQUFBQSxhOztJQUtBQyxXOzs7V0FBQUEsVztBQUFBQSxFQUFBQSxXO0FBQUFBLEVBQUFBLFc7QUFBQUEsRUFBQUEsVztBQUFBQSxFQUFBQSxXO0dBQUFBLFcsMkJBQUFBLFc7O0lBT0FDLGtCOzs7V0FBQUEsa0I7QUFBQUEsRUFBQUEsa0I7R0FBQUEsa0Isa0NBQUFBLGtCOztJQUlBQyxZOzs7V0FBQUEsWTtBQUFBQSxFQUFBQSxZO0FBQUFBLEVBQUFBLFk7R0FBQUEsWSw0QkFBQUEsWTs7SUFLQUMsYTs7O1dBQUFBLGE7QUFBQUEsRUFBQUEsYTtBQUFBQSxFQUFBQSxhO0dBQUFBLGEsNkJBQUFBLGE7O0lBS0FDLFEsRUFNWjs7OztXQU5ZQSxRO0FBQUFBLEVBQUFBLFE7QUFBQUEsRUFBQUEsUTtBQUFBQSxFQUFBQSxRO0dBQUFBLFEsd0JBQUFBLFE7O0FBT0wsTUFBTUMsZ0JBQWdCLEdBQUcsS0FBekI7O0FBRUEsTUFBTUMscUJBQXFCLEdBQUcsd0NBQTlCOztBQUVBLE1BQU1DLGtCQUFrQixHQUFHO0FBQ2hDQyxFQUFBQSx3QkFBd0IsRUFBRTtBQURNLENBQTNCOztBQUlBLE1BQU1DLGFBQWEsR0FBRyxDQUMzQixRQUQyQixFQUUzQixjQUYyQixFQUczQixlQUgyQixFQUkzQixpQkFKMkIsQ0FBdEI7O0FBT0EsTUFBTUMsYUFBYSxHQUFJLEdBQUVDLFNBQVUsb0NBQW5DO0FBRVA7QUFDQTtBQUNBOzs7QUFDTyxNQUFNQyxNQUFNLEdBQUcsSUFBZjs7QUFDQSxNQUFNQyxRQUFRLEdBQUcsRUFBakI7O0FBQ0EsTUFBTUMsUUFBUSxHQUFJRixNQUFNLEdBQUdDLFFBQVYsR0FBc0IsQ0FBdkM7O0FBRUEsTUFBTUUsb0JBQWtDLEdBQUc7QUFDaERDLEVBQUFBLE1BQU0sRUFBRTtBQUNOQyxJQUFBQSxNQUFNLEVBQUU7QUFDTkMsTUFBQUEsS0FBSyxFQUFFO0FBREQsS0FERjtBQUlOQyxJQUFBQSxzQkFBc0IsRUFBRTtBQUN0QkQsTUFBQUEsS0FBSyxFQUFFO0FBRGUsS0FKbEI7QUFPTkUsSUFBQUEsUUFBUSxFQUFFO0FBQ1JGLE1BQUFBLEtBQUssRUFBRTtBQURDLEtBUEo7QUFVTkcsSUFBQUEsSUFBSSxFQUFFO0FBQ0pILE1BQUFBLEtBQUssRUFBRTtBQURILEtBVkE7QUFhTkksSUFBQUEsSUFBSSxFQUFFO0FBQ0pKLE1BQUFBLEtBQUssRUFBRTtBQURIO0FBYkEsR0FEd0M7QUFrQmhESyxFQUFBQSxpQkFBaUIsRUFBRTtBQUNqQk4sSUFBQUEsTUFBTSxFQUFFO0FBQ05DLE1BQUFBLEtBQUssRUFBRTtBQURELEtBRFM7QUFJakJHLElBQUFBLElBQUksRUFBRTtBQUNKSCxNQUFBQSxLQUFLLEVBQUU7QUFESCxLQUpXO0FBT2pCSSxJQUFBQSxJQUFJLEVBQUU7QUFDSkosTUFBQUEsS0FBSyxFQUFFO0FBREgsS0FQVztBQVVqQk0sSUFBQUEsTUFBTSxFQUFFO0FBQ05OLE1BQUFBLEtBQUssRUFBRTtBQURELEtBVlM7QUFhakJPLElBQUFBLE1BQU0sRUFBRTtBQUNOUCxNQUFBQSxLQUFLLEVBQUU7QUFERDtBQWJTLEdBbEI2QjtBQW1DaERRLEVBQUFBLGFBQWEsRUFBRTtBQUNiTCxJQUFBQSxJQUFJLEVBQUU7QUFDSkgsTUFBQUEsS0FBSyxFQUFFO0FBREg7QUFETyxHQW5DaUM7QUF3Q2hEUyxFQUFBQSxTQUFTLEVBQUU7QUFDVEMsSUFBQUEsR0FBRyxFQUFFO0FBQ0hSLE1BQUFBLFFBQVEsRUFBRTtBQUNSRixRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQLEtBREk7QUFNVFcsSUFBQUEsR0FBRyxFQUFFO0FBQ0hULE1BQUFBLFFBQVEsRUFBRTtBQUNSRixRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQO0FBTkksR0F4Q3FDO0FBb0RoRFksRUFBQUEsYUFBYSxFQUFFO0FBQ2JGLElBQUFBLEdBQUcsRUFBRTtBQUNIUixNQUFBQSxRQUFRLEVBQUU7QUFDUkYsUUFBQUEsS0FBSyxFQUFFO0FBREM7QUFEUCxLQURRO0FBTWJXLElBQUFBLEdBQUcsRUFBRTtBQUNIVCxNQUFBQSxRQUFRLEVBQUU7QUFDUkYsUUFBQUEsS0FBSyxFQUFFO0FBREM7QUFEUDtBQU5RLEdBcERpQztBQWdFaERhLEVBQUFBLFFBQVEsRUFBRTtBQUNSSCxJQUFBQSxHQUFHLEVBQUU7QUFDSFIsTUFBQUEsUUFBUSxFQUFFO0FBQ1JZLFFBQUFBLEtBQUssRUFBRTtBQURDO0FBRFAsS0FERztBQU1SSCxJQUFBQSxHQUFHLEVBQUU7QUFDSFQsTUFBQUEsUUFBUSxFQUFFO0FBQ1JZLFFBQUFBLEtBQUssRUFBRTtBQURDO0FBRFA7QUFORyxHQWhFc0M7QUE0RWhEQyxFQUFBQSxZQUFZLEVBQUU7QUFDWkMsSUFBQUEsR0FBRyxFQUFFO0FBQ0hkLE1BQUFBLFFBQVEsRUFBRTtBQUNSRixRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQO0FBRE87QUE1RWtDLENBQTNDOztBQXFGQSxNQUFNaUIsdUJBQXFDLEdBQUc7QUFDbkRuQixFQUFBQSxNQUFNLEVBQUU7QUFDTkMsSUFBQUEsTUFBTSxFQUFFO0FBQ05lLE1BQUFBLEtBQUssRUFBRSxDQUREO0FBRU5JLE1BQUFBLFlBQVksRUFBRSxDQUZSO0FBR05DLE1BQUFBLFVBQVUsRUFBRTtBQUhOLEtBREY7QUFNTmxCLElBQUFBLHNCQUFzQixFQUFFO0FBQ3RCYSxNQUFBQSxLQUFLLEVBQUUsQ0FEZTtBQUV0QkksTUFBQUEsWUFBWSxFQUFFLENBRlE7QUFHdEJDLE1BQUFBLFVBQVUsRUFBRTtBQUhVLEtBTmxCO0FBV05qQixJQUFBQSxRQUFRLEVBQUU7QUFDUlksTUFBQUEsS0FBSyxFQUFFLENBREM7QUFFUkksTUFBQUEsWUFBWSxFQUFFLENBRk47QUFHUkMsTUFBQUEsVUFBVSxFQUFFO0FBSEosS0FYSjtBQWdCTmhCLElBQUFBLElBQUksRUFBRTtBQUNKVyxNQUFBQSxLQUFLLEVBQUUsQ0FESDtBQUVKSSxNQUFBQSxZQUFZLEVBQUUsQ0FGVjtBQUdKQyxNQUFBQSxVQUFVLEVBQUU7QUFIUixLQWhCQTtBQXFCTmYsSUFBQUEsSUFBSSxFQUFFO0FBQ0pVLE1BQUFBLEtBQUssRUFBRSxDQURIO0FBRUpJLE1BQUFBLFlBQVksRUFBRSxDQUZWO0FBR0pDLE1BQUFBLFVBQVUsRUFBRTtBQUhSO0FBckJBLEdBRDJDO0FBNEJuRGQsRUFBQUEsaUJBQWlCLEVBQUU7QUFDakJOLElBQUFBLE1BQU0sRUFBRTtBQUNOZSxNQUFBQSxLQUFLLEVBQUUsQ0FERDtBQUVOSSxNQUFBQSxZQUFZLEVBQUUsQ0FGUjtBQUdOQyxNQUFBQSxVQUFVLEVBQUU7QUFITixLQURTO0FBTWpCaEIsSUFBQUEsSUFBSSxFQUFFO0FBQ0pXLE1BQUFBLEtBQUssRUFBRSxDQURIO0FBRUpJLE1BQUFBLFlBQVksRUFBRSxDQUZWO0FBR0pDLE1BQUFBLFVBQVUsRUFBRTtBQUhSLEtBTlc7QUFXakJmLElBQUFBLElBQUksRUFBRTtBQUNKVSxNQUFBQSxLQUFLLEVBQUUsQ0FESDtBQUVKSSxNQUFBQSxZQUFZLEVBQUUsQ0FGVjtBQUdKQyxNQUFBQSxVQUFVLEVBQUU7QUFIUixLQVhXO0FBZ0JqQmIsSUFBQUEsTUFBTSxFQUFFO0FBQ05RLE1BQUFBLEtBQUssRUFBRSxDQUREO0FBRU5JLE1BQUFBLFlBQVksRUFBRSxDQUZSO0FBR05DLE1BQUFBLFVBQVUsRUFBRTtBQUhOLEtBaEJTO0FBcUJqQlosSUFBQUEsTUFBTSxFQUFFO0FBQ05PLE1BQUFBLEtBQUssRUFBRSxDQUREO0FBRU5JLE1BQUFBLFlBQVksRUFBRSxDQUZSO0FBR05DLE1BQUFBLFVBQVUsRUFBRTtBQUhOO0FBckJTLEdBNUJnQztBQXVEbkRYLEVBQUFBLGFBQWEsRUFBRTtBQUNiTCxJQUFBQSxJQUFJLEVBQUU7QUFDSlcsTUFBQUEsS0FBSyxFQUFFLENBREg7QUFFSkksTUFBQUEsWUFBWSxFQUFFLENBRlY7QUFHSkMsTUFBQUEsVUFBVSxFQUFFO0FBSFI7QUFETyxHQXZEb0M7QUE4RG5EVixFQUFBQSxTQUFTLEVBQUU7QUFDVEMsSUFBQUEsR0FBRyxFQUFFO0FBQ0hSLE1BQUFBLFFBQVEsRUFBRTtBQUNSWSxRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQLEtBREk7QUFNVEgsSUFBQUEsR0FBRyxFQUFFO0FBQ0hULE1BQUFBLFFBQVEsRUFBRTtBQUNSWSxRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQO0FBTkksR0E5RHdDO0FBMEVuREYsRUFBQUEsYUFBYSxFQUFFO0FBQ2JGLElBQUFBLEdBQUcsRUFBRTtBQUNIUixNQUFBQSxRQUFRLEVBQUU7QUFDUlksUUFBQUEsS0FBSyxFQUFFO0FBREM7QUFEUCxLQURRO0FBTWJILElBQUFBLEdBQUcsRUFBRTtBQUNIVCxNQUFBQSxRQUFRLEVBQUU7QUFDUlksUUFBQUEsS0FBSyxFQUFFO0FBREM7QUFEUDtBQU5RLEdBMUVvQztBQXNGbkRELEVBQUFBLFFBQVEsRUFBRTtBQUNSSCxJQUFBQSxHQUFHLEVBQUU7QUFDSFIsTUFBQUEsUUFBUSxFQUFFO0FBQ1JZLFFBQUFBLEtBQUssRUFBRTtBQURDO0FBRFAsS0FERztBQU1SSCxJQUFBQSxHQUFHLEVBQUU7QUFDSFQsTUFBQUEsUUFBUSxFQUFFO0FBQ1JZLFFBQUFBLEtBQUssRUFBRTtBQURDO0FBRFA7QUFORyxHQXRGeUM7QUFrR25EQyxFQUFBQSxZQUFZLEVBQUU7QUFDWkMsSUFBQUEsR0FBRyxFQUFFO0FBQ0hkLE1BQUFBLFFBQVEsRUFBRTtBQUNSWSxRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQO0FBRE87QUFsR3FDLENBQTlDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBDb3VudGVyc1R5cGUgfSBmcm9tICcuL3R5cGVzJztcblxuZXhwb3J0IGVudW0gRk9STUFUIHtcbiAgcGRmID0gJ3BkZicsXG4gIHBuZyA9ICdwbmcnLFxuICBjc3YgPSAnY3N2Jyxcbn1cblxuZXhwb3J0IGVudW0gUkVQT1JUX1NUQVRFIHtcbiAgY3JlYXRlZCA9ICdDcmVhdGVkJyxcbiAgZXJyb3IgPSAnRXJyb3InLFxuICBwZW5kaW5nID0gJ1BlbmRpbmcnLFxuICBzaGFyZWQgPSAnU2hhcmVkJyxcbn1cblxuZXhwb3J0IGVudW0gUkVQT1JUX0RFRklOSVRJT05fU1RBVFVTIHtcbiAgYWN0aXZlID0gJ0FjdGl2ZScsXG4gIGRpc2FibGVkID0gJ0Rpc2FibGVkJyxcbn1cblxuZXhwb3J0IGVudW0gREVMSVZFUllfQ0hBTk5FTCB7XG4gIGVtYWlsID0gJ0VtYWlsJyxcbiAgc2xhY2sgPSAnU2xhY2snLFxuICBjaGltZSA9ICdDaGltZScsXG4gIG9wZW5zZWFyY2hEYXNoYm9hcmRzID0gJ09wZW5TZWFyY2ggRGFzaGJvYXJkcyB1c2VyJyxcbn1cblxuZXhwb3J0IGVudW0gU0NIRURVTEVfVFlQRSB7XG4gIHJlY3VycmluZyA9ICdSZWN1cnJpbmcnLFxuICBjcm9uID0gJ0Nyb24gYmFzZWQnLFxufVxuXG5leHBvcnQgZW51bSBSRVBPUlRfVFlQRSB7XG4gIHNhdmVkU2VhcmNoID0gJ1NhdmVkIHNlYXJjaCcsXG4gIGRhc2hib2FyZCA9ICdEYXNoYm9hcmQnLFxuICB2aXN1YWxpemF0aW9uID0gJ1Zpc3VhbGl6YXRpb24nLFxuICBub3RlYm9vayA9ICdOb3RlYm9vaycsXG59XG5cbmV4cG9ydCBlbnVtIERBVEFfUkVQT1JUX0NPTkZJRyB7XG4gIGV4Y2VsRGF0ZUZvcm1hdCA9ICdNTS9ERC9ZWVlZIGg6bW06c3MuU1NTIGEnLFxufVxuXG5leHBvcnQgZW51bSBUUklHR0VSX1RZUEUge1xuICBzY2hlZHVsZSA9ICdTY2hlZHVsZScsXG4gIG9uRGVtYW5kID0gJ09uIGRlbWFuZCcsXG59XG5cbmV4cG9ydCBlbnVtIERFTElWRVJZX1RZUEUge1xuICBvcGVuc2VhcmNoRGFzaGJvYXJkc1VzZXIgPSAnT3BlblNlYXJjaCBEYXNoYm9hcmRzIHVzZXInLFxuICBjaGFubmVsID0gJ0NoYW5uZWwnLFxufVxuXG5leHBvcnQgZW51bSBTRUxFQ1RPUiB7XG4gIGRhc2hib2FyZCA9ICcjZGFzaGJvYXJkVmlld3BvcnQnLFxuICB2aXN1YWxpemF0aW9uID0gJy52aXNFZGl0b3JfX2NvbnRlbnQnLFxuICBub3RlYm9vayA9ICcuZXVpUGFnZUJvZHknLFxufVxuXG4vLyBodHRwczovL3d3dy5lbGFzdGljLmNvL2d1aWRlL2VuL2VsYXN0aWNzZWFyY2gvcmVmZXJlbmNlLzYuOC9zZWFyY2gtcmVxdWVzdC1mcm9tLXNpemUuaHRtbFxuZXhwb3J0IGNvbnN0IERFRkFVTFRfTUFYX1NJWkUgPSAxMDAwMDtcblxuZXhwb3J0IGNvbnN0IERFRkFVTFRfUkVQT1JUX0hFQURFUiA9ICc8aDE+T3BlblNlYXJjaCBEYXNoYm9hcmRzIFJlcG9ydHM8L2gxPic7XG5cbmV4cG9ydCBjb25zdCBTRUNVUklUWV9DT05TVEFOVFMgPSB7XG4gIFRFTkFOVF9MT0NBTF9TVE9SQUdFX0tFWTogJ29wZW5kaXN0cm86OnNlY3VyaXR5Ojp0ZW5hbnQ6OnNob3dfcG9wdXAnLFxufTtcblxuZXhwb3J0IGNvbnN0IEVYVFJBX0hFQURFUlMgPSBbXG4gICdjb29raWUnLFxuICAneC1wcm94eS11c2VyJyxcbiAgJ3gtcHJveHktcm9sZXMnLFxuICAneC1mb3J3YXJkZWQtZm9yJyxcbl07XG5cbmV4cG9ydCBjb25zdCBDSFJPTUlVTV9QQVRIID0gYCR7X19kaXJuYW1lfS8uLi8uLi8uLi8uY2hyb21pdW0vaGVhZGxlc3Nfc2hlbGxgO1xuXG4vKipcbiAqIE1ldHJpYyBjb25zdGFudHNcbiAqL1xuZXhwb3J0IGNvbnN0IFdJTkRPVyA9IDM2MDA7XG5leHBvcnQgY29uc3QgSU5URVJWQUwgPSA2MDtcbmV4cG9ydCBjb25zdCBDQVBBQ0lUWSA9IChXSU5ET1cgLyBJTlRFUlZBTCkgKiAyO1xuXG5leHBvcnQgY29uc3QgR0xPQkFMX0JBU0lDX0NPVU5URVI6IENvdW50ZXJzVHlwZSA9IHtcbiAgcmVwb3J0OiB7XG4gICAgY3JlYXRlOiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICAgIGNyZWF0ZV9mcm9tX2RlZmluaXRpb246IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gICAgZG93bmxvYWQ6IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gICAgbGlzdDoge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgICBpbmZvOiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICB9LFxuICByZXBvcnRfZGVmaW5pdGlvbjoge1xuICAgIGNyZWF0ZToge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgICBsaXN0OiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICAgIGluZm86IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gICAgdXBkYXRlOiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICAgIGRlbGV0ZToge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgfSxcbiAgcmVwb3J0X3NvdXJjZToge1xuICAgIGxpc3Q6IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gIH0sXG4gIGRhc2hib2FyZDoge1xuICAgIHBkZjoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgdG90YWw6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gICAgcG5nOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICB0b3RhbDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAgdmlzdWFsaXphdGlvbjoge1xuICAgIHBkZjoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgdG90YWw6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gICAgcG5nOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICB0b3RhbDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAgbm90ZWJvb2s6IHtcbiAgICBwZGY6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIGNvdW50OiAwLFxuICAgICAgfSxcbiAgICB9LFxuICAgIHBuZzoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIHNhdmVkX3NlYXJjaDoge1xuICAgIGNzdjoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgdG90YWw6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG59O1xuXG5leHBvcnQgY29uc3QgREVGQVVMVF9ST0xMSU5HX0NPVU5URVI6IENvdW50ZXJzVHlwZSA9IHtcbiAgcmVwb3J0OiB7XG4gICAgY3JlYXRlOiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICBjcmVhdGVfZnJvbV9kZWZpbml0aW9uOiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICBkb3dubG9hZDoge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gICAgbGlzdDoge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gICAgaW5mbzoge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gIH0sXG4gIHJlcG9ydF9kZWZpbml0aW9uOiB7XG4gICAgY3JlYXRlOiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICBsaXN0OiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICBpbmZvOiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICB1cGRhdGU6IHtcbiAgICAgIGNvdW50OiAwLFxuICAgICAgc3lzdGVtX2Vycm9yOiAwLFxuICAgICAgdXNlcl9lcnJvcjogMCxcbiAgICB9LFxuICAgIGRlbGV0ZToge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gIH0sXG4gIHJlcG9ydF9zb3VyY2U6IHtcbiAgICBsaXN0OiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgfSxcbiAgZGFzaGJvYXJkOiB7XG4gICAgcGRmOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBwbmc6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIGNvdW50OiAwLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICB2aXN1YWxpemF0aW9uOiB7XG4gICAgcGRmOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBwbmc6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIGNvdW50OiAwLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICBub3RlYm9vazoge1xuICAgIHBkZjoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gICAgcG5nOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAgc2F2ZWRfc2VhcmNoOiB7XG4gICAgY3N2OiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbn07XG4iXX0=