from collections.abc import Mapping
from datetime import datetime, tzinfo
from typing import IO, Any
from typing_extensions import TypeAlias

from .isoparser import isoparse as isoparse, isoparser as isoparser

_FileOrStr: TypeAlias = bytes | str | IO[str] | IO[Any]

class parserinfo:
    JUMP: list[str]
    WEEKDAYS: list[tuple[str, ...]]
    MONTHS: list[tuple[str, ...]]
    HMS: list[tuple[str, str, str]]
    AMPM: list[tuple[str, str]]
    UTCZONE: list[str]
    PERTAIN: list[str]
    TZOFFSET: dict[str, int]
    def __init__(self, dayfirst: bool = ..., yearfirst: bool = ...) -> None: ...
    def jump(self, name: str) -> bool: ...
    def weekday(self, name: str) -> int | None: ...
    def month(self, name: str) -> int | None: ...
    def hms(self, name: str) -> int | None: ...
    def ampm(self, name: str) -> int | None: ...
    def pertain(self, name: str) -> bool: ...
    def utczone(self, name: str) -> bool: ...
    def tzoffset(self, name: str) -> int | None: ...
    def convertyear(self, year: int) -> int: ...
    def validate(self, res: datetime) -> bool: ...

class parser:
    def __init__(self, info: parserinfo | None = ...) -> None: ...
    def parse(
        self,
        timestr: _FileOrStr,
        default: datetime | None = ...,
        ignoretz: bool = ...,
        tzinfos: Mapping[str, tzinfo] | None = ...,
        **kwargs: Any,
    ) -> datetime: ...

DEFAULTPARSER: parser

def parse(timestr: _FileOrStr, parserinfo: parserinfo | None = ..., **kwargs: Any) -> datetime: ...

class _tzparser: ...

DEFAULTTZPARSER: _tzparser

class ParserError(ValueError): ...
