/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LightState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.PointLight;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SpotLight;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class SpotLightState
extends LightState {
    public SpotLightState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        Point3f point3f = new Point3f();
        ((PointLight)this.node).getAttenuation(point3f);
        this.control.writePoint3f(dataOutput, point3f);
        ((PointLight)this.node).getPosition(point3f);
        this.control.writePoint3f(dataOutput, point3f);
        Vector3f vector3f = new Vector3f();
        ((SpotLight)this.node).getDirection(vector3f);
        this.control.writeVector3f(dataOutput, vector3f);
        dataOutput.writeFloat(((SpotLight)this.node).getSpreadAngle());
        dataOutput.writeFloat(((SpotLight)this.node).getConcentration());
    }

    @Override
    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        if (this.control.getCurrentFileVersion() >= 5) {
            ((PointLight)this.node).setAttenuation(this.control.readPoint3f(dataInput));
            ((PointLight)this.node).setPosition(this.control.readPoint3f(dataInput));
        }
        ((SpotLight)this.node).setDirection(this.control.readVector3f(dataInput));
        ((SpotLight)this.node).setSpreadAngle(dataInput.readFloat());
        ((SpotLight)this.node).setConcentration(dataInput.readFloat());
    }

    @Override
    protected SceneGraphObject createNode() {
        return new SpotLight();
    }
}

