// third_party/blink/public/mojom/digital_goods/digital_goods.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-params-data.h"
namespace payments {
namespace mojom {

std::ostream& operator<<(std::ostream& os, BillingResponseCode value) {
  switch(value) {
    case BillingResponseCode::kOk:
      return os << "BillingResponseCode::kOk";
    case BillingResponseCode::kError:
      return os << "BillingResponseCode::kError";
    case BillingResponseCode::kItemAlreadyOwned:
      return os << "BillingResponseCode::kItemAlreadyOwned";
    case BillingResponseCode::kItemNotOwned:
      return os << "BillingResponseCode::kItemNotOwned";
    case BillingResponseCode::kItemUnavailable:
      return os << "BillingResponseCode::kItemUnavailable";
    case BillingResponseCode::kClientAppUnavailable:
      return os << "BillingResponseCode::kClientAppUnavailable";
    case BillingResponseCode::kClientAppError:
      return os << "BillingResponseCode::kClientAppError";
    default:
      return os << "Unknown BillingResponseCode value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, CreateDigitalGoodsResponseCode value) {
  switch(value) {
    case CreateDigitalGoodsResponseCode::kOk:
      return os << "CreateDigitalGoodsResponseCode::kOk";
    case CreateDigitalGoodsResponseCode::kError:
      return os << "CreateDigitalGoodsResponseCode::kError";
    case CreateDigitalGoodsResponseCode::kUnsupportedPaymentMethod:
      return os << "CreateDigitalGoodsResponseCode::kUnsupportedPaymentMethod";
    case CreateDigitalGoodsResponseCode::kUnsupportedContext:
      return os << "CreateDigitalGoodsResponseCode::kUnsupportedContext";
    default:
      return os << "Unknown CreateDigitalGoodsResponseCode value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool ItemDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ItemDetails_Data* object = static_cast<const ItemDetails_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams item_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->item_id, validation_context,
                                         &item_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams title_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams description_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->price, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->price, validation_context))
    return false;

  return true;
}

ItemDetails_Data::ItemDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoods_GetDetails_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoods_GetDetails_Params_Data* object = static_cast<const DigitalGoods_GetDetails_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item_ids, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams item_ids_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->item_ids, validation_context,
                                         &item_ids_validate_params)) {
    return false;
  }

  return true;
}

DigitalGoods_GetDetails_Params_Data::DigitalGoods_GetDetails_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoods_GetDetails_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoods_GetDetails_ResponseParams_Data* object = static_cast<const DigitalGoods_GetDetails_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::payments::mojom::internal::BillingResponseCode_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item_details_list, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams item_details_list_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->item_details_list, validation_context,
                                         &item_details_list_validate_params)) {
    return false;
  }

  return true;
}

DigitalGoods_GetDetails_ResponseParams_Data::DigitalGoods_GetDetails_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoods_Acknowledge_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoods_Acknowledge_Params_Data* object = static_cast<const DigitalGoods_Acknowledge_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->purchase_token, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams purchase_token_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->purchase_token, validation_context,
                                         &purchase_token_validate_params)) {
    return false;
  }

  return true;
}

DigitalGoods_Acknowledge_Params_Data::DigitalGoods_Acknowledge_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoods_Acknowledge_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoods_Acknowledge_ResponseParams_Data* object = static_cast<const DigitalGoods_Acknowledge_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::payments::mojom::internal::BillingResponseCode_Data
        ::Validate(object->code, validation_context))
    return false;

  return true;
}

DigitalGoods_Acknowledge_ResponseParams_Data::DigitalGoods_Acknowledge_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoodsFactory_CreateDigitalGoods_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoodsFactory_CreateDigitalGoods_Params_Data* object = static_cast<const DigitalGoodsFactory_CreateDigitalGoods_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->payment_method, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams payment_method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->payment_method, validation_context,
                                         &payment_method_validate_params)) {
    return false;
  }

  return true;
}

DigitalGoodsFactory_CreateDigitalGoods_Params_Data::DigitalGoodsFactory_CreateDigitalGoods_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data* object = static_cast<const DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::payments::mojom::internal::CreateDigitalGoodsResponseCode_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->digital_goods,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace payments