/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class SimpleDigest {
    private static final String[] HASH_ALGOS = new String[]{"SHA-1", "MD5"};
    private MessageDigest digest;
    private long hash;

    SimpleDigest() {
        for (String hashAlgo : HASH_ALGOS) {
            try {
                this.digest = MessageDigest.getInstance(hashAlgo);
                this.hash = 0L;
                break;
            }
            catch (NoSuchAlgorithmException ne) {
                this.digest = null;
                this.hash = 13L;
            }
        }
    }

    public void update(String data2) {
        if (data2 == null || data2.length() <= 0) {
            return;
        }
        if (this.digest != null) {
            this.digest.update(data2.getBytes(StandardCharsets.UTF_8));
        } else {
            this.hash = this.hash * 31L + (long)data2.hashCode();
        }
    }

    public String digest() {
        if (this.digest != null) {
            byte[] bytes2;
            StringBuilder buffer2 = new StringBuilder(64);
            for (byte aByte : bytes2 = this.digest.digest()) {
                int b = aByte & 0xFF;
                if (b < 16) {
                    buffer2.append('0');
                }
                buffer2.append(Integer.toHexString(b));
            }
            return buffer2.toString();
        }
        return Long.toHexString(this.hash);
    }
}

