/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.transformer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.graph.transformer.ConflictIdSorter;
import org.eclipse.aether.util.graph.transformer.TransformationContextKeys;

public final class ConflictResolver
implements DependencyGraphTransformer {
    public static final String CONFIG_PROP_VERBOSE = "aether.conflictResolver.verbose";
    public static final String NODE_DATA_WINNER = "conflict.winner";
    public static final String NODE_DATA_ORIGINAL_SCOPE = "conflict.originalScope";
    public static final String NODE_DATA_ORIGINAL_OPTIONALITY = "conflict.originalOptionality";
    private final VersionSelector versionSelector;
    private final ScopeSelector scopeSelector;
    private final ScopeDeriver scopeDeriver;
    private final OptionalitySelector optionalitySelector;

    public ConflictResolver(VersionSelector versionSelector, ScopeSelector scopeSelector, OptionalitySelector optionalitySelector, ScopeDeriver scopeDeriver) {
        this.versionSelector = Objects.requireNonNull(versionSelector, "version selector cannot be null");
        this.scopeSelector = Objects.requireNonNull(scopeSelector, "scope selector cannot be null");
        this.optionalitySelector = Objects.requireNonNull(optionalitySelector, "optionality selector cannot be null");
        this.scopeDeriver = Objects.requireNonNull(scopeDeriver, "scope deriver cannot be null");
    }

    @Override
    public DependencyNode transformGraph(DependencyNode node2, DependencyGraphTransformationContext context) throws RepositoryException {
        List sortedConflictIds = (List)context.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        if (sortedConflictIds == null) {
            ConflictIdSorter sorter = new ConflictIdSorter();
            sorter.transformGraph(node2, context);
            sortedConflictIds = (List)context.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        }
        Map stats = (Map)context.get(TransformationContextKeys.STATS);
        long time1 = System.nanoTime();
        Collection conflictIdCycles = (Collection)context.get(TransformationContextKeys.CYCLIC_CONFLICT_IDS);
        if (conflictIdCycles == null) {
            throw new RepositoryException("conflict id cycles have not been identified");
        }
        Map conflictIds = (Map)context.get(TransformationContextKeys.CONFLICT_IDS);
        if (conflictIds == null) {
            throw new RepositoryException("conflict groups have not been identified");
        }
        HashMap cyclicPredecessors = new HashMap();
        for (Collection cycle2 : conflictIdCycles) {
            for (Object conflictId : cycle2) {
                HashSet predecessors = (HashSet)cyclicPredecessors.get(conflictId);
                if (predecessors == null) {
                    predecessors = new HashSet();
                    cyclicPredecessors.put(conflictId, predecessors);
                }
                predecessors.addAll(cycle2);
            }
        }
        State state = new State(node2, conflictIds, sortedConflictIds.size(), context);
        Iterator it = sortedConflictIds.iterator();
        while (it.hasNext()) {
            Object conflictId = it.next();
            state.prepare(conflictId, (Collection)cyclicPredecessors.get(conflictId));
            this.gatherConflictItems(node2, state);
            state.finish();
            if (!state.items.isEmpty()) {
                ConflictContext ctx2 = state.conflictCtx;
                state.versionSelector.selectVersion(ctx2);
                if (ctx2.winner == null) {
                    throw new RepositoryException("conflict resolver did not select winner among " + state.items);
                }
                DependencyNode winner = ctx2.winner.node;
                state.scopeSelector.selectScope(ctx2);
                if (state.verbose) {
                    winner.setData(NODE_DATA_ORIGINAL_SCOPE, winner.getDependency().getScope());
                }
                winner.setScope(ctx2.scope);
                state.optionalitySelector.selectOptionality(ctx2);
                if (state.verbose) {
                    winner.setData(NODE_DATA_ORIGINAL_OPTIONALITY, winner.getDependency().isOptional());
                }
                winner.setOptional(ctx2.optional);
                this.removeLosers(state);
            }
            state.winner();
            if (it.hasNext() || conflictIdCycles.isEmpty() || state.conflictCtx.winner == null) continue;
            DependencyNode winner = state.conflictCtx.winner.node;
            state.prepare(state, null);
            this.gatherConflictItems(winner, state);
        }
        if (stats != null) {
            long time2 = System.nanoTime();
            stats.put("ConflictResolver.totalTime", time2 - time1);
            stats.put("ConflictResolver.conflictItemCount", state.totalConflictItems);
        }
        return node2;
    }

    private boolean gatherConflictItems(DependencyNode node2, State state) throws RepositoryException {
        Object conflictId = state.conflictIds.get(node2);
        if (state.currentId.equals(conflictId)) {
            state.add(node2);
        } else {
            if (state.loser(node2, conflictId)) {
                return false;
            }
            if (state.push(node2, conflictId)) {
                Iterator<DependencyNode> it = node2.getChildren().iterator();
                while (it.hasNext()) {
                    DependencyNode child = it.next();
                    if (this.gatherConflictItems(child, state)) continue;
                    it.remove();
                }
                state.pop();
            }
        }
        return true;
    }

    private void removeLosers(State state) {
        ConflictItem winner = state.conflictCtx.winner;
        List<DependencyNode> previousParent = null;
        ListIterator<DependencyNode> childIt = null;
        boolean conflictVisualized = false;
        block0: for (ConflictItem item : state.items) {
            if (item == winner) continue;
            if (item.parent != previousParent) {
                childIt = item.parent.listIterator();
                previousParent = item.parent;
                conflictVisualized = false;
            }
            while (childIt.hasNext()) {
                DependencyNode child = childIt.next();
                if (child != item.node) continue;
                if (state.verbose && !conflictVisualized && item.parent != winner.parent) {
                    conflictVisualized = true;
                    DefaultDependencyNode loser = new DefaultDependencyNode(child);
                    loser.setData(NODE_DATA_WINNER, winner.node);
                    loser.setData(NODE_DATA_ORIGINAL_SCOPE, loser.getDependency().getScope());
                    loser.setData(NODE_DATA_ORIGINAL_OPTIONALITY, loser.getDependency().isOptional());
                    loser.setScope(item.getScopes().iterator().next());
                    loser.setChildren(Collections.emptyList());
                    childIt.set(loser);
                    continue block0;
                }
                childIt.remove();
                continue block0;
            }
        }
    }

    public static abstract class OptionalitySelector {
        public OptionalitySelector getInstance(DependencyNode root2, DependencyGraphTransformationContext context) throws RepositoryException {
            return this;
        }

        public abstract void selectOptionality(ConflictContext var1) throws RepositoryException;
    }

    public static abstract class ScopeDeriver {
        public ScopeDeriver getInstance(DependencyNode root2, DependencyGraphTransformationContext context) throws RepositoryException {
            return this;
        }

        public abstract void deriveScope(ScopeContext var1) throws RepositoryException;
    }

    public static abstract class ScopeSelector {
        public ScopeSelector getInstance(DependencyNode root2, DependencyGraphTransformationContext context) throws RepositoryException {
            return this;
        }

        public abstract void selectScope(ConflictContext var1) throws RepositoryException;
    }

    public static abstract class VersionSelector {
        public VersionSelector getInstance(DependencyNode root2, DependencyGraphTransformationContext context) throws RepositoryException {
            return this;
        }

        public abstract void selectVersion(ConflictContext var1) throws RepositoryException;
    }

    public static final class ConflictContext {
        final DependencyNode root;
        final Map<?, ?> conflictIds;
        final Collection<ConflictItem> items;
        Object conflictId;
        ConflictItem winner;
        String scope;
        Boolean optional;

        ConflictContext(DependencyNode root2, Map<?, ?> conflictIds, Collection<ConflictItem> items) {
            this.root = root2;
            this.conflictIds = conflictIds;
            this.items = Collections.unmodifiableCollection(items);
        }

        public ConflictContext(DependencyNode root2, Object conflictId, Map<DependencyNode, Object> conflictIds, Collection<ConflictItem> items) {
            this(root2, conflictIds, items);
            this.conflictId = conflictId;
        }

        public DependencyNode getRoot() {
            return this.root;
        }

        public boolean isIncluded(DependencyNode node2) {
            return this.conflictId.equals(this.conflictIds.get(node2));
        }

        public Collection<ConflictItem> getItems() {
            return this.items;
        }

        public ConflictItem getWinner() {
            return this.winner;
        }

        public void setWinner(ConflictItem winner) {
            this.winner = winner;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public Boolean getOptional() {
            return this.optional;
        }

        public void setOptional(Boolean optional) {
            this.optional = optional;
        }

        public String toString() {
            return this.winner + " @ " + this.scope + " < " + this.items;
        }
    }

    public static final class ConflictItem {
        final List<DependencyNode> parent;
        final Artifact artifact;
        final DependencyNode node;
        int depth;
        Object scopes;
        int optionalities;
        public static final int OPTIONAL_FALSE = 1;
        public static final int OPTIONAL_TRUE = 2;

        ConflictItem(DependencyNode parent, DependencyNode node2, String scope, boolean optional) {
            if (parent != null) {
                this.parent = parent.getChildren();
                this.artifact = parent.getArtifact();
            } else {
                this.parent = null;
                this.artifact = null;
            }
            this.node = node2;
            this.scopes = scope;
            this.optionalities = optional ? 2 : 1;
        }

        public ConflictItem(DependencyNode parent, DependencyNode node2, int depth, int optionalities, String ... scopes) {
            this.parent = parent != null ? parent.getChildren() : null;
            this.artifact = parent != null ? parent.getArtifact() : null;
            this.node = node2;
            this.depth = depth;
            this.optionalities = optionalities;
            this.scopes = Arrays.asList(scopes);
        }

        public boolean isSibling(ConflictItem item) {
            return this.parent == item.parent;
        }

        public DependencyNode getNode() {
            return this.node;
        }

        public Dependency getDependency() {
            return this.node.getDependency();
        }

        public int getDepth() {
            return this.depth;
        }

        public Collection<String> getScopes() {
            if (this.scopes instanceof String) {
                return Collections.singleton((String)this.scopes);
            }
            return (Collection)this.scopes;
        }

        void addScope(String scope) {
            if (this.scopes instanceof Collection) {
                ((Collection)this.scopes).add(scope);
            } else if (!this.scopes.equals(scope)) {
                HashSet<Object> set2 = new HashSet<Object>();
                set2.add(this.scopes);
                set2.add(scope);
                this.scopes = set2;
            }
        }

        public int getOptionalities() {
            return this.optionalities;
        }

        void addOptional(boolean optional) {
            this.optionalities |= optional ? 2 : 1;
        }

        public String toString() {
            return this.node + " @ " + this.depth + " < " + this.artifact;
        }
    }

    public static final class ScopeContext {
        String parentScope;
        String childScope;
        String derivedScope;

        public ScopeContext(String parentScope, String childScope) {
            this.parentScope = parentScope != null ? parentScope : "";
            this.derivedScope = childScope != null ? childScope : "";
            this.childScope = childScope != null ? childScope : "";
        }

        public String getParentScope() {
            return this.parentScope;
        }

        public String getChildScope() {
            return this.childScope;
        }

        public String getDerivedScope() {
            return this.derivedScope;
        }

        public void setDerivedScope(String derivedScope) {
            this.derivedScope = derivedScope != null ? derivedScope : "";
        }
    }

    final class State {
        Object currentId;
        int totalConflictItems;
        final boolean verbose;
        final Map<Object, DependencyNode> resolvedIds;
        final Collection<Object> potentialAncestorIds;
        final Map<?, ?> conflictIds;
        final List<ConflictItem> items;
        final Map<List<DependencyNode>, NodeInfo> infos;
        final Map<List<DependencyNode>, Object> stack;
        final List<DependencyNode> parentNodes;
        final List<String> parentScopes;
        final List<Boolean> parentOptionals;
        final List<NodeInfo> parentInfos;
        final ConflictContext conflictCtx;
        final ScopeContext scopeCtx;
        final VersionSelector versionSelector;
        final ScopeSelector scopeSelector;
        final ScopeDeriver scopeDeriver;
        final OptionalitySelector optionalitySelector;

        State(DependencyNode root2, Map<?, ?> conflictIds, int conflictIdCount, DependencyGraphTransformationContext context) throws RepositoryException {
            this.conflictIds = conflictIds;
            this.verbose = ConfigUtils.getBoolean(context.getSession(), false, ConflictResolver.CONFIG_PROP_VERBOSE);
            this.potentialAncestorIds = new HashSet<Object>(conflictIdCount * 2);
            this.resolvedIds = new HashMap<Object, DependencyNode>(conflictIdCount * 2);
            this.items = new ArrayList<ConflictItem>(256);
            this.infos = new IdentityHashMap<List<DependencyNode>, NodeInfo>(64);
            this.stack = new IdentityHashMap<List<DependencyNode>, Object>(64);
            this.parentNodes = new ArrayList<DependencyNode>(64);
            this.parentScopes = new ArrayList<String>(64);
            this.parentOptionals = new ArrayList<Boolean>(64);
            this.parentInfos = new ArrayList<NodeInfo>(64);
            this.conflictCtx = new ConflictContext(root2, conflictIds, this.items);
            this.scopeCtx = new ScopeContext(null, null);
            this.versionSelector = ConflictResolver.this.versionSelector.getInstance(root2, context);
            this.scopeSelector = ConflictResolver.this.scopeSelector.getInstance(root2, context);
            this.scopeDeriver = ConflictResolver.this.scopeDeriver.getInstance(root2, context);
            this.optionalitySelector = ConflictResolver.this.optionalitySelector.getInstance(root2, context);
        }

        void prepare(Object conflictId, Collection<Object> cyclicPredecessors) {
            this.currentId = conflictId;
            this.conflictCtx.conflictId = conflictId;
            this.conflictCtx.winner = null;
            this.conflictCtx.scope = null;
            this.conflictCtx.optional = null;
            this.items.clear();
            this.infos.clear();
            if (cyclicPredecessors != null) {
                this.potentialAncestorIds.addAll(cyclicPredecessors);
            }
        }

        void finish() {
            List<DependencyNode> previousParent = null;
            int previousDepth = 0;
            this.totalConflictItems += this.items.size();
            for (int i = this.items.size() - 1; i >= 0; --i) {
                ConflictItem item = this.items.get(i);
                if (item.parent == previousParent) {
                    item.depth = previousDepth;
                    continue;
                }
                if (item.parent == null) continue;
                previousParent = item.parent;
                NodeInfo info2 = this.infos.get(previousParent);
                item.depth = previousDepth = info2.minDepth + 1;
            }
            this.potentialAncestorIds.add(this.currentId);
        }

        void winner() {
            this.resolvedIds.put(this.currentId, this.conflictCtx.winner != null ? this.conflictCtx.winner.node : null);
        }

        boolean loser(DependencyNode node2, Object conflictId) {
            DependencyNode winner = this.resolvedIds.get(conflictId);
            return winner != null && winner != node2;
        }

        boolean push(DependencyNode node2, Object conflictId) throws RepositoryException {
            List<DependencyNode> graphNode;
            if (conflictId == null) {
                if (node2.getDependency() != null) {
                    if (node2.getData().get(ConflictResolver.NODE_DATA_WINNER) != null) {
                        return false;
                    }
                    throw new RepositoryException("missing conflict id for node " + node2);
                }
            } else if (!this.potentialAncestorIds.contains(conflictId)) {
                return false;
            }
            if (this.stack.put(graphNode = node2.getChildren(), Boolean.TRUE) != null) {
                return false;
            }
            int depth = this.depth();
            String scope = this.deriveScope(node2, conflictId);
            boolean optional = this.deriveOptional(node2, conflictId);
            NodeInfo info2 = this.infos.get(graphNode);
            if (info2 == null) {
                info2 = new NodeInfo(depth, scope, optional);
                this.infos.put(graphNode, info2);
                this.parentInfos.add(info2);
                this.parentNodes.add(node2);
                this.parentScopes.add(scope);
                this.parentOptionals.add(optional);
            } else {
                int changes = info2.update(depth, scope, optional);
                if (changes == 0) {
                    this.stack.remove(graphNode);
                    return false;
                }
                this.parentInfos.add(null);
                this.parentNodes.add(node2);
                this.parentScopes.add(scope);
                this.parentOptionals.add(optional);
                if (info2.children != null) {
                    ConflictItem item;
                    int i;
                    if ((changes & 1) != 0) {
                        for (i = info2.children.size() - 1; i >= 0; --i) {
                            item = info2.children.get(i);
                            String childScope = this.deriveScope(item.node, null);
                            item.addScope(childScope);
                        }
                    }
                    if ((changes & 2) != 0) {
                        for (i = info2.children.size() - 1; i >= 0; --i) {
                            item = info2.children.get(i);
                            boolean childOptional = this.deriveOptional(item.node, null);
                            item.addOptional(childOptional);
                        }
                    }
                }
            }
            return true;
        }

        void pop() {
            int last = this.parentInfos.size() - 1;
            this.parentInfos.remove(last);
            this.parentScopes.remove(last);
            this.parentOptionals.remove(last);
            DependencyNode node2 = this.parentNodes.remove(last);
            this.stack.remove(node2.getChildren());
        }

        void add(DependencyNode node2) throws RepositoryException {
            DependencyNode parent = this.parent();
            if (parent == null) {
                ConflictItem item = this.newConflictItem(parent, node2);
                this.items.add(item);
            } else {
                NodeInfo info2 = this.parentInfos.get(this.parentInfos.size() - 1);
                if (info2 != null) {
                    ConflictItem item = this.newConflictItem(parent, node2);
                    info2.add(item);
                    this.items.add(item);
                }
            }
        }

        private ConflictItem newConflictItem(DependencyNode parent, DependencyNode node2) throws RepositoryException {
            return new ConflictItem(parent, node2, this.deriveScope(node2, null), this.deriveOptional(node2, null));
        }

        private int depth() {
            return this.parentNodes.size();
        }

        private DependencyNode parent() {
            int size = this.parentNodes.size();
            return size <= 0 ? null : this.parentNodes.get(size - 1);
        }

        private String deriveScope(DependencyNode node2, Object conflictId) throws RepositoryException {
            if ((node2.getManagedBits() & 2) != 0 || conflictId != null && this.resolvedIds.containsKey(conflictId)) {
                return this.scope(node2.getDependency());
            }
            int depth = this.parentNodes.size();
            this.scopes(depth, node2.getDependency());
            if (depth > 0) {
                this.scopeDeriver.deriveScope(this.scopeCtx);
            }
            return this.scopeCtx.derivedScope;
        }

        private void scopes(int parent, Dependency child) {
            this.scopeCtx.parentScope = parent > 0 ? this.parentScopes.get(parent - 1) : null;
            this.scopeCtx.derivedScope = this.scope(child);
            this.scopeCtx.childScope = this.scope(child);
        }

        private String scope(Dependency dependency) {
            return dependency != null ? dependency.getScope() : null;
        }

        private boolean deriveOptional(DependencyNode node2, Object conflictId) {
            boolean optional;
            Dependency dep = node2.getDependency();
            boolean bl = optional = dep != null && dep.isOptional();
            if (optional || (node2.getManagedBits() & 4) != 0 || conflictId != null && this.resolvedIds.containsKey(conflictId)) {
                return optional;
            }
            int depth = this.parentNodes.size();
            return depth > 0 ? this.parentOptionals.get(depth - 1) : false;
        }
    }

    static final class NodeInfo {
        int minDepth;
        Object derivedScopes;
        int derivedOptionalities;
        List<ConflictItem> children;
        static final int CHANGE_SCOPE = 1;
        static final int CHANGE_OPTIONAL = 2;
        private static final int OPT_FALSE = 1;
        private static final int OPT_TRUE = 2;

        NodeInfo(int depth, String derivedScope, boolean optional) {
            this.minDepth = depth;
            this.derivedScopes = derivedScope;
            this.derivedOptionalities = optional ? 2 : 1;
        }

        int update(int depth, String derivedScope, boolean optional) {
            int bit;
            int changes;
            if (depth < this.minDepth) {
                this.minDepth = depth;
            }
            if (this.derivedScopes.equals(derivedScope)) {
                changes = 0;
            } else if (this.derivedScopes instanceof Collection) {
                changes = ((Collection)this.derivedScopes).add(derivedScope) ? 1 : 0;
            } else {
                HashSet<String> scopes = new HashSet<String>();
                scopes.add((String)this.derivedScopes);
                scopes.add(derivedScope);
                this.derivedScopes = scopes;
                changes = 1;
            }
            int n = bit = optional ? 2 : 1;
            if ((this.derivedOptionalities & bit) == 0) {
                this.derivedOptionalities |= bit;
                changes |= 2;
            }
            return changes;
        }

        void add(ConflictItem item) {
            if (this.children == null) {
                this.children = new ArrayList<ConflictItem>(1);
            }
            this.children.add(item);
        }
    }
}

