"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEnvOptions = void 0;
function getEnvOptions(options = {}) {
    return {
        configs: options.configs || [],
        cliArgs: {
            dev: true,
            quiet: false,
            silent: false,
            watch: false,
            repl: false,
            basePath: false,
            disableOptimizer: true,
            cache: true,
            dist: false,
            runExamples: false,
            ...(options.cliArgs || {}),
        },
        isDevClusterMaster: options.isDevClusterMaster !== undefined ? options.isDevClusterMaster : false,
    };
}
exports.getEnvOptions = getEnvOptions;
