"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MONITOR_BASE_API = exports.EMAIL_GROUP_BASE_API = exports.EMAIL_ACCOUNT_BASE_API = exports.DESTINATION_BASE_API = exports.DEFAULT_HEADERS = exports.CLUSTER = exports.API_ROUTE_PREFIX = exports.AD_BASE_API = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const API_ROUTE_PREFIX = '/_plugins/_alerting';
exports.API_ROUTE_PREFIX = API_ROUTE_PREFIX;
const MONITOR_BASE_API = `${API_ROUTE_PREFIX}/monitors`;
exports.MONITOR_BASE_API = MONITOR_BASE_API;
const AD_BASE_API = `/_plugins/_anomaly_detection/detectors`;
exports.AD_BASE_API = AD_BASE_API;
const DESTINATION_BASE_API = `${API_ROUTE_PREFIX}/destinations`;
exports.DESTINATION_BASE_API = DESTINATION_BASE_API;
const EMAIL_ACCOUNT_BASE_API = `${DESTINATION_BASE_API}/email_accounts`;
exports.EMAIL_ACCOUNT_BASE_API = EMAIL_ACCOUNT_BASE_API;
const EMAIL_GROUP_BASE_API = `${DESTINATION_BASE_API}/email_groups`;
exports.EMAIL_GROUP_BASE_API = EMAIL_GROUP_BASE_API;
const DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json',
  'User-Agent': 'OpenSearch-Dashboards'
};
exports.DEFAULT_HEADERS = DEFAULT_HEADERS;
const CLUSTER = {
  ADMIN: 'admin',
  ALERTING: 'opensearch_alerting',
  AD_ALERTING: 'alerting_ad',
  DATA: 'data'
};
exports.CLUSTER = CLUSTER;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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