"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.YamlCodeLens = void 0;
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
const commands_1 = require("../../commands");
const yaml_documents_1 = require("../parser/yaml-documents");
const vscode_uri_1 = require("vscode-uri");
const path = require("path");
const schemaUrls_1 = require("../utils/schemaUrls");
const objects_1 = require("../utils/objects");
class YamlCodeLens {
    constructor(schemaService, telemetry) {
        this.schemaService = schemaService;
        this.telemetry = telemetry;
    }
    getCodeLens(document) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = [];
            try {
                const yamlDocument = yaml_documents_1.yamlDocumentsCache.getYamlDocument(document);
                let schemaUrls = new Map();
                for (const currentYAMLDoc of yamlDocument.documents) {
                    const schema = yield this.schemaService.getSchemaForResource(document.uri, currentYAMLDoc);
                    if (schema === null || schema === void 0 ? void 0 : schema.schema) {
                        // merge schemas from all docs to avoid duplicates
                        schemaUrls = new Map([...schemaUrls_1.getSchemaUrls(schema === null || schema === void 0 ? void 0 : schema.schema), ...schemaUrls]);
                    }
                }
                for (const urlToSchema of schemaUrls) {
                    const lens = vscode_languageserver_types_1.CodeLens.create(vscode_languageserver_types_1.Range.create(0, 0, 0, 0));
                    lens.command = {
                        title: getCommandTitle(urlToSchema[0], urlToSchema[1]),
                        command: commands_1.YamlCommands.JUMP_TO_SCHEMA,
                        arguments: [urlToSchema[0]],
                    };
                    result.push(lens);
                }
            }
            catch (err) {
                this.telemetry.sendError('yaml.codeLens.error', { error: objects_1.convertErrorToTelemetryMsg(err) });
            }
            return result;
        });
    }
    resolveCodeLens(param) {
        return param;
    }
}
exports.YamlCodeLens = YamlCodeLens;
function getCommandTitle(url, schema) {
    const uri = vscode_uri_1.URI.parse(url);
    let baseName = path.basename(uri.fsPath);
    if (!path.extname(uri.fsPath)) {
        baseName += '.json';
    }
    if (Object.getOwnPropertyDescriptor(schema, 'name')) {
        return Object.getOwnPropertyDescriptor(schema, 'name').value + ` (${baseName})`;
    }
    else if (schema.title) {
        return schema.title + ` (${baseName})`;
    }
    return baseName;
}
//# sourceMappingURL=yamlCodeLens.js.map