// third_party/blink/public/mojom/loader/content_security_notifier.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/loader/content_security_notifier.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/loader/content_security_notifier.mojom-params-data.h"
#include "third_party/blink/public/mojom/loader/content_security_notifier.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/loader/content_security_notifier.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_CONTENT_SECURITY_NOTIFIER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_CONTENT_SECURITY_NOTIFIER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char ContentSecurityNotifier::Name_[] = "blink.mojom.ContentSecurityNotifier";

ContentSecurityNotifierProxy::ContentSecurityNotifierProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContentSecurityNotifierProxy::NotifyContentWithCertificateErrorsRan(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ContentSecurityNotifier::NotifyContentWithCertificateErrorsRan");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentSecurityNotifier::Name_);
  message.set_method_name("NotifyContentWithCertificateErrorsRan");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ContentSecurityNotifierProxy::NotifyContentWithCertificateErrorsDisplayed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ContentSecurityNotifier::NotifyContentWithCertificateErrorsDisplayed");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentSecurityNotifier::Name_);
  message.set_method_name("NotifyContentWithCertificateErrorsDisplayed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ContentSecurityNotifierProxy::NotifyInsecureContentRan(
    const ::GURL& in_origin, const ::GURL& in_insecure_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ContentSecurityNotifier::NotifyInsecureContentRan", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::GURL&>"));
      raw_value->SetString("insecure_url", base::trace_event::ValueToString(in_insecure_url, "<value of type const ::GURL&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentSecurityNotifier_NotifyInsecureContentRan_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ContentSecurityNotifier_NotifyInsecureContentRan_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in ContentSecurityNotifier.NotifyInsecureContentRan request");
  typename decltype(params->insecure_url)::BaseType::BufferWriter
      insecure_url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_insecure_url, buffer, &insecure_url_writer, &serialization_context);
  params->insecure_url.Set(
      insecure_url_writer.is_null() ? nullptr : insecure_url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->insecure_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null insecure_url in ContentSecurityNotifier.NotifyInsecureContentRan request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentSecurityNotifier::Name_);
  message.set_method_name("NotifyInsecureContentRan");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ContentSecurityNotifierStubDispatch::Accept(
    ContentSecurityNotifier* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ContentSecurityNotifier::NotifyContentWithCertificateErrorsRan",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ContentSecurityNotifier::NotifyContentWithCertificateErrorsRan");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params_Data* params =
          reinterpret_cast<internal::ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentSecurityNotifier::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyContentWithCertificateErrorsRan();
      return true;
    }
    case internal::kContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ContentSecurityNotifier::NotifyContentWithCertificateErrorsDisplayed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ContentSecurityNotifier::NotifyContentWithCertificateErrorsDisplayed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params_Data* params =
          reinterpret_cast<internal::ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentSecurityNotifier::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyContentWithCertificateErrorsDisplayed();
      return true;
    }
    case internal::kContentSecurityNotifier_NotifyInsecureContentRan_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ContentSecurityNotifier::NotifyInsecureContentRan",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ContentSecurityNotifier::NotifyInsecureContentRan");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ContentSecurityNotifier_NotifyInsecureContentRan_Params_Data* params =
          reinterpret_cast<internal::ContentSecurityNotifier_NotifyInsecureContentRan_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_origin{};
      ::GURL p_insecure_url{};
      ContentSecurityNotifier_NotifyInsecureContentRan_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadInsecureUrl(&p_insecure_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentSecurityNotifier::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyInsecureContentRan(
std::move(p_origin), 
std::move(p_insecure_url));
      return true;
    }
  }
  return false;
}

// static
bool ContentSecurityNotifierStubDispatch::AcceptWithResponder(
    ContentSecurityNotifier* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Name: {
      break;
    }
    case internal::kContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Name: {
      break;
    }
    case internal::kContentSecurityNotifier_NotifyInsecureContentRan_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kContentSecurityNotifierValidationInfo[] = {
    {&internal::ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ContentSecurityNotifier_NotifyInsecureContentRan_Params_Data::Validate,
     nullptr /* no response */},
};

bool ContentSecurityNotifierRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ContentSecurityNotifier::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kContentSecurityNotifierValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif