// cc/mojom/render_frame_metadata.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "cc/mojom/render_frame_metadata.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "cc/mojom/render_frame_metadata.mojom-params-data.h"
namespace cc {
namespace mojom {

namespace internal {


// static
bool DelegatedInkBrowserMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DelegatedInkBrowserMetadata_Data* object = static_cast<const DelegatedInkBrowserMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DelegatedInkBrowserMetadata_Data::DelegatedInkBrowserMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderFrameMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 120, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RenderFrameMetadata_Data* object = static_cast<const RenderFrameMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->root_scroll_offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selection, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->selection, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->delegated_ink_metadata, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewport_size_in_pixels, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->viewport_size_in_pixels, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->local_surface_id, validation_context))
    return false;


  if (!::viz::mojom::internal::VerticalScrollDirection_Data
        ::Validate(object->new_vertical_scroll_direction, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scrollable_viewport_size, 22, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scrollable_viewport_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_layer_size, 23, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_layer_size, validation_context))
    return false;

  return true;
}

RenderFrameMetadata_Data::RenderFrameMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data* object = static_cast<const RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data::RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data* object = static_cast<const RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data::RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data* object = static_cast<const RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data::RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace cc
