// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   chrome/common/extensions/api/enterprise_hardware_platform.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "chrome/common/extensions/api/enterprise_hardware_platform.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace enterprise_hardware_platform {
//
// Types
//

HardwarePlatformInfo::HardwarePlatformInfo()
 {}

HardwarePlatformInfo::~HardwarePlatformInfo() = default;
HardwarePlatformInfo::HardwarePlatformInfo(HardwarePlatformInfo&& rhs) = default;
HardwarePlatformInfo& HardwarePlatformInfo::operator=(HardwarePlatformInfo&& rhs) = default;
// static
bool HardwarePlatformInfo::Populate(
    const base::Value& value, HardwarePlatformInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* model_value = dict->FindKey("model");
  if (!model_value) {
    return false;
  }
  {
    auto* temp = model_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->model = *temp;
  }

  const base::Value* manufacturer_value = dict->FindKey("manufacturer");
  if (!manufacturer_value) {
    return false;
  }
  {
    auto* temp = manufacturer_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->manufacturer = *temp;
  }

  return true;
}

// static
std::unique_ptr<HardwarePlatformInfo> HardwarePlatformInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<HardwarePlatformInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> HardwarePlatformInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("model", std::make_unique<base::Value>(this->model));

  to_value_result->SetWithoutPathExpansion("manufacturer", std::make_unique<base::Value>(this->manufacturer));


  return to_value_result;
}



//
// Functions
//

namespace GetHardwarePlatformInfo {

std::vector<base::Value> Results::Create(const HardwarePlatformInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}
}  // namespace GetHardwarePlatformInfo

}  // namespace enterprise_hardware_platform
}  // namespace api
}  // namespace extensions

