// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   chrome/common/extensions/api/webrtc_logging_private.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "chrome/common/extensions/api/webrtc_logging_private.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace webrtc_logging_private {
//
// Types
//

MetaDataEntry::MetaDataEntry()
 {}

MetaDataEntry::~MetaDataEntry() = default;
MetaDataEntry::MetaDataEntry(MetaDataEntry&& rhs) = default;
MetaDataEntry& MetaDataEntry::operator=(MetaDataEntry&& rhs) = default;
// static
bool MetaDataEntry::Populate(
    const base::Value& value, MetaDataEntry* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* key_value = dict->FindKey("key");
  if (!key_value) {
    return false;
  }
  {
    auto* temp = key_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->key = *temp;
  }

  const base::Value* value_value = dict->FindKey("value");
  if (!value_value) {
    return false;
  }
  {
    auto* temp = value_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->value = *temp;
  }

  return true;
}

// static
std::unique_ptr<MetaDataEntry> MetaDataEntry::FromValue(const base::Value& value) {
  auto out = std::make_unique<MetaDataEntry>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> MetaDataEntry::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("key", std::make_unique<base::Value>(this->key));

  to_value_result->SetWithoutPathExpansion("value", std::make_unique<base::Value>(this->value));


  return to_value_result;
}


UploadResult::UploadResult()
 {}

UploadResult::~UploadResult() = default;
UploadResult::UploadResult(UploadResult&& rhs) = default;
UploadResult& UploadResult::operator=(UploadResult&& rhs) = default;
// static
bool UploadResult::Populate(
    const base::Value& value, UploadResult* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* report_id_value = dict->FindKey("reportId");
  if (!report_id_value) {
    return false;
  }
  {
    auto* temp = report_id_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->report_id = *temp;
  }

  return true;
}

// static
std::unique_ptr<UploadResult> UploadResult::FromValue(const base::Value& value) {
  auto out = std::make_unique<UploadResult>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> UploadResult::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("reportId", std::make_unique<base::Value>(this->report_id));


  return to_value_result;
}


RequestInfo::RequestInfo()
 {}

RequestInfo::~RequestInfo() = default;
RequestInfo::RequestInfo(RequestInfo&& rhs) = default;
RequestInfo& RequestInfo::operator=(RequestInfo&& rhs) = default;
// static
bool RequestInfo::Populate(
    const base::Value& value, RequestInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* tab_id_value = dict->FindKey("tabId");
  if (tab_id_value) {
    {
      auto temp = tab_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->tab_id.reset();
        return false;
      }
      out->tab_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* guest_process_id_value = dict->FindKey("guestProcessId");
  if (guest_process_id_value) {
    {
      auto temp = guest_process_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->guest_process_id.reset();
        return false;
      }
      out->guest_process_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* target_webview_value = dict->FindKey("targetWebview");
  if (target_webview_value) {
    {
      auto temp = target_webview_value->GetIfBool();
      if (!temp.has_value()) {
        out->target_webview.reset();
        return false;
      }
      out->target_webview = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<RequestInfo> RequestInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<RequestInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> RequestInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->tab_id.get()) {
    to_value_result->SetWithoutPathExpansion("tabId", std::make_unique<base::Value>(*this->tab_id));

  }
  if (this->guest_process_id.get()) {
    to_value_result->SetWithoutPathExpansion("guestProcessId", std::make_unique<base::Value>(*this->guest_process_id));

  }
  if (this->target_webview.get()) {
    to_value_result->SetWithoutPathExpansion("targetWebview", std::make_unique<base::Value>(*this->target_webview));

  }

  return to_value_result;
}


RecordingInfo::RecordingInfo()
: did_stop(false),
did_manual_stop(false) {}

RecordingInfo::~RecordingInfo() = default;
RecordingInfo::RecordingInfo(RecordingInfo&& rhs) = default;
RecordingInfo& RecordingInfo::operator=(RecordingInfo&& rhs) = default;
// static
bool RecordingInfo::Populate(
    const base::Value& value, RecordingInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* prefix_path_value = dict->FindKey("prefixPath");
  if (!prefix_path_value) {
    return false;
  }
  {
    auto* temp = prefix_path_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->prefix_path = *temp;
  }

  const base::Value* did_stop_value = dict->FindKey("didStop");
  if (!did_stop_value) {
    return false;
  }
  {
    auto temp = did_stop_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->did_stop = temp.value();
  }

  const base::Value* did_manual_stop_value = dict->FindKey("didManualStop");
  if (!did_manual_stop_value) {
    return false;
  }
  {
    auto temp = did_manual_stop_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->did_manual_stop = temp.value();
  }

  return true;
}

// static
std::unique_ptr<RecordingInfo> RecordingInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<RecordingInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> RecordingInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("prefixPath", std::make_unique<base::Value>(this->prefix_path));

  to_value_result->SetWithoutPathExpansion("didStop", std::make_unique<base::Value>(this->did_stop));

  to_value_result->SetWithoutPathExpansion("didManualStop", std::make_unique<base::Value>(this->did_manual_stop));


  return to_value_result;
}


StartEventLoggingResult::StartEventLoggingResult()
 {}

StartEventLoggingResult::~StartEventLoggingResult() = default;
StartEventLoggingResult::StartEventLoggingResult(StartEventLoggingResult&& rhs) = default;
StartEventLoggingResult& StartEventLoggingResult::operator=(StartEventLoggingResult&& rhs) = default;
// static
bool StartEventLoggingResult::Populate(
    const base::Value& value, StartEventLoggingResult* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* log_id_value = dict->FindKey("logId");
  if (!log_id_value) {
    return false;
  }
  {
    auto* temp = log_id_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->log_id = *temp;
  }

  return true;
}

// static
std::unique_ptr<StartEventLoggingResult> StartEventLoggingResult::FromValue(const base::Value& value) {
  auto out = std::make_unique<StartEventLoggingResult>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> StartEventLoggingResult::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("logId", std::make_unique<base::Value>(this->log_id));


  return to_value_result;
}



//
// Functions
//

namespace SetMetaData {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* meta_data_value = nullptr;
  if (args.Get(2, &meta_data_value) &&
      !meta_data_value->is_none()) {
    {
      const base::ListValue* list = nullptr;
      if (!meta_data_value->GetAsList(&list)) {
        return std::unique_ptr<Params>();
      }
      else {
        if (!json_schema_compiler::util::PopulateArrayFromList(*list, &params->meta_data)) {
          return std::unique_ptr<Params>();
        }
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace SetMetaData

namespace Start {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace Start

namespace SetUploadOnRenderClose {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* should_upload_value = nullptr;
  if (args.Get(2, &should_upload_value) &&
      !should_upload_value->is_none()) {
    {
      auto temp = should_upload_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->should_upload = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetUploadOnRenderClose

namespace Stop {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace Stop

namespace Store {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* log_id_value = nullptr;
  if (args.Get(2, &log_id_value) &&
      !log_id_value->is_none()) {
    {
      auto* temp = log_id_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->log_id = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace Store

namespace UploadStored {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* log_id_value = nullptr;
  if (args.Get(2, &log_id_value) &&
      !log_id_value->is_none()) {
    {
      auto* temp = log_id_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->log_id = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const UploadResult& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((result).ToValue()));

  return create_results;
}
}  // namespace UploadStored

namespace Upload {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const UploadResult& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((result).ToValue()));

  return create_results;
}
}  // namespace Upload

namespace Discard {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace Discard

namespace StartRtpDump {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 4) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* incoming_value = nullptr;
  if (args.Get(2, &incoming_value) &&
      !incoming_value->is_none()) {
    {
      auto temp = incoming_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->incoming = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* outgoing_value = nullptr;
  if (args.Get(3, &outgoing_value) &&
      !outgoing_value->is_none()) {
    {
      auto temp = outgoing_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->outgoing = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace StartRtpDump

namespace StopRtpDump {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 4) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* incoming_value = nullptr;
  if (args.Get(2, &incoming_value) &&
      !incoming_value->is_none()) {
    {
      auto temp = incoming_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->incoming = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* outgoing_value = nullptr;
  if (args.Get(3, &outgoing_value) &&
      !outgoing_value->is_none()) {
    {
      auto temp = outgoing_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->outgoing = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace StopRtpDump

namespace StartAudioDebugRecordings {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* seconds_value = nullptr;
  if (args.Get(2, &seconds_value) &&
      !seconds_value->is_none()) {
    {
      auto temp = seconds_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->seconds = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const RecordingInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}
}  // namespace StartAudioDebugRecordings

namespace StopAudioDebugRecordings {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const RecordingInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}
}  // namespace StopAudioDebugRecordings

namespace StartEventLogging {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 6) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* security_origin_value = nullptr;
  if (args.Get(1, &security_origin_value) &&
      !security_origin_value->is_none()) {
    {
      auto* temp = security_origin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->security_origin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* session_id_value = nullptr;
  if (args.Get(2, &session_id_value) &&
      !session_id_value->is_none()) {
    {
      auto* temp = session_id_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->session_id = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* max_log_size_bytes_value = nullptr;
  if (args.Get(3, &max_log_size_bytes_value) &&
      !max_log_size_bytes_value->is_none()) {
    {
      auto temp = max_log_size_bytes_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->max_log_size_bytes = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* output_period_ms_value = nullptr;
  if (args.Get(4, &output_period_ms_value) &&
      !output_period_ms_value->is_none()) {
    {
      auto temp = output_period_ms_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->output_period_ms = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* web_app_id_value = nullptr;
  if (args.Get(5, &web_app_id_value) &&
      !web_app_id_value->is_none()) {
    {
      auto temp = web_app_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->web_app_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const StartEventLoggingResult& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((result).ToValue()));

  return create_results;
}
}  // namespace StartEventLogging

namespace GetLogsDirectory {

Results::Entry::Entry()
 {}

Results::Entry::~Entry() = default;
Results::Entry::Entry(Entry&& rhs) = default;
Results::Entry& Results::Entry::operator=(Entry&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Results::Entry::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->MergeDictionary(&additional_properties);

  return to_value_result;
}


std::vector<base::Value> Results::Create(const Entry& entry) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((entry).ToValue()));

  return create_results;
}
}  // namespace GetLogsDirectory

}  // namespace webrtc_logging_private
}  // namespace api
}  // namespace extensions

