// components/autofill/core/common/mojom/autofill_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/autofill/core/common/mojom/autofill_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/autofill/core/common/mojom/autofill_types.mojom-params-data.h"
namespace autofill {
namespace mojom {

static NOINLINE const char* SubmissionIndicatorEventToStringHelper(SubmissionIndicatorEvent value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SubmissionIndicatorEvent::NONE:
      return "NONE";
    case SubmissionIndicatorEvent::HTML_FORM_SUBMISSION:
      return "HTML_FORM_SUBMISSION";
    case SubmissionIndicatorEvent::SAME_DOCUMENT_NAVIGATION:
      return "SAME_DOCUMENT_NAVIGATION";
    case SubmissionIndicatorEvent::XHR_SUCCEEDED:
      return "XHR_SUCCEEDED";
    case SubmissionIndicatorEvent::FRAME_DETACHED:
      return "FRAME_DETACHED";
    case SubmissionIndicatorEvent::DOM_MUTATION_AFTER_XHR:
      return "DOM_MUTATION_AFTER_XHR";
    case SubmissionIndicatorEvent::PROVISIONALLY_SAVED_FORM_ON_START_PROVISIONAL_LOAD:
      return "PROVISIONALLY_SAVED_FORM_ON_START_PROVISIONAL_LOAD";
    case SubmissionIndicatorEvent::PROBABLE_FORM_SUBMISSION:
      return "PROBABLE_FORM_SUBMISSION";
    case SubmissionIndicatorEvent::CHANGE_PASSWORD_FORM_CLEARED:
      return "CHANGE_PASSWORD_FORM_CLEARED";
    default:
      return nullptr;
  }
}

std::string SubmissionIndicatorEventToString(SubmissionIndicatorEvent value) {
  const char *str = SubmissionIndicatorEventToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SubmissionIndicatorEvent value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SubmissionIndicatorEvent value) {
  return os << SubmissionIndicatorEventToString(value);
}

static NOINLINE const char* SubmissionSourceToStringHelper(SubmissionSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SubmissionSource::NONE:
      return "NONE";
    case SubmissionSource::SAME_DOCUMENT_NAVIGATION:
      return "SAME_DOCUMENT_NAVIGATION";
    case SubmissionSource::XHR_SUCCEEDED:
      return "XHR_SUCCEEDED";
    case SubmissionSource::FRAME_DETACHED:
      return "FRAME_DETACHED";
    case SubmissionSource::DOM_MUTATION_AFTER_XHR:
      return "DOM_MUTATION_AFTER_XHR";
    case SubmissionSource::PROBABLY_FORM_SUBMITTED:
      return "PROBABLY_FORM_SUBMITTED";
    case SubmissionSource::FORM_SUBMISSION:
      return "FORM_SUBMISSION";
    default:
      return nullptr;
  }
}

std::string SubmissionSourceToString(SubmissionSource value) {
  const char *str = SubmissionSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SubmissionSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SubmissionSource value) {
  return os << SubmissionSourceToString(value);
}

static NOINLINE const char* FocusedFieldTypeToStringHelper(FocusedFieldType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FocusedFieldType::kUnknown:
      return "kUnknown";
    case FocusedFieldType::kUnfillableElement:
      return "kUnfillableElement";
    case FocusedFieldType::kFillableTextArea:
      return "kFillableTextArea";
    case FocusedFieldType::kFillableSearchField:
      return "kFillableSearchField";
    case FocusedFieldType::kFillableNonSearchField:
      return "kFillableNonSearchField";
    case FocusedFieldType::kFillableUsernameField:
      return "kFillableUsernameField";
    case FocusedFieldType::kFillablePasswordField:
      return "kFillablePasswordField";
    default:
      return nullptr;
  }
}

std::string FocusedFieldTypeToString(FocusedFieldType value) {
  const char *str = FocusedFieldTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FocusedFieldType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FocusedFieldType value) {
  return os << FocusedFieldTypeToString(value);
}

static NOINLINE const char* ButtonTitleTypeToStringHelper(ButtonTitleType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ButtonTitleType::NONE:
      return "NONE";
    case ButtonTitleType::BUTTON_ELEMENT_SUBMIT_TYPE:
      return "BUTTON_ELEMENT_SUBMIT_TYPE";
    case ButtonTitleType::BUTTON_ELEMENT_BUTTON_TYPE:
      return "BUTTON_ELEMENT_BUTTON_TYPE";
    case ButtonTitleType::INPUT_ELEMENT_SUBMIT_TYPE:
      return "INPUT_ELEMENT_SUBMIT_TYPE";
    case ButtonTitleType::INPUT_ELEMENT_BUTTON_TYPE:
      return "INPUT_ELEMENT_BUTTON_TYPE";
    case ButtonTitleType::HYPERLINK:
      return "HYPERLINK";
    case ButtonTitleType::DIV:
      return "DIV";
    case ButtonTitleType::SPAN:
      return "SPAN";
    default:
      return nullptr;
  }
}

std::string ButtonTitleTypeToString(ButtonTitleType value) {
  const char *str = ButtonTitleTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ButtonTitleType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ButtonTitleType value) {
  return os << ButtonTitleTypeToString(value);
}

static NOINLINE const char* AutofillStateToStringHelper(AutofillState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AutofillState::kNoSuggestions:
      return "kNoSuggestions";
    case AutofillState::kAutofillAvailable:
      return "kAutofillAvailable";
    case AutofillState::kAutocompleteAvailable:
      return "kAutocompleteAvailable";
    default:
      return nullptr;
  }
}

std::string AutofillStateToString(AutofillState value) {
  const char *str = AutofillStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AutofillState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AutofillState value) {
  return os << AutofillStateToString(value);
}

static NOINLINE const char* RendererFormDataActionToStringHelper(RendererFormDataAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RendererFormDataAction::kFill:
      return "kFill";
    case RendererFormDataAction::kPreview:
      return "kPreview";
    default:
      return nullptr;
  }
}

std::string RendererFormDataActionToString(RendererFormDataAction value) {
  const char *str = RendererFormDataActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RendererFormDataAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RendererFormDataAction value) {
  return os << RendererFormDataActionToString(value);
}

static NOINLINE const char* FormFieldData_CheckStatusToStringHelper(FormFieldData_CheckStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FormFieldData_CheckStatus::kNotCheckable:
      return "kNotCheckable";
    case FormFieldData_CheckStatus::kCheckableButUnchecked:
      return "kCheckableButUnchecked";
    case FormFieldData_CheckStatus::kChecked:
      return "kChecked";
    default:
      return nullptr;
  }
}

std::string FormFieldData_CheckStatusToString(FormFieldData_CheckStatus value) {
  const char *str = FormFieldData_CheckStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FormFieldData_CheckStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FormFieldData_CheckStatus value) {
  return os << FormFieldData_CheckStatusToString(value);
}

static NOINLINE const char* FormFieldData_RoleAttributeToStringHelper(FormFieldData_RoleAttribute value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FormFieldData_RoleAttribute::kPresentation:
      return "kPresentation";
    case FormFieldData_RoleAttribute::kOther:
      return "kOther";
    default:
      return nullptr;
  }
}

std::string FormFieldData_RoleAttributeToString(FormFieldData_RoleAttribute value) {
  const char *str = FormFieldData_RoleAttributeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FormFieldData_RoleAttribute value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FormFieldData_RoleAttribute value) {
  return os << FormFieldData_RoleAttributeToString(value);
}

static NOINLINE const char* FormFieldData_LabelSourceToStringHelper(FormFieldData_LabelSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FormFieldData_LabelSource::kUnknown:
      return "kUnknown";
    case FormFieldData_LabelSource::kLabelTag:
      return "kLabelTag";
    case FormFieldData_LabelSource::kPTag:
      return "kPTag";
    case FormFieldData_LabelSource::kDivTable:
      return "kDivTable";
    case FormFieldData_LabelSource::kTdTag:
      return "kTdTag";
    case FormFieldData_LabelSource::kDdTag:
      return "kDdTag";
    case FormFieldData_LabelSource::kLiTag:
      return "kLiTag";
    case FormFieldData_LabelSource::kPlaceHolder:
      return "kPlaceHolder";
    case FormFieldData_LabelSource::kAriaLabel:
      return "kAriaLabel";
    case FormFieldData_LabelSource::kCombined:
      return "kCombined";
    case FormFieldData_LabelSource::kValue:
      return "kValue";
    default:
      return nullptr;
  }
}

std::string FormFieldData_LabelSourceToString(FormFieldData_LabelSource value) {
  const char *str = FormFieldData_LabelSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FormFieldData_LabelSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FormFieldData_LabelSource value) {
  return os << FormFieldData_LabelSourceToString(value);
}

namespace internal {


// static
bool FrameToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameToken_Data* object = static_cast<const FrameToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  return true;
}

FrameToken_Data::FrameToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameTokenWithPredecessor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameTokenWithPredecessor_Data* object = static_cast<const FrameTokenWithPredecessor_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  return true;
}

FrameTokenWithPredecessor_Data::FrameTokenWithPredecessor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormRendererId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FormRendererId_Data* object = static_cast<const FormRendererId_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FormRendererId_Data::FormRendererId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FieldRendererId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FieldRendererId_Data* object = static_cast<const FieldRendererId_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FieldRendererId_Data::FieldRendererId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SelectOption_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SelectOption_Data* object = static_cast<const SelectOption_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->content, validation_context))
    return false;

  return true;
}

SelectOption_Data::SelectOption_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormFieldData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 200, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FormFieldData_Data* object = static_cast<const FormFieldData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->label, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id_attribute, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id_attribute, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name_attribute, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name_attribute, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_control_type, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams form_control_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->form_control_type, validation_context,
                                         &form_control_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->autocomplete_attribute, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams autocomplete_attribute_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->autocomplete_attribute, validation_context,
                                         &autocomplete_attribute_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->placeholder, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->placeholder, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->css_classes, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->css_classes, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aria_label, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aria_label, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aria_description, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aria_description, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->unique_renderer_id, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->unique_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_form_id, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host_form_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->section, 18, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams section_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->section, validation_context,
                                         &section_validate_params)) {
    return false;
  }


  if (!::autofill::mojom::internal::FormFieldData_CheckStatus_Data
        ::Validate(object->check_status, validation_context))
    return false;


  if (!::autofill::mojom::internal::FormFieldData_RoleAttribute_Data
        ::Validate(object->role, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::TextDirection_Data
        ::Validate(object->text_direction, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_input, 26, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->user_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 27, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams options_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->options, validation_context,
                                         &options_validate_params)) {
    return false;
  }


  if (!::autofill::mojom::internal::FormFieldData_LabelSource_Data
        ::Validate(object->label_source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 29, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->datalist_values, 30, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams datalist_values_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->datalist_values, validation_context,
                                         &datalist_values_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->datalist_labels, 31, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams datalist_labels_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->datalist_labels, validation_context,
                                         &datalist_labels_validate_params)) {
    return false;
  }

  return true;
}

FormFieldData_Data::FormFieldData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ButtonTitleInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ButtonTitleInfo_Data* object = static_cast<const ButtonTitleInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;


  if (!::autofill::mojom::internal::ButtonTitleType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

ButtonTitleInfo_Data::ButtonTitleInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FormData_Data* object = static_cast<const FormData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id_attribute, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id_attribute, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name_attribute, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name_attribute, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->button_titles, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams button_titles_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->button_titles, validation_context,
                                         &button_titles_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->full_url, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->full_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_frame_origin, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_frame_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->unique_renderer_id, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->unique_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->child_frames, 12, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams child_frames_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->child_frames, validation_context,
                                         &child_frames_validate_params)) {
    return false;
  }


  if (!::autofill::mojom::internal::SubmissionIndicatorEvent_Data
        ::Validate(object->submission_event, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fields, 14, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fields_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->fields, validation_context,
                                         &fields_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username_predictions, 15, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams username_predictions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->username_predictions, validation_context,
                                         &username_predictions_validate_params)) {
    return false;
  }

  return true;
}

FormData_Data::FormData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormFieldDataPredictions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FormFieldDataPredictions_Data* object = static_cast<const FormFieldDataPredictions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_form_signature, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_form_signature_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host_form_signature, validation_context,
                                         &host_form_signature_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams signature_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->heuristic_type, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams heuristic_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->heuristic_type, validation_context,
                                         &heuristic_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->server_type, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams server_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->server_type, validation_context,
                                         &server_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->overall_type, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams overall_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->overall_type, validation_context,
                                         &overall_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parseable_name, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams parseable_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->parseable_name, validation_context,
                                         &parseable_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->section, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams section_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->section, validation_context,
                                         &section_validate_params)) {
    return false;
  }

  return true;
}

FormFieldDataPredictions_Data::FormFieldDataPredictions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormDataPredictions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FormDataPredictions_Data* object = static_cast<const FormDataPredictions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams signature_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fields, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fields_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->fields, validation_context,
                                         &fields_validate_params)) {
    return false;
  }

  return true;
}

FormDataPredictions_Data::FormDataPredictions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordAndMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PasswordAndMetadata_Data* object = static_cast<const PasswordAndMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->realm, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams realm_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->realm, validation_context,
                                         &realm_validate_params)) {
    return false;
  }

  return true;
}

PasswordAndMetadata_Data::PasswordAndMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordFormFillData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PasswordFormFillData_Data* object = static_cast<const PasswordFormFillData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_renderer_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username_field, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username_field, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password_field, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password_field, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->preferred_realm, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams preferred_realm_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->preferred_realm, validation_context,
                                         &preferred_realm_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_logins, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams additional_logins_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->additional_logins, validation_context,
                                         &additional_logins_validate_params)) {
    return false;
  }

  return true;
}

PasswordFormFillData_Data::PasswordFormFillData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordFormGenerationData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PasswordFormGenerationData_Data* object = static_cast<const PasswordFormGenerationData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_password_renderer_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_password_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->confirmation_password_renderer_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->confirmation_password_renderer_id, validation_context))
    return false;

  return true;
}

PasswordFormGenerationData_Data::PasswordFormGenerationData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordGenerationUIData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PasswordGenerationUIData_Data* object = static_cast<const PasswordGenerationUIData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->generation_element, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->generation_element, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->generation_element_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->generation_element_id, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::TextDirection_Data
        ::Validate(object->text_direction, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_data, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_data, validation_context))
    return false;

  return true;
}

PasswordGenerationUIData_Data::PasswordGenerationUIData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ParsingResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ParsingResult_Data* object = static_cast<const ParsingResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username_renderer_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password_renderer_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_password_renderer_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_password_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->confirm_password_renderer_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->confirm_password_renderer_id, validation_context))
    return false;

  return true;
}

ParsingResult_Data::ParsingResult_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace autofill

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::SubmissionIndicatorEvent>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::SubmissionIndicatorEvent value) {
  return std::move(context).WriteString(::autofill::mojom::SubmissionIndicatorEventToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::SubmissionSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::SubmissionSource value) {
  return std::move(context).WriteString(::autofill::mojom::SubmissionSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FocusedFieldType>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::FocusedFieldType value) {
  return std::move(context).WriteString(::autofill::mojom::FocusedFieldTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::ButtonTitleType>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::ButtonTitleType value) {
  return std::move(context).WriteString(::autofill::mojom::ButtonTitleTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::AutofillState>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::AutofillState value) {
  return std::move(context).WriteString(::autofill::mojom::AutofillStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::RendererFormDataAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::RendererFormDataAction value) {
  return std::move(context).WriteString(::autofill::mojom::RendererFormDataActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FormFieldData_CheckStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::FormFieldData_CheckStatus value) {
  return std::move(context).WriteString(::autofill::mojom::FormFieldData_CheckStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FormFieldData_RoleAttribute>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::FormFieldData_RoleAttribute value) {
  return std::move(context).WriteString(::autofill::mojom::FormFieldData_RoleAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FormFieldData_LabelSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::FormFieldData_LabelSource value) {
  return std::move(context).WriteString(::autofill::mojom::FormFieldData_LabelSourceToString(value));
}

} // namespace perfetto
