// components/performance_manager/public/mojom/v8_contexts.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/performance_manager/public/mojom/v8_contexts.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/performance_manager/public/mojom/v8_contexts.mojom-params-data.h"
namespace performance_manager {
namespace mojom {

static NOINLINE const char* V8ContextWorldTypeToStringHelper(V8ContextWorldType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case V8ContextWorldType::kMain:
      return "kMain";
    case V8ContextWorldType::kWorkerOrWorklet:
      return "kWorkerOrWorklet";
    case V8ContextWorldType::kExtension:
      return "kExtension";
    case V8ContextWorldType::kIsolated:
      return "kIsolated";
    case V8ContextWorldType::kInspector:
      return "kInspector";
    case V8ContextWorldType::kRegExp:
      return "kRegExp";
    default:
      return nullptr;
  }
}

std::string V8ContextWorldTypeToString(V8ContextWorldType value) {
  const char *str = V8ContextWorldTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown V8ContextWorldType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, V8ContextWorldType value) {
  return os << V8ContextWorldTypeToString(value);
}

namespace internal {


// static
bool IframeAttributionData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IframeAttributionData_Data* object = static_cast<const IframeAttributionData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams src_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->src, validation_context,
                                         &src_validate_params)) {
    return false;
  }

  return true;
}

IframeAttributionData_Data::IframeAttributionData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool V8ContextDescription_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const V8ContextDescription_Data* object = static_cast<const V8ContextDescription_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;


  if (!::performance_manager::mojom::internal::V8ContextWorldType_Data
        ::Validate(object->world_type, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams world_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->world_name, validation_context,
                                         &world_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->execution_context_token, validation_context))
    return false;

  return true;
}

V8ContextDescription_Data::V8ContextDescription_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace performance_manager

namespace perfetto {

// static
void TraceFormatTraits<::performance_manager::mojom::V8ContextWorldType>::WriteIntoTrace(
   perfetto::TracedValue context, ::performance_manager::mojom::V8ContextWorldType value) {
  return std::move(context).WriteString(::performance_manager::mojom::V8ContextWorldTypeToString(value));
}

} // namespace perfetto
