// components/services/app_service/public/mojom/app_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/app_service/public/mojom/app_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/app_service/public/mojom/app_service.mojom-params-data.h"
#include "components/services/app_service/public/mojom/app_service.mojom-shared-message-ids.h"

#include "components/services/app_service/public/mojom/app_service.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_APP_SERVICE_PUBLIC_MOJOM_APP_SERVICE_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_APP_SERVICE_PUBLIC_MOJOM_APP_SERVICE_MOJOM_JUMBO_H_
#endif
namespace apps {
namespace mojom {
ConnectOptions::ConnectOptions() {}

ConnectOptions::~ConnectOptions() = default;
size_t ConnectOptions::Hash(size_t seed) const {
  return seed;
}

void ConnectOptions::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
}

bool ConnectOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char AppService::Name_[] = "apps.mojom.AppService";

class AppService_LoadIcon_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AppService_LoadIcon_ForwardToCallback(
      AppService::LoadIconCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AppService::LoadIconCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AppService_LoadIcon_ForwardToCallback);
};

class AppService_GetMenuModel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AppService_GetMenuModel_ForwardToCallback(
      AppService::GetMenuModelCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AppService::GetMenuModelCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AppService_GetMenuModel_ForwardToCallback);
};

AppServiceProxy::AppServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AppServiceProxy::RegisterPublisher(
    ::mojo::PendingRemote<Publisher> in_publisher, ::apps::mojom::AppType in_app_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::RegisterPublisher", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("publisher"), in_publisher,
                        "<value of type ::mojo::PendingRemote<Publisher>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_RegisterPublisher_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_RegisterPublisher_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::apps::mojom::PublisherInterfaceBase>>(
      in_publisher, &params->publisher, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->publisher),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid publisher in AppService.RegisterPublisher request");
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("RegisterPublisher");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::RegisterSubscriber(
    ::mojo::PendingRemote<Subscriber> in_subscriber, ConnectOptionsPtr in_opts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::RegisterSubscriber", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscriber"), in_subscriber,
                        "<value of type ::mojo::PendingRemote<Subscriber>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opts"), in_opts,
                        "<value of type ConnectOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_RegisterSubscriber_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_RegisterSubscriber_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::apps::mojom::SubscriberInterfaceBase>>(
      in_subscriber, &params->subscriber, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->subscriber),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid subscriber in AppService.RegisterSubscriber request");
  mojo::internal::MessageFragment<
      typename decltype(params->opts)::BaseType> opts_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::ConnectOptionsDataView>(
      in_opts, opts_fragment);
  params->opts.Set(
      opts_fragment.is_null() ? nullptr : opts_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("RegisterSubscriber");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::LoadIcon(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id, ::apps::mojom::IconKeyPtr in_icon_key, ::apps::mojom::IconType in_icon_type, int32_t in_size_hint_in_dip, bool in_allow_placeholder_icon, LoadIconCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::LoadIcon", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon_key"), in_icon_key,
                        "<value of type ::apps::mojom::IconKeyPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon_type"), in_icon_type,
                        "<value of type ::apps::mojom::IconType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size_hint_in_dip"), in_size_hint_in_dip,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_placeholder_icon"), in_allow_placeholder_icon,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_LoadIcon_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_LoadIcon_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.LoadIcon request");
  mojo::internal::MessageFragment<
      typename decltype(params->icon_key)::BaseType> icon_key_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IconKeyDataView>(
      in_icon_key, icon_key_fragment);
  params->icon_key.Set(
      icon_key_fragment.is_null() ? nullptr : icon_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->icon_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon_key in AppService.LoadIcon request");
  mojo::internal::Serialize<::apps::mojom::IconType>(
      in_icon_type, &params->icon_type);
  params->size_hint_in_dip = in_size_hint_in_dip;
  params->allow_placeholder_icon = in_allow_placeholder_icon;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("LoadIcon");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AppService_LoadIcon_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AppServiceProxy::Launch(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id, int32_t in_event_flags, ::apps::mojom::LaunchSource in_launch_source, ::apps::mojom::WindowInfoPtr in_window_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::Launch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_flags"), in_event_flags,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("launch_source"), in_launch_source,
                        "<value of type ::apps::mojom::LaunchSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_info"), in_window_info,
                        "<value of type ::apps::mojom::WindowInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_Launch_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_Launch_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.Launch request");
  params->event_flags = in_event_flags;
  mojo::internal::Serialize<::apps::mojom::LaunchSource>(
      in_launch_source, &params->launch_source);
  mojo::internal::MessageFragment<
      typename decltype(params->window_info)::BaseType> window_info_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::WindowInfoDataView>(
      in_window_info, window_info_fragment);
  params->window_info.Set(
      window_info_fragment.is_null() ? nullptr : window_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("Launch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::LaunchAppWithFiles(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id, int32_t in_event_flags, ::apps::mojom::LaunchSource in_launch_source, ::apps::mojom::FilePathsPtr in_file_paths) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::LaunchAppWithFiles", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_flags"), in_event_flags,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("launch_source"), in_launch_source,
                        "<value of type ::apps::mojom::LaunchSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_paths"), in_file_paths,
                        "<value of type ::apps::mojom::FilePathsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_LaunchAppWithFiles_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_LaunchAppWithFiles_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.LaunchAppWithFiles request");
  params->event_flags = in_event_flags;
  mojo::internal::Serialize<::apps::mojom::LaunchSource>(
      in_launch_source, &params->launch_source);
  mojo::internal::MessageFragment<
      typename decltype(params->file_paths)::BaseType> file_paths_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::FilePathsDataView>(
      in_file_paths, file_paths_fragment);
  params->file_paths.Set(
      file_paths_fragment.is_null() ? nullptr : file_paths_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file_paths.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_paths in AppService.LaunchAppWithFiles request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("LaunchAppWithFiles");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::LaunchAppWithIntent(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id, int32_t in_event_flags, ::apps::mojom::IntentPtr in_intent, ::apps::mojom::LaunchSource in_launch_source, ::apps::mojom::WindowInfoPtr in_window_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::LaunchAppWithIntent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_flags"), in_event_flags,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intent"), in_intent,
                        "<value of type ::apps::mojom::IntentPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("launch_source"), in_launch_source,
                        "<value of type ::apps::mojom::LaunchSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_info"), in_window_info,
                        "<value of type ::apps::mojom::WindowInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_LaunchAppWithIntent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_LaunchAppWithIntent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.LaunchAppWithIntent request");
  params->event_flags = in_event_flags;
  mojo::internal::MessageFragment<
      typename decltype(params->intent)::BaseType> intent_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IntentDataView>(
      in_intent, intent_fragment);
  params->intent.Set(
      intent_fragment.is_null() ? nullptr : intent_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->intent.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null intent in AppService.LaunchAppWithIntent request");
  mojo::internal::Serialize<::apps::mojom::LaunchSource>(
      in_launch_source, &params->launch_source);
  mojo::internal::MessageFragment<
      typename decltype(params->window_info)::BaseType> window_info_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::WindowInfoDataView>(
      in_window_info, window_info_fragment);
  params->window_info.Set(
      window_info_fragment.is_null() ? nullptr : window_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("LaunchAppWithIntent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::SetPermission(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id, ::apps::mojom::PermissionPtr in_permission) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::SetPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permission"), in_permission,
                        "<value of type ::apps::mojom::PermissionPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_SetPermission_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_SetPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.SetPermission request");
  mojo::internal::MessageFragment<
      typename decltype(params->permission)::BaseType> permission_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::PermissionDataView>(
      in_permission, permission_fragment);
  params->permission.Set(
      permission_fragment.is_null() ? nullptr : permission_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->permission.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permission in AppService.SetPermission request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("SetPermission");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::Uninstall(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id, ::apps::mojom::UninstallSource in_uninstall_source, bool in_clear_site_data, bool in_report_abuse) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::Uninstall", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uninstall_source"), in_uninstall_source,
                        "<value of type ::apps::mojom::UninstallSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clear_site_data"), in_clear_site_data,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_abuse"), in_report_abuse,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_Uninstall_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_Uninstall_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.Uninstall request");
  mojo::internal::Serialize<::apps::mojom::UninstallSource>(
      in_uninstall_source, &params->uninstall_source);
  params->clear_site_data = in_clear_site_data;
  params->report_abuse = in_report_abuse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("Uninstall");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::PauseApp(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::PauseApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_PauseApp_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_PauseApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.PauseApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("PauseApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::UnpauseApp(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::UnpauseApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_UnpauseApp_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_UnpauseApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.UnpauseApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("UnpauseApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::StopApp(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::StopApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_StopApp_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_StopApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.StopApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("StopApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::GetMenuModel(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id, ::apps::mojom::MenuType in_menu_type, int64_t in_display_id, GetMenuModelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::GetMenuModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("menu_type"), in_menu_type,
                        "<value of type ::apps::mojom::MenuType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_id"), in_display_id,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_GetMenuModel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_GetMenuModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.GetMenuModel request");
  mojo::internal::Serialize<::apps::mojom::MenuType>(
      in_menu_type, &params->menu_type);
  params->display_id = in_display_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("GetMenuModel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AppService_GetMenuModel_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AppServiceProxy::ExecuteContextMenuCommand(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id, int32_t in_command_id, const std::string& in_shortcut_id, int64_t in_display_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::ExecuteContextMenuCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command_id"), in_command_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shortcut_id"), in_shortcut_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_id"), in_display_id,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_ExecuteContextMenuCommand_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_ExecuteContextMenuCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.ExecuteContextMenuCommand request");
  params->command_id = in_command_id;
  mojo::internal::MessageFragment<
      typename decltype(params->shortcut_id)::BaseType> shortcut_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_shortcut_id, shortcut_id_fragment);
  params->shortcut_id.Set(
      shortcut_id_fragment.is_null() ? nullptr : shortcut_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shortcut_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shortcut_id in AppService.ExecuteContextMenuCommand request");
  params->display_id = in_display_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("ExecuteContextMenuCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::OpenNativeSettings(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::OpenNativeSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_OpenNativeSettings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_OpenNativeSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.OpenNativeSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("OpenNativeSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::AddPreferredApp(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id, ::apps::mojom::IntentFilterPtr in_intent_filter, ::apps::mojom::IntentPtr in_intent, bool in_from_publisher) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::AddPreferredApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intent_filter"), in_intent_filter,
                        "<value of type ::apps::mojom::IntentFilterPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intent"), in_intent,
                        "<value of type ::apps::mojom::IntentPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("from_publisher"), in_from_publisher,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_AddPreferredApp_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_AddPreferredApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.AddPreferredApp request");
  mojo::internal::MessageFragment<
      typename decltype(params->intent_filter)::BaseType> intent_filter_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IntentFilterDataView>(
      in_intent_filter, intent_filter_fragment);
  params->intent_filter.Set(
      intent_filter_fragment.is_null() ? nullptr : intent_filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->intent_filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null intent_filter in AppService.AddPreferredApp request");
  mojo::internal::MessageFragment<
      typename decltype(params->intent)::BaseType> intent_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IntentDataView>(
      in_intent, intent_fragment);
  params->intent.Set(
      intent_fragment.is_null() ? nullptr : intent_fragment.data());
  params->from_publisher = in_from_publisher;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("AddPreferredApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::RemovePreferredApp(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::RemovePreferredApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_RemovePreferredApp_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_RemovePreferredApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.RemovePreferredApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("RemovePreferredApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::RemovePreferredAppForFilter(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id, ::apps::mojom::IntentFilterPtr in_intent_filter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::RemovePreferredAppForFilter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intent_filter"), in_intent_filter,
                        "<value of type ::apps::mojom::IntentFilterPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_RemovePreferredAppForFilter_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_RemovePreferredAppForFilter_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.RemovePreferredAppForFilter request");
  mojo::internal::MessageFragment<
      typename decltype(params->intent_filter)::BaseType> intent_filter_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IntentFilterDataView>(
      in_intent_filter, intent_filter_fragment);
  params->intent_filter.Set(
      intent_filter_fragment.is_null() ? nullptr : intent_filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->intent_filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null intent_filter in AppService.RemovePreferredAppForFilter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("RemovePreferredAppForFilter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::SetResizeLocked(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id, ::apps::mojom::OptionalBool in_locked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::SetResizeLocked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("locked"), in_locked,
                        "<value of type ::apps::mojom::OptionalBool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_SetResizeLocked_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_SetResizeLocked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.SetResizeLocked request");
  mojo::internal::Serialize<::apps::mojom::OptionalBool>(
      in_locked, &params->locked);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("SetResizeLocked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AppServiceProxy::SetWindowMode(
    ::apps::mojom::AppType in_app_type, const std::string& in_app_id, ::apps::mojom::WindowMode in_window_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::AppService::SetWindowMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_mode"), in_window_mode,
                        "<value of type ::apps::mojom::WindowMode>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_SetWindowMode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_SetWindowMode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in AppService.SetWindowMode request");
  mojo::internal::Serialize<::apps::mojom::WindowMode>(
      in_window_mode, &params->window_mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("SetWindowMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class AppService_LoadIcon_ProxyToResponder {
 public:
  static AppService::LoadIconCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AppService_LoadIcon_ProxyToResponder> proxy(
        new AppService_LoadIcon_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AppService_LoadIcon_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AppService_LoadIcon_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AppService_LoadIcon_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AppService::LoadIconCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::apps::mojom::IconValuePtr in_icon_value);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AppService_LoadIcon_ProxyToResponder);
};

bool AppService_LoadIcon_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "apps::mojom::AppService::LoadIconCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AppService_LoadIcon_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AppService_LoadIcon_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::apps::mojom::IconValuePtr p_icon_value{};
  AppService_LoadIcon_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadIconValue(&p_icon_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AppService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_icon_value));
  return true;
}

void AppService_LoadIcon_ProxyToResponder::Run(
    ::apps::mojom::IconValuePtr in_icon_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)apps::mojom::AppService::LoadIconCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon_value"), in_icon_value,
                        "<value of type ::apps::mojom::IconValuePtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_LoadIcon_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_LoadIcon_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->icon_value)::BaseType> icon_value_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IconValueDataView>(
      in_icon_value, icon_value_fragment);
  params->icon_value.Set(
      icon_value_fragment.is_null() ? nullptr : icon_value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->icon_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon_value in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)apps::mojom::AppService::LoadIconCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("LoadIcon");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AppService_GetMenuModel_ProxyToResponder {
 public:
  static AppService::GetMenuModelCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AppService_GetMenuModel_ProxyToResponder> proxy(
        new AppService_GetMenuModel_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AppService_GetMenuModel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AppService_GetMenuModel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AppService_GetMenuModel_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AppService::GetMenuModelCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::apps::mojom::MenuItemsPtr in_menu_items);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AppService_GetMenuModel_ProxyToResponder);
};

bool AppService_GetMenuModel_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "apps::mojom::AppService::GetMenuModelCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AppService_GetMenuModel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AppService_GetMenuModel_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::apps::mojom::MenuItemsPtr p_menu_items{};
  AppService_GetMenuModel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMenuItems(&p_menu_items))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AppService::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_menu_items));
  return true;
}

void AppService_GetMenuModel_ProxyToResponder::Run(
    ::apps::mojom::MenuItemsPtr in_menu_items) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)apps::mojom::AppService::GetMenuModelCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("menu_items"), in_menu_items,
                        "<value of type ::apps::mojom::MenuItemsPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAppService_GetMenuModel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::AppService_GetMenuModel_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->menu_items)::BaseType> menu_items_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::MenuItemsDataView>(
      in_menu_items, menu_items_fragment);
  params->menu_items.Set(
      menu_items_fragment.is_null() ? nullptr : menu_items_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->menu_items.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null menu_items in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)apps::mojom::AppService::GetMenuModelCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppService::Name_);
  message.set_method_name("GetMenuModel");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AppServiceStubDispatch::Accept(
    AppService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAppService_RegisterPublisher_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::RegisterPublisher",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::RegisterPublisher");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_RegisterPublisher_Params_Data* params =
          reinterpret_cast<internal::AppService_RegisterPublisher_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<Publisher> p_publisher{};
      ::apps::mojom::AppType p_app_type{};
      AppService_RegisterPublisher_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_publisher =
            input_data_view.TakePublisher<decltype(p_publisher)>();
      }
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterPublisher(
std::move(p_publisher), 
std::move(p_app_type));
      return true;
    }
    case internal::kAppService_RegisterSubscriber_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::RegisterSubscriber",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::RegisterSubscriber");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_RegisterSubscriber_Params_Data* params =
          reinterpret_cast<internal::AppService_RegisterSubscriber_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<Subscriber> p_subscriber{};
      ConnectOptionsPtr p_opts{};
      AppService_RegisterSubscriber_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_subscriber =
            input_data_view.TakeSubscriber<decltype(p_subscriber)>();
      }
      if (success && !input_data_view.ReadOpts(&p_opts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterSubscriber(
std::move(p_subscriber), 
std::move(p_opts));
      return true;
    }
    case internal::kAppService_LoadIcon_Name: {
      break;
    }
    case internal::kAppService_Launch_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::Launch",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::Launch");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_Launch_Params_Data* params =
          reinterpret_cast<internal::AppService_Launch_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      int32_t p_event_flags{};
      ::apps::mojom::LaunchSource p_launch_source{};
      ::apps::mojom::WindowInfoPtr p_window_info{};
      AppService_Launch_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success)
        p_event_flags = input_data_view.event_flags();
      if (success && !input_data_view.ReadLaunchSource(&p_launch_source))
        success = false;
      if (success && !input_data_view.ReadWindowInfo(&p_window_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Launch(
std::move(p_app_type), 
std::move(p_app_id), 
std::move(p_event_flags), 
std::move(p_launch_source), 
std::move(p_window_info));
      return true;
    }
    case internal::kAppService_LaunchAppWithFiles_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::LaunchAppWithFiles",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::LaunchAppWithFiles");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_LaunchAppWithFiles_Params_Data* params =
          reinterpret_cast<internal::AppService_LaunchAppWithFiles_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      int32_t p_event_flags{};
      ::apps::mojom::LaunchSource p_launch_source{};
      ::apps::mojom::FilePathsPtr p_file_paths{};
      AppService_LaunchAppWithFiles_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success)
        p_event_flags = input_data_view.event_flags();
      if (success && !input_data_view.ReadLaunchSource(&p_launch_source))
        success = false;
      if (success && !input_data_view.ReadFilePaths(&p_file_paths))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LaunchAppWithFiles(
std::move(p_app_type), 
std::move(p_app_id), 
std::move(p_event_flags), 
std::move(p_launch_source), 
std::move(p_file_paths));
      return true;
    }
    case internal::kAppService_LaunchAppWithIntent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::LaunchAppWithIntent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::LaunchAppWithIntent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_LaunchAppWithIntent_Params_Data* params =
          reinterpret_cast<internal::AppService_LaunchAppWithIntent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      int32_t p_event_flags{};
      ::apps::mojom::IntentPtr p_intent{};
      ::apps::mojom::LaunchSource p_launch_source{};
      ::apps::mojom::WindowInfoPtr p_window_info{};
      AppService_LaunchAppWithIntent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success)
        p_event_flags = input_data_view.event_flags();
      if (success && !input_data_view.ReadIntent(&p_intent))
        success = false;
      if (success && !input_data_view.ReadLaunchSource(&p_launch_source))
        success = false;
      if (success && !input_data_view.ReadWindowInfo(&p_window_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LaunchAppWithIntent(
std::move(p_app_type), 
std::move(p_app_id), 
std::move(p_event_flags), 
std::move(p_intent), 
std::move(p_launch_source), 
std::move(p_window_info));
      return true;
    }
    case internal::kAppService_SetPermission_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::SetPermission",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::SetPermission");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_SetPermission_Params_Data* params =
          reinterpret_cast<internal::AppService_SetPermission_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      ::apps::mojom::PermissionPtr p_permission{};
      AppService_SetPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadPermission(&p_permission))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPermission(
std::move(p_app_type), 
std::move(p_app_id), 
std::move(p_permission));
      return true;
    }
    case internal::kAppService_Uninstall_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::Uninstall",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::Uninstall");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_Uninstall_Params_Data* params =
          reinterpret_cast<internal::AppService_Uninstall_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      ::apps::mojom::UninstallSource p_uninstall_source{};
      bool p_clear_site_data{};
      bool p_report_abuse{};
      AppService_Uninstall_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadUninstallSource(&p_uninstall_source))
        success = false;
      if (success)
        p_clear_site_data = input_data_view.clear_site_data();
      if (success)
        p_report_abuse = input_data_view.report_abuse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Uninstall(
std::move(p_app_type), 
std::move(p_app_id), 
std::move(p_uninstall_source), 
std::move(p_clear_site_data), 
std::move(p_report_abuse));
      return true;
    }
    case internal::kAppService_PauseApp_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::PauseApp",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::PauseApp");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_PauseApp_Params_Data* params =
          reinterpret_cast<internal::AppService_PauseApp_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      AppService_PauseApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PauseApp(
std::move(p_app_type), 
std::move(p_app_id));
      return true;
    }
    case internal::kAppService_UnpauseApp_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::UnpauseApp",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::UnpauseApp");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_UnpauseApp_Params_Data* params =
          reinterpret_cast<internal::AppService_UnpauseApp_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      AppService_UnpauseApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnpauseApp(
std::move(p_app_type), 
std::move(p_app_id));
      return true;
    }
    case internal::kAppService_StopApp_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::StopApp",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::StopApp");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_StopApp_Params_Data* params =
          reinterpret_cast<internal::AppService_StopApp_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      AppService_StopApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopApp(
std::move(p_app_type), 
std::move(p_app_id));
      return true;
    }
    case internal::kAppService_GetMenuModel_Name: {
      break;
    }
    case internal::kAppService_ExecuteContextMenuCommand_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::ExecuteContextMenuCommand",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::ExecuteContextMenuCommand");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_ExecuteContextMenuCommand_Params_Data* params =
          reinterpret_cast<internal::AppService_ExecuteContextMenuCommand_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      int32_t p_command_id{};
      std::string p_shortcut_id{};
      int64_t p_display_id{};
      AppService_ExecuteContextMenuCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success)
        p_command_id = input_data_view.command_id();
      if (success && !input_data_view.ReadShortcutId(&p_shortcut_id))
        success = false;
      if (success)
        p_display_id = input_data_view.display_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteContextMenuCommand(
std::move(p_app_type), 
std::move(p_app_id), 
std::move(p_command_id), 
std::move(p_shortcut_id), 
std::move(p_display_id));
      return true;
    }
    case internal::kAppService_OpenNativeSettings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::OpenNativeSettings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::OpenNativeSettings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_OpenNativeSettings_Params_Data* params =
          reinterpret_cast<internal::AppService_OpenNativeSettings_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      AppService_OpenNativeSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenNativeSettings(
std::move(p_app_type), 
std::move(p_app_id));
      return true;
    }
    case internal::kAppService_AddPreferredApp_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::AddPreferredApp",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::AddPreferredApp");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_AddPreferredApp_Params_Data* params =
          reinterpret_cast<internal::AppService_AddPreferredApp_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      ::apps::mojom::IntentFilterPtr p_intent_filter{};
      ::apps::mojom::IntentPtr p_intent{};
      bool p_from_publisher{};
      AppService_AddPreferredApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadIntentFilter(&p_intent_filter))
        success = false;
      if (success && !input_data_view.ReadIntent(&p_intent))
        success = false;
      if (success)
        p_from_publisher = input_data_view.from_publisher();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddPreferredApp(
std::move(p_app_type), 
std::move(p_app_id), 
std::move(p_intent_filter), 
std::move(p_intent), 
std::move(p_from_publisher));
      return true;
    }
    case internal::kAppService_RemovePreferredApp_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::RemovePreferredApp",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::RemovePreferredApp");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_RemovePreferredApp_Params_Data* params =
          reinterpret_cast<internal::AppService_RemovePreferredApp_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      AppService_RemovePreferredApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemovePreferredApp(
std::move(p_app_type), 
std::move(p_app_id));
      return true;
    }
    case internal::kAppService_RemovePreferredAppForFilter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::RemovePreferredAppForFilter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::RemovePreferredAppForFilter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_RemovePreferredAppForFilter_Params_Data* params =
          reinterpret_cast<internal::AppService_RemovePreferredAppForFilter_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      ::apps::mojom::IntentFilterPtr p_intent_filter{};
      AppService_RemovePreferredAppForFilter_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadIntentFilter(&p_intent_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemovePreferredAppForFilter(
std::move(p_app_type), 
std::move(p_app_id), 
std::move(p_intent_filter));
      return true;
    }
    case internal::kAppService_SetResizeLocked_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::SetResizeLocked",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::SetResizeLocked");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_SetResizeLocked_Params_Data* params =
          reinterpret_cast<internal::AppService_SetResizeLocked_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      ::apps::mojom::OptionalBool p_locked{};
      AppService_SetResizeLocked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadLocked(&p_locked))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetResizeLocked(
std::move(p_app_type), 
std::move(p_app_id), 
std::move(p_locked));
      return true;
    }
    case internal::kAppService_SetWindowMode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::SetWindowMode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::SetWindowMode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AppService_SetWindowMode_Params_Data* params =
          reinterpret_cast<internal::AppService_SetWindowMode_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      ::apps::mojom::WindowMode p_window_mode{};
      AppService_SetWindowMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadWindowMode(&p_window_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWindowMode(
std::move(p_app_type), 
std::move(p_app_id), 
std::move(p_window_mode));
      return true;
    }
  }
  return false;
}

// static
bool AppServiceStubDispatch::AcceptWithResponder(
    AppService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAppService_RegisterPublisher_Name: {
      break;
    }
    case internal::kAppService_RegisterSubscriber_Name: {
      break;
    }
    case internal::kAppService_LoadIcon_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::LoadIcon",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::LoadIcon");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AppService_LoadIcon_Params_Data* params =
          reinterpret_cast<
              internal::AppService_LoadIcon_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      ::apps::mojom::IconKeyPtr p_icon_key{};
      ::apps::mojom::IconType p_icon_type{};
      int32_t p_size_hint_in_dip{};
      bool p_allow_placeholder_icon{};
      AppService_LoadIcon_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadIconKey(&p_icon_key))
        success = false;
      if (success && !input_data_view.ReadIconType(&p_icon_type))
        success = false;
      if (success)
        p_size_hint_in_dip = input_data_view.size_hint_in_dip();
      if (success)
        p_allow_placeholder_icon = input_data_view.allow_placeholder_icon();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 2, false);
        return false;
      }
      AppService::LoadIconCallback callback =
          AppService_LoadIcon_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadIcon(
std::move(p_app_type), 
std::move(p_app_id), 
std::move(p_icon_key), 
std::move(p_icon_type), 
std::move(p_size_hint_in_dip), 
std::move(p_allow_placeholder_icon), std::move(callback));
      return true;
    }
    case internal::kAppService_Launch_Name: {
      break;
    }
    case internal::kAppService_LaunchAppWithFiles_Name: {
      break;
    }
    case internal::kAppService_LaunchAppWithIntent_Name: {
      break;
    }
    case internal::kAppService_SetPermission_Name: {
      break;
    }
    case internal::kAppService_Uninstall_Name: {
      break;
    }
    case internal::kAppService_PauseApp_Name: {
      break;
    }
    case internal::kAppService_UnpauseApp_Name: {
      break;
    }
    case internal::kAppService_StopApp_Name: {
      break;
    }
    case internal::kAppService_GetMenuModel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::AppService::GetMenuModel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::AppService::GetMenuModel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AppService_GetMenuModel_Params_Data* params =
          reinterpret_cast<
              internal::AppService_GetMenuModel_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::apps::mojom::AppType p_app_type{};
      std::string p_app_id{};
      ::apps::mojom::MenuType p_menu_type{};
      int64_t p_display_id{};
      AppService_GetMenuModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadMenuType(&p_menu_type))
        success = false;
      if (success)
        p_display_id = input_data_view.display_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppService::Name_, 11, false);
        return false;
      }
      AppService::GetMenuModelCallback callback =
          AppService_GetMenuModel_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMenuModel(
std::move(p_app_type), 
std::move(p_app_id), 
std::move(p_menu_type), 
std::move(p_display_id), std::move(callback));
      return true;
    }
    case internal::kAppService_ExecuteContextMenuCommand_Name: {
      break;
    }
    case internal::kAppService_OpenNativeSettings_Name: {
      break;
    }
    case internal::kAppService_AddPreferredApp_Name: {
      break;
    }
    case internal::kAppService_RemovePreferredApp_Name: {
      break;
    }
    case internal::kAppService_RemovePreferredAppForFilter_Name: {
      break;
    }
    case internal::kAppService_SetResizeLocked_Name: {
      break;
    }
    case internal::kAppService_SetWindowMode_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAppServiceValidationInfo[] = {
    {internal::kAppService_RegisterPublisher_Name,
     {&internal::AppService_RegisterPublisher_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_RegisterSubscriber_Name,
     {&internal::AppService_RegisterSubscriber_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_LoadIcon_Name,
     {&internal::AppService_LoadIcon_Params_Data::Validate,
      &internal::AppService_LoadIcon_ResponseParams_Data::Validate}},
    {internal::kAppService_Launch_Name,
     {&internal::AppService_Launch_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_LaunchAppWithFiles_Name,
     {&internal::AppService_LaunchAppWithFiles_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_LaunchAppWithIntent_Name,
     {&internal::AppService_LaunchAppWithIntent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_SetPermission_Name,
     {&internal::AppService_SetPermission_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_Uninstall_Name,
     {&internal::AppService_Uninstall_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_PauseApp_Name,
     {&internal::AppService_PauseApp_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_UnpauseApp_Name,
     {&internal::AppService_UnpauseApp_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_StopApp_Name,
     {&internal::AppService_StopApp_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_GetMenuModel_Name,
     {&internal::AppService_GetMenuModel_Params_Data::Validate,
      &internal::AppService_GetMenuModel_ResponseParams_Data::Validate}},
    {internal::kAppService_ExecuteContextMenuCommand_Name,
     {&internal::AppService_ExecuteContextMenuCommand_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_OpenNativeSettings_Name,
     {&internal::AppService_OpenNativeSettings_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_AddPreferredApp_Name,
     {&internal::AppService_AddPreferredApp_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_RemovePreferredApp_Name,
     {&internal::AppService_RemovePreferredApp_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_RemovePreferredAppForFilter_Name,
     {&internal::AppService_RemovePreferredAppForFilter_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_SetResizeLocked_Name,
     {&internal::AppService_SetResizeLocked_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAppService_SetWindowMode_Name,
     {&internal::AppService_SetWindowMode_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AppServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::apps::mojom::AppService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAppServiceValidationInfo);
}

bool AppServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::apps::mojom::AppService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kAppServiceValidationInfo);

}
const char Publisher::Name_[] = "apps.mojom.Publisher";

class Publisher_LoadIcon_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Publisher_LoadIcon_ForwardToCallback(
      Publisher::LoadIconCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Publisher::LoadIconCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Publisher_LoadIcon_ForwardToCallback);
};

class Publisher_GetMenuModel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Publisher_GetMenuModel_ForwardToCallback(
      Publisher::GetMenuModelCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Publisher::GetMenuModelCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Publisher_GetMenuModel_ForwardToCallback);
};

PublisherProxy::PublisherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PublisherProxy::Connect(
    ::mojo::PendingRemote<Subscriber> in_subscriber, ConnectOptionsPtr in_opts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscriber"), in_subscriber,
                        "<value of type ::mojo::PendingRemote<Subscriber>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opts"), in_opts,
                        "<value of type ConnectOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_Connect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::apps::mojom::SubscriberInterfaceBase>>(
      in_subscriber, &params->subscriber, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->subscriber),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid subscriber in Publisher.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->opts)::BaseType> opts_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::ConnectOptionsDataView>(
      in_opts, opts_fragment);
  params->opts.Set(
      opts_fragment.is_null() ? nullptr : opts_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("Connect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::LoadIcon(
    const std::string& in_app_id, ::apps::mojom::IconKeyPtr in_icon_key, ::apps::mojom::IconType in_icon_type, int32_t in_size_hint_in_dip, bool in_allow_placeholder_icon, LoadIconCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::LoadIcon", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon_key"), in_icon_key,
                        "<value of type ::apps::mojom::IconKeyPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon_type"), in_icon_type,
                        "<value of type ::apps::mojom::IconType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size_hint_in_dip"), in_size_hint_in_dip,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_placeholder_icon"), in_allow_placeholder_icon,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_LoadIcon_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_LoadIcon_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.LoadIcon request");
  mojo::internal::MessageFragment<
      typename decltype(params->icon_key)::BaseType> icon_key_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IconKeyDataView>(
      in_icon_key, icon_key_fragment);
  params->icon_key.Set(
      icon_key_fragment.is_null() ? nullptr : icon_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->icon_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon_key in Publisher.LoadIcon request");
  mojo::internal::Serialize<::apps::mojom::IconType>(
      in_icon_type, &params->icon_type);
  params->size_hint_in_dip = in_size_hint_in_dip;
  params->allow_placeholder_icon = in_allow_placeholder_icon;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("LoadIcon");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Publisher_LoadIcon_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PublisherProxy::Launch(
    const std::string& in_app_id, int32_t in_event_flags, ::apps::mojom::LaunchSource in_launch_source, ::apps::mojom::WindowInfoPtr in_window_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::Launch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_flags"), in_event_flags,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("launch_source"), in_launch_source,
                        "<value of type ::apps::mojom::LaunchSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_info"), in_window_info,
                        "<value of type ::apps::mojom::WindowInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_Launch_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_Launch_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.Launch request");
  params->event_flags = in_event_flags;
  mojo::internal::Serialize<::apps::mojom::LaunchSource>(
      in_launch_source, &params->launch_source);
  mojo::internal::MessageFragment<
      typename decltype(params->window_info)::BaseType> window_info_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::WindowInfoDataView>(
      in_window_info, window_info_fragment);
  params->window_info.Set(
      window_info_fragment.is_null() ? nullptr : window_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("Launch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::LaunchAppWithFiles(
    const std::string& in_app_id, int32_t in_event_flags, ::apps::mojom::LaunchSource in_launch_source, ::apps::mojom::FilePathsPtr in_file_paths) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::LaunchAppWithFiles", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_flags"), in_event_flags,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("launch_source"), in_launch_source,
                        "<value of type ::apps::mojom::LaunchSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_paths"), in_file_paths,
                        "<value of type ::apps::mojom::FilePathsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_LaunchAppWithFiles_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_LaunchAppWithFiles_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.LaunchAppWithFiles request");
  params->event_flags = in_event_flags;
  mojo::internal::Serialize<::apps::mojom::LaunchSource>(
      in_launch_source, &params->launch_source);
  mojo::internal::MessageFragment<
      typename decltype(params->file_paths)::BaseType> file_paths_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::FilePathsDataView>(
      in_file_paths, file_paths_fragment);
  params->file_paths.Set(
      file_paths_fragment.is_null() ? nullptr : file_paths_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file_paths.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_paths in Publisher.LaunchAppWithFiles request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("LaunchAppWithFiles");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::LaunchAppWithIntent(
    const std::string& in_app_id, int32_t in_event_flags, ::apps::mojom::IntentPtr in_intent, ::apps::mojom::LaunchSource in_launch_source, ::apps::mojom::WindowInfoPtr in_window_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::LaunchAppWithIntent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_flags"), in_event_flags,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intent"), in_intent,
                        "<value of type ::apps::mojom::IntentPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("launch_source"), in_launch_source,
                        "<value of type ::apps::mojom::LaunchSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_info"), in_window_info,
                        "<value of type ::apps::mojom::WindowInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_LaunchAppWithIntent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_LaunchAppWithIntent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.LaunchAppWithIntent request");
  params->event_flags = in_event_flags;
  mojo::internal::MessageFragment<
      typename decltype(params->intent)::BaseType> intent_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IntentDataView>(
      in_intent, intent_fragment);
  params->intent.Set(
      intent_fragment.is_null() ? nullptr : intent_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->intent.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null intent in Publisher.LaunchAppWithIntent request");
  mojo::internal::Serialize<::apps::mojom::LaunchSource>(
      in_launch_source, &params->launch_source);
  mojo::internal::MessageFragment<
      typename decltype(params->window_info)::BaseType> window_info_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::WindowInfoDataView>(
      in_window_info, window_info_fragment);
  params->window_info.Set(
      window_info_fragment.is_null() ? nullptr : window_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("LaunchAppWithIntent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::SetPermission(
    const std::string& in_app_id, ::apps::mojom::PermissionPtr in_permission) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::SetPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permission"), in_permission,
                        "<value of type ::apps::mojom::PermissionPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_SetPermission_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_SetPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.SetPermission request");
  mojo::internal::MessageFragment<
      typename decltype(params->permission)::BaseType> permission_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::PermissionDataView>(
      in_permission, permission_fragment);
  params->permission.Set(
      permission_fragment.is_null() ? nullptr : permission_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->permission.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permission in Publisher.SetPermission request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("SetPermission");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::Uninstall(
    const std::string& in_app_id, ::apps::mojom::UninstallSource in_uninstall_source, bool in_clear_site_data, bool in_report_abuse) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::Uninstall", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uninstall_source"), in_uninstall_source,
                        "<value of type ::apps::mojom::UninstallSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clear_site_data"), in_clear_site_data,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_abuse"), in_report_abuse,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_Uninstall_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_Uninstall_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.Uninstall request");
  mojo::internal::Serialize<::apps::mojom::UninstallSource>(
      in_uninstall_source, &params->uninstall_source);
  params->clear_site_data = in_clear_site_data;
  params->report_abuse = in_report_abuse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("Uninstall");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::PauseApp(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::PauseApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_PauseApp_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_PauseApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.PauseApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("PauseApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::UnpauseApp(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::UnpauseApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_UnpauseApp_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_UnpauseApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.UnpauseApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("UnpauseApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::StopApp(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::StopApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_StopApp_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_StopApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.StopApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("StopApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::GetMenuModel(
    const std::string& in_app_id, ::apps::mojom::MenuType in_menu_type, int64_t in_display_id, GetMenuModelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::GetMenuModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("menu_type"), in_menu_type,
                        "<value of type ::apps::mojom::MenuType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_id"), in_display_id,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_GetMenuModel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_GetMenuModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.GetMenuModel request");
  mojo::internal::Serialize<::apps::mojom::MenuType>(
      in_menu_type, &params->menu_type);
  params->display_id = in_display_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("GetMenuModel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Publisher_GetMenuModel_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PublisherProxy::ExecuteContextMenuCommand(
    const std::string& in_app_id, int32_t in_command_id, const std::string& in_shortcut_id, int64_t in_display_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::ExecuteContextMenuCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command_id"), in_command_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shortcut_id"), in_shortcut_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_id"), in_display_id,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_ExecuteContextMenuCommand_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_ExecuteContextMenuCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.ExecuteContextMenuCommand request");
  params->command_id = in_command_id;
  mojo::internal::MessageFragment<
      typename decltype(params->shortcut_id)::BaseType> shortcut_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_shortcut_id, shortcut_id_fragment);
  params->shortcut_id.Set(
      shortcut_id_fragment.is_null() ? nullptr : shortcut_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shortcut_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shortcut_id in Publisher.ExecuteContextMenuCommand request");
  params->display_id = in_display_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("ExecuteContextMenuCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::OpenNativeSettings(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::OpenNativeSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_OpenNativeSettings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_OpenNativeSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.OpenNativeSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("OpenNativeSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::OnPreferredAppSet(
    const std::string& in_app_id, ::apps::mojom::IntentFilterPtr in_intent_filter, ::apps::mojom::IntentPtr in_intent, ::apps::mojom::ReplacedAppPreferencesPtr in_replaced_app_preferences) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::OnPreferredAppSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intent_filter"), in_intent_filter,
                        "<value of type ::apps::mojom::IntentFilterPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intent"), in_intent,
                        "<value of type ::apps::mojom::IntentPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replaced_app_preferences"), in_replaced_app_preferences,
                        "<value of type ::apps::mojom::ReplacedAppPreferencesPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_OnPreferredAppSet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_OnPreferredAppSet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.OnPreferredAppSet request");
  mojo::internal::MessageFragment<
      typename decltype(params->intent_filter)::BaseType> intent_filter_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IntentFilterDataView>(
      in_intent_filter, intent_filter_fragment);
  params->intent_filter.Set(
      intent_filter_fragment.is_null() ? nullptr : intent_filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->intent_filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null intent_filter in Publisher.OnPreferredAppSet request");
  mojo::internal::MessageFragment<
      typename decltype(params->intent)::BaseType> intent_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IntentDataView>(
      in_intent, intent_fragment);
  params->intent.Set(
      intent_fragment.is_null() ? nullptr : intent_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->intent.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null intent in Publisher.OnPreferredAppSet request");
  mojo::internal::MessageFragment<
      typename decltype(params->replaced_app_preferences)::BaseType> replaced_app_preferences_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::ReplacedAppPreferencesDataView>(
      in_replaced_app_preferences, replaced_app_preferences_fragment);
  params->replaced_app_preferences.Set(
      replaced_app_preferences_fragment.is_null() ? nullptr : replaced_app_preferences_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->replaced_app_preferences.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null replaced_app_preferences in Publisher.OnPreferredAppSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("OnPreferredAppSet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::SetResizeLocked(
    const std::string& in_app_id, ::apps::mojom::OptionalBool in_locked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::SetResizeLocked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("locked"), in_locked,
                        "<value of type ::apps::mojom::OptionalBool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_SetResizeLocked_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_SetResizeLocked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.SetResizeLocked request");
  mojo::internal::Serialize<::apps::mojom::OptionalBool>(
      in_locked, &params->locked);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("SetResizeLocked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PublisherProxy::SetWindowMode(
    const std::string& in_app_id, ::apps::mojom::WindowMode in_window_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Publisher::SetWindowMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_mode"), in_window_mode,
                        "<value of type ::apps::mojom::WindowMode>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_SetWindowMode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_SetWindowMode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Publisher.SetWindowMode request");
  mojo::internal::Serialize<::apps::mojom::WindowMode>(
      in_window_mode, &params->window_mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("SetWindowMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class Publisher_LoadIcon_ProxyToResponder {
 public:
  static Publisher::LoadIconCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Publisher_LoadIcon_ProxyToResponder> proxy(
        new Publisher_LoadIcon_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Publisher_LoadIcon_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Publisher_LoadIcon_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Publisher_LoadIcon_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Publisher::LoadIconCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::apps::mojom::IconValuePtr in_icon_value);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Publisher_LoadIcon_ProxyToResponder);
};

bool Publisher_LoadIcon_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "apps::mojom::Publisher::LoadIconCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Publisher_LoadIcon_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Publisher_LoadIcon_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::apps::mojom::IconValuePtr p_icon_value{};
  Publisher_LoadIcon_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadIconValue(&p_icon_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Publisher::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_icon_value));
  return true;
}

void Publisher_LoadIcon_ProxyToResponder::Run(
    ::apps::mojom::IconValuePtr in_icon_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)apps::mojom::Publisher::LoadIconCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon_value"), in_icon_value,
                        "<value of type ::apps::mojom::IconValuePtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_LoadIcon_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_LoadIcon_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->icon_value)::BaseType> icon_value_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IconValueDataView>(
      in_icon_value, icon_value_fragment);
  params->icon_value.Set(
      icon_value_fragment.is_null() ? nullptr : icon_value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->icon_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon_value in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)apps::mojom::Publisher::LoadIconCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("LoadIcon");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Publisher_GetMenuModel_ProxyToResponder {
 public:
  static Publisher::GetMenuModelCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Publisher_GetMenuModel_ProxyToResponder> proxy(
        new Publisher_GetMenuModel_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Publisher_GetMenuModel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Publisher_GetMenuModel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Publisher_GetMenuModel_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Publisher::GetMenuModelCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::apps::mojom::MenuItemsPtr in_menu_items);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Publisher_GetMenuModel_ProxyToResponder);
};

bool Publisher_GetMenuModel_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "apps::mojom::Publisher::GetMenuModelCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Publisher_GetMenuModel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Publisher_GetMenuModel_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::apps::mojom::MenuItemsPtr p_menu_items{};
  Publisher_GetMenuModel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMenuItems(&p_menu_items))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Publisher::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_menu_items));
  return true;
}

void Publisher_GetMenuModel_ProxyToResponder::Run(
    ::apps::mojom::MenuItemsPtr in_menu_items) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)apps::mojom::Publisher::GetMenuModelCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("menu_items"), in_menu_items,
                        "<value of type ::apps::mojom::MenuItemsPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPublisher_GetMenuModel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Publisher_GetMenuModel_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->menu_items)::BaseType> menu_items_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::MenuItemsDataView>(
      in_menu_items, menu_items_fragment);
  params->menu_items.Set(
      menu_items_fragment.is_null() ? nullptr : menu_items_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->menu_items.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null menu_items in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)apps::mojom::Publisher::GetMenuModelCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Publisher::Name_);
  message.set_method_name("GetMenuModel");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PublisherStubDispatch::Accept(
    Publisher* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPublisher_Connect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::Connect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::Connect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_Connect_Params_Data* params =
          reinterpret_cast<internal::Publisher_Connect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<Subscriber> p_subscriber{};
      ConnectOptionsPtr p_opts{};
      Publisher_Connect_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_subscriber =
            input_data_view.TakeSubscriber<decltype(p_subscriber)>();
      }
      if (success && !input_data_view.ReadOpts(&p_opts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(
std::move(p_subscriber), 
std::move(p_opts));
      return true;
    }
    case internal::kPublisher_LoadIcon_Name: {
      break;
    }
    case internal::kPublisher_Launch_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::Launch",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::Launch");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_Launch_Params_Data* params =
          reinterpret_cast<internal::Publisher_Launch_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      int32_t p_event_flags{};
      ::apps::mojom::LaunchSource p_launch_source{};
      ::apps::mojom::WindowInfoPtr p_window_info{};
      Publisher_Launch_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success)
        p_event_flags = input_data_view.event_flags();
      if (success && !input_data_view.ReadLaunchSource(&p_launch_source))
        success = false;
      if (success && !input_data_view.ReadWindowInfo(&p_window_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Launch(
std::move(p_app_id), 
std::move(p_event_flags), 
std::move(p_launch_source), 
std::move(p_window_info));
      return true;
    }
    case internal::kPublisher_LaunchAppWithFiles_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::LaunchAppWithFiles",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::LaunchAppWithFiles");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_LaunchAppWithFiles_Params_Data* params =
          reinterpret_cast<internal::Publisher_LaunchAppWithFiles_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      int32_t p_event_flags{};
      ::apps::mojom::LaunchSource p_launch_source{};
      ::apps::mojom::FilePathsPtr p_file_paths{};
      Publisher_LaunchAppWithFiles_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success)
        p_event_flags = input_data_view.event_flags();
      if (success && !input_data_view.ReadLaunchSource(&p_launch_source))
        success = false;
      if (success && !input_data_view.ReadFilePaths(&p_file_paths))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LaunchAppWithFiles(
std::move(p_app_id), 
std::move(p_event_flags), 
std::move(p_launch_source), 
std::move(p_file_paths));
      return true;
    }
    case internal::kPublisher_LaunchAppWithIntent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::LaunchAppWithIntent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::LaunchAppWithIntent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_LaunchAppWithIntent_Params_Data* params =
          reinterpret_cast<internal::Publisher_LaunchAppWithIntent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      int32_t p_event_flags{};
      ::apps::mojom::IntentPtr p_intent{};
      ::apps::mojom::LaunchSource p_launch_source{};
      ::apps::mojom::WindowInfoPtr p_window_info{};
      Publisher_LaunchAppWithIntent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success)
        p_event_flags = input_data_view.event_flags();
      if (success && !input_data_view.ReadIntent(&p_intent))
        success = false;
      if (success && !input_data_view.ReadLaunchSource(&p_launch_source))
        success = false;
      if (success && !input_data_view.ReadWindowInfo(&p_window_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LaunchAppWithIntent(
std::move(p_app_id), 
std::move(p_event_flags), 
std::move(p_intent), 
std::move(p_launch_source), 
std::move(p_window_info));
      return true;
    }
    case internal::kPublisher_SetPermission_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::SetPermission",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::SetPermission");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_SetPermission_Params_Data* params =
          reinterpret_cast<internal::Publisher_SetPermission_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      ::apps::mojom::PermissionPtr p_permission{};
      Publisher_SetPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadPermission(&p_permission))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPermission(
std::move(p_app_id), 
std::move(p_permission));
      return true;
    }
    case internal::kPublisher_Uninstall_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::Uninstall",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::Uninstall");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_Uninstall_Params_Data* params =
          reinterpret_cast<internal::Publisher_Uninstall_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      ::apps::mojom::UninstallSource p_uninstall_source{};
      bool p_clear_site_data{};
      bool p_report_abuse{};
      Publisher_Uninstall_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadUninstallSource(&p_uninstall_source))
        success = false;
      if (success)
        p_clear_site_data = input_data_view.clear_site_data();
      if (success)
        p_report_abuse = input_data_view.report_abuse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Uninstall(
std::move(p_app_id), 
std::move(p_uninstall_source), 
std::move(p_clear_site_data), 
std::move(p_report_abuse));
      return true;
    }
    case internal::kPublisher_PauseApp_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::PauseApp",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::PauseApp");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_PauseApp_Params_Data* params =
          reinterpret_cast<internal::Publisher_PauseApp_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      Publisher_PauseApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PauseApp(
std::move(p_app_id));
      return true;
    }
    case internal::kPublisher_UnpauseApp_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::UnpauseApp",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::UnpauseApp");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_UnpauseApp_Params_Data* params =
          reinterpret_cast<internal::Publisher_UnpauseApp_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      Publisher_UnpauseApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnpauseApp(
std::move(p_app_id));
      return true;
    }
    case internal::kPublisher_StopApp_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::StopApp",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::StopApp");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_StopApp_Params_Data* params =
          reinterpret_cast<internal::Publisher_StopApp_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      Publisher_StopApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopApp(
std::move(p_app_id));
      return true;
    }
    case internal::kPublisher_GetMenuModel_Name: {
      break;
    }
    case internal::kPublisher_ExecuteContextMenuCommand_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::ExecuteContextMenuCommand",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::ExecuteContextMenuCommand");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_ExecuteContextMenuCommand_Params_Data* params =
          reinterpret_cast<internal::Publisher_ExecuteContextMenuCommand_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      int32_t p_command_id{};
      std::string p_shortcut_id{};
      int64_t p_display_id{};
      Publisher_ExecuteContextMenuCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success)
        p_command_id = input_data_view.command_id();
      if (success && !input_data_view.ReadShortcutId(&p_shortcut_id))
        success = false;
      if (success)
        p_display_id = input_data_view.display_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteContextMenuCommand(
std::move(p_app_id), 
std::move(p_command_id), 
std::move(p_shortcut_id), 
std::move(p_display_id));
      return true;
    }
    case internal::kPublisher_OpenNativeSettings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::OpenNativeSettings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::OpenNativeSettings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_OpenNativeSettings_Params_Data* params =
          reinterpret_cast<internal::Publisher_OpenNativeSettings_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      Publisher_OpenNativeSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenNativeSettings(
std::move(p_app_id));
      return true;
    }
    case internal::kPublisher_OnPreferredAppSet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::OnPreferredAppSet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::OnPreferredAppSet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_OnPreferredAppSet_Params_Data* params =
          reinterpret_cast<internal::Publisher_OnPreferredAppSet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      ::apps::mojom::IntentFilterPtr p_intent_filter{};
      ::apps::mojom::IntentPtr p_intent{};
      ::apps::mojom::ReplacedAppPreferencesPtr p_replaced_app_preferences{};
      Publisher_OnPreferredAppSet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadIntentFilter(&p_intent_filter))
        success = false;
      if (success && !input_data_view.ReadIntent(&p_intent))
        success = false;
      if (success && !input_data_view.ReadReplacedAppPreferences(&p_replaced_app_preferences))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPreferredAppSet(
std::move(p_app_id), 
std::move(p_intent_filter), 
std::move(p_intent), 
std::move(p_replaced_app_preferences));
      return true;
    }
    case internal::kPublisher_SetResizeLocked_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::SetResizeLocked",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::SetResizeLocked");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_SetResizeLocked_Params_Data* params =
          reinterpret_cast<internal::Publisher_SetResizeLocked_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      ::apps::mojom::OptionalBool p_locked{};
      Publisher_SetResizeLocked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadLocked(&p_locked))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetResizeLocked(
std::move(p_app_id), 
std::move(p_locked));
      return true;
    }
    case internal::kPublisher_SetWindowMode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::SetWindowMode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::SetWindowMode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Publisher_SetWindowMode_Params_Data* params =
          reinterpret_cast<internal::Publisher_SetWindowMode_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      ::apps::mojom::WindowMode p_window_mode{};
      Publisher_SetWindowMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadWindowMode(&p_window_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWindowMode(
std::move(p_app_id), 
std::move(p_window_mode));
      return true;
    }
  }
  return false;
}

// static
bool PublisherStubDispatch::AcceptWithResponder(
    Publisher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPublisher_Connect_Name: {
      break;
    }
    case internal::kPublisher_LoadIcon_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::LoadIcon",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::LoadIcon");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Publisher_LoadIcon_Params_Data* params =
          reinterpret_cast<
              internal::Publisher_LoadIcon_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      ::apps::mojom::IconKeyPtr p_icon_key{};
      ::apps::mojom::IconType p_icon_type{};
      int32_t p_size_hint_in_dip{};
      bool p_allow_placeholder_icon{};
      Publisher_LoadIcon_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadIconKey(&p_icon_key))
        success = false;
      if (success && !input_data_view.ReadIconType(&p_icon_type))
        success = false;
      if (success)
        p_size_hint_in_dip = input_data_view.size_hint_in_dip();
      if (success)
        p_allow_placeholder_icon = input_data_view.allow_placeholder_icon();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 1, false);
        return false;
      }
      Publisher::LoadIconCallback callback =
          Publisher_LoadIcon_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadIcon(
std::move(p_app_id), 
std::move(p_icon_key), 
std::move(p_icon_type), 
std::move(p_size_hint_in_dip), 
std::move(p_allow_placeholder_icon), std::move(callback));
      return true;
    }
    case internal::kPublisher_Launch_Name: {
      break;
    }
    case internal::kPublisher_LaunchAppWithFiles_Name: {
      break;
    }
    case internal::kPublisher_LaunchAppWithIntent_Name: {
      break;
    }
    case internal::kPublisher_SetPermission_Name: {
      break;
    }
    case internal::kPublisher_Uninstall_Name: {
      break;
    }
    case internal::kPublisher_PauseApp_Name: {
      break;
    }
    case internal::kPublisher_UnpauseApp_Name: {
      break;
    }
    case internal::kPublisher_StopApp_Name: {
      break;
    }
    case internal::kPublisher_GetMenuModel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Publisher::GetMenuModel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Publisher::GetMenuModel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Publisher_GetMenuModel_Params_Data* params =
          reinterpret_cast<
              internal::Publisher_GetMenuModel_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      ::apps::mojom::MenuType p_menu_type{};
      int64_t p_display_id{};
      Publisher_GetMenuModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadMenuType(&p_menu_type))
        success = false;
      if (success)
        p_display_id = input_data_view.display_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Publisher::Name_, 10, false);
        return false;
      }
      Publisher::GetMenuModelCallback callback =
          Publisher_GetMenuModel_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMenuModel(
std::move(p_app_id), 
std::move(p_menu_type), 
std::move(p_display_id), std::move(callback));
      return true;
    }
    case internal::kPublisher_ExecuteContextMenuCommand_Name: {
      break;
    }
    case internal::kPublisher_OpenNativeSettings_Name: {
      break;
    }
    case internal::kPublisher_OnPreferredAppSet_Name: {
      break;
    }
    case internal::kPublisher_SetResizeLocked_Name: {
      break;
    }
    case internal::kPublisher_SetWindowMode_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPublisherValidationInfo[] = {
    {internal::kPublisher_Connect_Name,
     {&internal::Publisher_Connect_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_LoadIcon_Name,
     {&internal::Publisher_LoadIcon_Params_Data::Validate,
      &internal::Publisher_LoadIcon_ResponseParams_Data::Validate}},
    {internal::kPublisher_Launch_Name,
     {&internal::Publisher_Launch_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_LaunchAppWithFiles_Name,
     {&internal::Publisher_LaunchAppWithFiles_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_LaunchAppWithIntent_Name,
     {&internal::Publisher_LaunchAppWithIntent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_SetPermission_Name,
     {&internal::Publisher_SetPermission_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_Uninstall_Name,
     {&internal::Publisher_Uninstall_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_PauseApp_Name,
     {&internal::Publisher_PauseApp_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_UnpauseApp_Name,
     {&internal::Publisher_UnpauseApp_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_StopApp_Name,
     {&internal::Publisher_StopApp_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_GetMenuModel_Name,
     {&internal::Publisher_GetMenuModel_Params_Data::Validate,
      &internal::Publisher_GetMenuModel_ResponseParams_Data::Validate}},
    {internal::kPublisher_ExecuteContextMenuCommand_Name,
     {&internal::Publisher_ExecuteContextMenuCommand_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_OpenNativeSettings_Name,
     {&internal::Publisher_OpenNativeSettings_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_OnPreferredAppSet_Name,
     {&internal::Publisher_OnPreferredAppSet_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_SetResizeLocked_Name,
     {&internal::Publisher_SetResizeLocked_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPublisher_SetWindowMode_Name,
     {&internal::Publisher_SetWindowMode_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PublisherRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::apps::mojom::Publisher::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPublisherValidationInfo);
}

bool PublisherResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::apps::mojom::Publisher::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPublisherValidationInfo);

}
const char Subscriber::Name_[] = "apps.mojom.Subscriber";

SubscriberProxy::SubscriberProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SubscriberProxy::OnApps(
    std::vector<::apps::mojom::AppPtr> in_deltas, ::apps::mojom::AppType in_app_type, bool in_should_notify_initialized) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Subscriber::OnApps", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("deltas"), in_deltas,
                        "<value of type std::vector<::apps::mojom::AppPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_type"), in_app_type,
                        "<value of type ::apps::mojom::AppType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_notify_initialized"), in_should_notify_initialized,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSubscriber_OnApps_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Subscriber_OnApps_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->deltas)::BaseType>
      deltas_fragment(params.message());
  const mojo::internal::ContainerValidateParams deltas_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::apps::mojom::AppDataView>>(
      in_deltas, deltas_fragment, &deltas_validate_params);
  params->deltas.Set(
      deltas_fragment.is_null() ? nullptr : deltas_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->deltas.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null deltas in Subscriber.OnApps request");
  mojo::internal::Serialize<::apps::mojom::AppType>(
      in_app_type, &params->app_type);
  params->should_notify_initialized = in_should_notify_initialized;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Subscriber::Name_);
  message.set_method_name("OnApps");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SubscriberProxy::OnCapabilityAccesses(
    std::vector<::apps::mojom::CapabilityAccessPtr> in_deltas) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Subscriber::OnCapabilityAccesses", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("deltas"), in_deltas,
                        "<value of type std::vector<::apps::mojom::CapabilityAccessPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSubscriber_OnCapabilityAccesses_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Subscriber_OnCapabilityAccesses_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->deltas)::BaseType>
      deltas_fragment(params.message());
  const mojo::internal::ContainerValidateParams deltas_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::apps::mojom::CapabilityAccessDataView>>(
      in_deltas, deltas_fragment, &deltas_validate_params);
  params->deltas.Set(
      deltas_fragment.is_null() ? nullptr : deltas_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->deltas.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null deltas in Subscriber.OnCapabilityAccesses request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Subscriber::Name_);
  message.set_method_name("OnCapabilityAccesses");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SubscriberProxy::Clone(
    ::mojo::PendingReceiver<Subscriber> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Subscriber::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<Subscriber>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSubscriber_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Subscriber_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::apps::mojom::SubscriberInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in Subscriber.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Subscriber::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SubscriberProxy::OnPreferredAppSet(
    const std::string& in_app_id, ::apps::mojom::IntentFilterPtr in_intent_filter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Subscriber::OnPreferredAppSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intent_filter"), in_intent_filter,
                        "<value of type ::apps::mojom::IntentFilterPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSubscriber_OnPreferredAppSet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Subscriber_OnPreferredAppSet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Subscriber.OnPreferredAppSet request");
  mojo::internal::MessageFragment<
      typename decltype(params->intent_filter)::BaseType> intent_filter_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IntentFilterDataView>(
      in_intent_filter, intent_filter_fragment);
  params->intent_filter.Set(
      intent_filter_fragment.is_null() ? nullptr : intent_filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->intent_filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null intent_filter in Subscriber.OnPreferredAppSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Subscriber::Name_);
  message.set_method_name("OnPreferredAppSet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SubscriberProxy::OnPreferredAppRemoved(
    const std::string& in_app_id, ::apps::mojom::IntentFilterPtr in_intent_filter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Subscriber::OnPreferredAppRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intent_filter"), in_intent_filter,
                        "<value of type ::apps::mojom::IntentFilterPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSubscriber_OnPreferredAppRemoved_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Subscriber_OnPreferredAppRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id, app_id_fragment);
  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->app_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in Subscriber.OnPreferredAppRemoved request");
  mojo::internal::MessageFragment<
      typename decltype(params->intent_filter)::BaseType> intent_filter_fragment(
          params.message());
  mojo::internal::Serialize<::apps::mojom::IntentFilterDataView>(
      in_intent_filter, intent_filter_fragment);
  params->intent_filter.Set(
      intent_filter_fragment.is_null() ? nullptr : intent_filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->intent_filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null intent_filter in Subscriber.OnPreferredAppRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Subscriber::Name_);
  message.set_method_name("OnPreferredAppRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SubscriberProxy::InitializePreferredApps(
    std::vector<::apps::mojom::PreferredAppPtr> in_preferred_apps) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "apps::mojom::Subscriber::InitializePreferredApps", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preferred_apps"), in_preferred_apps,
                        "<value of type std::vector<::apps::mojom::PreferredAppPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSubscriber_InitializePreferredApps_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::apps::mojom::internal::Subscriber_InitializePreferredApps_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->preferred_apps)::BaseType>
      preferred_apps_fragment(params.message());
  const mojo::internal::ContainerValidateParams preferred_apps_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::apps::mojom::PreferredAppDataView>>(
      in_preferred_apps, preferred_apps_fragment, &preferred_apps_validate_params);
  params->preferred_apps.Set(
      preferred_apps_fragment.is_null() ? nullptr : preferred_apps_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->preferred_apps.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null preferred_apps in Subscriber.InitializePreferredApps request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Subscriber::Name_);
  message.set_method_name("InitializePreferredApps");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SubscriberStubDispatch::Accept(
    Subscriber* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSubscriber_OnApps_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Subscriber::OnApps",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Subscriber::OnApps");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Subscriber_OnApps_Params_Data* params =
          reinterpret_cast<internal::Subscriber_OnApps_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::apps::mojom::AppPtr> p_deltas{};
      ::apps::mojom::AppType p_app_type{};
      bool p_should_notify_initialized{};
      Subscriber_OnApps_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeltas(&p_deltas))
        success = false;
      if (success && !input_data_view.ReadAppType(&p_app_type))
        success = false;
      if (success)
        p_should_notify_initialized = input_data_view.should_notify_initialized();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Subscriber::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnApps(
std::move(p_deltas), 
std::move(p_app_type), 
std::move(p_should_notify_initialized));
      return true;
    }
    case internal::kSubscriber_OnCapabilityAccesses_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Subscriber::OnCapabilityAccesses",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Subscriber::OnCapabilityAccesses");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Subscriber_OnCapabilityAccesses_Params_Data* params =
          reinterpret_cast<internal::Subscriber_OnCapabilityAccesses_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::apps::mojom::CapabilityAccessPtr> p_deltas{};
      Subscriber_OnCapabilityAccesses_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeltas(&p_deltas))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Subscriber::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCapabilityAccesses(
std::move(p_deltas));
      return true;
    }
    case internal::kSubscriber_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Subscriber::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Subscriber::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Subscriber_Clone_Params_Data* params =
          reinterpret_cast<internal::Subscriber_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<Subscriber> p_receiver{};
      Subscriber_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Subscriber::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_receiver));
      return true;
    }
    case internal::kSubscriber_OnPreferredAppSet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Subscriber::OnPreferredAppSet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Subscriber::OnPreferredAppSet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Subscriber_OnPreferredAppSet_Params_Data* params =
          reinterpret_cast<internal::Subscriber_OnPreferredAppSet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      ::apps::mojom::IntentFilterPtr p_intent_filter{};
      Subscriber_OnPreferredAppSet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadIntentFilter(&p_intent_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Subscriber::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPreferredAppSet(
std::move(p_app_id), 
std::move(p_intent_filter));
      return true;
    }
    case internal::kSubscriber_OnPreferredAppRemoved_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Subscriber::OnPreferredAppRemoved",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Subscriber::OnPreferredAppRemoved");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Subscriber_OnPreferredAppRemoved_Params_Data* params =
          reinterpret_cast<internal::Subscriber_OnPreferredAppRemoved_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_app_id{};
      ::apps::mojom::IntentFilterPtr p_intent_filter{};
      Subscriber_OnPreferredAppRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadIntentFilter(&p_intent_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Subscriber::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPreferredAppRemoved(
std::move(p_app_id), 
std::move(p_intent_filter));
      return true;
    }
    case internal::kSubscriber_InitializePreferredApps_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)apps::mojom::Subscriber::InitializePreferredApps",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)apps::mojom::Subscriber::InitializePreferredApps");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Subscriber_InitializePreferredApps_Params_Data* params =
          reinterpret_cast<internal::Subscriber_InitializePreferredApps_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::apps::mojom::PreferredAppPtr> p_preferred_apps{};
      Subscriber_InitializePreferredApps_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPreferredApps(&p_preferred_apps))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Subscriber::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializePreferredApps(
std::move(p_preferred_apps));
      return true;
    }
  }
  return false;
}

// static
bool SubscriberStubDispatch::AcceptWithResponder(
    Subscriber* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSubscriber_OnApps_Name: {
      break;
    }
    case internal::kSubscriber_OnCapabilityAccesses_Name: {
      break;
    }
    case internal::kSubscriber_Clone_Name: {
      break;
    }
    case internal::kSubscriber_OnPreferredAppSet_Name: {
      break;
    }
    case internal::kSubscriber_OnPreferredAppRemoved_Name: {
      break;
    }
    case internal::kSubscriber_InitializePreferredApps_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSubscriberValidationInfo[] = {
    {internal::kSubscriber_OnApps_Name,
     {&internal::Subscriber_OnApps_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSubscriber_OnCapabilityAccesses_Name,
     {&internal::Subscriber_OnCapabilityAccesses_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSubscriber_Clone_Name,
     {&internal::Subscriber_Clone_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSubscriber_OnPreferredAppSet_Name,
     {&internal::Subscriber_OnPreferredAppSet_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSubscriber_OnPreferredAppRemoved_Name,
     {&internal::Subscriber_OnPreferredAppRemoved_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSubscriber_InitializePreferredApps_Name,
     {&internal::Subscriber_InitializePreferredApps_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SubscriberRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::apps::mojom::Subscriber::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSubscriberValidationInfo);
}

}  // namespace mojom
}  // namespace apps

namespace mojo {


// static
bool StructTraits<::apps::mojom::ConnectOptions::DataView, ::apps::mojom::ConnectOptionsPtr>::Read(
    ::apps::mojom::ConnectOptions::DataView input,
    ::apps::mojom::ConnectOptionsPtr* output) {
  bool success = true;
  ::apps::mojom::ConnectOptionsPtr result(::apps::mojom::ConnectOptions::New());
  
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif