// components/services/filesystem/public/mojom/directory.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/filesystem/public/mojom/directory.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/filesystem/public/mojom/directory.mojom-params-data.h"
#include "components/services/filesystem/public/mojom/directory.mojom-shared-message-ids.h"

#include "components/services/filesystem/public/mojom/directory.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_BLINK_JUMBO_H_
#define COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_BLINK_JUMBO_H_
#endif
namespace filesystem {
namespace mojom {
namespace blink {
FileOpenDetails::FileOpenDetails()
    : path(),
      open_flags() {}

FileOpenDetails::FileOpenDetails(
    const WTF::String& path_in,
    uint32_t open_flags_in)
    : path(std::move(path_in)),
      open_flags(std::move(open_flags_in)) {}

FileOpenDetails::~FileOpenDetails() = default;
size_t FileOpenDetails::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->path);
  seed = mojo::internal::WTFHash(seed, this->open_flags);
  return seed;
}

void FileOpenDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "open_flags"), this->open_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileOpenDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileOpenResult::FileOpenResult()
    : path(),
      error(),
      file_handle() {}

FileOpenResult::FileOpenResult(
    const WTF::String& path_in,
    ::base::File::Error error_in,
    ::base::File file_handle_in)
    : path(std::move(path_in)),
      error(std::move(error_in)),
      file_handle(std::move(file_handle_in)) {}

FileOpenResult::~FileOpenResult() = default;

void FileOpenResult::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File::Error>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_handle"), this->file_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileOpenResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char Directory::Name_[] = "filesystem.mojom.Directory";
bool Directory::Read(::base::File::Error* out_error, absl::optional<WTF::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>>* out_directory_contents) {
  NOTREACHED();
  return false;
}
bool Directory::OpenFile(const WTF::String& path, ::mojo::PendingReceiver<::filesystem::mojom::blink::File> file, uint32_t open_flags, ::base::File::Error* out_error) {
  NOTREACHED();
  return false;
}
bool Directory::OpenFileHandle(const WTF::String& path, uint32_t open_flags, ::base::File::Error* out_error, ::base::File* out_file_handle) {
  NOTREACHED();
  return false;
}
bool Directory::OpenFileHandles(WTF::Vector<FileOpenDetailsPtr> files, WTF::Vector<FileOpenResultPtr>* out_results) {
  NOTREACHED();
  return false;
}
bool Directory::OpenDirectory(const WTF::String& path, ::mojo::PendingReceiver<Directory> directory, uint32_t open_flags, ::base::File::Error* out_error) {
  NOTREACHED();
  return false;
}
bool Directory::Rename(const WTF::String& path, const WTF::String& new_path, ::base::File::Error* out_error) {
  NOTREACHED();
  return false;
}
bool Directory::Replace(const WTF::String& path, const WTF::String& new_path, ::base::File::Error* out_error) {
  NOTREACHED();
  return false;
}
bool Directory::Delete(const WTF::String& path, uint32_t delete_flags, ::base::File::Error* out_error) {
  NOTREACHED();
  return false;
}
bool Directory::Exists(const WTF::String& path, ::base::File::Error* out_error, bool* out_exists) {
  NOTREACHED();
  return false;
}
bool Directory::IsWritable(const WTF::String& path, ::base::File::Error* out_error, bool* out_is_writable) {
  NOTREACHED();
  return false;
}
bool Directory::Flush(::base::File::Error* out_error) {
  NOTREACHED();
  return false;
}
bool Directory::StatFile(const WTF::String& path, ::base::File::Error* out_error, ::filesystem::mojom::blink::FileInformationPtr* out_file_information) {
  NOTREACHED();
  return false;
}
bool Directory::ReadEntireFile(const WTF::String& path, ::base::File::Error* out_error, WTF::Vector<uint8_t>* out_data) {
  NOTREACHED();
  return false;
}
bool Directory::WriteFile(const WTF::String& path, const WTF::Vector<uint8_t>& data, ::base::File::Error* out_error) {
  NOTREACHED();
  return false;
}
class Directory_Read_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_Read_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, absl::optional<WTF::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>>* out_directory_contents)
      : result_(result), out_error_(out_error), out_directory_contents_(out_directory_contents) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  absl::optional<WTF::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>>* out_directory_contents_;DISALLOW_COPY_AND_ASSIGN(Directory_Read_HandleSyncResponse);
};

class Directory_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_Read_ForwardToCallback(
      Directory::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::ReadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_Read_ForwardToCallback);
};
class Directory_OpenFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;DISALLOW_COPY_AND_ASSIGN(Directory_OpenFile_HandleSyncResponse);
};

class Directory_OpenFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFile_ForwardToCallback(
      Directory::OpenFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::OpenFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_OpenFile_ForwardToCallback);
};
class Directory_OpenFileHandle_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFileHandle_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, ::base::File* out_file_handle)
      : result_(result), out_error_(out_error), out_file_handle_(out_file_handle) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  ::base::File* out_file_handle_;DISALLOW_COPY_AND_ASSIGN(Directory_OpenFileHandle_HandleSyncResponse);
};

class Directory_OpenFileHandle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFileHandle_ForwardToCallback(
      Directory::OpenFileHandleCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::OpenFileHandleCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_OpenFileHandle_ForwardToCallback);
};
class Directory_OpenFileHandles_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFileHandles_HandleSyncResponse(
      bool* result, WTF::Vector<FileOpenResultPtr>* out_results)
      : result_(result), out_results_(out_results) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  WTF::Vector<FileOpenResultPtr>* out_results_;DISALLOW_COPY_AND_ASSIGN(Directory_OpenFileHandles_HandleSyncResponse);
};

class Directory_OpenFileHandles_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFileHandles_ForwardToCallback(
      Directory::OpenFileHandlesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::OpenFileHandlesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_OpenFileHandles_ForwardToCallback);
};
class Directory_OpenDirectory_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_OpenDirectory_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;DISALLOW_COPY_AND_ASSIGN(Directory_OpenDirectory_HandleSyncResponse);
};

class Directory_OpenDirectory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_OpenDirectory_ForwardToCallback(
      Directory::OpenDirectoryCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::OpenDirectoryCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_OpenDirectory_ForwardToCallback);
};
class Directory_Rename_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_Rename_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;DISALLOW_COPY_AND_ASSIGN(Directory_Rename_HandleSyncResponse);
};

class Directory_Rename_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_Rename_ForwardToCallback(
      Directory::RenameCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::RenameCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_Rename_ForwardToCallback);
};
class Directory_Replace_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_Replace_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;DISALLOW_COPY_AND_ASSIGN(Directory_Replace_HandleSyncResponse);
};

class Directory_Replace_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_Replace_ForwardToCallback(
      Directory::ReplaceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::ReplaceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_Replace_ForwardToCallback);
};
class Directory_Delete_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_Delete_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;DISALLOW_COPY_AND_ASSIGN(Directory_Delete_HandleSyncResponse);
};

class Directory_Delete_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_Delete_ForwardToCallback(
      Directory::DeleteCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::DeleteCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_Delete_ForwardToCallback);
};
class Directory_Exists_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_Exists_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, bool* out_exists)
      : result_(result), out_error_(out_error), out_exists_(out_exists) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  bool* out_exists_;DISALLOW_COPY_AND_ASSIGN(Directory_Exists_HandleSyncResponse);
};

class Directory_Exists_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_Exists_ForwardToCallback(
      Directory::ExistsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::ExistsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_Exists_ForwardToCallback);
};
class Directory_IsWritable_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_IsWritable_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, bool* out_is_writable)
      : result_(result), out_error_(out_error), out_is_writable_(out_is_writable) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  bool* out_is_writable_;DISALLOW_COPY_AND_ASSIGN(Directory_IsWritable_HandleSyncResponse);
};

class Directory_IsWritable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_IsWritable_ForwardToCallback(
      Directory::IsWritableCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::IsWritableCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_IsWritable_ForwardToCallback);
};
class Directory_Flush_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_Flush_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;DISALLOW_COPY_AND_ASSIGN(Directory_Flush_HandleSyncResponse);
};

class Directory_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_Flush_ForwardToCallback(
      Directory::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::FlushCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_Flush_ForwardToCallback);
};
class Directory_StatFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_StatFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, ::filesystem::mojom::blink::FileInformationPtr* out_file_information)
      : result_(result), out_error_(out_error), out_file_information_(out_file_information) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  ::filesystem::mojom::blink::FileInformationPtr* out_file_information_;DISALLOW_COPY_AND_ASSIGN(Directory_StatFile_HandleSyncResponse);
};

class Directory_StatFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_StatFile_ForwardToCallback(
      Directory::StatFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::StatFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_StatFile_ForwardToCallback);
};
class Directory_ReadEntireFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_ReadEntireFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, WTF::Vector<uint8_t>* out_data)
      : result_(result), out_error_(out_error), out_data_(out_data) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  WTF::Vector<uint8_t>* out_data_;DISALLOW_COPY_AND_ASSIGN(Directory_ReadEntireFile_HandleSyncResponse);
};

class Directory_ReadEntireFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_ReadEntireFile_ForwardToCallback(
      Directory::ReadEntireFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::ReadEntireFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_ReadEntireFile_ForwardToCallback);
};
class Directory_WriteFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_WriteFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;DISALLOW_COPY_AND_ASSIGN(Directory_WriteFile_HandleSyncResponse);
};

class Directory_WriteFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_WriteFile_ForwardToCallback(
      Directory::WriteFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::WriteFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_WriteFile_ForwardToCallback);
};

DirectoryProxy::DirectoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool DirectoryProxy::Read(
    ::base::File::Error* out_param_error, absl::optional<WTF::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>>* out_param_directory_contents) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "filesystem::mojom::Directory::Read");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Read_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Read_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Read");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Read_HandleSyncResponse(
          &result, out_param_error, out_param_directory_contents));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::Read", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory_contents"), out_param_directory_contents,
                        "<value of type absl::optional<WTF::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>>>");
   });
#endif
  return result;
}

void DirectoryProxy::Read(
    ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "filesystem::mojom::Directory::Read");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Read_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Read_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Read_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::OpenFile(
    const WTF::String& param_path, ::mojo::PendingReceiver<::filesystem::mojom::blink::File> param_file, uint32_t param_open_flags, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "filesystem::mojom::Directory::OpenFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), param_file,
                        "<value of type ::mojo::PendingReceiver<::filesystem::mojom::blink::File>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_flags"), param_open_flags,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.OpenFile request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::filesystem::mojom::FileInterfaceBase>>(
      param_file, &params->file, &params.message());
  params->open_flags = param_open_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFile_HandleSyncResponse(
          &result, out_param_error));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::OpenFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::OpenFile(
    const WTF::String& in_path, ::mojo::PendingReceiver<::filesystem::mojom::blink::File> in_file, uint32_t in_open_flags, OpenFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::OpenFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::mojo::PendingReceiver<::filesystem::mojom::blink::File>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_flags"), in_open_flags,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.OpenFile request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::filesystem::mojom::FileInterfaceBase>>(
      in_file, &params->file, &params.message());
  params->open_flags = in_open_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::OpenFileHandle(
    const WTF::String& param_path, uint32_t param_open_flags, ::base::File::Error* out_param_error, ::base::File* out_param_file_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "filesystem::mojom::Directory::OpenFileHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_flags"), param_open_flags,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenFileHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFileHandle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.OpenFileHandle request");
  params->open_flags = param_open_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFileHandle");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFileHandle_HandleSyncResponse(
          &result, out_param_error, out_param_file_handle));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::OpenFileHandle", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_handle"), out_param_file_handle,
                        "<value of type ::base::File>");
   });
#endif
  return result;
}

void DirectoryProxy::OpenFileHandle(
    const WTF::String& in_path, uint32_t in_open_flags, OpenFileHandleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::OpenFileHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_flags"), in_open_flags,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenFileHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFileHandle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.OpenFileHandle request");
  params->open_flags = in_open_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFileHandle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFileHandle_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::OpenFileHandles(
    WTF::Vector<FileOpenDetailsPtr> param_files, WTF::Vector<FileOpenResultPtr>* out_param_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "filesystem::mojom::Directory::OpenFileHandles", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("files"), param_files,
                        "<value of type WTF::Vector<FileOpenDetailsPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenFileHandles_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFileHandles_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->files)::BaseType>
      files_fragment(params.message());
  const mojo::internal::ContainerValidateParams files_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::filesystem::mojom::FileOpenDetailsDataView>>(
      param_files, files_fragment, &files_validate_params);
  params->files.Set(
      files_fragment.is_null() ? nullptr : files_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->files.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null files in Directory.OpenFileHandles request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFileHandles");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFileHandles_HandleSyncResponse(
          &result, out_param_results));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::OpenFileHandles", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), out_param_results,
                        "<value of type WTF::Vector<FileOpenResultPtr>>");
   });
#endif
  return result;
}

void DirectoryProxy::OpenFileHandles(
    WTF::Vector<FileOpenDetailsPtr> in_files, OpenFileHandlesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::OpenFileHandles", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("files"), in_files,
                        "<value of type WTF::Vector<FileOpenDetailsPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenFileHandles_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFileHandles_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->files)::BaseType>
      files_fragment(params.message());
  const mojo::internal::ContainerValidateParams files_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::filesystem::mojom::FileOpenDetailsDataView>>(
      in_files, files_fragment, &files_validate_params);
  params->files.Set(
      files_fragment.is_null() ? nullptr : files_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->files.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null files in Directory.OpenFileHandles request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFileHandles");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFileHandles_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::OpenDirectory(
    const WTF::String& param_path, ::mojo::PendingReceiver<Directory> param_directory, uint32_t param_open_flags, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "filesystem::mojom::Directory::OpenDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), param_directory,
                        "<value of type ::mojo::PendingReceiver<Directory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_flags"), param_open_flags,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenDirectory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.OpenDirectory request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::filesystem::mojom::DirectoryInterfaceBase>>(
      param_directory, &params->directory, &params.message());
  params->open_flags = param_open_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenDirectory");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenDirectory_HandleSyncResponse(
          &result, out_param_error));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::OpenDirectory", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::OpenDirectory(
    const WTF::String& in_path, ::mojo::PendingReceiver<Directory> in_directory, uint32_t in_open_flags, OpenDirectoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::OpenDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory,
                        "<value of type ::mojo::PendingReceiver<Directory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_flags"), in_open_flags,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenDirectory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.OpenDirectory request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::filesystem::mojom::DirectoryInterfaceBase>>(
      in_directory, &params->directory, &params.message());
  params->open_flags = in_open_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenDirectory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenDirectory_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::Rename(
    const WTF::String& param_path, const WTF::String& param_new_path, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "filesystem::mojom::Directory::Rename", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_path"), param_new_path,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Rename_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Rename_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.Rename request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_path)::BaseType> new_path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_new_path, new_path_fragment);
  params->new_path.Set(
      new_path_fragment.is_null() ? nullptr : new_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_path in Directory.Rename request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Rename");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Rename_HandleSyncResponse(
          &result, out_param_error));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::Rename", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::Rename(
    const WTF::String& in_path, const WTF::String& in_new_path, RenameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::Rename", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_path"), in_new_path,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Rename_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Rename_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.Rename request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_path)::BaseType> new_path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_new_path, new_path_fragment);
  params->new_path.Set(
      new_path_fragment.is_null() ? nullptr : new_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_path in Directory.Rename request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Rename");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Rename_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::Replace(
    const WTF::String& param_path, const WTF::String& param_new_path, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "filesystem::mojom::Directory::Replace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_path"), param_new_path,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Replace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Replace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.Replace request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_path)::BaseType> new_path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_new_path, new_path_fragment);
  params->new_path.Set(
      new_path_fragment.is_null() ? nullptr : new_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_path in Directory.Replace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Replace");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Replace_HandleSyncResponse(
          &result, out_param_error));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::Replace", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::Replace(
    const WTF::String& in_path, const WTF::String& in_new_path, ReplaceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::Replace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_path"), in_new_path,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Replace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Replace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.Replace request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_path)::BaseType> new_path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_new_path, new_path_fragment);
  params->new_path.Set(
      new_path_fragment.is_null() ? nullptr : new_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_path in Directory.Replace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Replace");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Replace_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::Delete(
    const WTF::String& param_path, uint32_t param_delete_flags, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "filesystem::mojom::Directory::Delete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delete_flags"), param_delete_flags,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Delete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Delete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.Delete request");
  params->delete_flags = param_delete_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Delete");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Delete_HandleSyncResponse(
          &result, out_param_error));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::Delete", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::Delete(
    const WTF::String& in_path, uint32_t in_delete_flags, DeleteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::Delete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delete_flags"), in_delete_flags,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Delete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Delete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.Delete request");
  params->delete_flags = in_delete_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Delete");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Delete_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::Exists(
    const WTF::String& param_path, ::base::File::Error* out_param_error, bool* out_param_exists) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "filesystem::mojom::Directory::Exists", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Exists_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Exists_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.Exists request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Exists");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Exists_HandleSyncResponse(
          &result, out_param_error, out_param_exists));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::Exists", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exists"), out_param_exists,
                        "<value of type bool>");
   });
#endif
  return result;
}

void DirectoryProxy::Exists(
    const WTF::String& in_path, ExistsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::Exists", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Exists_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Exists_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.Exists request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Exists");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Exists_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::IsWritable(
    const WTF::String& param_path, ::base::File::Error* out_param_error, bool* out_param_is_writable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "filesystem::mojom::Directory::IsWritable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_IsWritable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_IsWritable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.IsWritable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("IsWritable");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_IsWritable_HandleSyncResponse(
          &result, out_param_error, out_param_is_writable));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::IsWritable", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_writable"), out_param_is_writable,
                        "<value of type bool>");
   });
#endif
  return result;
}

void DirectoryProxy::IsWritable(
    const WTF::String& in_path, IsWritableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::IsWritable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_IsWritable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_IsWritable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.IsWritable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("IsWritable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_IsWritable_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::Flush(
    ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "filesystem::mojom::Directory::Flush");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Flush");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Flush_HandleSyncResponse(
          &result, out_param_error));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::Flush", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::Flush(
    FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "filesystem::mojom::Directory::Flush");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Flush_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::StatFile(
    const WTF::String& param_path, ::base::File::Error* out_param_error, ::filesystem::mojom::blink::FileInformationPtr* out_param_file_information) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "filesystem::mojom::Directory::StatFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_StatFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_StatFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.StatFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("StatFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_StatFile_HandleSyncResponse(
          &result, out_param_error, out_param_file_information));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::StatFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_information"), out_param_file_information,
                        "<value of type ::filesystem::mojom::blink::FileInformationPtr>");
   });
#endif
  return result;
}

void DirectoryProxy::StatFile(
    const WTF::String& in_path, StatFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::StatFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_StatFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_StatFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.StatFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("StatFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_StatFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DirectoryProxy::Clone(
    ::mojo::PendingReceiver<Directory> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory,
                        "<value of type ::mojo::PendingReceiver<Directory>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::filesystem::mojom::DirectoryInterfaceBase>>(
      in_directory, &params->directory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->directory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid directory in Directory.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool DirectoryProxy::ReadEntireFile(
    const WTF::String& param_path, ::base::File::Error* out_param_error, WTF::Vector<uint8_t>* out_param_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "filesystem::mojom::Directory::ReadEntireFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_ReadEntireFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_ReadEntireFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.ReadEntireFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("ReadEntireFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_ReadEntireFile_HandleSyncResponse(
          &result, out_param_error, out_param_data));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::ReadEntireFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), out_param_data,
                        "<value of type const WTF::Vector<uint8_t>&>");
   });
#endif
  return result;
}

void DirectoryProxy::ReadEntireFile(
    const WTF::String& in_path, ReadEntireFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::ReadEntireFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_ReadEntireFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_ReadEntireFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.ReadEntireFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("ReadEntireFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_ReadEntireFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::WriteFile(
    const WTF::String& param_path, const WTF::Vector<uint8_t>& param_data, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "filesystem::mojom::Directory::WriteFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), param_data,
                        "<value of type const WTF::Vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_WriteFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_WriteFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.WriteFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      param_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in Directory.WriteFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("WriteFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_WriteFile_HandleSyncResponse(
          &result, out_param_error));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "filesystem::mojom::Directory::WriteFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::WriteFile(
    const WTF::String& in_path, const WTF::Vector<uint8_t>& in_data, WriteFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "filesystem::mojom::Directory::WriteFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const WTF::Vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_WriteFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_WriteFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.WriteFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in Directory.WriteFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("WriteFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_WriteFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class Directory_Read_ProxyToResponder {
 public:
  static Directory::ReadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_Read_ProxyToResponder> proxy(
        new Directory_Read_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_Read_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::ReadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, absl::optional<WTF::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>> in_directory_contents);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_Read_ProxyToResponder);
};

bool Directory_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::ReadCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_Read_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  absl::optional<WTF::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>> p_directory_contents{};
  Directory_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadDirectoryContents(&p_directory_contents))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_directory_contents));
  return true;
}

void Directory_Read_ProxyToResponder::Run(
    ::base::File::Error in_error, absl::optional<WTF::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>> in_directory_contents) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::ReadCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory_contents"), in_directory_contents,
                        "<value of type absl::optional<WTF::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Read_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Read_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->directory_contents)::BaseType>
      directory_contents_fragment(params.message());
  const mojo::internal::ContainerValidateParams directory_contents_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>>(
      in_directory_contents, directory_contents_fragment, &directory_contents_validate_params);
  params->directory_contents.Set(
      directory_contents_fragment.is_null() ? nullptr : directory_contents_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::ReadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_Read_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_Read_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_Read_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  absl::optional<WTF::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>> p_directory_contents{};
  Directory_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadDirectoryContents(&p_directory_contents))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 0, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_directory_contents_ = std::move(p_directory_contents);
  *result_ = true;
  return true;
}
class Directory_OpenFile_ProxyToResponder {
 public:
  static Directory::OpenFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_OpenFile_ProxyToResponder> proxy(
        new Directory_OpenFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_OpenFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_OpenFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_OpenFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::OpenFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_OpenFile_ProxyToResponder);
};

bool Directory_OpenFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::OpenFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_OpenFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_OpenFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void Directory_OpenFile_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::OpenFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::OpenFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_OpenFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_OpenFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_OpenFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 1, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_OpenFileHandle_ProxyToResponder {
 public:
  static Directory::OpenFileHandleCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_OpenFileHandle_ProxyToResponder> proxy(
        new Directory_OpenFileHandle_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_OpenFileHandle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_OpenFileHandle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_OpenFileHandle_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::OpenFileHandleCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, ::base::File in_file_handle);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_OpenFileHandle_ProxyToResponder);
};

bool Directory_OpenFileHandle_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::OpenFileHandleCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_OpenFileHandle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_OpenFileHandle_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  ::base::File p_file_handle{};
  Directory_OpenFileHandle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadFileHandle(&p_file_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_file_handle));
  return true;
}

void Directory_OpenFileHandle_ProxyToResponder::Run(
    ::base::File::Error in_error, ::base::File in_file_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::OpenFileHandleCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_handle"), in_file_handle,
                        "<value of type ::base::File>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenFileHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFileHandle_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->file_handle)::BaseType> file_handle_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file_handle, file_handle_fragment);
  params->file_handle.Set(
      file_handle_fragment.is_null() ? nullptr : file_handle_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::OpenFileHandleCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFileHandle");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_OpenFileHandle_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_OpenFileHandle_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_OpenFileHandle_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  ::base::File p_file_handle{};
  Directory_OpenFileHandle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadFileHandle(&p_file_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 2, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_file_handle_ = std::move(p_file_handle);
  *result_ = true;
  return true;
}
class Directory_OpenFileHandles_ProxyToResponder {
 public:
  static Directory::OpenFileHandlesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_OpenFileHandles_ProxyToResponder> proxy(
        new Directory_OpenFileHandles_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_OpenFileHandles_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_OpenFileHandles_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_OpenFileHandles_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::OpenFileHandlesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<FileOpenResultPtr> in_results);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_OpenFileHandles_ProxyToResponder);
};

bool Directory_OpenFileHandles_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::OpenFileHandlesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_OpenFileHandles_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_OpenFileHandles_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<FileOpenResultPtr> p_results{};
  Directory_OpenFileHandles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_results));
  return true;
}

void Directory_OpenFileHandles_ProxyToResponder::Run(
    WTF::Vector<FileOpenResultPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::OpenFileHandlesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type WTF::Vector<FileOpenResultPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenFileHandles_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFileHandles_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  const mojo::internal::ContainerValidateParams results_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::filesystem::mojom::FileOpenResultDataView>>(
      in_results, results_fragment, &results_validate_params);
  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->results.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::OpenFileHandlesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFileHandles");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_OpenFileHandles_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_OpenFileHandles_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_OpenFileHandles_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  WTF::Vector<FileOpenResultPtr> p_results{};
  Directory_OpenFileHandles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 3, true);
    return false;
  }
  *out_results_ = std::move(p_results);
  *result_ = true;
  return true;
}
class Directory_OpenDirectory_ProxyToResponder {
 public:
  static Directory::OpenDirectoryCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_OpenDirectory_ProxyToResponder> proxy(
        new Directory_OpenDirectory_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_OpenDirectory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_OpenDirectory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_OpenDirectory_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::OpenDirectoryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_OpenDirectory_ProxyToResponder);
};

bool Directory_OpenDirectory_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::OpenDirectoryCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_OpenDirectory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_OpenDirectory_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_OpenDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void Directory_OpenDirectory_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::OpenDirectoryCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenDirectory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenDirectory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::OpenDirectoryCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenDirectory");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_OpenDirectory_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_OpenDirectory_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_OpenDirectory_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_OpenDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 4, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_Rename_ProxyToResponder {
 public:
  static Directory::RenameCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_Rename_ProxyToResponder> proxy(
        new Directory_Rename_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_Rename_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_Rename_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_Rename_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::RenameCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_Rename_ProxyToResponder);
};

bool Directory_Rename_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::RenameCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_Rename_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_Rename_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Rename_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void Directory_Rename_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::RenameCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Rename_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Rename_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::RenameCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Rename");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_Rename_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_Rename_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_Rename_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Rename_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 5, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_Replace_ProxyToResponder {
 public:
  static Directory::ReplaceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_Replace_ProxyToResponder> proxy(
        new Directory_Replace_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_Replace_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_Replace_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_Replace_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::ReplaceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_Replace_ProxyToResponder);
};

bool Directory_Replace_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::ReplaceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_Replace_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_Replace_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Replace_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void Directory_Replace_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::ReplaceCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Replace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Replace_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::ReplaceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Replace");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_Replace_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_Replace_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_Replace_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Replace_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 6, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_Delete_ProxyToResponder {
 public:
  static Directory::DeleteCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_Delete_ProxyToResponder> proxy(
        new Directory_Delete_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_Delete_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_Delete_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_Delete_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::DeleteCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_Delete_ProxyToResponder);
};

bool Directory_Delete_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::DeleteCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_Delete_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_Delete_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Delete_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void Directory_Delete_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::DeleteCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Delete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Delete_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::DeleteCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Delete");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_Delete_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_Delete_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_Delete_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Delete_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 7, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_Exists_ProxyToResponder {
 public:
  static Directory::ExistsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_Exists_ProxyToResponder> proxy(
        new Directory_Exists_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_Exists_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_Exists_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_Exists_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::ExistsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, bool in_exists);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_Exists_ProxyToResponder);
};

bool Directory_Exists_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::ExistsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_Exists_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_Exists_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  bool p_exists{};
  Directory_Exists_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_exists = input_data_view.exists();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_exists));
  return true;
}

void Directory_Exists_ProxyToResponder::Run(
    ::base::File::Error in_error, bool in_exists) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::ExistsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exists"), in_exists,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Exists_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Exists_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  params->exists = in_exists;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::ExistsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Exists");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_Exists_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_Exists_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_Exists_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  bool p_exists{};
  Directory_Exists_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_exists = input_data_view.exists();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 8, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_exists_ = std::move(p_exists);
  *result_ = true;
  return true;
}
class Directory_IsWritable_ProxyToResponder {
 public:
  static Directory::IsWritableCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_IsWritable_ProxyToResponder> proxy(
        new Directory_IsWritable_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_IsWritable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_IsWritable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_IsWritable_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::IsWritableCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, bool in_is_writable);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_IsWritable_ProxyToResponder);
};

bool Directory_IsWritable_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::IsWritableCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_IsWritable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_IsWritable_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  bool p_is_writable{};
  Directory_IsWritable_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_is_writable = input_data_view.is_writable();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_is_writable));
  return true;
}

void Directory_IsWritable_ProxyToResponder::Run(
    ::base::File::Error in_error, bool in_is_writable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::IsWritableCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_writable"), in_is_writable,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_IsWritable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_IsWritable_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  params->is_writable = in_is_writable;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::IsWritableCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("IsWritable");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_IsWritable_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_IsWritable_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_IsWritable_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  bool p_is_writable{};
  Directory_IsWritable_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_is_writable = input_data_view.is_writable();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 9, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_is_writable_ = std::move(p_is_writable);
  *result_ = true;
  return true;
}
class Directory_Flush_ProxyToResponder {
 public:
  static Directory::FlushCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_Flush_ProxyToResponder> proxy(
        new Directory_Flush_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_Flush_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::FlushCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_Flush_ProxyToResponder);
};

bool Directory_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::FlushCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void Directory_Flush_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::FlushCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::FlushCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_Flush_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_Flush_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_Flush_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 10, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_StatFile_ProxyToResponder {
 public:
  static Directory::StatFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_StatFile_ProxyToResponder> proxy(
        new Directory_StatFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_StatFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_StatFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_StatFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::StatFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, ::filesystem::mojom::blink::FileInformationPtr in_file_information);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_StatFile_ProxyToResponder);
};

bool Directory_StatFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::StatFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_StatFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_StatFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  ::filesystem::mojom::blink::FileInformationPtr p_file_information{};
  Directory_StatFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadFileInformation(&p_file_information))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_file_information));
  return true;
}

void Directory_StatFile_ProxyToResponder::Run(
    ::base::File::Error in_error, ::filesystem::mojom::blink::FileInformationPtr in_file_information) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::StatFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_information"), in_file_information,
                        "<value of type ::filesystem::mojom::blink::FileInformationPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_StatFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_StatFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->file_information)::BaseType> file_information_fragment(
          params.message());
  mojo::internal::Serialize<::filesystem::mojom::FileInformationDataView>(
      in_file_information, file_information_fragment);
  params->file_information.Set(
      file_information_fragment.is_null() ? nullptr : file_information_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::StatFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("StatFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_StatFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_StatFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_StatFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  ::filesystem::mojom::blink::FileInformationPtr p_file_information{};
  Directory_StatFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadFileInformation(&p_file_information))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 11, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_file_information_ = std::move(p_file_information);
  *result_ = true;
  return true;
}
class Directory_ReadEntireFile_ProxyToResponder {
 public:
  static Directory::ReadEntireFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_ReadEntireFile_ProxyToResponder> proxy(
        new Directory_ReadEntireFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_ReadEntireFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_ReadEntireFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_ReadEntireFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::ReadEntireFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, const WTF::Vector<uint8_t>& in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_ReadEntireFile_ProxyToResponder);
};

bool Directory_ReadEntireFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::ReadEntireFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_ReadEntireFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_ReadEntireFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  WTF::Vector<uint8_t> p_data{};
  Directory_ReadEntireFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_data));
  return true;
}

void Directory_ReadEntireFile_ProxyToResponder::Run(
    ::base::File::Error in_error, const WTF::Vector<uint8_t>& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::ReadEntireFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const WTF::Vector<uint8_t>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_ReadEntireFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_ReadEntireFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::ReadEntireFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("ReadEntireFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_ReadEntireFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_ReadEntireFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_ReadEntireFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  WTF::Vector<uint8_t> p_data{};
  Directory_ReadEntireFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 13, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_data_ = std::move(p_data);
  *result_ = true;
  return true;
}
class Directory_WriteFile_ProxyToResponder {
 public:
  static Directory::WriteFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_WriteFile_ProxyToResponder> proxy(
        new Directory_WriteFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_WriteFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_WriteFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_WriteFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::WriteFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_WriteFile_ProxyToResponder);
};

bool Directory_WriteFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "filesystem::mojom::Directory::WriteFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_WriteFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_WriteFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_WriteFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void Directory_WriteFile_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)filesystem::mojom::Directory::WriteFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_WriteFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_WriteFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)filesystem::mojom::Directory::WriteFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("WriteFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_WriteFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_WriteFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_WriteFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_WriteFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 14, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}

// static
bool DirectoryStubDispatch::Accept(
    Directory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDirectory_Read_Name: {
      break;
    }
    case internal::kDirectory_OpenFile_Name: {
      break;
    }
    case internal::kDirectory_OpenFileHandle_Name: {
      break;
    }
    case internal::kDirectory_OpenFileHandles_Name: {
      break;
    }
    case internal::kDirectory_OpenDirectory_Name: {
      break;
    }
    case internal::kDirectory_Rename_Name: {
      break;
    }
    case internal::kDirectory_Replace_Name: {
      break;
    }
    case internal::kDirectory_Delete_Name: {
      break;
    }
    case internal::kDirectory_Exists_Name: {
      break;
    }
    case internal::kDirectory_IsWritable_Name: {
      break;
    }
    case internal::kDirectory_Flush_Name: {
      break;
    }
    case internal::kDirectory_StatFile_Name: {
      break;
    }
    case internal::kDirectory_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Directory_Clone_Params_Data* params =
          reinterpret_cast<internal::Directory_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<Directory> p_directory{};
      Directory_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_directory =
            input_data_view.TakeDirectory<decltype(p_directory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_directory));
      return true;
    }
    case internal::kDirectory_ReadEntireFile_Name: {
      break;
    }
    case internal::kDirectory_WriteFile_Name: {
      break;
    }
  }
  return false;
}

// static
bool DirectoryStubDispatch::AcceptWithResponder(
    Directory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDirectory_Read_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::Read",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::Read");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_Read_Params_Data* params =
          reinterpret_cast<
              internal::Directory_Read_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Directory_Read_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 0, false);
        return false;
      }
      Directory::ReadCallback callback =
          Directory_Read_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(std::move(callback));
      return true;
    }
    case internal::kDirectory_OpenFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::OpenFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::OpenFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_OpenFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_OpenFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_path{};
      ::mojo::PendingReceiver<::filesystem::mojom::blink::File> p_file{};
      uint32_t p_open_flags{};
      Directory_OpenFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success) {
        p_file =
            input_data_view.TakeFile<decltype(p_file)>();
      }
      if (success)
        p_open_flags = input_data_view.open_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 1, false);
        return false;
      }
      Directory::OpenFileCallback callback =
          Directory_OpenFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFile(
std::move(p_path), 
std::move(p_file), 
std::move(p_open_flags), std::move(callback));
      return true;
    }
    case internal::kDirectory_OpenFileHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::OpenFileHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::OpenFileHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_OpenFileHandle_Params_Data* params =
          reinterpret_cast<
              internal::Directory_OpenFileHandle_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_path{};
      uint32_t p_open_flags{};
      Directory_OpenFileHandle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success)
        p_open_flags = input_data_view.open_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 2, false);
        return false;
      }
      Directory::OpenFileHandleCallback callback =
          Directory_OpenFileHandle_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFileHandle(
std::move(p_path), 
std::move(p_open_flags), std::move(callback));
      return true;
    }
    case internal::kDirectory_OpenFileHandles_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::OpenFileHandles",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::OpenFileHandles");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_OpenFileHandles_Params_Data* params =
          reinterpret_cast<
              internal::Directory_OpenFileHandles_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<FileOpenDetailsPtr> p_files{};
      Directory_OpenFileHandles_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFiles(&p_files))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 3, false);
        return false;
      }
      Directory::OpenFileHandlesCallback callback =
          Directory_OpenFileHandles_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFileHandles(
std::move(p_files), std::move(callback));
      return true;
    }
    case internal::kDirectory_OpenDirectory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::OpenDirectory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::OpenDirectory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_OpenDirectory_Params_Data* params =
          reinterpret_cast<
              internal::Directory_OpenDirectory_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_path{};
      ::mojo::PendingReceiver<Directory> p_directory{};
      uint32_t p_open_flags{};
      Directory_OpenDirectory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success) {
        p_directory =
            input_data_view.TakeDirectory<decltype(p_directory)>();
      }
      if (success)
        p_open_flags = input_data_view.open_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 4, false);
        return false;
      }
      Directory::OpenDirectoryCallback callback =
          Directory_OpenDirectory_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenDirectory(
std::move(p_path), 
std::move(p_directory), 
std::move(p_open_flags), std::move(callback));
      return true;
    }
    case internal::kDirectory_Rename_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::Rename",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::Rename");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_Rename_Params_Data* params =
          reinterpret_cast<
              internal::Directory_Rename_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_path{};
      WTF::String p_new_path{};
      Directory_Rename_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadNewPath(&p_new_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 5, false);
        return false;
      }
      Directory::RenameCallback callback =
          Directory_Rename_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Rename(
std::move(p_path), 
std::move(p_new_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_Replace_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::Replace",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::Replace");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_Replace_Params_Data* params =
          reinterpret_cast<
              internal::Directory_Replace_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_path{};
      WTF::String p_new_path{};
      Directory_Replace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadNewPath(&p_new_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 6, false);
        return false;
      }
      Directory::ReplaceCallback callback =
          Directory_Replace_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Replace(
std::move(p_path), 
std::move(p_new_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_Delete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::Delete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::Delete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_Delete_Params_Data* params =
          reinterpret_cast<
              internal::Directory_Delete_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_path{};
      uint32_t p_delete_flags{};
      Directory_Delete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success)
        p_delete_flags = input_data_view.delete_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 7, false);
        return false;
      }
      Directory::DeleteCallback callback =
          Directory_Delete_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(
std::move(p_path), 
std::move(p_delete_flags), std::move(callback));
      return true;
    }
    case internal::kDirectory_Exists_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::Exists",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::Exists");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_Exists_Params_Data* params =
          reinterpret_cast<
              internal::Directory_Exists_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_path{};
      Directory_Exists_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 8, false);
        return false;
      }
      Directory::ExistsCallback callback =
          Directory_Exists_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Exists(
std::move(p_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_IsWritable_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::IsWritable",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::IsWritable");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_IsWritable_Params_Data* params =
          reinterpret_cast<
              internal::Directory_IsWritable_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_path{};
      Directory_IsWritable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 9, false);
        return false;
      }
      Directory::IsWritableCallback callback =
          Directory_IsWritable_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsWritable(
std::move(p_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_Flush_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::Flush",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::Flush");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_Flush_Params_Data* params =
          reinterpret_cast<
              internal::Directory_Flush_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Directory_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 10, false);
        return false;
      }
      Directory::FlushCallback callback =
          Directory_Flush_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(std::move(callback));
      return true;
    }
    case internal::kDirectory_StatFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::StatFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::StatFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_StatFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_StatFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_path{};
      Directory_StatFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 11, false);
        return false;
      }
      Directory::StatFileCallback callback =
          Directory_StatFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StatFile(
std::move(p_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_Clone_Name: {
      break;
    }
    case internal::kDirectory_ReadEntireFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::ReadEntireFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::ReadEntireFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_ReadEntireFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_ReadEntireFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_path{};
      Directory_ReadEntireFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 13, false);
        return false;
      }
      Directory::ReadEntireFileCallback callback =
          Directory_ReadEntireFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadEntireFile(
std::move(p_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_WriteFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)filesystem::mojom::Directory::WriteFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)filesystem::mojom::Directory::WriteFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_WriteFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_WriteFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_path{};
      WTF::Vector<uint8_t> p_data{};
      Directory_WriteFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 14, false);
        return false;
      }
      Directory::WriteFileCallback callback =
          Directory_WriteFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteFile(
std::move(p_path), 
std::move(p_data), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDirectoryValidationInfo[] = {
    {internal::kDirectory_Read_Name,
     {&internal::Directory_Read_Params_Data::Validate,
      &internal::Directory_Read_ResponseParams_Data::Validate}},
    {internal::kDirectory_OpenFile_Name,
     {&internal::Directory_OpenFile_Params_Data::Validate,
      &internal::Directory_OpenFile_ResponseParams_Data::Validate}},
    {internal::kDirectory_OpenFileHandle_Name,
     {&internal::Directory_OpenFileHandle_Params_Data::Validate,
      &internal::Directory_OpenFileHandle_ResponseParams_Data::Validate}},
    {internal::kDirectory_OpenFileHandles_Name,
     {&internal::Directory_OpenFileHandles_Params_Data::Validate,
      &internal::Directory_OpenFileHandles_ResponseParams_Data::Validate}},
    {internal::kDirectory_OpenDirectory_Name,
     {&internal::Directory_OpenDirectory_Params_Data::Validate,
      &internal::Directory_OpenDirectory_ResponseParams_Data::Validate}},
    {internal::kDirectory_Rename_Name,
     {&internal::Directory_Rename_Params_Data::Validate,
      &internal::Directory_Rename_ResponseParams_Data::Validate}},
    {internal::kDirectory_Replace_Name,
     {&internal::Directory_Replace_Params_Data::Validate,
      &internal::Directory_Replace_ResponseParams_Data::Validate}},
    {internal::kDirectory_Delete_Name,
     {&internal::Directory_Delete_Params_Data::Validate,
      &internal::Directory_Delete_ResponseParams_Data::Validate}},
    {internal::kDirectory_Exists_Name,
     {&internal::Directory_Exists_Params_Data::Validate,
      &internal::Directory_Exists_ResponseParams_Data::Validate}},
    {internal::kDirectory_IsWritable_Name,
     {&internal::Directory_IsWritable_Params_Data::Validate,
      &internal::Directory_IsWritable_ResponseParams_Data::Validate}},
    {internal::kDirectory_Flush_Name,
     {&internal::Directory_Flush_Params_Data::Validate,
      &internal::Directory_Flush_ResponseParams_Data::Validate}},
    {internal::kDirectory_StatFile_Name,
     {&internal::Directory_StatFile_Params_Data::Validate,
      &internal::Directory_StatFile_ResponseParams_Data::Validate}},
    {internal::kDirectory_Clone_Name,
     {&internal::Directory_Clone_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDirectory_ReadEntireFile_Name,
     {&internal::Directory_ReadEntireFile_Params_Data::Validate,
      &internal::Directory_ReadEntireFile_ResponseParams_Data::Validate}},
    {internal::kDirectory_WriteFile_Name,
     {&internal::Directory_WriteFile_Params_Data::Validate,
      &internal::Directory_WriteFile_ResponseParams_Data::Validate}},
};

bool DirectoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::filesystem::mojom::blink::Directory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDirectoryValidationInfo);
}

bool DirectoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::filesystem::mojom::blink::Directory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDirectoryValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace filesystem

namespace mojo {


// static
bool StructTraits<::filesystem::mojom::blink::FileOpenDetails::DataView, ::filesystem::mojom::blink::FileOpenDetailsPtr>::Read(
    ::filesystem::mojom::blink::FileOpenDetails::DataView input,
    ::filesystem::mojom::blink::FileOpenDetailsPtr* output) {
  bool success = true;
  ::filesystem::mojom::blink::FileOpenDetailsPtr result(::filesystem::mojom::blink::FileOpenDetails::New());
  
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success)
        result->open_flags = input.open_flags();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::filesystem::mojom::blink::FileOpenResult::DataView, ::filesystem::mojom::blink::FileOpenResultPtr>::Read(
    ::filesystem::mojom::blink::FileOpenResult::DataView input,
    ::filesystem::mojom::blink::FileOpenResultPtr* output) {
  bool success = true;
  ::filesystem::mojom::blink::FileOpenResultPtr result(::filesystem::mojom::blink::FileOpenResult::New());
  
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadError(&result->error))
        success = false;
      if (success && !input.ReadFileHandle(&result->file_handle))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif