// components/services/storage/public/mojom/file_system_access_context.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/file_system_access_context.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/file_system_access_context.mojom-params-data.h"
#include "components/services/storage/public/mojom/file_system_access_context.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/file_system_access_context.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_CONTEXT_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_CONTEXT_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
const char FileSystemAccessContext::Name_[] = "storage.mojom.FileSystemAccessContext";

class FileSystemAccessContext_SerializeHandle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessContext_SerializeHandle_ForwardToCallback(
      FileSystemAccessContext::SerializeHandleCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessContext::SerializeHandleCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessContext_SerializeHandle_ForwardToCallback);
};

FileSystemAccessContextProxy::FileSystemAccessContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessContextProxy::SerializeHandle(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> in_token, SerializeHandleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::FileSystemAccessContext::SerializeHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessContext_SerializeHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileSystemAccessContext_SerializeHandle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
      in_token, &params->token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in FileSystemAccessContext.SerializeHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessContext::Name_);
  message.set_method_name("SerializeHandle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessContext_SerializeHandle_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessContextProxy::DeserializeHandle(
    const ::url::Origin& in_origin, const std::vector<uint8_t>& in_bits, ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::FileSystemAccessContext::DeserializeHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bits"), in_bits,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessContext_DeserializeHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileSystemAccessContext_DeserializeHandle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in FileSystemAccessContext.DeserializeHandle request");
  mojo::internal::MessageFragment<
      typename decltype(params->bits)::BaseType>
      bits_fragment(params.message());
  const mojo::internal::ContainerValidateParams bits_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bits, bits_fragment, &bits_validate_params);
  params->bits.Set(
      bits_fragment.is_null() ? nullptr : bits_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bits.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bits in FileSystemAccessContext.DeserializeHandle request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
      in_token, &params->token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in FileSystemAccessContext.DeserializeHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessContext::Name_);
  message.set_method_name("DeserializeHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class FileSystemAccessContext_SerializeHandle_ProxyToResponder {
 public:
  static FileSystemAccessContext::SerializeHandleCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessContext_SerializeHandle_ProxyToResponder> proxy(
        new FileSystemAccessContext_SerializeHandle_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessContext_SerializeHandle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessContext_SerializeHandle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessContext_SerializeHandle_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessContext::SerializeHandleCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<uint8_t>& in_bits);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessContext_SerializeHandle_ProxyToResponder);
};

bool FileSystemAccessContext_SerializeHandle_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::FileSystemAccessContext::SerializeHandleCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessContext_SerializeHandle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessContext_SerializeHandle_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<uint8_t> p_bits{};
  FileSystemAccessContext_SerializeHandle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBits(&p_bits))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessContext::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_bits));
  return true;
}

void FileSystemAccessContext_SerializeHandle_ProxyToResponder::Run(
    const std::vector<uint8_t>& in_bits) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::FileSystemAccessContext::SerializeHandleCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bits"), in_bits,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessContext_SerializeHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileSystemAccessContext_SerializeHandle_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bits)::BaseType>
      bits_fragment(params.message());
  const mojo::internal::ContainerValidateParams bits_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bits, bits_fragment, &bits_validate_params);
  params->bits.Set(
      bits_fragment.is_null() ? nullptr : bits_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bits.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bits in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::FileSystemAccessContext::SerializeHandleCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessContext::Name_);
  message.set_method_name("SerializeHandle");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessContextStubDispatch::Accept(
    FileSystemAccessContext* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFileSystemAccessContext_SerializeHandle_Name: {
      break;
    }
    case internal::kFileSystemAccessContext_DeserializeHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::FileSystemAccessContext::DeserializeHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::FileSystemAccessContext::DeserializeHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FileSystemAccessContext_DeserializeHandle_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessContext_DeserializeHandle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      std::vector<uint8_t> p_bits{};
      ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> p_token{};
      FileSystemAccessContext_DeserializeHandle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadBits(&p_bits))
        success = false;
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessContext::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeserializeHandle(
std::move(p_origin), 
std::move(p_bits), 
std::move(p_token));
      return true;
    }
  }
  return false;
}

// static
bool FileSystemAccessContextStubDispatch::AcceptWithResponder(
    FileSystemAccessContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFileSystemAccessContext_SerializeHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::FileSystemAccessContext::SerializeHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::FileSystemAccessContext::SerializeHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessContext_SerializeHandle_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessContext_SerializeHandle_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> p_token{};
      FileSystemAccessContext_SerializeHandle_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessContext::Name_, 0, false);
        return false;
      }
      FileSystemAccessContext::SerializeHandleCallback callback =
          FileSystemAccessContext_SerializeHandle_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SerializeHandle(
std::move(p_token), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessContext_DeserializeHandle_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFileSystemAccessContextValidationInfo[] = {
    {internal::kFileSystemAccessContext_SerializeHandle_Name,
     {&internal::FileSystemAccessContext_SerializeHandle_Params_Data::Validate,
      &internal::FileSystemAccessContext_SerializeHandle_ResponseParams_Data::Validate}},
    {internal::kFileSystemAccessContext_DeserializeHandle_Name,
     {&internal::FileSystemAccessContext_DeserializeHandle_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FileSystemAccessContextRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::FileSystemAccessContext::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFileSystemAccessContextValidationInfo);
}

bool FileSystemAccessContextResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::FileSystemAccessContext::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kFileSystemAccessContextValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif