// components/services/storage/public/mojom/filesystem/directory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/filesystem/directory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/filesystem/directory.mojom-params-data.h"
#include "components/services/storage/public/mojom/filesystem/directory.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/filesystem/directory.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
StrictRelativePath::StrictRelativePath()
    : path() {}

StrictRelativePath::StrictRelativePath(
    const ::base::FilePath& path_in)
    : path(std::move(path_in)) {}

StrictRelativePath::~StrictRelativePath() = default;

void StrictRelativePath::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StrictRelativePath::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PathAccessInfo::PathAccessInfo()
    : can_read(),
      can_write() {}

PathAccessInfo::PathAccessInfo(
    bool can_read_in,
    bool can_write_in)
    : can_read(std::move(can_read_in)),
      can_write(std::move(can_write_in)) {}

PathAccessInfo::~PathAccessInfo() = default;
size_t PathAccessInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->can_read);
  seed = mojo::internal::Hash(seed, this->can_write);
  return seed;
}

void PathAccessInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_read"), this->can_read,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_write"), this->can_write,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PathAccessInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char FileLock::Name_[] = "storage.mojom.FileLock";
bool FileLock::Release(::base::File::Error* out_error) {
  NOTREACHED();
  return false;
}
class FileLock_Release_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileLock_Release_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;DISALLOW_COPY_AND_ASSIGN(FileLock_Release_HandleSyncResponse);
};

class FileLock_Release_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileLock_Release_ForwardToCallback(
      FileLock::ReleaseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileLock::ReleaseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileLock_Release_ForwardToCallback);
};

FileLockProxy::FileLockProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FileLockProxy::Release(
    ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "storage::mojom::FileLock::Release");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileLock_Release_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileLock_Release_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileLock::Name_);
  message.set_method_name("Release");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileLock_Release_HandleSyncResponse(
          &result, out_param_error));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::FileLock::Release", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileLockProxy::Release(
    ReleaseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::FileLock::Release");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileLock_Release_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileLock_Release_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileLock::Name_);
  message.set_method_name("Release");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileLock_Release_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class FileLock_Release_ProxyToResponder {
 public:
  static FileLock::ReleaseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileLock_Release_ProxyToResponder> proxy(
        new FileLock_Release_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileLock_Release_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileLock_Release_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileLock_Release_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileLock::ReleaseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileLock_Release_ProxyToResponder);
};

bool FileLock_Release_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::FileLock::ReleaseCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileLock_Release_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileLock_Release_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  FileLock_Release_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileLock::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void FileLock_Release_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::FileLock::ReleaseCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileLock_Release_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileLock_Release_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::FileLock::ReleaseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileLock::Name_);
  message.set_method_name("Release");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileLock_Release_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FileLock_Release_ResponseParams_Data* params =
      reinterpret_cast<internal::FileLock_Release_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  FileLock_Release_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileLock::Name_, 0, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}

// static
bool FileLockStubDispatch::Accept(
    FileLock* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFileLock_Release_Name: {
      break;
    }
  }
  return false;
}

// static
bool FileLockStubDispatch::AcceptWithResponder(
    FileLock* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFileLock_Release_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::FileLock::Release",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::FileLock::Release");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileLock_Release_Params_Data* params =
          reinterpret_cast<
              internal::FileLock_Release_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      FileLock_Release_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileLock::Name_, 0, false);
        return false;
      }
      FileLock::ReleaseCallback callback =
          FileLock_Release_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Release(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFileLockValidationInfo[] = {
    {internal::kFileLock_Release_Name,
     {&internal::FileLock_Release_Params_Data::Validate,
      &internal::FileLock_Release_ResponseParams_Data::Validate}},
};

bool FileLockRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::FileLock::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFileLockValidationInfo);
}

bool FileLockResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::FileLock::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kFileLockValidationInfo);

}
const char Directory::Name_[] = "storage.mojom.Directory";
bool Directory::PathExists(const ::base::FilePath& path, bool* out_exists) {
  NOTREACHED();
  return false;
}
bool Directory::GetEntries(const ::base::FilePath& path, GetEntriesMode mode, ::base::File::Error* out_error, std::vector<::base::FilePath>* out_entries) {
  NOTREACHED();
  return false;
}
bool Directory::OpenFile(const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, ::base::File::Error* out_error, ::base::File* out_file) {
  NOTREACHED();
  return false;
}
bool Directory::WriteFileAtomically(const ::base::FilePath& path, const ::std::string& contents, bool* out_success) {
  NOTREACHED();
  return false;
}
bool Directory::CreateDirectory(const ::base::FilePath& path, ::base::File::Error* out_error) {
  NOTREACHED();
  return false;
}
bool Directory::DeleteFile(const ::base::FilePath& path, bool* out_success) {
  NOTREACHED();
  return false;
}
bool Directory::DeletePathRecursively(const ::base::FilePath& path, bool* out_success) {
  NOTREACHED();
  return false;
}
bool Directory::GetFileInfo(const ::base::FilePath& path, absl::optional<::base::File::Info>* out_info) {
  NOTREACHED();
  return false;
}
bool Directory::GetPathAccess(const ::base::FilePath& path, PathAccessInfoPtr* out_info) {
  NOTREACHED();
  return false;
}
bool Directory::GetMaximumPathComponentLength(const ::base::FilePath& path, bool* out_success, int32_t* out_length) {
  NOTREACHED();
  return false;
}
bool Directory::RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path, ::base::File::Error* out_error) {
  NOTREACHED();
  return false;
}
bool Directory::LockFile(const ::base::FilePath& path, ::base::File::Error* out_error, ::mojo::PendingRemote<FileLock>* out_lock) {
  NOTREACHED();
  return false;
}
bool Directory::SetOpenedFileLength(::base::File file, uint64_t size, bool* out_success, ::base::File* out_file) {
  NOTREACHED();
  return false;
}
class Directory_PathExists_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_PathExists_HandleSyncResponse(
      bool* result, bool* out_exists)
      : result_(result), out_exists_(out_exists) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_exists_;DISALLOW_COPY_AND_ASSIGN(Directory_PathExists_HandleSyncResponse);
};

class Directory_PathExists_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_PathExists_ForwardToCallback(
      Directory::PathExistsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::PathExistsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_PathExists_ForwardToCallback);
};
class Directory_GetEntries_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_GetEntries_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, std::vector<::base::FilePath>* out_entries)
      : result_(result), out_error_(out_error), out_entries_(out_entries) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  std::vector<::base::FilePath>* out_entries_;DISALLOW_COPY_AND_ASSIGN(Directory_GetEntries_HandleSyncResponse);
};

class Directory_GetEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_GetEntries_ForwardToCallback(
      Directory::GetEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::GetEntriesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_GetEntries_ForwardToCallback);
};
class Directory_OpenFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, ::base::File* out_file)
      : result_(result), out_error_(out_error), out_file_(out_file) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  ::base::File* out_file_;DISALLOW_COPY_AND_ASSIGN(Directory_OpenFile_HandleSyncResponse);
};

class Directory_OpenFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFile_ForwardToCallback(
      Directory::OpenFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::OpenFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_OpenFile_ForwardToCallback);
};
class Directory_WriteFileAtomically_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_WriteFileAtomically_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;DISALLOW_COPY_AND_ASSIGN(Directory_WriteFileAtomically_HandleSyncResponse);
};

class Directory_WriteFileAtomically_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_WriteFileAtomically_ForwardToCallback(
      Directory::WriteFileAtomicallyCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::WriteFileAtomicallyCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_WriteFileAtomically_ForwardToCallback);
};
class Directory_CreateDirectory_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_CreateDirectory_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;DISALLOW_COPY_AND_ASSIGN(Directory_CreateDirectory_HandleSyncResponse);
};

class Directory_CreateDirectory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_CreateDirectory_ForwardToCallback(
      Directory::CreateDirectoryCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::CreateDirectoryCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_CreateDirectory_ForwardToCallback);
};
class Directory_DeleteFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_DeleteFile_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;DISALLOW_COPY_AND_ASSIGN(Directory_DeleteFile_HandleSyncResponse);
};

class Directory_DeleteFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_DeleteFile_ForwardToCallback(
      Directory::DeleteFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::DeleteFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_DeleteFile_ForwardToCallback);
};
class Directory_DeletePathRecursively_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_DeletePathRecursively_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;DISALLOW_COPY_AND_ASSIGN(Directory_DeletePathRecursively_HandleSyncResponse);
};

class Directory_DeletePathRecursively_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_DeletePathRecursively_ForwardToCallback(
      Directory::DeletePathRecursivelyCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::DeletePathRecursivelyCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_DeletePathRecursively_ForwardToCallback);
};
class Directory_GetFileInfo_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_GetFileInfo_HandleSyncResponse(
      bool* result, absl::optional<::base::File::Info>* out_info)
      : result_(result), out_info_(out_info) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  absl::optional<::base::File::Info>* out_info_;DISALLOW_COPY_AND_ASSIGN(Directory_GetFileInfo_HandleSyncResponse);
};

class Directory_GetFileInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_GetFileInfo_ForwardToCallback(
      Directory::GetFileInfoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::GetFileInfoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_GetFileInfo_ForwardToCallback);
};
class Directory_GetPathAccess_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_GetPathAccess_HandleSyncResponse(
      bool* result, PathAccessInfoPtr* out_info)
      : result_(result), out_info_(out_info) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PathAccessInfoPtr* out_info_;DISALLOW_COPY_AND_ASSIGN(Directory_GetPathAccess_HandleSyncResponse);
};

class Directory_GetPathAccess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_GetPathAccess_ForwardToCallback(
      Directory::GetPathAccessCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::GetPathAccessCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_GetPathAccess_ForwardToCallback);
};
class Directory_GetMaximumPathComponentLength_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_GetMaximumPathComponentLength_HandleSyncResponse(
      bool* result, bool* out_success, int32_t* out_length)
      : result_(result), out_success_(out_success), out_length_(out_length) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;
  int32_t* out_length_;DISALLOW_COPY_AND_ASSIGN(Directory_GetMaximumPathComponentLength_HandleSyncResponse);
};

class Directory_GetMaximumPathComponentLength_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_GetMaximumPathComponentLength_ForwardToCallback(
      Directory::GetMaximumPathComponentLengthCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::GetMaximumPathComponentLengthCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_GetMaximumPathComponentLength_ForwardToCallback);
};
class Directory_RenameFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_RenameFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;DISALLOW_COPY_AND_ASSIGN(Directory_RenameFile_HandleSyncResponse);
};

class Directory_RenameFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_RenameFile_ForwardToCallback(
      Directory::RenameFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::RenameFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_RenameFile_ForwardToCallback);
};
class Directory_LockFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_LockFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, ::mojo::PendingRemote<FileLock>* out_lock)
      : result_(result), out_error_(out_error), out_lock_(out_lock) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  ::mojo::PendingRemote<FileLock>* out_lock_;DISALLOW_COPY_AND_ASSIGN(Directory_LockFile_HandleSyncResponse);
};

class Directory_LockFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_LockFile_ForwardToCallback(
      Directory::LockFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::LockFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_LockFile_ForwardToCallback);
};
class Directory_SetOpenedFileLength_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_SetOpenedFileLength_HandleSyncResponse(
      bool* result, bool* out_success, ::base::File* out_file)
      : result_(result), out_success_(out_success), out_file_(out_file) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;
  ::base::File* out_file_;DISALLOW_COPY_AND_ASSIGN(Directory_SetOpenedFileLength_HandleSyncResponse);
};

class Directory_SetOpenedFileLength_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_SetOpenedFileLength_ForwardToCallback(
      Directory::SetOpenedFileLengthCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Directory::SetOpenedFileLengthCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Directory_SetOpenedFileLength_ForwardToCallback);
};

DirectoryProxy::DirectoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DirectoryProxy::Clone(
    ::mojo::PendingReceiver<Directory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<Directory>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::DirectoryInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in Directory.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool DirectoryProxy::PathExists(
    const ::base::FilePath& param_path, bool* out_param_exists) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::PathExists", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_PathExists_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_PathExists_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.PathExists request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("PathExists");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_PathExists_HandleSyncResponse(
          &result, out_param_exists));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::PathExists", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exists"), out_param_exists,
                        "<value of type bool>");
   });
#endif
  return result;
}

void DirectoryProxy::PathExists(
    const ::base::FilePath& in_path, PathExistsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::PathExists", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_PathExists_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_PathExists_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.PathExists request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("PathExists");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_PathExists_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::GetEntries(
    const ::base::FilePath& param_path, GetEntriesMode param_mode, ::base::File::Error* out_param_error, std::vector<::base::FilePath>* out_param_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::GetEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), param_mode,
                        "<value of type GetEntriesMode>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_GetEntries_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetEntries_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetEntries request");
  mojo::internal::Serialize<::storage::mojom::GetEntriesMode>(
      param_mode, &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetEntries");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetEntries_HandleSyncResponse(
          &result, out_param_error, out_param_entries));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::GetEntries", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), out_param_entries,
                        "<value of type const std::vector<::base::FilePath>&>");
   });
#endif
  return result;
}

void DirectoryProxy::GetEntries(
    const ::base::FilePath& in_path, GetEntriesMode in_mode, GetEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::GetEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type GetEntriesMode>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_GetEntries_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetEntries_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetEntries request");
  mojo::internal::Serialize<::storage::mojom::GetEntriesMode>(
      in_mode, &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetEntries_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::OpenFile(
    const ::base::FilePath& param_path, FileOpenMode param_mode, FileReadAccess param_read_access, FileWriteAccess param_write_access, ::base::File::Error* out_param_error, ::base::File* out_param_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::OpenFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), param_mode,
                        "<value of type FileOpenMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("read_access"), param_read_access,
                        "<value of type FileReadAccess>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("write_access"), param_write_access,
                        "<value of type FileWriteAccess>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_OpenFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.OpenFile request");
  mojo::internal::Serialize<::storage::mojom::FileOpenMode>(
      param_mode, &params->mode);
  mojo::internal::Serialize<::storage::mojom::FileReadAccess>(
      param_read_access, &params->read_access);
  mojo::internal::Serialize<::storage::mojom::FileWriteAccess>(
      param_write_access, &params->write_access);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFile_HandleSyncResponse(
          &result, out_param_error, out_param_file));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::OpenFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), out_param_file,
                        "<value of type ::base::File>");
   });
#endif
  return result;
}

void DirectoryProxy::OpenFile(
    const ::base::FilePath& in_path, FileOpenMode in_mode, FileReadAccess in_read_access, FileWriteAccess in_write_access, OpenFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::OpenFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type FileOpenMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("read_access"), in_read_access,
                        "<value of type FileReadAccess>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("write_access"), in_write_access,
                        "<value of type FileWriteAccess>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_OpenFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.OpenFile request");
  mojo::internal::Serialize<::storage::mojom::FileOpenMode>(
      in_mode, &params->mode);
  mojo::internal::Serialize<::storage::mojom::FileReadAccess>(
      in_read_access, &params->read_access);
  mojo::internal::Serialize<::storage::mojom::FileWriteAccess>(
      in_write_access, &params->write_access);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::WriteFileAtomically(
    const ::base::FilePath& param_path, const ::std::string& param_contents, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::WriteFileAtomically", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("contents"), param_contents,
                        "<value of type const ::std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_WriteFileAtomically_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_WriteFileAtomically_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.WriteFileAtomically request");
  mojo::internal::MessageFragment<
      typename decltype(params->contents)::BaseType> contents_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigStringDataView>(
      param_contents, contents_fragment);
  params->contents.Set(
      contents_fragment.is_null() ? nullptr : contents_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->contents.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null contents in Directory.WriteFileAtomically request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("WriteFileAtomically");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_WriteFileAtomically_HandleSyncResponse(
          &result, out_param_success));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::WriteFileAtomically", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void DirectoryProxy::WriteFileAtomically(
    const ::base::FilePath& in_path, const ::std::string& in_contents, WriteFileAtomicallyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::WriteFileAtomically", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("contents"), in_contents,
                        "<value of type const ::std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_WriteFileAtomically_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_WriteFileAtomically_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.WriteFileAtomically request");
  mojo::internal::MessageFragment<
      typename decltype(params->contents)::BaseType> contents_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigStringDataView>(
      in_contents, contents_fragment);
  params->contents.Set(
      contents_fragment.is_null() ? nullptr : contents_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->contents.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null contents in Directory.WriteFileAtomically request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("WriteFileAtomically");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_WriteFileAtomically_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::CreateDirectory(
    const ::base::FilePath& param_path, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::CreateDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_CreateDirectory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_CreateDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.CreateDirectory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("CreateDirectory");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_CreateDirectory_HandleSyncResponse(
          &result, out_param_error));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::CreateDirectory", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::CreateDirectory(
    const ::base::FilePath& in_path, CreateDirectoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::CreateDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_CreateDirectory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_CreateDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.CreateDirectory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("CreateDirectory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_CreateDirectory_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::DeleteFile(
    const ::base::FilePath& param_path, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::DeleteFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_DeleteFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_DeleteFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.DeleteFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("DeleteFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_DeleteFile_HandleSyncResponse(
          &result, out_param_success));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::DeleteFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void DirectoryProxy::DeleteFile(
    const ::base::FilePath& in_path, DeleteFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::DeleteFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_DeleteFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_DeleteFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.DeleteFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("DeleteFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_DeleteFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::DeletePathRecursively(
    const ::base::FilePath& param_path, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::DeletePathRecursively", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_DeletePathRecursively_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_DeletePathRecursively_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.DeletePathRecursively request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("DeletePathRecursively");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_DeletePathRecursively_HandleSyncResponse(
          &result, out_param_success));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::DeletePathRecursively", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void DirectoryProxy::DeletePathRecursively(
    const ::base::FilePath& in_path, DeletePathRecursivelyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::DeletePathRecursively", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_DeletePathRecursively_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_DeletePathRecursively_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.DeletePathRecursively request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("DeletePathRecursively");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_DeletePathRecursively_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::GetFileInfo(
    const ::base::FilePath& param_path, absl::optional<::base::File::Info>* out_param_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::GetFileInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_GetFileInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetFileInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetFileInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetFileInfo");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetFileInfo_HandleSyncResponse(
          &result, out_param_info));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::GetFileInfo", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), out_param_info,
                        "<value of type const absl::optional<::base::File::Info>&>");
   });
#endif
  return result;
}

void DirectoryProxy::GetFileInfo(
    const ::base::FilePath& in_path, GetFileInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::GetFileInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_GetFileInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetFileInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetFileInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetFileInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetFileInfo_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::GetPathAccess(
    const ::base::FilePath& param_path, PathAccessInfoPtr* out_param_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::GetPathAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_GetPathAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetPathAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetPathAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetPathAccess");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetPathAccess_HandleSyncResponse(
          &result, out_param_info));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::GetPathAccess", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), out_param_info,
                        "<value of type PathAccessInfoPtr>");
   });
#endif
  return result;
}

void DirectoryProxy::GetPathAccess(
    const ::base::FilePath& in_path, GetPathAccessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::GetPathAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_GetPathAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetPathAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetPathAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetPathAccess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetPathAccess_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::GetMaximumPathComponentLength(
    const ::base::FilePath& param_path, bool* out_param_success, int32_t* out_param_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::GetMaximumPathComponentLength", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_GetMaximumPathComponentLength_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetMaximumPathComponentLength_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetMaximumPathComponentLength request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetMaximumPathComponentLength");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetMaximumPathComponentLength_HandleSyncResponse(
          &result, out_param_success, out_param_length));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::GetMaximumPathComponentLength", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), out_param_length,
                        "<value of type int32_t>");
   });
#endif
  return result;
}

void DirectoryProxy::GetMaximumPathComponentLength(
    const ::base::FilePath& in_path, GetMaximumPathComponentLengthCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::GetMaximumPathComponentLength", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_GetMaximumPathComponentLength_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetMaximumPathComponentLength_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetMaximumPathComponentLength request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetMaximumPathComponentLength");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetMaximumPathComponentLength_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::RenameFile(
    const ::base::FilePath& param_old_path, const ::base::FilePath& param_new_path, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::RenameFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_path"), param_old_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_path"), param_new_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_RenameFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_RenameFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->old_path)::BaseType> old_path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_old_path, old_path_fragment);
  params->old_path.Set(
      old_path_fragment.is_null() ? nullptr : old_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->old_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null old_path in Directory.RenameFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_path)::BaseType> new_path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_new_path, new_path_fragment);
  params->new_path.Set(
      new_path_fragment.is_null() ? nullptr : new_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_path in Directory.RenameFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("RenameFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_RenameFile_HandleSyncResponse(
          &result, out_param_error));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::RenameFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::RenameFile(
    const ::base::FilePath& in_old_path, const ::base::FilePath& in_new_path, RenameFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::RenameFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_path"), in_old_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_path"), in_new_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_RenameFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_RenameFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->old_path)::BaseType> old_path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_old_path, old_path_fragment);
  params->old_path.Set(
      old_path_fragment.is_null() ? nullptr : old_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->old_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null old_path in Directory.RenameFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_path)::BaseType> new_path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_new_path, new_path_fragment);
  params->new_path.Set(
      new_path_fragment.is_null() ? nullptr : new_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_path in Directory.RenameFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("RenameFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_RenameFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::LockFile(
    const ::base::FilePath& param_path, ::base::File::Error* out_param_error, ::mojo::PendingRemote<FileLock>* out_param_lock) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::LockFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_LockFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_LockFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.LockFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("LockFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_LockFile_HandleSyncResponse(
          &result, out_param_error, out_param_lock));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::LockFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lock"), out_param_lock,
                        "<value of type ::mojo::PendingRemote<FileLock>>");
   });
#endif
  return result;
}

void DirectoryProxy::LockFile(
    const ::base::FilePath& in_path, LockFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::LockFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_LockFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_LockFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.LockFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("LockFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_LockFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool DirectoryProxy::SetOpenedFileLength(
    ::base::File param_file, uint64_t param_size, bool* out_param_success, ::base::File* out_param_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "storage::mojom::Directory::SetOpenedFileLength", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), param_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), param_size,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_SetOpenedFileLength_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_SetOpenedFileLength_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      param_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file in Directory.SetOpenedFileLength request");
  params->size = param_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("SetOpenedFileLength");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_SetOpenedFileLength_HandleSyncResponse(
          &result, out_param_success, out_param_file));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "storage::mojom::Directory::SetOpenedFileLength", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), out_param_file,
                        "<value of type ::base::File>");
   });
#endif
  return result;
}

void DirectoryProxy::SetOpenedFileLength(
    ::base::File in_file, uint64_t in_size, SetOpenedFileLengthCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::Directory::SetOpenedFileLength", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_SetOpenedFileLength_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_SetOpenedFileLength_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file in Directory.SetOpenedFileLength request");
  params->size = in_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("SetOpenedFileLength");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_SetOpenedFileLength_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class Directory_PathExists_ProxyToResponder {
 public:
  static Directory::PathExistsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_PathExists_ProxyToResponder> proxy(
        new Directory_PathExists_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_PathExists_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_PathExists_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_PathExists_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::PathExistsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_exists);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_PathExists_ProxyToResponder);
};

bool Directory_PathExists_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::PathExistsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_PathExists_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_PathExists_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_exists{};
  Directory_PathExists_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_exists = input_data_view.exists();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_exists));
  return true;
}

void Directory_PathExists_ProxyToResponder::Run(
    bool in_exists) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::PathExistsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exists"), in_exists,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_PathExists_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_PathExists_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->exists = in_exists;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::PathExistsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("PathExists");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_PathExists_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_PathExists_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_PathExists_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_exists{};
  Directory_PathExists_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_exists = input_data_view.exists();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 1, true);
    return false;
  }
  *out_exists_ = std::move(p_exists);
  *result_ = true;
  return true;
}
class Directory_GetEntries_ProxyToResponder {
 public:
  static Directory::GetEntriesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_GetEntries_ProxyToResponder> proxy(
        new Directory_GetEntries_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_GetEntries_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_GetEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_GetEntries_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::GetEntriesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, const std::vector<::base::FilePath>& in_entries);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_GetEntries_ProxyToResponder);
};

bool Directory_GetEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::GetEntriesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_GetEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_GetEntries_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  std::vector<::base::FilePath> p_entries{};
  Directory_GetEntries_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_entries));
  return true;
}

void Directory_GetEntries_ProxyToResponder::Run(
    ::base::File::Error in_error, const std::vector<::base::FilePath>& in_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::GetEntriesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type const std::vector<::base::FilePath>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_GetEntries_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetEntries_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  const mojo::internal::ContainerValidateParams entries_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
      in_entries, entries_fragment, &entries_validate_params);
  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entries.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entries in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::GetEntriesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetEntries");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_GetEntries_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_GetEntries_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_GetEntries_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  std::vector<::base::FilePath> p_entries{};
  Directory_GetEntries_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 2, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_entries_ = std::move(p_entries);
  *result_ = true;
  return true;
}
class Directory_OpenFile_ProxyToResponder {
 public:
  static Directory::OpenFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_OpenFile_ProxyToResponder> proxy(
        new Directory_OpenFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_OpenFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_OpenFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_OpenFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::OpenFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, ::base::File in_file);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_OpenFile_ProxyToResponder);
};

bool Directory_OpenFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::OpenFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_OpenFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  ::base::File p_file{};
  Directory_OpenFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_file));
  return true;
}

void Directory_OpenFile_ProxyToResponder::Run(
    ::base::File::Error in_error, ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::OpenFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_OpenFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_OpenFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::OpenFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_OpenFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_OpenFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  ::base::File p_file{};
  Directory_OpenFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 3, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_file_ = std::move(p_file);
  *result_ = true;
  return true;
}
class Directory_WriteFileAtomically_ProxyToResponder {
 public:
  static Directory::WriteFileAtomicallyCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_WriteFileAtomically_ProxyToResponder> proxy(
        new Directory_WriteFileAtomically_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_WriteFileAtomically_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_WriteFileAtomically_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_WriteFileAtomically_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::WriteFileAtomicallyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_WriteFileAtomically_ProxyToResponder);
};

bool Directory_WriteFileAtomically_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::WriteFileAtomicallyCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_WriteFileAtomically_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_WriteFileAtomically_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  Directory_WriteFileAtomically_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void Directory_WriteFileAtomically_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::WriteFileAtomicallyCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_WriteFileAtomically_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_WriteFileAtomically_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::WriteFileAtomicallyCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("WriteFileAtomically");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_WriteFileAtomically_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_WriteFileAtomically_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_WriteFileAtomically_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  Directory_WriteFileAtomically_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 4, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}
class Directory_CreateDirectory_ProxyToResponder {
 public:
  static Directory::CreateDirectoryCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_CreateDirectory_ProxyToResponder> proxy(
        new Directory_CreateDirectory_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_CreateDirectory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_CreateDirectory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_CreateDirectory_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::CreateDirectoryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_CreateDirectory_ProxyToResponder);
};

bool Directory_CreateDirectory_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::CreateDirectoryCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_CreateDirectory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_CreateDirectory_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_CreateDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void Directory_CreateDirectory_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::CreateDirectoryCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_CreateDirectory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_CreateDirectory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::CreateDirectoryCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("CreateDirectory");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_CreateDirectory_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_CreateDirectory_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_CreateDirectory_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_CreateDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 5, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_DeleteFile_ProxyToResponder {
 public:
  static Directory::DeleteFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_DeleteFile_ProxyToResponder> proxy(
        new Directory_DeleteFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_DeleteFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_DeleteFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_DeleteFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::DeleteFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_DeleteFile_ProxyToResponder);
};

bool Directory_DeleteFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::DeleteFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_DeleteFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_DeleteFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  Directory_DeleteFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void Directory_DeleteFile_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::DeleteFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_DeleteFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_DeleteFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::DeleteFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("DeleteFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_DeleteFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_DeleteFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_DeleteFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  Directory_DeleteFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 6, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}
class Directory_DeletePathRecursively_ProxyToResponder {
 public:
  static Directory::DeletePathRecursivelyCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_DeletePathRecursively_ProxyToResponder> proxy(
        new Directory_DeletePathRecursively_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_DeletePathRecursively_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_DeletePathRecursively_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_DeletePathRecursively_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::DeletePathRecursivelyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_DeletePathRecursively_ProxyToResponder);
};

bool Directory_DeletePathRecursively_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::DeletePathRecursivelyCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_DeletePathRecursively_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_DeletePathRecursively_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  Directory_DeletePathRecursively_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void Directory_DeletePathRecursively_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::DeletePathRecursivelyCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_DeletePathRecursively_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_DeletePathRecursively_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::DeletePathRecursivelyCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("DeletePathRecursively");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_DeletePathRecursively_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_DeletePathRecursively_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_DeletePathRecursively_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  Directory_DeletePathRecursively_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 7, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}
class Directory_GetFileInfo_ProxyToResponder {
 public:
  static Directory::GetFileInfoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_GetFileInfo_ProxyToResponder> proxy(
        new Directory_GetFileInfo_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_GetFileInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_GetFileInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_GetFileInfo_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::GetFileInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const absl::optional<::base::File::Info>& in_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_GetFileInfo_ProxyToResponder);
};

bool Directory_GetFileInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::GetFileInfoCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_GetFileInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_GetFileInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  absl::optional<::base::File::Info> p_info{};
  Directory_GetFileInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void Directory_GetFileInfo_ProxyToResponder::Run(
    const absl::optional<::base::File::Info>& in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::GetFileInfoCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type const absl::optional<::base::File::Info>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_GetFileInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetFileInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::GetFileInfoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetFileInfo");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_GetFileInfo_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_GetFileInfo_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_GetFileInfo_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  absl::optional<::base::File::Info> p_info{};
  Directory_GetFileInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 8, true);
    return false;
  }
  *out_info_ = std::move(p_info);
  *result_ = true;
  return true;
}
class Directory_GetPathAccess_ProxyToResponder {
 public:
  static Directory::GetPathAccessCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_GetPathAccess_ProxyToResponder> proxy(
        new Directory_GetPathAccess_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_GetPathAccess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_GetPathAccess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_GetPathAccess_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::GetPathAccessCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PathAccessInfoPtr in_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_GetPathAccess_ProxyToResponder);
};

bool Directory_GetPathAccess_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::GetPathAccessCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_GetPathAccess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_GetPathAccess_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PathAccessInfoPtr p_info{};
  Directory_GetPathAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void Directory_GetPathAccess_ProxyToResponder::Run(
    PathAccessInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::GetPathAccessCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type PathAccessInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_GetPathAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetPathAccess_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::PathAccessInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::GetPathAccessCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetPathAccess");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_GetPathAccess_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_GetPathAccess_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_GetPathAccess_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  PathAccessInfoPtr p_info{};
  Directory_GetPathAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 9, true);
    return false;
  }
  *out_info_ = std::move(p_info);
  *result_ = true;
  return true;
}
class Directory_GetMaximumPathComponentLength_ProxyToResponder {
 public:
  static Directory::GetMaximumPathComponentLengthCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_GetMaximumPathComponentLength_ProxyToResponder> proxy(
        new Directory_GetMaximumPathComponentLength_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_GetMaximumPathComponentLength_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_GetMaximumPathComponentLength_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_GetMaximumPathComponentLength_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::GetMaximumPathComponentLengthCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, int32_t in_length);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_GetMaximumPathComponentLength_ProxyToResponder);
};

bool Directory_GetMaximumPathComponentLength_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::GetMaximumPathComponentLengthCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_GetMaximumPathComponentLength_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_GetMaximumPathComponentLength_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  int32_t p_length{};
  Directory_GetMaximumPathComponentLength_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_length = input_data_view.length();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_length));
  return true;
}

void Directory_GetMaximumPathComponentLength_ProxyToResponder::Run(
    bool in_success, int32_t in_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::GetMaximumPathComponentLengthCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_GetMaximumPathComponentLength_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetMaximumPathComponentLength_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  params->length = in_length;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::GetMaximumPathComponentLengthCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetMaximumPathComponentLength");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_GetMaximumPathComponentLength_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_GetMaximumPathComponentLength_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_GetMaximumPathComponentLength_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  int32_t p_length{};
  Directory_GetMaximumPathComponentLength_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_length = input_data_view.length();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 10, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *out_length_ = std::move(p_length);
  *result_ = true;
  return true;
}
class Directory_RenameFile_ProxyToResponder {
 public:
  static Directory::RenameFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_RenameFile_ProxyToResponder> proxy(
        new Directory_RenameFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_RenameFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_RenameFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_RenameFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::RenameFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_RenameFile_ProxyToResponder);
};

bool Directory_RenameFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::RenameFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_RenameFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_RenameFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_RenameFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void Directory_RenameFile_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::RenameFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_RenameFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_RenameFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::RenameFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("RenameFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_RenameFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_RenameFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_RenameFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  Directory_RenameFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 11, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_LockFile_ProxyToResponder {
 public:
  static Directory::LockFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_LockFile_ProxyToResponder> proxy(
        new Directory_LockFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_LockFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_LockFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_LockFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::LockFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, ::mojo::PendingRemote<FileLock> in_lock);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_LockFile_ProxyToResponder);
};

bool Directory_LockFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::LockFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_LockFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_LockFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  ::mojo::PendingRemote<FileLock> p_lock{};
  Directory_LockFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success) {
    p_lock =
        input_data_view.TakeLock<decltype(p_lock)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_lock));
  return true;
}

void Directory_LockFile_ProxyToResponder::Run(
    ::base::File::Error in_error, ::mojo::PendingRemote<FileLock> in_lock) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::LockFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lock"), in_lock,
                        "<value of type ::mojo::PendingRemote<FileLock>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_LockFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_LockFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::FileLockInterfaceBase>>(
      in_lock, &params->lock, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::LockFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("LockFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_LockFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_LockFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_LockFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  ::mojo::PendingRemote<FileLock> p_lock{};
  Directory_LockFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success) {
    p_lock =
        input_data_view.TakeLock<decltype(p_lock)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 12, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_lock_ = std::move(p_lock);
  *result_ = true;
  return true;
}
class Directory_SetOpenedFileLength_ProxyToResponder {
 public:
  static Directory::SetOpenedFileLengthCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Directory_SetOpenedFileLength_ProxyToResponder> proxy(
        new Directory_SetOpenedFileLength_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Directory_SetOpenedFileLength_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_SetOpenedFileLength_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Directory_SetOpenedFileLength_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::SetOpenedFileLengthCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, ::base::File in_file);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Directory_SetOpenedFileLength_ProxyToResponder);
};

bool Directory_SetOpenedFileLength_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::Directory::SetOpenedFileLengthCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Directory_SetOpenedFileLength_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_SetOpenedFileLength_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  ::base::File p_file{};
  Directory_SetOpenedFileLength_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_file));
  return true;
}

void Directory_SetOpenedFileLength_ProxyToResponder::Run(
    bool in_success, ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::Directory::SetOpenedFileLengthCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDirectory_SetOpenedFileLength_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_SetOpenedFileLength_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::Directory::SetOpenedFileLengthCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("SetOpenedFileLength");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_SetOpenedFileLength_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Directory_SetOpenedFileLength_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_SetOpenedFileLength_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  ::base::File p_file{};
  Directory_SetOpenedFileLength_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 13, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *out_file_ = std::move(p_file);
  *result_ = true;
  return true;
}

// static
bool DirectoryStubDispatch::Accept(
    Directory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDirectory_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Directory_Clone_Params_Data* params =
          reinterpret_cast<internal::Directory_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<Directory> p_receiver{};
      Directory_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_receiver));
      return true;
    }
    case internal::kDirectory_PathExists_Name: {
      break;
    }
    case internal::kDirectory_GetEntries_Name: {
      break;
    }
    case internal::kDirectory_OpenFile_Name: {
      break;
    }
    case internal::kDirectory_WriteFileAtomically_Name: {
      break;
    }
    case internal::kDirectory_CreateDirectory_Name: {
      break;
    }
    case internal::kDirectory_DeleteFile_Name: {
      break;
    }
    case internal::kDirectory_DeletePathRecursively_Name: {
      break;
    }
    case internal::kDirectory_GetFileInfo_Name: {
      break;
    }
    case internal::kDirectory_GetPathAccess_Name: {
      break;
    }
    case internal::kDirectory_GetMaximumPathComponentLength_Name: {
      break;
    }
    case internal::kDirectory_RenameFile_Name: {
      break;
    }
    case internal::kDirectory_LockFile_Name: {
      break;
    }
    case internal::kDirectory_SetOpenedFileLength_Name: {
      break;
    }
  }
  return false;
}

// static
bool DirectoryStubDispatch::AcceptWithResponder(
    Directory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDirectory_Clone_Name: {
      break;
    }
    case internal::kDirectory_PathExists_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::PathExists",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::PathExists");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_PathExists_Params_Data* params =
          reinterpret_cast<
              internal::Directory_PathExists_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      Directory_PathExists_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 1, false);
        return false;
      }
      Directory::PathExistsCallback callback =
          Directory_PathExists_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PathExists(
std::move(p_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_GetEntries_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::GetEntries",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::GetEntries");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_GetEntries_Params_Data* params =
          reinterpret_cast<
              internal::Directory_GetEntries_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      GetEntriesMode p_mode{};
      Directory_GetEntries_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 2, false);
        return false;
      }
      Directory::GetEntriesCallback callback =
          Directory_GetEntries_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEntries(
std::move(p_path), 
std::move(p_mode), std::move(callback));
      return true;
    }
    case internal::kDirectory_OpenFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::OpenFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::OpenFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_OpenFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_OpenFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      FileOpenMode p_mode{};
      FileReadAccess p_read_access{};
      FileWriteAccess p_write_access{};
      Directory_OpenFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (success && !input_data_view.ReadReadAccess(&p_read_access))
        success = false;
      if (success && !input_data_view.ReadWriteAccess(&p_write_access))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 3, false);
        return false;
      }
      Directory::OpenFileCallback callback =
          Directory_OpenFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFile(
std::move(p_path), 
std::move(p_mode), 
std::move(p_read_access), 
std::move(p_write_access), std::move(callback));
      return true;
    }
    case internal::kDirectory_WriteFileAtomically_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::WriteFileAtomically",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::WriteFileAtomically");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_WriteFileAtomically_Params_Data* params =
          reinterpret_cast<
              internal::Directory_WriteFileAtomically_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      ::std::string p_contents{};
      Directory_WriteFileAtomically_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadContents(&p_contents))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 4, false);
        return false;
      }
      Directory::WriteFileAtomicallyCallback callback =
          Directory_WriteFileAtomically_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteFileAtomically(
std::move(p_path), 
std::move(p_contents), std::move(callback));
      return true;
    }
    case internal::kDirectory_CreateDirectory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::CreateDirectory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::CreateDirectory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_CreateDirectory_Params_Data* params =
          reinterpret_cast<
              internal::Directory_CreateDirectory_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      Directory_CreateDirectory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 5, false);
        return false;
      }
      Directory::CreateDirectoryCallback callback =
          Directory_CreateDirectory_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateDirectory(
std::move(p_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_DeleteFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::DeleteFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::DeleteFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_DeleteFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_DeleteFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      Directory_DeleteFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 6, false);
        return false;
      }
      Directory::DeleteFileCallback callback =
          Directory_DeleteFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteFile(
std::move(p_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_DeletePathRecursively_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::DeletePathRecursively",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::DeletePathRecursively");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_DeletePathRecursively_Params_Data* params =
          reinterpret_cast<
              internal::Directory_DeletePathRecursively_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      Directory_DeletePathRecursively_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 7, false);
        return false;
      }
      Directory::DeletePathRecursivelyCallback callback =
          Directory_DeletePathRecursively_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeletePathRecursively(
std::move(p_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_GetFileInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::GetFileInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::GetFileInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_GetFileInfo_Params_Data* params =
          reinterpret_cast<
              internal::Directory_GetFileInfo_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      Directory_GetFileInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 8, false);
        return false;
      }
      Directory::GetFileInfoCallback callback =
          Directory_GetFileInfo_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFileInfo(
std::move(p_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_GetPathAccess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::GetPathAccess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::GetPathAccess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_GetPathAccess_Params_Data* params =
          reinterpret_cast<
              internal::Directory_GetPathAccess_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      Directory_GetPathAccess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 9, false);
        return false;
      }
      Directory::GetPathAccessCallback callback =
          Directory_GetPathAccess_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPathAccess(
std::move(p_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_GetMaximumPathComponentLength_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::GetMaximumPathComponentLength",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::GetMaximumPathComponentLength");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_GetMaximumPathComponentLength_Params_Data* params =
          reinterpret_cast<
              internal::Directory_GetMaximumPathComponentLength_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      Directory_GetMaximumPathComponentLength_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 10, false);
        return false;
      }
      Directory::GetMaximumPathComponentLengthCallback callback =
          Directory_GetMaximumPathComponentLength_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMaximumPathComponentLength(
std::move(p_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_RenameFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::RenameFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::RenameFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_RenameFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_RenameFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_old_path{};
      ::base::FilePath p_new_path{};
      Directory_RenameFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOldPath(&p_old_path))
        success = false;
      if (success && !input_data_view.ReadNewPath(&p_new_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 11, false);
        return false;
      }
      Directory::RenameFileCallback callback =
          Directory_RenameFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenameFile(
std::move(p_old_path), 
std::move(p_new_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_LockFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::LockFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::LockFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_LockFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_LockFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      Directory_LockFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 12, false);
        return false;
      }
      Directory::LockFileCallback callback =
          Directory_LockFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LockFile(
std::move(p_path), std::move(callback));
      return true;
    }
    case internal::kDirectory_SetOpenedFileLength_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::Directory::SetOpenedFileLength",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::Directory::SetOpenedFileLength");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Directory_SetOpenedFileLength_Params_Data* params =
          reinterpret_cast<
              internal::Directory_SetOpenedFileLength_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::File p_file{};
      uint64_t p_size{};
      Directory_SetOpenedFileLength_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (success)
        p_size = input_data_view.size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 13, false);
        return false;
      }
      Directory::SetOpenedFileLengthCallback callback =
          Directory_SetOpenedFileLength_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOpenedFileLength(
std::move(p_file), 
std::move(p_size), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDirectoryValidationInfo[] = {
    {internal::kDirectory_Clone_Name,
     {&internal::Directory_Clone_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDirectory_PathExists_Name,
     {&internal::Directory_PathExists_Params_Data::Validate,
      &internal::Directory_PathExists_ResponseParams_Data::Validate}},
    {internal::kDirectory_GetEntries_Name,
     {&internal::Directory_GetEntries_Params_Data::Validate,
      &internal::Directory_GetEntries_ResponseParams_Data::Validate}},
    {internal::kDirectory_OpenFile_Name,
     {&internal::Directory_OpenFile_Params_Data::Validate,
      &internal::Directory_OpenFile_ResponseParams_Data::Validate}},
    {internal::kDirectory_WriteFileAtomically_Name,
     {&internal::Directory_WriteFileAtomically_Params_Data::Validate,
      &internal::Directory_WriteFileAtomically_ResponseParams_Data::Validate}},
    {internal::kDirectory_CreateDirectory_Name,
     {&internal::Directory_CreateDirectory_Params_Data::Validate,
      &internal::Directory_CreateDirectory_ResponseParams_Data::Validate}},
    {internal::kDirectory_DeleteFile_Name,
     {&internal::Directory_DeleteFile_Params_Data::Validate,
      &internal::Directory_DeleteFile_ResponseParams_Data::Validate}},
    {internal::kDirectory_DeletePathRecursively_Name,
     {&internal::Directory_DeletePathRecursively_Params_Data::Validate,
      &internal::Directory_DeletePathRecursively_ResponseParams_Data::Validate}},
    {internal::kDirectory_GetFileInfo_Name,
     {&internal::Directory_GetFileInfo_Params_Data::Validate,
      &internal::Directory_GetFileInfo_ResponseParams_Data::Validate}},
    {internal::kDirectory_GetPathAccess_Name,
     {&internal::Directory_GetPathAccess_Params_Data::Validate,
      &internal::Directory_GetPathAccess_ResponseParams_Data::Validate}},
    {internal::kDirectory_GetMaximumPathComponentLength_Name,
     {&internal::Directory_GetMaximumPathComponentLength_Params_Data::Validate,
      &internal::Directory_GetMaximumPathComponentLength_ResponseParams_Data::Validate}},
    {internal::kDirectory_RenameFile_Name,
     {&internal::Directory_RenameFile_Params_Data::Validate,
      &internal::Directory_RenameFile_ResponseParams_Data::Validate}},
    {internal::kDirectory_LockFile_Name,
     {&internal::Directory_LockFile_Params_Data::Validate,
      &internal::Directory_LockFile_ResponseParams_Data::Validate}},
    {internal::kDirectory_SetOpenedFileLength_Name,
     {&internal::Directory_SetOpenedFileLength_Params_Data::Validate,
      &internal::Directory_SetOpenedFileLength_ResponseParams_Data::Validate}},
};

bool DirectoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::Directory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDirectoryValidationInfo);
}

bool DirectoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::Directory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDirectoryValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {


// static
bool StructTraits<::storage::mojom::StrictRelativePath::DataView, ::storage::mojom::StrictRelativePathPtr>::Read(
    ::storage::mojom::StrictRelativePath::DataView input,
    ::storage::mojom::StrictRelativePathPtr* output) {
  bool success = true;
  ::storage::mojom::StrictRelativePathPtr result(::storage::mojom::StrictRelativePath::New());
  
      if (success && !input.ReadPath(&result->path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::PathAccessInfo::DataView, ::storage::mojom::PathAccessInfoPtr>::Read(
    ::storage::mojom::PathAccessInfo::DataView input,
    ::storage::mojom::PathAccessInfoPtr* output) {
  bool success = true;
  ::storage::mojom::PathAccessInfoPtr result(::storage::mojom::PathAccessInfo::New());
  
      if (success)
        result->can_read = input.can_read();
      if (success)
        result->can_write = input.can_write();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif