// components/services/storage/public/mojom/indexed_db_control.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/services/storage/public/mojom/indexed_db_control.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "components/services/storage/public/mojom/indexed_db_control_test.mojom.h"
#include "components/services/storage/public/mojom/storage_policy_update.mojom.h"
#include "components/services/storage/public/mojom/storage_usage_info.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_JUMBO_H_
#endif


namespace storage {
namespace mojom {


void IndexedDBObserverInterceptorForTesting::OnIndexedDBListChanged(const ::blink::StorageKey& storage_key) {
  GetForwardingInterface()->OnIndexedDBListChanged(std::move(storage_key));
}
void IndexedDBObserverInterceptorForTesting::OnIndexedDBContentChanged(const ::blink::StorageKey& storage_key, const ::std::u16string& database_name, const ::std::u16string& object_store_name) {
  GetForwardingInterface()->OnIndexedDBContentChanged(std::move(storage_key), std::move(database_name), std::move(object_store_name));
}
IndexedDBObserverAsyncWaiter::IndexedDBObserverAsyncWaiter(
    IndexedDBObserver* proxy) : proxy_(proxy) {}

IndexedDBObserverAsyncWaiter::~IndexedDBObserverAsyncWaiter() = default;




void IndexedDBControlInterceptorForTesting::BindIndexedDB(const ::blink::StorageKey& storage_key, ::mojo::PendingReceiver<::blink::mojom::IDBFactory> receiver) {
  GetForwardingInterface()->BindIndexedDB(std::move(storage_key), std::move(receiver));
}
void IndexedDBControlInterceptorForTesting::GetUsage(GetUsageCallback callback) {
  GetForwardingInterface()->GetUsage(std::move(callback));
}
void IndexedDBControlInterceptorForTesting::DeleteForStorageKey(const ::blink::StorageKey& storage_key, DeleteForStorageKeyCallback callback) {
  GetForwardingInterface()->DeleteForStorageKey(std::move(storage_key), std::move(callback));
}
void IndexedDBControlInterceptorForTesting::ForceClose(const ::blink::StorageKey& storage_key, ForceCloseReason reason, ForceCloseCallback callback) {
  GetForwardingInterface()->ForceClose(std::move(storage_key), std::move(reason), std::move(callback));
}
void IndexedDBControlInterceptorForTesting::GetConnectionCount(const ::blink::StorageKey& storage_key, GetConnectionCountCallback callback) {
  GetForwardingInterface()->GetConnectionCount(std::move(storage_key), std::move(callback));
}
void IndexedDBControlInterceptorForTesting::DownloadStorageKeyData(const ::blink::StorageKey& storage_key, DownloadStorageKeyDataCallback callback) {
  GetForwardingInterface()->DownloadStorageKeyData(std::move(storage_key), std::move(callback));
}
void IndexedDBControlInterceptorForTesting::GetAllStorageKeysDetails(GetAllStorageKeysDetailsCallback callback) {
  GetForwardingInterface()->GetAllStorageKeysDetails(std::move(callback));
}
void IndexedDBControlInterceptorForTesting::SetForceKeepSessionState() {
  GetForwardingInterface()->SetForceKeepSessionState();
}
void IndexedDBControlInterceptorForTesting::AddObserver(::mojo::PendingRemote<IndexedDBObserver> observer) {
  GetForwardingInterface()->AddObserver(std::move(observer));
}
void IndexedDBControlInterceptorForTesting::ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates) {
  GetForwardingInterface()->ApplyPolicyUpdates(std::move(policy_updates));
}
void IndexedDBControlInterceptorForTesting::BindTestInterface(::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest> receiver) {
  GetForwardingInterface()->BindTestInterface(std::move(receiver));
}
IndexedDBControlAsyncWaiter::IndexedDBControlAsyncWaiter(
    IndexedDBControl* proxy) : proxy_(proxy) {}

IndexedDBControlAsyncWaiter::~IndexedDBControlAsyncWaiter() = default;

void IndexedDBControlAsyncWaiter::GetUsage(
    std::vector<::storage::mojom::StorageUsageInfoPtr>* out_info) {
  base::RunLoop loop;
  proxy_->GetUsage(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::storage::mojom::StorageUsageInfoPtr>* out_info
,
             std::vector<::storage::mojom::StorageUsageInfoPtr> info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}
void IndexedDBControlAsyncWaiter::DeleteForStorageKey(
    const ::blink::StorageKey& storage_key, bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteForStorageKey(std::move(storage_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void IndexedDBControlAsyncWaiter::ForceClose(
    const ::blink::StorageKey& storage_key, ForceCloseReason reason) {
  base::RunLoop loop;
  proxy_->ForceClose(std::move(storage_key),std::move(reason),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void IndexedDBControlAsyncWaiter::GetConnectionCount(
    const ::blink::StorageKey& storage_key, uint64_t* out_connection_count) {
  base::RunLoop loop;
  proxy_->GetConnectionCount(std::move(storage_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint64_t* out_connection_count
,
             uint64_t connection_count) {*out_connection_count = std::move(connection_count);
            loop->Quit();
          },
          &loop,
          out_connection_count));
  loop.Run();
}
void IndexedDBControlAsyncWaiter::DownloadStorageKeyData(
    const ::blink::StorageKey& storage_key, bool* out_success, ::base::FilePath* out_temp_path, ::base::FilePath* out_zip_path) {
  base::RunLoop loop;
  proxy_->DownloadStorageKeyData(std::move(storage_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::base::FilePath* out_temp_path
,
             ::base::FilePath* out_zip_path
,
             bool success,
             const ::base::FilePath& temp_path,
             const ::base::FilePath& zip_path) {*out_success = std::move(success);*out_temp_path = std::move(temp_path);*out_zip_path = std::move(zip_path);
            loop->Quit();
          },
          &loop,
          out_success,
          out_temp_path,
          out_zip_path));
  loop.Run();
}
void IndexedDBControlAsyncWaiter::GetAllStorageKeysDetails(
    bool* out_incognito, ::base::Value* out_details) {
  base::RunLoop loop;
  proxy_->GetAllStorageKeysDetails(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_incognito
,
             ::base::Value* out_details
,
             bool incognito,
             ::base::Value details) {*out_incognito = std::move(incognito);*out_details = std::move(details);
            loop->Quit();
          },
          &loop,
          out_incognito,
          out_details));
  loop.Run();
}





}  // namespace mojom
}  // namespace storage

#if defined(__clang__)
#pragma clang diagnostic pop
#endif