// components/services/storage/public/mojom/indexed_db_control.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/indexed_db_control.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/indexed_db_control.mojom-params-data.h"
#include "components/services/storage/public/mojom/indexed_db_control.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/indexed_db_control.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
const char IndexedDBObserver::Name_[] = "storage.mojom.IndexedDBObserver";

IndexedDBObserverProxy::IndexedDBObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IndexedDBObserverProxy::OnIndexedDBListChanged(
    const ::blink::StorageKey& in_storage_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBObserver::OnIndexedDBListChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBObserver_OnIndexedDBListChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBObserver_OnIndexedDBListChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBObserver.OnIndexedDBListChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBObserver::Name_);
  message.set_method_name("OnIndexedDBListChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IndexedDBObserverProxy::OnIndexedDBContentChanged(
    const ::blink::StorageKey& in_storage_key, const ::std::u16string& in_database_name, const ::std::u16string& in_object_store_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBObserver::OnIndexedDBContentChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("database_name"), in_database_name,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_name"), in_object_store_name,
                        "<value of type const ::std::u16string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBObserver_OnIndexedDBContentChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBObserver.OnIndexedDBContentChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->database_name)::BaseType> database_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_database_name, database_name_fragment);
  params->database_name.Set(
      database_name_fragment.is_null() ? nullptr : database_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->database_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null database_name in IndexedDBObserver.OnIndexedDBContentChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->object_store_name)::BaseType> object_store_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_object_store_name, object_store_name_fragment);
  params->object_store_name.Set(
      object_store_name_fragment.is_null() ? nullptr : object_store_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->object_store_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null object_store_name in IndexedDBObserver.OnIndexedDBContentChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBObserver::Name_);
  message.set_method_name("OnIndexedDBContentChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool IndexedDBObserverStubDispatch::Accept(
    IndexedDBObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kIndexedDBObserver_OnIndexedDBListChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBObserver::OnIndexedDBListChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBObserver::OnIndexedDBListChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBObserver_OnIndexedDBListChanged_Params_Data* params =
          reinterpret_cast<internal::IndexedDBObserver_OnIndexedDBListChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      IndexedDBObserver_OnIndexedDBListChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnIndexedDBListChanged(
std::move(p_storage_key));
      return true;
    }
    case internal::kIndexedDBObserver_OnIndexedDBContentChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBObserver::OnIndexedDBContentChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBObserver::OnIndexedDBContentChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data* params =
          reinterpret_cast<internal::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      ::std::u16string p_database_name{};
      ::std::u16string p_object_store_name{};
      IndexedDBObserver_OnIndexedDBContentChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success && !input_data_view.ReadDatabaseName(&p_database_name))
        success = false;
      if (success && !input_data_view.ReadObjectStoreName(&p_object_store_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnIndexedDBContentChanged(
std::move(p_storage_key), 
std::move(p_database_name), 
std::move(p_object_store_name));
      return true;
    }
  }
  return false;
}

// static
bool IndexedDBObserverStubDispatch::AcceptWithResponder(
    IndexedDBObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIndexedDBObserver_OnIndexedDBListChanged_Name: {
      break;
    }
    case internal::kIndexedDBObserver_OnIndexedDBContentChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIndexedDBObserverValidationInfo[] = {
    {internal::kIndexedDBObserver_OnIndexedDBListChanged_Name,
     {&internal::IndexedDBObserver_OnIndexedDBListChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIndexedDBObserver_OnIndexedDBContentChanged_Name,
     {&internal::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IndexedDBObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IndexedDBObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIndexedDBObserverValidationInfo);
}

const char IndexedDBControl::Name_[] = "storage.mojom.IndexedDBControl";

class IndexedDBControl_GetUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_GetUsage_ForwardToCallback(
      IndexedDBControl::GetUsageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::GetUsageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_GetUsage_ForwardToCallback);
};

class IndexedDBControl_DeleteForStorageKey_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_DeleteForStorageKey_ForwardToCallback(
      IndexedDBControl::DeleteForStorageKeyCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::DeleteForStorageKeyCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_DeleteForStorageKey_ForwardToCallback);
};

class IndexedDBControl_ForceClose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_ForceClose_ForwardToCallback(
      IndexedDBControl::ForceCloseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::ForceCloseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_ForceClose_ForwardToCallback);
};

class IndexedDBControl_GetConnectionCount_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_GetConnectionCount_ForwardToCallback(
      IndexedDBControl::GetConnectionCountCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::GetConnectionCountCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_GetConnectionCount_ForwardToCallback);
};

class IndexedDBControl_DownloadStorageKeyData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_DownloadStorageKeyData_ForwardToCallback(
      IndexedDBControl::DownloadStorageKeyDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::DownloadStorageKeyDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_DownloadStorageKeyData_ForwardToCallback);
};

class IndexedDBControl_GetAllStorageKeysDetails_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_GetAllStorageKeysDetails_ForwardToCallback(
      IndexedDBControl::GetAllStorageKeysDetailsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::GetAllStorageKeysDetailsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_GetAllStorageKeysDetails_ForwardToCallback);
};

IndexedDBControlProxy::IndexedDBControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IndexedDBControlProxy::BindIndexedDB(
    const ::blink::StorageKey& in_storage_key, ::mojo::PendingReceiver<::blink::mojom::IDBFactory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::BindIndexedDB", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::IDBFactory>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_BindIndexedDB_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_BindIndexedDB_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControl.BindIndexedDB request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::IDBFactoryInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in IndexedDBControl.BindIndexedDB request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("BindIndexedDB");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IndexedDBControlProxy::GetUsage(
    GetUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::IndexedDBControl::GetUsage");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_GetUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_GetUsage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_GetUsage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlProxy::DeleteForStorageKey(
    const ::blink::StorageKey& in_storage_key, DeleteForStorageKeyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::DeleteForStorageKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_DeleteForStorageKey_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_DeleteForStorageKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControl.DeleteForStorageKey request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("DeleteForStorageKey");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_DeleteForStorageKey_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlProxy::ForceClose(
    const ::blink::StorageKey& in_storage_key, ForceCloseReason in_reason, ForceCloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::ForceClose", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ForceCloseReason>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_ForceClose_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_ForceClose_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControl.ForceClose request");
  mojo::internal::Serialize<::storage::mojom::ForceCloseReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("ForceClose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_ForceClose_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlProxy::GetConnectionCount(
    const ::blink::StorageKey& in_storage_key, GetConnectionCountCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::GetConnectionCount", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_GetConnectionCount_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_GetConnectionCount_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControl.GetConnectionCount request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetConnectionCount");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_GetConnectionCount_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlProxy::DownloadStorageKeyData(
    const ::blink::StorageKey& in_storage_key, DownloadStorageKeyDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::DownloadStorageKeyData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_DownloadStorageKeyData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_DownloadStorageKeyData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControl.DownloadStorageKeyData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("DownloadStorageKeyData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_DownloadStorageKeyData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlProxy::GetAllStorageKeysDetails(
    GetAllStorageKeysDetailsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::IndexedDBControl::GetAllStorageKeysDetails");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_GetAllStorageKeysDetails_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_GetAllStorageKeysDetails_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetAllStorageKeysDetails");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_GetAllStorageKeysDetails_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlProxy::SetForceKeepSessionState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::IndexedDBControl::SetForceKeepSessionState");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_SetForceKeepSessionState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_SetForceKeepSessionState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("SetForceKeepSessionState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IndexedDBControlProxy::AddObserver(
    ::mojo::PendingRemote<IndexedDBObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<IndexedDBObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_AddObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_AddObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::IndexedDBObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in IndexedDBControl.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IndexedDBControlProxy::ApplyPolicyUpdates(
    std::vector<::storage::mojom::StoragePolicyUpdatePtr> in_policy_updates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::ApplyPolicyUpdates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_updates"), in_policy_updates,
                        "<value of type std::vector<::storage::mojom::StoragePolicyUpdatePtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_ApplyPolicyUpdates_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_ApplyPolicyUpdates_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->policy_updates)::BaseType>
      policy_updates_fragment(params.message());
  const mojo::internal::ContainerValidateParams policy_updates_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::StoragePolicyUpdateDataView>>(
      in_policy_updates, policy_updates_fragment, &policy_updates_validate_params);
  params->policy_updates.Set(
      policy_updates_fragment.is_null() ? nullptr : policy_updates_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_updates.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_updates in IndexedDBControl.ApplyPolicyUpdates request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("ApplyPolicyUpdates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IndexedDBControlProxy::BindTestInterface(
    ::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::BindTestInterface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_BindTestInterface_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_BindTestInterface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::IndexedDBControlTestInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in IndexedDBControl.BindTestInterface request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("BindTestInterface");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class IndexedDBControl_GetUsage_ProxyToResponder {
 public:
  static IndexedDBControl::GetUsageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControl_GetUsage_ProxyToResponder> proxy(
        new IndexedDBControl_GetUsage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControl_GetUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_GetUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControl_GetUsage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::GetUsageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::storage::mojom::StorageUsageInfoPtr> in_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_GetUsage_ProxyToResponder);
};

bool IndexedDBControl_GetUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControl::GetUsageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControl_GetUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_GetUsage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::storage::mojom::StorageUsageInfoPtr> p_info{};
  IndexedDBControl_GetUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void IndexedDBControl_GetUsage_ProxyToResponder::Run(
    std::vector<::storage::mojom::StorageUsageInfoPtr> in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControl::GetUsageCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type std::vector<::storage::mojom::StorageUsageInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_GetUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_GetUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType>
      info_fragment(params.message());
  const mojo::internal::ContainerValidateParams info_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::StorageUsageInfoDataView>>(
      in_info, info_fragment, &info_validate_params);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControl::GetUsageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetUsage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_DeleteForStorageKey_ProxyToResponder {
 public:
  static IndexedDBControl::DeleteForStorageKeyCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControl_DeleteForStorageKey_ProxyToResponder> proxy(
        new IndexedDBControl_DeleteForStorageKey_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControl_DeleteForStorageKey_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_DeleteForStorageKey_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControl_DeleteForStorageKey_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::DeleteForStorageKeyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_DeleteForStorageKey_ProxyToResponder);
};

bool IndexedDBControl_DeleteForStorageKey_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControl::DeleteForStorageKeyCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControl_DeleteForStorageKey_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_DeleteForStorageKey_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  IndexedDBControl_DeleteForStorageKey_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void IndexedDBControl_DeleteForStorageKey_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControl::DeleteForStorageKeyCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_DeleteForStorageKey_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_DeleteForStorageKey_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControl::DeleteForStorageKeyCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("DeleteForStorageKey");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_ForceClose_ProxyToResponder {
 public:
  static IndexedDBControl::ForceCloseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControl_ForceClose_ProxyToResponder> proxy(
        new IndexedDBControl_ForceClose_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControl_ForceClose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_ForceClose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControl_ForceClose_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::ForceCloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_ForceClose_ProxyToResponder);
};

bool IndexedDBControl_ForceClose_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControl::ForceCloseCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControl_ForceClose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_ForceClose_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  IndexedDBControl_ForceClose_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void IndexedDBControl_ForceClose_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::IndexedDBControl::ForceCloseCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_ForceClose_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_ForceClose_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControl::ForceCloseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("ForceClose");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_GetConnectionCount_ProxyToResponder {
 public:
  static IndexedDBControl::GetConnectionCountCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControl_GetConnectionCount_ProxyToResponder> proxy(
        new IndexedDBControl_GetConnectionCount_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControl_GetConnectionCount_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_GetConnectionCount_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControl_GetConnectionCount_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::GetConnectionCountCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_connection_count);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_GetConnectionCount_ProxyToResponder);
};

bool IndexedDBControl_GetConnectionCount_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControl::GetConnectionCountCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControl_GetConnectionCount_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_GetConnectionCount_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  uint64_t p_connection_count{};
  IndexedDBControl_GetConnectionCount_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_connection_count = input_data_view.connection_count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_connection_count));
  return true;
}

void IndexedDBControl_GetConnectionCount_ProxyToResponder::Run(
    uint64_t in_connection_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControl::GetConnectionCountCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection_count"), in_connection_count,
                        "<value of type uint64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_GetConnectionCount_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_GetConnectionCount_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->connection_count = in_connection_count;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControl::GetConnectionCountCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetConnectionCount");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_DownloadStorageKeyData_ProxyToResponder {
 public:
  static IndexedDBControl::DownloadStorageKeyDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControl_DownloadStorageKeyData_ProxyToResponder> proxy(
        new IndexedDBControl_DownloadStorageKeyData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControl_DownloadStorageKeyData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_DownloadStorageKeyData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControl_DownloadStorageKeyData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::DownloadStorageKeyDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::base::FilePath& in_temp_path, const ::base::FilePath& in_zip_path);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_DownloadStorageKeyData_ProxyToResponder);
};

bool IndexedDBControl_DownloadStorageKeyData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControl::DownloadStorageKeyDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControl_DownloadStorageKeyData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_DownloadStorageKeyData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  ::base::FilePath p_temp_path{};
  ::base::FilePath p_zip_path{};
  IndexedDBControl_DownloadStorageKeyData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadTempPath(&p_temp_path))
    success = false;
  if (success && !input_data_view.ReadZipPath(&p_zip_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_temp_path), 
std::move(p_zip_path));
  return true;
}

void IndexedDBControl_DownloadStorageKeyData_ProxyToResponder::Run(
    bool in_success, const ::base::FilePath& in_temp_path, const ::base::FilePath& in_zip_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControl::DownloadStorageKeyDataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("temp_path"), in_temp_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("zip_path"), in_zip_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_DownloadStorageKeyData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_DownloadStorageKeyData_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->temp_path)::BaseType> temp_path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_temp_path, temp_path_fragment);
  params->temp_path.Set(
      temp_path_fragment.is_null() ? nullptr : temp_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->temp_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null temp_path in ");
  mojo::internal::MessageFragment<
      typename decltype(params->zip_path)::BaseType> zip_path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_zip_path, zip_path_fragment);
  params->zip_path.Set(
      zip_path_fragment.is_null() ? nullptr : zip_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->zip_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null zip_path in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControl::DownloadStorageKeyDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("DownloadStorageKeyData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_GetAllStorageKeysDetails_ProxyToResponder {
 public:
  static IndexedDBControl::GetAllStorageKeysDetailsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControl_GetAllStorageKeysDetails_ProxyToResponder> proxy(
        new IndexedDBControl_GetAllStorageKeysDetails_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControl_GetAllStorageKeysDetails_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_GetAllStorageKeysDetails_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControl_GetAllStorageKeysDetails_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::GetAllStorageKeysDetailsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_incognito, ::base::Value in_details);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_GetAllStorageKeysDetails_ProxyToResponder);
};

bool IndexedDBControl_GetAllStorageKeysDetails_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControl::GetAllStorageKeysDetailsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControl_GetAllStorageKeysDetails_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_GetAllStorageKeysDetails_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_incognito{};
  ::base::Value p_details{};
  IndexedDBControl_GetAllStorageKeysDetails_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_incognito = input_data_view.incognito();
  if (success && !input_data_view.ReadDetails(&p_details))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_incognito), 
std::move(p_details));
  return true;
}

void IndexedDBControl_GetAllStorageKeysDetails_ProxyToResponder::Run(
    bool in_incognito, ::base::Value in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControl::GetAllStorageKeysDetailsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("incognito"), in_incognito,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type ::base::Value>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControl_GetAllStorageKeysDetails_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_GetAllStorageKeysDetails_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->incognito = in_incognito;
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_details, details_fragment);
  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControl::GetAllStorageKeysDetailsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetAllStorageKeysDetails");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IndexedDBControlStubDispatch::Accept(
    IndexedDBControl* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kIndexedDBControl_BindIndexedDB_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::BindIndexedDB",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::BindIndexedDB");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBControl_BindIndexedDB_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_BindIndexedDB_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      ::mojo::PendingReceiver<::blink::mojom::IDBFactory> p_receiver{};
      IndexedDBControl_BindIndexedDB_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindIndexedDB(
std::move(p_storage_key), 
std::move(p_receiver));
      return true;
    }
    case internal::kIndexedDBControl_GetUsage_Name: {
      break;
    }
    case internal::kIndexedDBControl_DeleteForStorageKey_Name: {
      break;
    }
    case internal::kIndexedDBControl_ForceClose_Name: {
      break;
    }
    case internal::kIndexedDBControl_GetConnectionCount_Name: {
      break;
    }
    case internal::kIndexedDBControl_DownloadStorageKeyData_Name: {
      break;
    }
    case internal::kIndexedDBControl_GetAllStorageKeysDetails_Name: {
      break;
    }
    case internal::kIndexedDBControl_SetForceKeepSessionState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::SetForceKeepSessionState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::SetForceKeepSessionState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBControl_SetForceKeepSessionState_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_SetForceKeepSessionState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      IndexedDBControl_SetForceKeepSessionState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetForceKeepSessionState();
      return true;
    }
    case internal::kIndexedDBControl_AddObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::AddObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::AddObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBControl_AddObserver_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_AddObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<IndexedDBObserver> p_observer{};
      IndexedDBControl_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(
std::move(p_observer));
      return true;
    }
    case internal::kIndexedDBControl_ApplyPolicyUpdates_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::ApplyPolicyUpdates",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::ApplyPolicyUpdates");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBControl_ApplyPolicyUpdates_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_ApplyPolicyUpdates_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::storage::mojom::StoragePolicyUpdatePtr> p_policy_updates{};
      IndexedDBControl_ApplyPolicyUpdates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicyUpdates(&p_policy_updates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyPolicyUpdates(
std::move(p_policy_updates));
      return true;
    }
    case internal::kIndexedDBControl_BindTestInterface_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::BindTestInterface",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::BindTestInterface");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBControl_BindTestInterface_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_BindTestInterface_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest> p_receiver{};
      IndexedDBControl_BindTestInterface_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTestInterface(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool IndexedDBControlStubDispatch::AcceptWithResponder(
    IndexedDBControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIndexedDBControl_BindIndexedDB_Name: {
      break;
    }
    case internal::kIndexedDBControl_GetUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::GetUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::GetUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControl_GetUsage_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_GetUsage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      IndexedDBControl_GetUsage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 1, false);
        return false;
      }
      IndexedDBControl::GetUsageCallback callback =
          IndexedDBControl_GetUsage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUsage(std::move(callback));
      return true;
    }
    case internal::kIndexedDBControl_DeleteForStorageKey_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::DeleteForStorageKey",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::DeleteForStorageKey");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControl_DeleteForStorageKey_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_DeleteForStorageKey_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      IndexedDBControl_DeleteForStorageKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 2, false);
        return false;
      }
      IndexedDBControl::DeleteForStorageKeyCallback callback =
          IndexedDBControl_DeleteForStorageKey_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteForStorageKey(
std::move(p_storage_key), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControl_ForceClose_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::ForceClose",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::ForceClose");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControl_ForceClose_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_ForceClose_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      ForceCloseReason p_reason{};
      IndexedDBControl_ForceClose_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 3, false);
        return false;
      }
      IndexedDBControl::ForceCloseCallback callback =
          IndexedDBControl_ForceClose_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceClose(
std::move(p_storage_key), 
std::move(p_reason), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControl_GetConnectionCount_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::GetConnectionCount",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::GetConnectionCount");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControl_GetConnectionCount_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_GetConnectionCount_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      IndexedDBControl_GetConnectionCount_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 4, false);
        return false;
      }
      IndexedDBControl::GetConnectionCountCallback callback =
          IndexedDBControl_GetConnectionCount_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetConnectionCount(
std::move(p_storage_key), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControl_DownloadStorageKeyData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::DownloadStorageKeyData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::DownloadStorageKeyData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControl_DownloadStorageKeyData_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_DownloadStorageKeyData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      IndexedDBControl_DownloadStorageKeyData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 5, false);
        return false;
      }
      IndexedDBControl::DownloadStorageKeyDataCallback callback =
          IndexedDBControl_DownloadStorageKeyData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadStorageKeyData(
std::move(p_storage_key), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControl_GetAllStorageKeysDetails_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::GetAllStorageKeysDetails",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::GetAllStorageKeysDetails");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControl_GetAllStorageKeysDetails_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_GetAllStorageKeysDetails_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      IndexedDBControl_GetAllStorageKeysDetails_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 6, false);
        return false;
      }
      IndexedDBControl::GetAllStorageKeysDetailsCallback callback =
          IndexedDBControl_GetAllStorageKeysDetails_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllStorageKeysDetails(std::move(callback));
      return true;
    }
    case internal::kIndexedDBControl_SetForceKeepSessionState_Name: {
      break;
    }
    case internal::kIndexedDBControl_AddObserver_Name: {
      break;
    }
    case internal::kIndexedDBControl_ApplyPolicyUpdates_Name: {
      break;
    }
    case internal::kIndexedDBControl_BindTestInterface_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIndexedDBControlValidationInfo[] = {
    {internal::kIndexedDBControl_BindIndexedDB_Name,
     {&internal::IndexedDBControl_BindIndexedDB_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIndexedDBControl_GetUsage_Name,
     {&internal::IndexedDBControl_GetUsage_Params_Data::Validate,
      &internal::IndexedDBControl_GetUsage_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControl_DeleteForStorageKey_Name,
     {&internal::IndexedDBControl_DeleteForStorageKey_Params_Data::Validate,
      &internal::IndexedDBControl_DeleteForStorageKey_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControl_ForceClose_Name,
     {&internal::IndexedDBControl_ForceClose_Params_Data::Validate,
      &internal::IndexedDBControl_ForceClose_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControl_GetConnectionCount_Name,
     {&internal::IndexedDBControl_GetConnectionCount_Params_Data::Validate,
      &internal::IndexedDBControl_GetConnectionCount_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControl_DownloadStorageKeyData_Name,
     {&internal::IndexedDBControl_DownloadStorageKeyData_Params_Data::Validate,
      &internal::IndexedDBControl_DownloadStorageKeyData_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControl_GetAllStorageKeysDetails_Name,
     {&internal::IndexedDBControl_GetAllStorageKeysDetails_Params_Data::Validate,
      &internal::IndexedDBControl_GetAllStorageKeysDetails_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControl_SetForceKeepSessionState_Name,
     {&internal::IndexedDBControl_SetForceKeepSessionState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIndexedDBControl_AddObserver_Name,
     {&internal::IndexedDBControl_AddObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIndexedDBControl_ApplyPolicyUpdates_Name,
     {&internal::IndexedDBControl_ApplyPolicyUpdates_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIndexedDBControl_BindTestInterface_Name,
     {&internal::IndexedDBControl_BindTestInterface_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IndexedDBControlRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IndexedDBControl::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIndexedDBControlValidationInfo);
}

bool IndexedDBControlResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IndexedDBControl::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kIndexedDBControlValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif