// components/services/storage/public/mojom/indexed_db_control_test.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/indexed_db_control_test.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/indexed_db_control_test.mojom-params-data.h"
#include "components/services/storage/public/mojom/indexed_db_control_test.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/indexed_db_control_test.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_TEST_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_TEST_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
const char MockFailureInjector::Name_[] = "storage.mojom.MockFailureInjector";

class MockFailureInjector_FailOperation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MockFailureInjector_FailOperation_ForwardToCallback(
      MockFailureInjector::FailOperationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MockFailureInjector::FailOperationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MockFailureInjector_FailOperation_ForwardToCallback);
};

MockFailureInjectorProxy::MockFailureInjectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MockFailureInjectorProxy::FailOperation(
    FailClass in_failure_class, FailMethod in_failure_method, int32_t in_instance_num, int32_t in_call_num, FailOperationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::MockFailureInjector::FailOperation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("failure_class"), in_failure_class,
                        "<value of type FailClass>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("failure_method"), in_failure_method,
                        "<value of type FailMethod>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instance_num"), in_instance_num,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("call_num"), in_call_num,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMockFailureInjector_FailOperation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::MockFailureInjector_FailOperation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::FailClass>(
      in_failure_class, &params->failure_class);
  mojo::internal::Serialize<::storage::mojom::FailMethod>(
      in_failure_method, &params->failure_method);
  params->instance_num = in_instance_num;
  params->call_num = in_call_num;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MockFailureInjector::Name_);
  message.set_method_name("FailOperation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MockFailureInjector_FailOperation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class MockFailureInjector_FailOperation_ProxyToResponder {
 public:
  static MockFailureInjector::FailOperationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MockFailureInjector_FailOperation_ProxyToResponder> proxy(
        new MockFailureInjector_FailOperation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MockFailureInjector_FailOperation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MockFailureInjector_FailOperation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MockFailureInjector_FailOperation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MockFailureInjector::FailOperationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MockFailureInjector_FailOperation_ProxyToResponder);
};

bool MockFailureInjector_FailOperation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::MockFailureInjector::FailOperationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MockFailureInjector_FailOperation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MockFailureInjector_FailOperation_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  MockFailureInjector_FailOperation_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MockFailureInjector::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void MockFailureInjector_FailOperation_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::MockFailureInjector::FailOperationCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMockFailureInjector_FailOperation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::MockFailureInjector_FailOperation_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::MockFailureInjector::FailOperationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MockFailureInjector::Name_);
  message.set_method_name("FailOperation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MockFailureInjectorStubDispatch::Accept(
    MockFailureInjector* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMockFailureInjector_FailOperation_Name: {
      break;
    }
  }
  return false;
}

// static
bool MockFailureInjectorStubDispatch::AcceptWithResponder(
    MockFailureInjector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMockFailureInjector_FailOperation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::MockFailureInjector::FailOperation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::MockFailureInjector::FailOperation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MockFailureInjector_FailOperation_Params_Data* params =
          reinterpret_cast<
              internal::MockFailureInjector_FailOperation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      FailClass p_failure_class{};
      FailMethod p_failure_method{};
      int32_t p_instance_num{};
      int32_t p_call_num{};
      MockFailureInjector_FailOperation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFailureClass(&p_failure_class))
        success = false;
      if (success && !input_data_view.ReadFailureMethod(&p_failure_method))
        success = false;
      if (success)
        p_instance_num = input_data_view.instance_num();
      if (success)
        p_call_num = input_data_view.call_num();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MockFailureInjector::Name_, 0, false);
        return false;
      }
      MockFailureInjector::FailOperationCallback callback =
          MockFailureInjector_FailOperation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FailOperation(
std::move(p_failure_class), 
std::move(p_failure_method), 
std::move(p_instance_num), 
std::move(p_call_num), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMockFailureInjectorValidationInfo[] = {
    {internal::kMockFailureInjector_FailOperation_Name,
     {&internal::MockFailureInjector_FailOperation_Params_Data::Validate,
      &internal::MockFailureInjector_FailOperation_ResponseParams_Data::Validate}},
};

bool MockFailureInjectorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::MockFailureInjector::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMockFailureInjectorValidationInfo);
}

bool MockFailureInjectorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::MockFailureInjector::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kMockFailureInjectorValidationInfo);

}
const char IndexedDBControlTest::Name_[] = "storage.mojom.IndexedDBControlTest";

class IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback(
      IndexedDBControlTest::GetBaseDataPathForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::GetBaseDataPathForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback);
};

class IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback(
      IndexedDBControlTest::GetFilePathForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::GetFilePathForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback);
};

class IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback(
      IndexedDBControlTest::ResetCachesForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::ResetCachesForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback);
};

class IndexedDBControlTest_ForceSchemaDowngradeForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_ForceSchemaDowngradeForTesting_ForwardToCallback(
      IndexedDBControlTest::ForceSchemaDowngradeForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::ForceSchemaDowngradeForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_ForceSchemaDowngradeForTesting_ForwardToCallback);
};

class IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ForwardToCallback(
      IndexedDBControlTest::HasV2SchemaCorruptionForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::HasV2SchemaCorruptionForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ForwardToCallback);
};

class IndexedDBControlTest_WriteToIndexedDBForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_WriteToIndexedDBForTesting_ForwardToCallback(
      IndexedDBControlTest::WriteToIndexedDBForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::WriteToIndexedDBForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_WriteToIndexedDBForTesting_ForwardToCallback);
};

class IndexedDBControlTest_GetBlobCountForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_GetBlobCountForTesting_ForwardToCallback(
      IndexedDBControlTest::GetBlobCountForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::GetBlobCountForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_GetBlobCountForTesting_ForwardToCallback);
};

class IndexedDBControlTest_GetNextBlobNumberForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_GetNextBlobNumberForTesting_ForwardToCallback(
      IndexedDBControlTest::GetNextBlobNumberForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::GetNextBlobNumberForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_GetNextBlobNumberForTesting_ForwardToCallback);
};

class IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback(
      IndexedDBControlTest::GetPathForBlobForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::GetPathForBlobForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback);
};

class IndexedDBControlTest_CompactBackingStoreForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_CompactBackingStoreForTesting_ForwardToCallback(
      IndexedDBControlTest::CompactBackingStoreForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::CompactBackingStoreForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_CompactBackingStoreForTesting_ForwardToCallback);
};

class IndexedDBControlTest_GetDatabaseKeysForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControlTest_GetDatabaseKeysForTesting_ForwardToCallback(
      IndexedDBControlTest::GetDatabaseKeysForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControlTest::GetDatabaseKeysForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_GetDatabaseKeysForTesting_ForwardToCallback);
};

IndexedDBControlTestProxy::IndexedDBControlTestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IndexedDBControlTestProxy::GetBaseDataPathForTesting(
    GetBaseDataPathForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::IndexedDBControlTest::GetBaseDataPathForTesting");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_GetBaseDataPathForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetBaseDataPathForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlTestProxy::GetFilePathForTesting(
    const ::blink::StorageKey& in_storage_key, GetFilePathForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControlTest::GetFilePathForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_GetFilePathForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetFilePathForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControlTest.GetFilePathForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetFilePathForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlTestProxy::ResetCachesForTesting(
    ResetCachesForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::IndexedDBControlTest::ResetCachesForTesting");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_ResetCachesForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_ResetCachesForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("ResetCachesForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlTestProxy::ForceSchemaDowngradeForTesting(
    const ::blink::StorageKey& in_storage_key, ForceSchemaDowngradeForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControlTest::ForceSchemaDowngradeForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_ForceSchemaDowngradeForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_ForceSchemaDowngradeForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControlTest.ForceSchemaDowngradeForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("ForceSchemaDowngradeForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_ForceSchemaDowngradeForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlTestProxy::HasV2SchemaCorruptionForTesting(
    const ::blink::StorageKey& in_storage_key, HasV2SchemaCorruptionForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControlTest::HasV2SchemaCorruptionForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_HasV2SchemaCorruptionForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_HasV2SchemaCorruptionForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControlTest.HasV2SchemaCorruptionForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("HasV2SchemaCorruptionForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlTestProxy::WriteToIndexedDBForTesting(
    const ::blink::StorageKey& in_storage_key, const std::string& in_key, const std::string& in_value, WriteToIndexedDBForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControlTest::WriteToIndexedDBForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_WriteToIndexedDBForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_WriteToIndexedDBForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControlTest.WriteToIndexedDBForTesting request");
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key, key_fragment);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in IndexedDBControlTest.WriteToIndexedDBForTesting request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_value, value_fragment);
  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in IndexedDBControlTest.WriteToIndexedDBForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("WriteToIndexedDBForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_WriteToIndexedDBForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlTestProxy::GetBlobCountForTesting(
    const ::blink::StorageKey& in_storage_key, GetBlobCountForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControlTest::GetBlobCountForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_GetBlobCountForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetBlobCountForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControlTest.GetBlobCountForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetBlobCountForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_GetBlobCountForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlTestProxy::GetNextBlobNumberForTesting(
    const ::blink::StorageKey& in_storage_key, int64_t in_database_id, GetNextBlobNumberForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControlTest::GetNextBlobNumberForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("database_id"), in_database_id,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_GetNextBlobNumberForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetNextBlobNumberForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControlTest.GetNextBlobNumberForTesting request");
  params->database_id = in_database_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetNextBlobNumberForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_GetNextBlobNumberForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlTestProxy::GetPathForBlobForTesting(
    const ::blink::StorageKey& in_storage_key, int64_t in_database_id, int64_t in_blob_number, GetPathForBlobForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControlTest::GetPathForBlobForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("database_id"), in_database_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob_number"), in_blob_number,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_GetPathForBlobForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetPathForBlobForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControlTest.GetPathForBlobForTesting request");
  params->database_id = in_database_id;
  params->blob_number = in_blob_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetPathForBlobForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlTestProxy::CompactBackingStoreForTesting(
    const ::blink::StorageKey& in_storage_key, CompactBackingStoreForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControlTest::CompactBackingStoreForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_CompactBackingStoreForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_CompactBackingStoreForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in IndexedDBControlTest.CompactBackingStoreForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("CompactBackingStoreForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_CompactBackingStoreForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlTestProxy::BindMockFailureSingletonForTesting(
    ::mojo::PendingReceiver<MockFailureInjector> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControlTest::BindMockFailureSingletonForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<MockFailureInjector>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_BindMockFailureSingletonForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::MockFailureInjectorInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in IndexedDBControlTest.BindMockFailureSingletonForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("BindMockFailureSingletonForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IndexedDBControlTestProxy::GetDatabaseKeysForTesting(
    GetDatabaseKeysForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::IndexedDBControlTest::GetDatabaseKeysForTesting");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_GetDatabaseKeysForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetDatabaseKeysForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetDatabaseKeysForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControlTest_GetDatabaseKeysForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder {
 public:
  static IndexedDBControlTest::GetBaseDataPathForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::GetBaseDataPathForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::FilePath& in_path);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder);
};

bool IndexedDBControlTest_GetBaseDataPathForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControlTest::GetBaseDataPathForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::FilePath p_path{};
  IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPath(&p_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_path));
  return true;
}

void IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder::Run(
    const ::base::FilePath& in_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControlTest::GetBaseDataPathForTestingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_GetBaseDataPathForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControlTest::GetBaseDataPathForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetBaseDataPathForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder {
 public:
  static IndexedDBControlTest::GetFilePathForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::GetFilePathForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::FilePath& in_path);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder);
};

bool IndexedDBControlTest_GetFilePathForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControlTest::GetFilePathForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::FilePath p_path{};
  IndexedDBControlTest_GetFilePathForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPath(&p_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_path));
  return true;
}

void IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder::Run(
    const ::base::FilePath& in_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControlTest::GetFilePathForTestingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_GetFilePathForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControlTest::GetFilePathForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetFilePathForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder {
 public:
  static IndexedDBControlTest::ResetCachesForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::ResetCachesForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder);
};

bool IndexedDBControlTest_ResetCachesForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControlTest::ResetCachesForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  IndexedDBControlTest_ResetCachesForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::IndexedDBControlTest::ResetCachesForTestingCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_ResetCachesForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControlTest::ResetCachesForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("ResetCachesForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_ForceSchemaDowngradeForTesting_ProxyToResponder {
 public:
  static IndexedDBControlTest::ForceSchemaDowngradeForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControlTest_ForceSchemaDowngradeForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_ForceSchemaDowngradeForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControlTest_ForceSchemaDowngradeForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_ForceSchemaDowngradeForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControlTest_ForceSchemaDowngradeForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::ForceSchemaDowngradeForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_downgraded);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_ForceSchemaDowngradeForTesting_ProxyToResponder);
};

bool IndexedDBControlTest_ForceSchemaDowngradeForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControlTest::ForceSchemaDowngradeForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_ForceSchemaDowngradeForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_ForceSchemaDowngradeForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_downgraded{};
  IndexedDBControlTest_ForceSchemaDowngradeForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_downgraded = input_data_view.downgraded();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_downgraded));
  return true;
}

void IndexedDBControlTest_ForceSchemaDowngradeForTesting_ProxyToResponder::Run(
    bool in_downgraded) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControlTest::ForceSchemaDowngradeForTestingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("downgraded"), in_downgraded,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_ForceSchemaDowngradeForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_ForceSchemaDowngradeForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->downgraded = in_downgraded;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControlTest::ForceSchemaDowngradeForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("ForceSchemaDowngradeForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ProxyToResponder {
 public:
  static IndexedDBControlTest::HasV2SchemaCorruptionForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::HasV2SchemaCorruptionForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      V2SchemaCorruptionStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ProxyToResponder);
};

bool IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControlTest::HasV2SchemaCorruptionForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  V2SchemaCorruptionStatus p_status{};
  IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ProxyToResponder::Run(
    V2SchemaCorruptionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControlTest::HasV2SchemaCorruptionForTestingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type V2SchemaCorruptionStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_HasV2SchemaCorruptionForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::V2SchemaCorruptionStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControlTest::HasV2SchemaCorruptionForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("HasV2SchemaCorruptionForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_WriteToIndexedDBForTesting_ProxyToResponder {
 public:
  static IndexedDBControlTest::WriteToIndexedDBForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControlTest_WriteToIndexedDBForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_WriteToIndexedDBForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControlTest_WriteToIndexedDBForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_WriteToIndexedDBForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControlTest_WriteToIndexedDBForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::WriteToIndexedDBForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_WriteToIndexedDBForTesting_ProxyToResponder);
};

bool IndexedDBControlTest_WriteToIndexedDBForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControlTest::WriteToIndexedDBForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_WriteToIndexedDBForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_WriteToIndexedDBForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  IndexedDBControlTest_WriteToIndexedDBForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void IndexedDBControlTest_WriteToIndexedDBForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::IndexedDBControlTest::WriteToIndexedDBForTestingCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_WriteToIndexedDBForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_WriteToIndexedDBForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControlTest::WriteToIndexedDBForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("WriteToIndexedDBForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_GetBlobCountForTesting_ProxyToResponder {
 public:
  static IndexedDBControlTest::GetBlobCountForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControlTest_GetBlobCountForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_GetBlobCountForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControlTest_GetBlobCountForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_GetBlobCountForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControlTest_GetBlobCountForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::GetBlobCountForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_num_blobs);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_GetBlobCountForTesting_ProxyToResponder);
};

bool IndexedDBControlTest_GetBlobCountForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControlTest::GetBlobCountForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_GetBlobCountForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_GetBlobCountForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_num_blobs{};
  IndexedDBControlTest_GetBlobCountForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_num_blobs = input_data_view.num_blobs();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_num_blobs));
  return true;
}

void IndexedDBControlTest_GetBlobCountForTesting_ProxyToResponder::Run(
    int64_t in_num_blobs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControlTest::GetBlobCountForTestingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_blobs"), in_num_blobs,
                        "<value of type int64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_GetBlobCountForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetBlobCountForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->num_blobs = in_num_blobs;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControlTest::GetBlobCountForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetBlobCountForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_GetNextBlobNumberForTesting_ProxyToResponder {
 public:
  static IndexedDBControlTest::GetNextBlobNumberForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControlTest_GetNextBlobNumberForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_GetNextBlobNumberForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControlTest_GetNextBlobNumberForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_GetNextBlobNumberForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControlTest_GetNextBlobNumberForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::GetNextBlobNumberForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_next_blob_number);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_GetNextBlobNumberForTesting_ProxyToResponder);
};

bool IndexedDBControlTest_GetNextBlobNumberForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControlTest::GetNextBlobNumberForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_GetNextBlobNumberForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_GetNextBlobNumberForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_next_blob_number{};
  IndexedDBControlTest_GetNextBlobNumberForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_next_blob_number = input_data_view.next_blob_number();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_next_blob_number));
  return true;
}

void IndexedDBControlTest_GetNextBlobNumberForTesting_ProxyToResponder::Run(
    int64_t in_next_blob_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControlTest::GetNextBlobNumberForTestingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("next_blob_number"), in_next_blob_number,
                        "<value of type int64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_GetNextBlobNumberForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetNextBlobNumberForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->next_blob_number = in_next_blob_number;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControlTest::GetNextBlobNumberForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetNextBlobNumberForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder {
 public:
  static IndexedDBControlTest::GetPathForBlobForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::GetPathForBlobForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::FilePath& in_path);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder);
};

bool IndexedDBControlTest_GetPathForBlobForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControlTest::GetPathForBlobForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::FilePath p_path{};
  IndexedDBControlTest_GetPathForBlobForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPath(&p_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_path));
  return true;
}

void IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder::Run(
    const ::base::FilePath& in_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControlTest::GetPathForBlobForTestingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_GetPathForBlobForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControlTest::GetPathForBlobForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetPathForBlobForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_CompactBackingStoreForTesting_ProxyToResponder {
 public:
  static IndexedDBControlTest::CompactBackingStoreForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControlTest_CompactBackingStoreForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_CompactBackingStoreForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControlTest_CompactBackingStoreForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_CompactBackingStoreForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControlTest_CompactBackingStoreForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::CompactBackingStoreForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_CompactBackingStoreForTesting_ProxyToResponder);
};

bool IndexedDBControlTest_CompactBackingStoreForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControlTest::CompactBackingStoreForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_CompactBackingStoreForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_CompactBackingStoreForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  IndexedDBControlTest_CompactBackingStoreForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void IndexedDBControlTest_CompactBackingStoreForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::IndexedDBControlTest::CompactBackingStoreForTestingCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_CompactBackingStoreForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_CompactBackingStoreForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControlTest::CompactBackingStoreForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("CompactBackingStoreForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControlTest_GetDatabaseKeysForTesting_ProxyToResponder {
 public:
  static IndexedDBControlTest::GetDatabaseKeysForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControlTest_GetDatabaseKeysForTesting_ProxyToResponder> proxy(
        new IndexedDBControlTest_GetDatabaseKeysForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControlTest_GetDatabaseKeysForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControlTest_GetDatabaseKeysForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControlTest_GetDatabaseKeysForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControlTest::GetDatabaseKeysForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_schema_version_key, const std::string& in_data_version_key);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControlTest_GetDatabaseKeysForTesting_ProxyToResponder);
};

bool IndexedDBControlTest_GetDatabaseKeysForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControlTest::GetDatabaseKeysForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::IndexedDBControlTest_GetDatabaseKeysForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControlTest_GetDatabaseKeysForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::string p_schema_version_key{};
  std::string p_data_version_key{};
  IndexedDBControlTest_GetDatabaseKeysForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSchemaVersionKey(&p_schema_version_key))
    success = false;
  if (success && !input_data_view.ReadDataVersionKey(&p_data_version_key))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControlTest::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_schema_version_key), 
std::move(p_data_version_key));
  return true;
}

void IndexedDBControlTest_GetDatabaseKeysForTesting_ProxyToResponder::Run(
    const std::string& in_schema_version_key, const std::string& in_data_version_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControlTest::GetDatabaseKeysForTestingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("schema_version_key"), in_schema_version_key,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_version_key"), in_data_version_key,
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kIndexedDBControlTest_GetDatabaseKeysForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControlTest_GetDatabaseKeysForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->schema_version_key)::BaseType> schema_version_key_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_schema_version_key, schema_version_key_fragment);
  params->schema_version_key.Set(
      schema_version_key_fragment.is_null() ? nullptr : schema_version_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->schema_version_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null schema_version_key in ");
  mojo::internal::MessageFragment<
      typename decltype(params->data_version_key)::BaseType> data_version_key_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_data_version_key, data_version_key_fragment);
  params->data_version_key.Set(
      data_version_key_fragment.is_null() ? nullptr : data_version_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data_version_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_version_key in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControlTest::GetDatabaseKeysForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControlTest::Name_);
  message.set_method_name("GetDatabaseKeysForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IndexedDBControlTestStubDispatch::Accept(
    IndexedDBControlTest* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kIndexedDBControlTest_GetBaseDataPathForTesting_Name: {
      break;
    }
    case internal::kIndexedDBControlTest_GetFilePathForTesting_Name: {
      break;
    }
    case internal::kIndexedDBControlTest_ResetCachesForTesting_Name: {
      break;
    }
    case internal::kIndexedDBControlTest_ForceSchemaDowngradeForTesting_Name: {
      break;
    }
    case internal::kIndexedDBControlTest_HasV2SchemaCorruptionForTesting_Name: {
      break;
    }
    case internal::kIndexedDBControlTest_WriteToIndexedDBForTesting_Name: {
      break;
    }
    case internal::kIndexedDBControlTest_GetBlobCountForTesting_Name: {
      break;
    }
    case internal::kIndexedDBControlTest_GetNextBlobNumberForTesting_Name: {
      break;
    }
    case internal::kIndexedDBControlTest_GetPathForBlobForTesting_Name: {
      break;
    }
    case internal::kIndexedDBControlTest_CompactBackingStoreForTesting_Name: {
      break;
    }
    case internal::kIndexedDBControlTest_BindMockFailureSingletonForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControlTest::BindMockFailureSingletonForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControlTest::BindMockFailureSingletonForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<MockFailureInjector> p_receiver{};
      IndexedDBControlTest_BindMockFailureSingletonForTesting_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindMockFailureSingletonForTesting(
std::move(p_receiver));
      return true;
    }
    case internal::kIndexedDBControlTest_GetDatabaseKeysForTesting_Name: {
      break;
    }
  }
  return false;
}

// static
bool IndexedDBControlTestStubDispatch::AcceptWithResponder(
    IndexedDBControlTest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIndexedDBControlTest_GetBaseDataPathForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControlTest::GetBaseDataPathForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControlTest::GetBaseDataPathForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      IndexedDBControlTest_GetBaseDataPathForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 0, false);
        return false;
      }
      IndexedDBControlTest::GetBaseDataPathForTestingCallback callback =
          IndexedDBControlTest_GetBaseDataPathForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBaseDataPathForTesting(std::move(callback));
      return true;
    }
    case internal::kIndexedDBControlTest_GetFilePathForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControlTest::GetFilePathForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControlTest::GetFilePathForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControlTest_GetFilePathForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_GetFilePathForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      IndexedDBControlTest_GetFilePathForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 1, false);
        return false;
      }
      IndexedDBControlTest::GetFilePathForTestingCallback callback =
          IndexedDBControlTest_GetFilePathForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFilePathForTesting(
std::move(p_storage_key), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControlTest_ResetCachesForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControlTest::ResetCachesForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControlTest::ResetCachesForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControlTest_ResetCachesForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_ResetCachesForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      IndexedDBControlTest_ResetCachesForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 2, false);
        return false;
      }
      IndexedDBControlTest::ResetCachesForTestingCallback callback =
          IndexedDBControlTest_ResetCachesForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetCachesForTesting(std::move(callback));
      return true;
    }
    case internal::kIndexedDBControlTest_ForceSchemaDowngradeForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControlTest::ForceSchemaDowngradeForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControlTest::ForceSchemaDowngradeForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControlTest_ForceSchemaDowngradeForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_ForceSchemaDowngradeForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      IndexedDBControlTest_ForceSchemaDowngradeForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 3, false);
        return false;
      }
      IndexedDBControlTest::ForceSchemaDowngradeForTestingCallback callback =
          IndexedDBControlTest_ForceSchemaDowngradeForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceSchemaDowngradeForTesting(
std::move(p_storage_key), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControlTest_HasV2SchemaCorruptionForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControlTest::HasV2SchemaCorruptionForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControlTest::HasV2SchemaCorruptionForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControlTest_HasV2SchemaCorruptionForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_HasV2SchemaCorruptionForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 4, false);
        return false;
      }
      IndexedDBControlTest::HasV2SchemaCorruptionForTestingCallback callback =
          IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasV2SchemaCorruptionForTesting(
std::move(p_storage_key), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControlTest_WriteToIndexedDBForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControlTest::WriteToIndexedDBForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControlTest::WriteToIndexedDBForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControlTest_WriteToIndexedDBForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_WriteToIndexedDBForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      std::string p_key{};
      std::string p_value{};
      IndexedDBControlTest_WriteToIndexedDBForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 5, false);
        return false;
      }
      IndexedDBControlTest::WriteToIndexedDBForTestingCallback callback =
          IndexedDBControlTest_WriteToIndexedDBForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteToIndexedDBForTesting(
std::move(p_storage_key), 
std::move(p_key), 
std::move(p_value), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControlTest_GetBlobCountForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControlTest::GetBlobCountForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControlTest::GetBlobCountForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControlTest_GetBlobCountForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_GetBlobCountForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      IndexedDBControlTest_GetBlobCountForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 6, false);
        return false;
      }
      IndexedDBControlTest::GetBlobCountForTestingCallback callback =
          IndexedDBControlTest_GetBlobCountForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBlobCountForTesting(
std::move(p_storage_key), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControlTest_GetNextBlobNumberForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControlTest::GetNextBlobNumberForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControlTest::GetNextBlobNumberForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControlTest_GetNextBlobNumberForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_GetNextBlobNumberForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      int64_t p_database_id{};
      IndexedDBControlTest_GetNextBlobNumberForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success)
        p_database_id = input_data_view.database_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 7, false);
        return false;
      }
      IndexedDBControlTest::GetNextBlobNumberForTestingCallback callback =
          IndexedDBControlTest_GetNextBlobNumberForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNextBlobNumberForTesting(
std::move(p_storage_key), 
std::move(p_database_id), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControlTest_GetPathForBlobForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControlTest::GetPathForBlobForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControlTest::GetPathForBlobForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControlTest_GetPathForBlobForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_GetPathForBlobForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      int64_t p_database_id{};
      int64_t p_blob_number{};
      IndexedDBControlTest_GetPathForBlobForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success)
        p_database_id = input_data_view.database_id();
      if (success)
        p_blob_number = input_data_view.blob_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 8, false);
        return false;
      }
      IndexedDBControlTest::GetPathForBlobForTestingCallback callback =
          IndexedDBControlTest_GetPathForBlobForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPathForBlobForTesting(
std::move(p_storage_key), 
std::move(p_database_id), 
std::move(p_blob_number), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControlTest_CompactBackingStoreForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControlTest::CompactBackingStoreForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControlTest::CompactBackingStoreForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControlTest_CompactBackingStoreForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_CompactBackingStoreForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      IndexedDBControlTest_CompactBackingStoreForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 9, false);
        return false;
      }
      IndexedDBControlTest::CompactBackingStoreForTestingCallback callback =
          IndexedDBControlTest_CompactBackingStoreForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CompactBackingStoreForTesting(
std::move(p_storage_key), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControlTest_BindMockFailureSingletonForTesting_Name: {
      break;
    }
    case internal::kIndexedDBControlTest_GetDatabaseKeysForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControlTest::GetDatabaseKeysForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControlTest::GetDatabaseKeysForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControlTest_GetDatabaseKeysForTesting_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControlTest_GetDatabaseKeysForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      IndexedDBControlTest_GetDatabaseKeysForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControlTest::Name_, 11, false);
        return false;
      }
      IndexedDBControlTest::GetDatabaseKeysForTestingCallback callback =
          IndexedDBControlTest_GetDatabaseKeysForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDatabaseKeysForTesting(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIndexedDBControlTestValidationInfo[] = {
    {internal::kIndexedDBControlTest_GetBaseDataPathForTesting_Name,
     {&internal::IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControlTest_GetFilePathForTesting_Name,
     {&internal::IndexedDBControlTest_GetFilePathForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControlTest_ResetCachesForTesting_Name,
     {&internal::IndexedDBControlTest_ResetCachesForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControlTest_ForceSchemaDowngradeForTesting_Name,
     {&internal::IndexedDBControlTest_ForceSchemaDowngradeForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_ForceSchemaDowngradeForTesting_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControlTest_HasV2SchemaCorruptionForTesting_Name,
     {&internal::IndexedDBControlTest_HasV2SchemaCorruptionForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControlTest_WriteToIndexedDBForTesting_Name,
     {&internal::IndexedDBControlTest_WriteToIndexedDBForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_WriteToIndexedDBForTesting_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControlTest_GetBlobCountForTesting_Name,
     {&internal::IndexedDBControlTest_GetBlobCountForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_GetBlobCountForTesting_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControlTest_GetNextBlobNumberForTesting_Name,
     {&internal::IndexedDBControlTest_GetNextBlobNumberForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_GetNextBlobNumberForTesting_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControlTest_GetPathForBlobForTesting_Name,
     {&internal::IndexedDBControlTest_GetPathForBlobForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControlTest_CompactBackingStoreForTesting_Name,
     {&internal::IndexedDBControlTest_CompactBackingStoreForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_CompactBackingStoreForTesting_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControlTest_BindMockFailureSingletonForTesting_Name,
     {&internal::IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIndexedDBControlTest_GetDatabaseKeysForTesting_Name,
     {&internal::IndexedDBControlTest_GetDatabaseKeysForTesting_Params_Data::Validate,
      &internal::IndexedDBControlTest_GetDatabaseKeysForTesting_ResponseParams_Data::Validate}},
};

bool IndexedDBControlTestRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IndexedDBControlTest::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIndexedDBControlTestValidationInfo);
}

bool IndexedDBControlTestResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IndexedDBControlTest::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kIndexedDBControlTestValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif