// components/services/storage/public/mojom/quota_client.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/services/storage/public/mojom/quota_client.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "third_party/blink/public/mojom/quota/quota_types.mojom.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_QUOTA_CLIENT_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_QUOTA_CLIENT_MOJOM_JUMBO_H_
#endif


namespace storage {
namespace mojom {


void QuotaClientInterceptorForTesting::GetStorageKeyUsage(const ::blink::StorageKey& storage_key, ::blink::mojom::StorageType type, GetStorageKeyUsageCallback callback) {
  GetForwardingInterface()->GetStorageKeyUsage(std::move(storage_key), std::move(type), std::move(callback));
}
void QuotaClientInterceptorForTesting::GetStorageKeysForType(::blink::mojom::StorageType type, GetStorageKeysForTypeCallback callback) {
  GetForwardingInterface()->GetStorageKeysForType(std::move(type), std::move(callback));
}
void QuotaClientInterceptorForTesting::GetStorageKeysForHost(::blink::mojom::StorageType type, const std::string& host, GetStorageKeysForHostCallback callback) {
  GetForwardingInterface()->GetStorageKeysForHost(std::move(type), std::move(host), std::move(callback));
}
void QuotaClientInterceptorForTesting::DeleteStorageKeyData(const ::blink::StorageKey& storage_key, ::blink::mojom::StorageType type, DeleteStorageKeyDataCallback callback) {
  GetForwardingInterface()->DeleteStorageKeyData(std::move(storage_key), std::move(type), std::move(callback));
}
void QuotaClientInterceptorForTesting::PerformStorageCleanup(::blink::mojom::StorageType type, PerformStorageCleanupCallback callback) {
  GetForwardingInterface()->PerformStorageCleanup(std::move(type), std::move(callback));
}
QuotaClientAsyncWaiter::QuotaClientAsyncWaiter(
    QuotaClient* proxy) : proxy_(proxy) {}

QuotaClientAsyncWaiter::~QuotaClientAsyncWaiter() = default;

void QuotaClientAsyncWaiter::GetStorageKeyUsage(
    const ::blink::StorageKey& storage_key, ::blink::mojom::StorageType type, int64_t* out_usage) {
  base::RunLoop loop;
  proxy_->GetStorageKeyUsage(std::move(storage_key),std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_usage
,
             int64_t usage) {*out_usage = std::move(usage);
            loop->Quit();
          },
          &loop,
          out_usage));
  loop.Run();
}
void QuotaClientAsyncWaiter::GetStorageKeysForType(
    ::blink::mojom::StorageType type, std::vector<::blink::StorageKey>* out_storage_keys) {
  base::RunLoop loop;
  proxy_->GetStorageKeysForType(std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::blink::StorageKey>* out_storage_keys
,
             const std::vector<::blink::StorageKey>& storage_keys) {*out_storage_keys = std::move(storage_keys);
            loop->Quit();
          },
          &loop,
          out_storage_keys));
  loop.Run();
}
void QuotaClientAsyncWaiter::GetStorageKeysForHost(
    ::blink::mojom::StorageType type, const std::string& host, std::vector<::blink::StorageKey>* out_storage_keys) {
  base::RunLoop loop;
  proxy_->GetStorageKeysForHost(std::move(type),std::move(host),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::blink::StorageKey>* out_storage_keys
,
             const std::vector<::blink::StorageKey>& storage_keys) {*out_storage_keys = std::move(storage_keys);
            loop->Quit();
          },
          &loop,
          out_storage_keys));
  loop.Run();
}
void QuotaClientAsyncWaiter::DeleteStorageKeyData(
    const ::blink::StorageKey& storage_key, ::blink::mojom::StorageType type, ::blink::mojom::QuotaStatusCode* out_status) {
  base::RunLoop loop;
  proxy_->DeleteStorageKeyData(std::move(storage_key),std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::QuotaStatusCode* out_status
,
             ::blink::mojom::QuotaStatusCode status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void QuotaClientAsyncWaiter::PerformStorageCleanup(
    ::blink::mojom::StorageType type) {
  base::RunLoop loop;
  proxy_->PerformStorageCleanup(std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace mojom
}  // namespace storage

#if defined(__clang__)
#pragma clang diagnostic pop
#endif