// components/services/storage/public/mojom/quota_client.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/quota_client.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/quota_client.mojom-params-data.h"
#include "components/services/storage/public/mojom/quota_client.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/quota_client.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_QUOTA_CLIENT_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_QUOTA_CLIENT_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
const char QuotaClient::Name_[] = "storage.mojom.QuotaClient";

class QuotaClient_GetStorageKeyUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_GetStorageKeyUsage_ForwardToCallback(
      QuotaClient::GetStorageKeyUsageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::GetStorageKeyUsageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaClient_GetStorageKeyUsage_ForwardToCallback);
};

class QuotaClient_GetStorageKeysForType_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_GetStorageKeysForType_ForwardToCallback(
      QuotaClient::GetStorageKeysForTypeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::GetStorageKeysForTypeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaClient_GetStorageKeysForType_ForwardToCallback);
};

class QuotaClient_GetStorageKeysForHost_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_GetStorageKeysForHost_ForwardToCallback(
      QuotaClient::GetStorageKeysForHostCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::GetStorageKeysForHostCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaClient_GetStorageKeysForHost_ForwardToCallback);
};

class QuotaClient_DeleteStorageKeyData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_DeleteStorageKeyData_ForwardToCallback(
      QuotaClient::DeleteStorageKeyDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::DeleteStorageKeyDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaClient_DeleteStorageKeyData_ForwardToCallback);
};

class QuotaClient_PerformStorageCleanup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_PerformStorageCleanup_ForwardToCallback(
      QuotaClient::PerformStorageCleanupCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::PerformStorageCleanupCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaClient_PerformStorageCleanup_ForwardToCallback);
};

QuotaClientProxy::QuotaClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuotaClientProxy::GetStorageKeyUsage(
    const ::blink::StorageKey& in_storage_key, ::blink::mojom::StorageType in_type, GetStorageKeyUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::QuotaClient::GetStorageKeyUsage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::blink::mojom::StorageType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kQuotaClient_GetStorageKeyUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetStorageKeyUsage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in QuotaClient.GetStorageKeyUsage request");
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetStorageKeyUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_GetStorageKeyUsage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuotaClientProxy::GetStorageKeysForType(
    ::blink::mojom::StorageType in_type, GetStorageKeysForTypeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::QuotaClient::GetStorageKeysForType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::blink::mojom::StorageType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kQuotaClient_GetStorageKeysForType_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetStorageKeysForType_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetStorageKeysForType");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_GetStorageKeysForType_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuotaClientProxy::GetStorageKeysForHost(
    ::blink::mojom::StorageType in_type, const std::string& in_host, GetStorageKeysForHostCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::QuotaClient::GetStorageKeysForHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::blink::mojom::StorageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kQuotaClient_GetStorageKeysForHost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetStorageKeysForHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_type, &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host, host_fragment);
  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in QuotaClient.GetStorageKeysForHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetStorageKeysForHost");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_GetStorageKeysForHost_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuotaClientProxy::DeleteStorageKeyData(
    const ::blink::StorageKey& in_storage_key, ::blink::mojom::StorageType in_type, DeleteStorageKeyDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::QuotaClient::DeleteStorageKeyData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::blink::mojom::StorageType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kQuotaClient_DeleteStorageKeyData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_DeleteStorageKeyData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key, storage_key_fragment);
  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in QuotaClient.DeleteStorageKeyData request");
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("DeleteStorageKeyData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_DeleteStorageKeyData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuotaClientProxy::PerformStorageCleanup(
    ::blink::mojom::StorageType in_type, PerformStorageCleanupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::QuotaClient::PerformStorageCleanup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::blink::mojom::StorageType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kQuotaClient_PerformStorageCleanup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_PerformStorageCleanup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("PerformStorageCleanup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_PerformStorageCleanup_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class QuotaClient_GetStorageKeyUsage_ProxyToResponder {
 public:
  static QuotaClient::GetStorageKeyUsageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaClient_GetStorageKeyUsage_ProxyToResponder> proxy(
        new QuotaClient_GetStorageKeyUsage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaClient_GetStorageKeyUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_GetStorageKeyUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaClient_GetStorageKeyUsage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::GetStorageKeyUsageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_usage);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaClient_GetStorageKeyUsage_ProxyToResponder);
};

bool QuotaClient_GetStorageKeyUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::QuotaClient::GetStorageKeyUsageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaClient_GetStorageKeyUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_GetStorageKeyUsage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_usage{};
  QuotaClient_GetStorageKeyUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_usage = input_data_view.usage();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_usage));
  return true;
}

void QuotaClient_GetStorageKeyUsage_ProxyToResponder::Run(
    int64_t in_usage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::QuotaClient::GetStorageKeyUsageCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage"), in_usage,
                        "<value of type int64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kQuotaClient_GetStorageKeyUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetStorageKeyUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->usage = in_usage;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::QuotaClient::GetStorageKeyUsageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetStorageKeyUsage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaClient_GetStorageKeysForType_ProxyToResponder {
 public:
  static QuotaClient::GetStorageKeysForTypeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaClient_GetStorageKeysForType_ProxyToResponder> proxy(
        new QuotaClient_GetStorageKeysForType_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaClient_GetStorageKeysForType_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_GetStorageKeysForType_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaClient_GetStorageKeysForType_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::GetStorageKeysForTypeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::blink::StorageKey>& in_storage_keys);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaClient_GetStorageKeysForType_ProxyToResponder);
};

bool QuotaClient_GetStorageKeysForType_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::QuotaClient::GetStorageKeysForTypeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaClient_GetStorageKeysForType_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_GetStorageKeysForType_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::blink::StorageKey> p_storage_keys{};
  QuotaClient_GetStorageKeysForType_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStorageKeys(&p_storage_keys))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_storage_keys));
  return true;
}

void QuotaClient_GetStorageKeysForType_ProxyToResponder::Run(
    const std::vector<::blink::StorageKey>& in_storage_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::QuotaClient::GetStorageKeysForTypeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_keys"), in_storage_keys,
                        "<value of type const std::vector<::blink::StorageKey>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kQuotaClient_GetStorageKeysForType_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetStorageKeysForType_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_keys)::BaseType>
      storage_keys_fragment(params.message());
  const mojo::internal::ContainerValidateParams storage_keys_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::StorageKeyDataView>>(
      in_storage_keys, storage_keys_fragment, &storage_keys_validate_params);
  params->storage_keys.Set(
      storage_keys_fragment.is_null() ? nullptr : storage_keys_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_keys in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::QuotaClient::GetStorageKeysForTypeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetStorageKeysForType");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaClient_GetStorageKeysForHost_ProxyToResponder {
 public:
  static QuotaClient::GetStorageKeysForHostCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaClient_GetStorageKeysForHost_ProxyToResponder> proxy(
        new QuotaClient_GetStorageKeysForHost_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaClient_GetStorageKeysForHost_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_GetStorageKeysForHost_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaClient_GetStorageKeysForHost_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::GetStorageKeysForHostCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::blink::StorageKey>& in_storage_keys);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaClient_GetStorageKeysForHost_ProxyToResponder);
};

bool QuotaClient_GetStorageKeysForHost_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::QuotaClient::GetStorageKeysForHostCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaClient_GetStorageKeysForHost_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_GetStorageKeysForHost_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::blink::StorageKey> p_storage_keys{};
  QuotaClient_GetStorageKeysForHost_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStorageKeys(&p_storage_keys))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_storage_keys));
  return true;
}

void QuotaClient_GetStorageKeysForHost_ProxyToResponder::Run(
    const std::vector<::blink::StorageKey>& in_storage_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::QuotaClient::GetStorageKeysForHostCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_keys"), in_storage_keys,
                        "<value of type const std::vector<::blink::StorageKey>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kQuotaClient_GetStorageKeysForHost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetStorageKeysForHost_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_keys)::BaseType>
      storage_keys_fragment(params.message());
  const mojo::internal::ContainerValidateParams storage_keys_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::StorageKeyDataView>>(
      in_storage_keys, storage_keys_fragment, &storage_keys_validate_params);
  params->storage_keys.Set(
      storage_keys_fragment.is_null() ? nullptr : storage_keys_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_keys in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::QuotaClient::GetStorageKeysForHostCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetStorageKeysForHost");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaClient_DeleteStorageKeyData_ProxyToResponder {
 public:
  static QuotaClient::DeleteStorageKeyDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaClient_DeleteStorageKeyData_ProxyToResponder> proxy(
        new QuotaClient_DeleteStorageKeyData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaClient_DeleteStorageKeyData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_DeleteStorageKeyData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaClient_DeleteStorageKeyData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::DeleteStorageKeyDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::QuotaStatusCode in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaClient_DeleteStorageKeyData_ProxyToResponder);
};

bool QuotaClient_DeleteStorageKeyData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::QuotaClient::DeleteStorageKeyDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaClient_DeleteStorageKeyData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_DeleteStorageKeyData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::QuotaStatusCode p_status{};
  QuotaClient_DeleteStorageKeyData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void QuotaClient_DeleteStorageKeyData_ProxyToResponder::Run(
    ::blink::mojom::QuotaStatusCode in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::QuotaClient::DeleteStorageKeyDataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::QuotaStatusCode>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kQuotaClient_DeleteStorageKeyData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_DeleteStorageKeyData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::QuotaStatusCode>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::QuotaClient::DeleteStorageKeyDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("DeleteStorageKeyData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaClient_PerformStorageCleanup_ProxyToResponder {
 public:
  static QuotaClient::PerformStorageCleanupCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaClient_PerformStorageCleanup_ProxyToResponder> proxy(
        new QuotaClient_PerformStorageCleanup_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaClient_PerformStorageCleanup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_PerformStorageCleanup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaClient_PerformStorageCleanup_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::PerformStorageCleanupCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaClient_PerformStorageCleanup_ProxyToResponder);
};

bool QuotaClient_PerformStorageCleanup_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::QuotaClient::PerformStorageCleanupCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaClient_PerformStorageCleanup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_PerformStorageCleanup_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  QuotaClient_PerformStorageCleanup_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void QuotaClient_PerformStorageCleanup_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::QuotaClient::PerformStorageCleanupCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kQuotaClient_PerformStorageCleanup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_PerformStorageCleanup_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::QuotaClient::PerformStorageCleanupCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("PerformStorageCleanup");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool QuotaClientStubDispatch::Accept(
    QuotaClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kQuotaClient_GetStorageKeyUsage_Name: {
      break;
    }
    case internal::kQuotaClient_GetStorageKeysForType_Name: {
      break;
    }
    case internal::kQuotaClient_GetStorageKeysForHost_Name: {
      break;
    }
    case internal::kQuotaClient_DeleteStorageKeyData_Name: {
      break;
    }
    case internal::kQuotaClient_PerformStorageCleanup_Name: {
      break;
    }
  }
  return false;
}

// static
bool QuotaClientStubDispatch::AcceptWithResponder(
    QuotaClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kQuotaClient_GetStorageKeyUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::QuotaClient::GetStorageKeyUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::QuotaClient::GetStorageKeyUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaClient_GetStorageKeyUsage_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_GetStorageKeyUsage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      ::blink::mojom::StorageType p_type{};
      QuotaClient_GetStorageKeyUsage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 0, false);
        return false;
      }
      QuotaClient::GetStorageKeyUsageCallback callback =
          QuotaClient_GetStorageKeyUsage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStorageKeyUsage(
std::move(p_storage_key), 
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kQuotaClient_GetStorageKeysForType_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::QuotaClient::GetStorageKeysForType",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::QuotaClient::GetStorageKeysForType");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaClient_GetStorageKeysForType_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_GetStorageKeysForType_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::StorageType p_type{};
      QuotaClient_GetStorageKeysForType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 1, false);
        return false;
      }
      QuotaClient::GetStorageKeysForTypeCallback callback =
          QuotaClient_GetStorageKeysForType_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStorageKeysForType(
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kQuotaClient_GetStorageKeysForHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::QuotaClient::GetStorageKeysForHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::QuotaClient::GetStorageKeysForHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaClient_GetStorageKeysForHost_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_GetStorageKeysForHost_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::StorageType p_type{};
      std::string p_host{};
      QuotaClient_GetStorageKeysForHost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 2, false);
        return false;
      }
      QuotaClient::GetStorageKeysForHostCallback callback =
          QuotaClient_GetStorageKeysForHost_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStorageKeysForHost(
std::move(p_type), 
std::move(p_host), std::move(callback));
      return true;
    }
    case internal::kQuotaClient_DeleteStorageKeyData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::QuotaClient::DeleteStorageKeyData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::QuotaClient::DeleteStorageKeyData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaClient_DeleteStorageKeyData_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_DeleteStorageKeyData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      ::blink::mojom::StorageType p_type{};
      QuotaClient_DeleteStorageKeyData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 3, false);
        return false;
      }
      QuotaClient::DeleteStorageKeyDataCallback callback =
          QuotaClient_DeleteStorageKeyData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteStorageKeyData(
std::move(p_storage_key), 
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kQuotaClient_PerformStorageCleanup_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::QuotaClient::PerformStorageCleanup",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::QuotaClient::PerformStorageCleanup");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaClient_PerformStorageCleanup_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_PerformStorageCleanup_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::StorageType p_type{};
      QuotaClient_PerformStorageCleanup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 4, false);
        return false;
      }
      QuotaClient::PerformStorageCleanupCallback callback =
          QuotaClient_PerformStorageCleanup_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformStorageCleanup(
std::move(p_type), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kQuotaClientValidationInfo[] = {
    {internal::kQuotaClient_GetStorageKeyUsage_Name,
     {&internal::QuotaClient_GetStorageKeyUsage_Params_Data::Validate,
      &internal::QuotaClient_GetStorageKeyUsage_ResponseParams_Data::Validate}},
    {internal::kQuotaClient_GetStorageKeysForType_Name,
     {&internal::QuotaClient_GetStorageKeysForType_Params_Data::Validate,
      &internal::QuotaClient_GetStorageKeysForType_ResponseParams_Data::Validate}},
    {internal::kQuotaClient_GetStorageKeysForHost_Name,
     {&internal::QuotaClient_GetStorageKeysForHost_Params_Data::Validate,
      &internal::QuotaClient_GetStorageKeysForHost_ResponseParams_Data::Validate}},
    {internal::kQuotaClient_DeleteStorageKeyData_Name,
     {&internal::QuotaClient_DeleteStorageKeyData_Params_Data::Validate,
      &internal::QuotaClient_DeleteStorageKeyData_ResponseParams_Data::Validate}},
    {internal::kQuotaClient_PerformStorageCleanup_Name,
     {&internal::QuotaClient_PerformStorageCleanup_Params_Data::Validate,
      &internal::QuotaClient_PerformStorageCleanup_ResponseParams_Data::Validate}},
};

bool QuotaClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::QuotaClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kQuotaClientValidationInfo);
}

bool QuotaClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::QuotaClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kQuotaClientValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif