// components/services/storage/public/mojom/storage_usage_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/storage_usage_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/storage_usage_info.mojom-params-data.h"
#include "components/services/storage/public/mojom/storage_usage_info.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/storage_usage_info.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_USAGE_INFO_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_USAGE_INFO_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
StorageUsageInfo::StorageUsageInfo()
    : origin(),
      total_size_bytes(),
      last_modified() {}

StorageUsageInfo::StorageUsageInfo(
    const ::url::Origin& origin_in,
    int64_t total_size_bytes_in,
    ::base::Time last_modified_in)
    : origin(std::move(origin_in)),
      total_size_bytes(std::move(total_size_bytes_in)),
      last_modified(std::move(last_modified_in)) {}

StorageUsageInfo::~StorageUsageInfo() = default;

void StorageUsageInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_size_bytes"), this->total_size_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_modified"), this->last_modified,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StorageUsageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace storage

namespace mojo {


// static
bool StructTraits<::storage::mojom::StorageUsageInfo::DataView, ::storage::mojom::StorageUsageInfoPtr>::Read(
    ::storage::mojom::StorageUsageInfo::DataView input,
    ::storage::mojom::StorageUsageInfoPtr* output) {
  bool success = true;
  ::storage::mojom::StorageUsageInfoPtr result(::storage::mojom::StorageUsageInfo::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success)
        result->total_size_bytes = input.total_size_bytes();
      if (success && !input.ReadLastModified(&result->last_modified))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif