// components/services/unzip/public/mojom/unzipper.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/unzip/public/mojom/unzipper.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/unzip/public/mojom/unzipper.mojom-params-data.h"
#include "components/services/unzip/public/mojom/unzipper.mojom-shared-message-ids.h"

#include "components/services/unzip/public/mojom/unzipper.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_JUMBO_H_
#endif
namespace unzip {
namespace mojom {
const char UnzipFilter::Name_[] = "unzip.mojom.UnzipFilter";
bool UnzipFilter::ShouldUnzipFile(const ::base::FilePath& path, bool* out_result) {
  NOTREACHED();
  return false;
}
class UnzipFilter_ShouldUnzipFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  UnzipFilter_ShouldUnzipFile_HandleSyncResponse(
      bool* result, bool* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_result_;DISALLOW_COPY_AND_ASSIGN(UnzipFilter_ShouldUnzipFile_HandleSyncResponse);
};

class UnzipFilter_ShouldUnzipFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UnzipFilter_ShouldUnzipFile_ForwardToCallback(
      UnzipFilter::ShouldUnzipFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  UnzipFilter::ShouldUnzipFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(UnzipFilter_ShouldUnzipFile_ForwardToCallback);
};

UnzipFilterProxy::UnzipFilterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool UnzipFilterProxy::ShouldUnzipFile(
    const ::base::FilePath& param_path, bool* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "unzip::mojom::UnzipFilter::ShouldUnzipFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUnzipFilter_ShouldUnzipFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::UnzipFilter_ShouldUnzipFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in UnzipFilter.ShouldUnzipFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnzipFilter::Name_);
  message.set_method_name("ShouldUnzipFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UnzipFilter_ShouldUnzipFile_HandleSyncResponse(
          &result, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "unzip::mojom::UnzipFilter::ShouldUnzipFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type bool>");
   });
#endif
  return result;
}

void UnzipFilterProxy::ShouldUnzipFile(
    const ::base::FilePath& in_path, ShouldUnzipFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "unzip::mojom::UnzipFilter::ShouldUnzipFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUnzipFilter_ShouldUnzipFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::UnzipFilter_ShouldUnzipFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in UnzipFilter.ShouldUnzipFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnzipFilter::Name_);
  message.set_method_name("ShouldUnzipFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UnzipFilter_ShouldUnzipFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class UnzipFilter_ShouldUnzipFile_ProxyToResponder {
 public:
  static UnzipFilter::ShouldUnzipFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<UnzipFilter_ShouldUnzipFile_ProxyToResponder> proxy(
        new UnzipFilter_ShouldUnzipFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&UnzipFilter_ShouldUnzipFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UnzipFilter_ShouldUnzipFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  UnzipFilter_ShouldUnzipFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UnzipFilter::ShouldUnzipFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(UnzipFilter_ShouldUnzipFile_ProxyToResponder);
};

bool UnzipFilter_ShouldUnzipFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "unzip::mojom::UnzipFilter::ShouldUnzipFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  UnzipFilter_ShouldUnzipFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UnzipFilter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void UnzipFilter_ShouldUnzipFile_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)unzip::mojom::UnzipFilter::ShouldUnzipFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUnzipFilter_ShouldUnzipFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)unzip::mojom::UnzipFilter::ShouldUnzipFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UnzipFilter::Name_);
  message.set_method_name("ShouldUnzipFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool UnzipFilter_ShouldUnzipFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data* params =
      reinterpret_cast<internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  UnzipFilter_ShouldUnzipFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UnzipFilter::Name_, 0, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}

// static
bool UnzipFilterStubDispatch::Accept(
    UnzipFilter* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kUnzipFilter_ShouldUnzipFile_Name: {
      break;
    }
  }
  return false;
}

// static
bool UnzipFilterStubDispatch::AcceptWithResponder(
    UnzipFilter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kUnzipFilter_ShouldUnzipFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)unzip::mojom::UnzipFilter::ShouldUnzipFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)unzip::mojom::UnzipFilter::ShouldUnzipFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::UnzipFilter_ShouldUnzipFile_Params_Data* params =
          reinterpret_cast<
              internal::UnzipFilter_ShouldUnzipFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      UnzipFilter_ShouldUnzipFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UnzipFilter::Name_, 0, false);
        return false;
      }
      UnzipFilter::ShouldUnzipFileCallback callback =
          UnzipFilter_ShouldUnzipFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldUnzipFile(
std::move(p_path), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUnzipFilterValidationInfo[] = {
    {internal::kUnzipFilter_ShouldUnzipFile_Name,
     {&internal::UnzipFilter_ShouldUnzipFile_Params_Data::Validate,
      &internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data::Validate}},
};

bool UnzipFilterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::unzip::mojom::UnzipFilter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUnzipFilterValidationInfo);
}

bool UnzipFilterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::unzip::mojom::UnzipFilter::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kUnzipFilterValidationInfo);

}
const char Unzipper::Name_[] = "unzip.mojom.Unzipper";

class Unzipper_Unzip_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Unzipper_Unzip_ForwardToCallback(
      Unzipper::UnzipCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Unzipper::UnzipCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Unzipper_Unzip_ForwardToCallback);
};

class Unzipper_UnzipWithFilter_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Unzipper_UnzipWithFilter_ForwardToCallback(
      Unzipper::UnzipWithFilterCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Unzipper::UnzipWithFilterCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Unzipper_UnzipWithFilter_ForwardToCallback);
};

UnzipperProxy::UnzipperProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UnzipperProxy::Unzip(
    ::base::File in_zip_file, ::mojo::PendingRemote<::filesystem::mojom::Directory> in_output_dir, UnzipCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "unzip::mojom::Unzipper::Unzip", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("zip_file"), in_zip_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_dir"), in_output_dir,
                        "<value of type ::mojo::PendingRemote<::filesystem::mojom::Directory>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUnzipper_Unzip_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::Unzipper_Unzip_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->zip_file)::BaseType> zip_file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_zip_file, zip_file_fragment);
  params->zip_file.Set(
      zip_file_fragment.is_null() ? nullptr : zip_file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->zip_file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null zip_file in Unzipper.Unzip request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::filesystem::mojom::DirectoryInterfaceBase>>(
      in_output_dir, &params->output_dir, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->output_dir),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid output_dir in Unzipper.Unzip request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Unzipper::Name_);
  message.set_method_name("Unzip");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Unzipper_Unzip_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void UnzipperProxy::UnzipWithFilter(
    ::base::File in_zip_file, ::mojo::PendingRemote<::filesystem::mojom::Directory> in_output_dir, ::mojo::PendingRemote<UnzipFilter> in_filter, UnzipWithFilterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "unzip::mojom::Unzipper::UnzipWithFilter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("zip_file"), in_zip_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_dir"), in_output_dir,
                        "<value of type ::mojo::PendingRemote<::filesystem::mojom::Directory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::mojo::PendingRemote<UnzipFilter>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUnzipper_UnzipWithFilter_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::Unzipper_UnzipWithFilter_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->zip_file)::BaseType> zip_file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_zip_file, zip_file_fragment);
  params->zip_file.Set(
      zip_file_fragment.is_null() ? nullptr : zip_file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->zip_file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null zip_file in Unzipper.UnzipWithFilter request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::filesystem::mojom::DirectoryInterfaceBase>>(
      in_output_dir, &params->output_dir, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->output_dir),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid output_dir in Unzipper.UnzipWithFilter request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::unzip::mojom::UnzipFilterInterfaceBase>>(
      in_filter, &params->filter, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->filter),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid filter in Unzipper.UnzipWithFilter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Unzipper::Name_);
  message.set_method_name("UnzipWithFilter");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Unzipper_UnzipWithFilter_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class Unzipper_Unzip_ProxyToResponder {
 public:
  static Unzipper::UnzipCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Unzipper_Unzip_ProxyToResponder> proxy(
        new Unzipper_Unzip_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Unzipper_Unzip_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Unzipper_Unzip_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Unzipper_Unzip_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Unzipper::UnzipCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Unzipper_Unzip_ProxyToResponder);
};

bool Unzipper_Unzip_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "unzip::mojom::Unzipper::UnzipCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Unzipper_Unzip_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Unzipper_Unzip_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  Unzipper_Unzip_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Unzipper::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void Unzipper_Unzip_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)unzip::mojom::Unzipper::UnzipCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUnzipper_Unzip_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::Unzipper_Unzip_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)unzip::mojom::Unzipper::UnzipCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Unzipper::Name_);
  message.set_method_name("Unzip");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Unzipper_UnzipWithFilter_ProxyToResponder {
 public:
  static Unzipper::UnzipWithFilterCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Unzipper_UnzipWithFilter_ProxyToResponder> proxy(
        new Unzipper_UnzipWithFilter_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Unzipper_UnzipWithFilter_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Unzipper_UnzipWithFilter_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Unzipper_UnzipWithFilter_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Unzipper::UnzipWithFilterCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Unzipper_UnzipWithFilter_ProxyToResponder);
};

bool Unzipper_UnzipWithFilter_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "unzip::mojom::Unzipper::UnzipWithFilterCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Unzipper_UnzipWithFilter_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Unzipper_UnzipWithFilter_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  Unzipper_UnzipWithFilter_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Unzipper::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void Unzipper_UnzipWithFilter_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)unzip::mojom::Unzipper::UnzipWithFilterCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUnzipper_UnzipWithFilter_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::unzip::mojom::internal::Unzipper_UnzipWithFilter_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)unzip::mojom::Unzipper::UnzipWithFilterCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Unzipper::Name_);
  message.set_method_name("UnzipWithFilter");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool UnzipperStubDispatch::Accept(
    Unzipper* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kUnzipper_Unzip_Name: {
      break;
    }
    case internal::kUnzipper_UnzipWithFilter_Name: {
      break;
    }
  }
  return false;
}

// static
bool UnzipperStubDispatch::AcceptWithResponder(
    Unzipper* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kUnzipper_Unzip_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)unzip::mojom::Unzipper::Unzip",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)unzip::mojom::Unzipper::Unzip");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Unzipper_Unzip_Params_Data* params =
          reinterpret_cast<
              internal::Unzipper_Unzip_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::File p_zip_file{};
      ::mojo::PendingRemote<::filesystem::mojom::Directory> p_output_dir{};
      Unzipper_Unzip_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadZipFile(&p_zip_file))
        success = false;
      if (success) {
        p_output_dir =
            input_data_view.TakeOutputDir<decltype(p_output_dir)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Unzipper::Name_, 0, false);
        return false;
      }
      Unzipper::UnzipCallback callback =
          Unzipper_Unzip_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unzip(
std::move(p_zip_file), 
std::move(p_output_dir), std::move(callback));
      return true;
    }
    case internal::kUnzipper_UnzipWithFilter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)unzip::mojom::Unzipper::UnzipWithFilter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)unzip::mojom::Unzipper::UnzipWithFilter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Unzipper_UnzipWithFilter_Params_Data* params =
          reinterpret_cast<
              internal::Unzipper_UnzipWithFilter_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::File p_zip_file{};
      ::mojo::PendingRemote<::filesystem::mojom::Directory> p_output_dir{};
      ::mojo::PendingRemote<UnzipFilter> p_filter{};
      Unzipper_UnzipWithFilter_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadZipFile(&p_zip_file))
        success = false;
      if (success) {
        p_output_dir =
            input_data_view.TakeOutputDir<decltype(p_output_dir)>();
      }
      if (success) {
        p_filter =
            input_data_view.TakeFilter<decltype(p_filter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Unzipper::Name_, 1, false);
        return false;
      }
      Unzipper::UnzipWithFilterCallback callback =
          Unzipper_UnzipWithFilter_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnzipWithFilter(
std::move(p_zip_file), 
std::move(p_output_dir), 
std::move(p_filter), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUnzipperValidationInfo[] = {
    {internal::kUnzipper_Unzip_Name,
     {&internal::Unzipper_Unzip_Params_Data::Validate,
      &internal::Unzipper_Unzip_ResponseParams_Data::Validate}},
    {internal::kUnzipper_UnzipWithFilter_Name,
     {&internal::Unzipper_UnzipWithFilter_Params_Data::Validate,
      &internal::Unzipper_UnzipWithFilter_ResponseParams_Data::Validate}},
};

bool UnzipperRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::unzip::mojom::Unzipper::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUnzipperValidationInfo);
}

bool UnzipperResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::unzip::mojom::Unzipper::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kUnzipperValidationInfo);

}
}  // namespace mojom
}  // namespace unzip

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif