// content/browser/conversions/conversion_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/conversions/conversion_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/conversions/conversion_internals.mojom-params-data.h"
namespace mojom {

static NOINLINE const char* SourceTypeToStringHelper(SourceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SourceType::kNavigation:
      return "kNavigation";
    case SourceType::kEvent:
      return "kEvent";
    default:
      return nullptr;
  }
}

std::string SourceTypeToString(SourceType value) {
  const char *str = SourceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SourceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SourceType value) {
  return os << SourceTypeToString(value);
}

namespace internal {


// static
bool WebUIConversionReport_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebUIConversionReport_Data* object = static_cast<const WebUIConversionReport_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conversion_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->conversion_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reporting_origin, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reporting_origin, validation_context))
    return false;


  if (!::mojom::internal::SourceType_Data
        ::Validate(object->source_type, validation_context))
    return false;

  return true;
}

WebUIConversionReport_Data::WebUIConversionReport_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUIImpression_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebUIImpression_Data* object = static_cast<const WebUIImpression_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->impression_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->impression_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conversion_destination, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->conversion_destination, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reporting_origin, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reporting_origin, validation_context))
    return false;


  if (!::mojom::internal::SourceType_Data
        ::Validate(object->source_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dedup_keys, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams dedup_keys_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->dedup_keys, validation_context,
                                         &dedup_keys_validate_params)) {
    return false;
  }

  return true;
}

WebUIImpression_Data::WebUIImpression_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SentReportInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SentReportInfo_Data* object = static_cast<const SentReportInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->report_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report_body, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams report_body_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->report_body, validation_context,
                                         &report_body_validate_params)) {
    return false;
  }

  return true;
}

SentReportInfo_Data::SentReportInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionInternalsHandler_IsMeasurementEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionInternalsHandler_IsMeasurementEnabled_Params_Data* object = static_cast<const ConversionInternalsHandler_IsMeasurementEnabled_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ConversionInternalsHandler_IsMeasurementEnabled_Params_Data::ConversionInternalsHandler_IsMeasurementEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionInternalsHandler_IsMeasurementEnabled_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionInternalsHandler_IsMeasurementEnabled_ResponseParams_Data* object = static_cast<const ConversionInternalsHandler_IsMeasurementEnabled_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ConversionInternalsHandler_IsMeasurementEnabled_ResponseParams_Data::ConversionInternalsHandler_IsMeasurementEnabled_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionInternalsHandler_GetActiveImpressions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionInternalsHandler_GetActiveImpressions_Params_Data* object = static_cast<const ConversionInternalsHandler_GetActiveImpressions_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ConversionInternalsHandler_GetActiveImpressions_Params_Data::ConversionInternalsHandler_GetActiveImpressions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionInternalsHandler_GetActiveImpressions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionInternalsHandler_GetActiveImpressions_ResponseParams_Data* object = static_cast<const ConversionInternalsHandler_GetActiveImpressions_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->impressions, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams impressions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->impressions, validation_context,
                                         &impressions_validate_params)) {
    return false;
  }

  return true;
}

ConversionInternalsHandler_GetActiveImpressions_ResponseParams_Data::ConversionInternalsHandler_GetActiveImpressions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionInternalsHandler_GetPendingReports_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionInternalsHandler_GetPendingReports_Params_Data* object = static_cast<const ConversionInternalsHandler_GetPendingReports_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ConversionInternalsHandler_GetPendingReports_Params_Data::ConversionInternalsHandler_GetPendingReports_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionInternalsHandler_GetPendingReports_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionInternalsHandler_GetPendingReports_ResponseParams_Data* object = static_cast<const ConversionInternalsHandler_GetPendingReports_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reports, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams reports_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->reports, validation_context,
                                         &reports_validate_params)) {
    return false;
  }

  return true;
}

ConversionInternalsHandler_GetPendingReports_ResponseParams_Data::ConversionInternalsHandler_GetPendingReports_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionInternalsHandler_GetSentReports_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionInternalsHandler_GetSentReports_Params_Data* object = static_cast<const ConversionInternalsHandler_GetSentReports_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ConversionInternalsHandler_GetSentReports_Params_Data::ConversionInternalsHandler_GetSentReports_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionInternalsHandler_GetSentReports_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionInternalsHandler_GetSentReports_ResponseParams_Data* object = static_cast<const ConversionInternalsHandler_GetSentReports_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reports, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams reports_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->reports, validation_context,
                                         &reports_validate_params)) {
    return false;
  }

  return true;
}

ConversionInternalsHandler_GetSentReports_ResponseParams_Data::ConversionInternalsHandler_GetSentReports_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionInternalsHandler_SendPendingReports_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionInternalsHandler_SendPendingReports_Params_Data* object = static_cast<const ConversionInternalsHandler_SendPendingReports_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ConversionInternalsHandler_SendPendingReports_Params_Data::ConversionInternalsHandler_SendPendingReports_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionInternalsHandler_SendPendingReports_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionInternalsHandler_SendPendingReports_ResponseParams_Data* object = static_cast<const ConversionInternalsHandler_SendPendingReports_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ConversionInternalsHandler_SendPendingReports_ResponseParams_Data::ConversionInternalsHandler_SendPendingReports_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionInternalsHandler_ClearStorage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionInternalsHandler_ClearStorage_Params_Data* object = static_cast<const ConversionInternalsHandler_ClearStorage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ConversionInternalsHandler_ClearStorage_Params_Data::ConversionInternalsHandler_ClearStorage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversionInternalsHandler_ClearStorage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConversionInternalsHandler_ClearStorage_ResponseParams_Data* object = static_cast<const ConversionInternalsHandler_ClearStorage_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ConversionInternalsHandler_ClearStorage_ResponseParams_Data::ConversionInternalsHandler_ClearStorage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom

namespace perfetto {

// static
void TraceFormatTraits<::mojom::SourceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::mojom::SourceType value) {
  return std::move(context).WriteString(::mojom::SourceTypeToString(value));
}

} // namespace perfetto
