// content/common/render_accessibility.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/render_accessibility.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/render_accessibility.mojom-params-data.h"
#include "content/common/render_accessibility.mojom-shared-message-ids.h"

#include "content/common/render_accessibility.mojom-import-headers.h"


#ifndef CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_JUMBO_H_
#define CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_JUMBO_H_
#endif
namespace content {
namespace mojom {
LocationChanges::LocationChanges()
    : id(),
      new_location() {}

LocationChanges::LocationChanges(
    int32_t id_in,
    const ::ui::AXRelativeBounds& new_location_in)
    : id(std::move(id_in)),
      new_location(std::move(new_location_in)) {}

LocationChanges::~LocationChanges() = default;

void LocationChanges::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_location"), this->new_location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::ui::AXRelativeBounds&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LocationChanges::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HitTestResponse::HitTestResponse()
    : hit_frame_token(),
      hit_frame_transformed_point(),
      hit_node_id() {}

HitTestResponse::HitTestResponse(
    const ::blink::FrameToken& hit_frame_token_in,
    const ::gfx::Point& hit_frame_transformed_point_in,
    int32_t hit_node_id_in)
    : hit_frame_token(std::move(hit_frame_token_in)),
      hit_frame_transformed_point(std::move(hit_frame_transformed_point_in)),
      hit_node_id(std::move(hit_node_id_in)) {}

HitTestResponse::~HitTestResponse() = default;

void HitTestResponse::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_frame_token"), this->hit_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::FrameToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_frame_transformed_point"), this->hit_frame_transformed_point,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_node_id"), this->hit_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HitTestResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AXUpdatesAndEvents::AXUpdatesAndEvents()
    : updates(),
      events() {}

AXUpdatesAndEvents::AXUpdatesAndEvents(
    std::vector<::ui::AXTreeUpdate> updates_in,
    std::vector<::ui::AXEvent> events_in)
    : updates(std::move(updates_in)),
      events(std::move(events_in)) {}

AXUpdatesAndEvents::~AXUpdatesAndEvents() = default;

void AXUpdatesAndEvents::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "updates"), this->updates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::ui::AXTreeUpdate>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "events"), this->events,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::ui::AXEvent>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AXUpdatesAndEvents::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char RenderAccessibilityHost::Name_[] = "content.mojom.RenderAccessibilityHost";

class RenderAccessibilityHost_HandleAXEvents_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderAccessibilityHost_HandleAXEvents_ForwardToCallback(
      RenderAccessibilityHost::HandleAXEventsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RenderAccessibilityHost::HandleAXEventsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RenderAccessibilityHost_HandleAXEvents_ForwardToCallback);
};

RenderAccessibilityHostProxy::RenderAccessibilityHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderAccessibilityHostProxy::HandleAXEvents(
    AXUpdatesAndEventsPtr in_events_and_updates, int32_t in_reset_token, HandleAXEventsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RenderAccessibilityHost::HandleAXEvents", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("events_and_updates"), in_events_and_updates,
                        "<value of type AXUpdatesAndEventsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reset_token"), in_reset_token,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderAccessibilityHost_HandleAXEvents_Name, kFlags, 0, 0,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderAccessibilityHost_HandleAXEvents_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->events_and_updates)::BaseType> events_and_updates_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::AXUpdatesAndEventsDataView>(
      in_events_and_updates, events_and_updates_fragment);
  params->events_and_updates.Set(
      events_and_updates_fragment.is_null() ? nullptr : events_and_updates_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->events_and_updates.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null events_and_updates in RenderAccessibilityHost.HandleAXEvents request");
  params->reset_token = in_reset_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibilityHost::Name_);
  message.set_method_name("HandleAXEvents");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderAccessibilityHost_HandleAXEvents_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RenderAccessibilityHostProxy::HandleAXLocationChanges(
    std::vector<LocationChangesPtr> in_changes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RenderAccessibilityHost::HandleAXLocationChanges", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("changes"), in_changes,
                        "<value of type std::vector<LocationChangesPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderAccessibilityHost_HandleAXLocationChanges_Name, kFlags, 0, 0,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->changes)::BaseType>
      changes_fragment(params.message());
  const mojo::internal::ContainerValidateParams changes_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::content::mojom::LocationChangesDataView>>(
      in_changes, changes_fragment, &changes_validate_params);
  params->changes.Set(
      changes_fragment.is_null() ? nullptr : changes_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->changes.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null changes in RenderAccessibilityHost.HandleAXLocationChanges request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibilityHost::Name_);
  message.set_method_name("HandleAXLocationChanges");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class RenderAccessibilityHost_HandleAXEvents_ProxyToResponder {
 public:
  static RenderAccessibilityHost::HandleAXEventsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RenderAccessibilityHost_HandleAXEvents_ProxyToResponder> proxy(
        new RenderAccessibilityHost_HandleAXEvents_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RenderAccessibilityHost_HandleAXEvents_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderAccessibilityHost_HandleAXEvents_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RenderAccessibilityHost_HandleAXEvents_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RenderAccessibilityHost::HandleAXEventsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RenderAccessibilityHost_HandleAXEvents_ProxyToResponder);
};

bool RenderAccessibilityHost_HandleAXEvents_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::RenderAccessibilityHost::HandleAXEventsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  RenderAccessibilityHost_HandleAXEvents_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderAccessibilityHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void RenderAccessibilityHost_HandleAXEvents_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)content::mojom::RenderAccessibilityHost::HandleAXEventsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderAccessibilityHost_HandleAXEvents_Name, kFlags, 0, 0,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::RenderAccessibilityHost::HandleAXEventsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibilityHost::Name_);
  message.set_method_name("HandleAXEvents");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RenderAccessibilityHostStubDispatch::Accept(
    RenderAccessibilityHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRenderAccessibilityHost_HandleAXEvents_Name: {
      break;
    }
    case internal::kRenderAccessibilityHost_HandleAXLocationChanges_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderAccessibilityHost::HandleAXLocationChanges",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderAccessibilityHost::HandleAXLocationChanges");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data* params =
          reinterpret_cast<internal::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<LocationChangesPtr> p_changes{};
      RenderAccessibilityHost_HandleAXLocationChanges_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChanges(&p_changes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibilityHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleAXLocationChanges(
std::move(p_changes));
      return true;
    }
  }
  return false;
}

// static
bool RenderAccessibilityHostStubDispatch::AcceptWithResponder(
    RenderAccessibilityHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderAccessibilityHost_HandleAXEvents_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderAccessibilityHost::HandleAXEvents",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderAccessibilityHost::HandleAXEvents");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RenderAccessibilityHost_HandleAXEvents_Params_Data* params =
          reinterpret_cast<
              internal::RenderAccessibilityHost_HandleAXEvents_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      AXUpdatesAndEventsPtr p_events_and_updates{};
      int32_t p_reset_token{};
      RenderAccessibilityHost_HandleAXEvents_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventsAndUpdates(&p_events_and_updates))
        success = false;
      if (success)
        p_reset_token = input_data_view.reset_token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibilityHost::Name_, 0, false);
        return false;
      }
      RenderAccessibilityHost::HandleAXEventsCallback callback =
          RenderAccessibilityHost_HandleAXEvents_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleAXEvents(
std::move(p_events_and_updates), 
std::move(p_reset_token), std::move(callback));
      return true;
    }
    case internal::kRenderAccessibilityHost_HandleAXLocationChanges_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRenderAccessibilityHostValidationInfo[] = {
    {internal::kRenderAccessibilityHost_HandleAXEvents_Name,
     {&internal::RenderAccessibilityHost_HandleAXEvents_Params_Data::Validate,
      &internal::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data::Validate}},
    {internal::kRenderAccessibilityHost_HandleAXLocationChanges_Name,
     {&internal::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RenderAccessibilityHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RenderAccessibilityHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRenderAccessibilityHostValidationInfo);
}

bool RenderAccessibilityHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RenderAccessibilityHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRenderAccessibilityHostValidationInfo);

}
const char RenderAccessibility::Name_[] = "content.mojom.RenderAccessibility";

class RenderAccessibility_HitTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderAccessibility_HitTest_ForwardToCallback(
      RenderAccessibility::HitTestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RenderAccessibility::HitTestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RenderAccessibility_HitTest_ForwardToCallback);
};

RenderAccessibilityProxy::RenderAccessibilityProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderAccessibilityProxy::SetMode(
    uint32_t in_ax_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RenderAccessibility::SetMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ax_mode"), in_ax_mode,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderAccessibility_SetMode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderAccessibility_SetMode_Params_Data> params(
          message);
  params.Allocate();
  params->ax_mode = in_ax_mode;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibility::Name_);
  message.set_method_name("SetMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RenderAccessibilityProxy::FatalError(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::RenderAccessibility::FatalError");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderAccessibility_FatalError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderAccessibility_FatalError_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibility::Name_);
  message.set_method_name("FatalError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RenderAccessibilityProxy::HitTest(
    const ::gfx::Point& in_point, ::ax::mojom::Event in_event_to_fire, int32_t in_request_id, HitTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RenderAccessibility::HitTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_to_fire"), in_event_to_fire,
                        "<value of type ::ax::mojom::Event>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderAccessibility_HitTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderAccessibility_HitTest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_point, point_fragment);
  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point in RenderAccessibility.HitTest request");
  mojo::internal::Serialize<::ax::mojom::Event>(
      in_event_to_fire, &params->event_to_fire);
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibility::Name_);
  message.set_method_name("HitTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderAccessibility_HitTest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RenderAccessibilityProxy::PerformAction(
    const ::ui::AXActionData& in_action_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RenderAccessibility::PerformAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_data"), in_action_data,
                        "<value of type const ::ui::AXActionData&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderAccessibility_PerformAction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderAccessibility_PerformAction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->action_data)::BaseType> action_data_fragment(
          params.message());
  mojo::internal::Serialize<::ax::mojom::AXActionDataDataView>(
      in_action_data, action_data_fragment);
  params->action_data.Set(
      action_data_fragment.is_null() ? nullptr : action_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->action_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null action_data in RenderAccessibility.PerformAction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibility::Name_);
  message.set_method_name("PerformAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RenderAccessibilityProxy::Reset(
    int32_t in_reset_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RenderAccessibility::Reset", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reset_token"), in_reset_token,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderAccessibility_Reset_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderAccessibility_Reset_Params_Data> params(
          message);
  params.Allocate();
  params->reset_token = in_reset_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibility::Name_);
  message.set_method_name("Reset");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class RenderAccessibility_HitTest_ProxyToResponder {
 public:
  static RenderAccessibility::HitTestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RenderAccessibility_HitTest_ProxyToResponder> proxy(
        new RenderAccessibility_HitTest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RenderAccessibility_HitTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderAccessibility_HitTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RenderAccessibility_HitTest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RenderAccessibility::HitTestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      HitTestResponsePtr in_hit_test_response);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RenderAccessibility_HitTest_ProxyToResponder);
};

bool RenderAccessibility_HitTest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::RenderAccessibility::HitTestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::RenderAccessibility_HitTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderAccessibility_HitTest_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  HitTestResponsePtr p_hit_test_response{};
  RenderAccessibility_HitTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHitTestResponse(&p_hit_test_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderAccessibility::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_hit_test_response));
  return true;
}

void RenderAccessibility_HitTest_ProxyToResponder::Run(
    HitTestResponsePtr in_hit_test_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::RenderAccessibility::HitTestCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hit_test_response"), in_hit_test_response,
                        "<value of type HitTestResponsePtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderAccessibility_HitTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderAccessibility_HitTest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hit_test_response)::BaseType> hit_test_response_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::HitTestResponseDataView>(
      in_hit_test_response, hit_test_response_fragment);
  params->hit_test_response.Set(
      hit_test_response_fragment.is_null() ? nullptr : hit_test_response_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::RenderAccessibility::HitTestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibility::Name_);
  message.set_method_name("HitTest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RenderAccessibilityStubDispatch::Accept(
    RenderAccessibility* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRenderAccessibility_SetMode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderAccessibility::SetMode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderAccessibility::SetMode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderAccessibility_SetMode_Params_Data* params =
          reinterpret_cast<internal::RenderAccessibility_SetMode_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_ax_mode{};
      RenderAccessibility_SetMode_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_ax_mode = input_data_view.ax_mode();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibility::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMode(
std::move(p_ax_mode));
      return true;
    }
    case internal::kRenderAccessibility_FatalError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderAccessibility::FatalError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderAccessibility::FatalError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderAccessibility_FatalError_Params_Data* params =
          reinterpret_cast<internal::RenderAccessibility_FatalError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RenderAccessibility_FatalError_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibility::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FatalError();
      return true;
    }
    case internal::kRenderAccessibility_HitTest_Name: {
      break;
    }
    case internal::kRenderAccessibility_PerformAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderAccessibility::PerformAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderAccessibility::PerformAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderAccessibility_PerformAction_Params_Data* params =
          reinterpret_cast<internal::RenderAccessibility_PerformAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::ui::AXActionData p_action_data{};
      RenderAccessibility_PerformAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActionData(&p_action_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibility::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformAction(
std::move(p_action_data));
      return true;
    }
    case internal::kRenderAccessibility_Reset_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderAccessibility::Reset",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderAccessibility::Reset");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderAccessibility_Reset_Params_Data* params =
          reinterpret_cast<internal::RenderAccessibility_Reset_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_reset_token{};
      RenderAccessibility_Reset_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reset_token = input_data_view.reset_token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibility::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Reset(
std::move(p_reset_token));
      return true;
    }
  }
  return false;
}

// static
bool RenderAccessibilityStubDispatch::AcceptWithResponder(
    RenderAccessibility* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderAccessibility_SetMode_Name: {
      break;
    }
    case internal::kRenderAccessibility_FatalError_Name: {
      break;
    }
    case internal::kRenderAccessibility_HitTest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderAccessibility::HitTest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderAccessibility::HitTest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RenderAccessibility_HitTest_Params_Data* params =
          reinterpret_cast<
              internal::RenderAccessibility_HitTest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_point{};
      ::ax::mojom::Event p_event_to_fire{};
      int32_t p_request_id{};
      RenderAccessibility_HitTest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (success && !input_data_view.ReadEventToFire(&p_event_to_fire))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibility::Name_, 2, false);
        return false;
      }
      RenderAccessibility::HitTestCallback callback =
          RenderAccessibility_HitTest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HitTest(
std::move(p_point), 
std::move(p_event_to_fire), 
std::move(p_request_id), std::move(callback));
      return true;
    }
    case internal::kRenderAccessibility_PerformAction_Name: {
      break;
    }
    case internal::kRenderAccessibility_Reset_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRenderAccessibilityValidationInfo[] = {
    {internal::kRenderAccessibility_SetMode_Name,
     {&internal::RenderAccessibility_SetMode_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderAccessibility_FatalError_Name,
     {&internal::RenderAccessibility_FatalError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderAccessibility_HitTest_Name,
     {&internal::RenderAccessibility_HitTest_Params_Data::Validate,
      &internal::RenderAccessibility_HitTest_ResponseParams_Data::Validate}},
    {internal::kRenderAccessibility_PerformAction_Name,
     {&internal::RenderAccessibility_PerformAction_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderAccessibility_Reset_Name,
     {&internal::RenderAccessibility_Reset_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RenderAccessibilityRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RenderAccessibility::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRenderAccessibilityValidationInfo);
}

bool RenderAccessibilityResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RenderAccessibility::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRenderAccessibilityValidationInfo);

}
}  // namespace mojom
}  // namespace content

namespace mojo {


// static
bool StructTraits<::content::mojom::LocationChanges::DataView, ::content::mojom::LocationChangesPtr>::Read(
    ::content::mojom::LocationChanges::DataView input,
    ::content::mojom::LocationChangesPtr* output) {
  bool success = true;
  ::content::mojom::LocationChangesPtr result(::content::mojom::LocationChanges::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadNewLocation(&result->new_location))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::HitTestResponse::DataView, ::content::mojom::HitTestResponsePtr>::Read(
    ::content::mojom::HitTestResponse::DataView input,
    ::content::mojom::HitTestResponsePtr* output) {
  bool success = true;
  ::content::mojom::HitTestResponsePtr result(::content::mojom::HitTestResponse::New());
  
      if (success && !input.ReadHitFrameToken(&result->hit_frame_token))
        success = false;
      if (success && !input.ReadHitFrameTransformedPoint(&result->hit_frame_transformed_point))
        success = false;
      if (success)
        result->hit_node_id = input.hit_node_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::AXUpdatesAndEvents::DataView, ::content::mojom::AXUpdatesAndEventsPtr>::Read(
    ::content::mojom::AXUpdatesAndEvents::DataView input,
    ::content::mojom::AXUpdatesAndEventsPtr* output) {
  bool success = true;
  ::content::mojom::AXUpdatesAndEventsPtr result(::content::mojom::AXUpdatesAndEvents::New());
  
      if (success && !input.ReadUpdates(&result->updates))
        success = false;
      if (success && !input.ReadEvents(&result->events))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif